/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx.synchronisation;

import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.lookup.EmbeddedTransactionManagerLookup;
import org.infinispan.transaction.tm.EmbeddedTransaction;
import org.infinispan.tx.LocalModeTxTest;
import org.testng.Assert;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.synchronisation.LocalModeWithSyncTxTest")
public class LocalModeWithSyncTxTest
extends LocalModeTxTest {
    @Override
    @Factory
    public Object[] factory() {
        return new Object[]{new LocalModeWithSyncTxTest().withStorage(StorageType.BINARY), new LocalModeWithSyncTxTest().withStorage(StorageType.OBJECT), new LocalModeWithSyncTxTest().withStorage(StorageType.OFF_HEAP)};
    }

    @Override
    protected EmbeddedCacheManager createCacheManager() {
        ConfigurationBuilder config = this.getDefaultStandaloneCacheConfig(true);
        config.transaction().transactionManagerLookup((TransactionManagerLookup)new EmbeddedTransactionManagerLookup()).useSynchronization(true);
        return TestCacheManagerFactory.createCacheManager(config);
    }

    public void testSyncRegisteredWithCommit() throws Exception {
        EmbeddedTransaction dt = this.startTx();
        this.tm().commit();
        Assert.assertEquals((int)0, (int)dt.getEnlistedResources().size());
        Assert.assertEquals((int)0, (int)dt.getEnlistedSynchronization().size());
        Assert.assertEquals((Object)"v", (Object)this.cache.get((Object)"k"));
    }

    public void testSyncRegisteredWithRollback() throws Exception {
        EmbeddedTransaction dt = this.startTx();
        this.tm().rollback();
        Assert.assertEquals(null, (Object)this.cache.get((Object)"k"));
        Assert.assertEquals((int)0, (int)dt.getEnlistedResources().size());
        Assert.assertEquals((int)0, (int)dt.getEnlistedSynchronization().size());
    }

    private EmbeddedTransaction startTx() throws NotSupportedException, SystemException {
        this.tm().begin();
        this.cache.put((Object)"k", (Object)"v");
        EmbeddedTransaction dt = (EmbeddedTransaction)this.tm().getTransaction();
        Assert.assertEquals((int)0, (int)dt.getEnlistedResources().size());
        Assert.assertEquals((int)1, (int)dt.getEnlistedSynchronization().size());
        this.cache.put((Object)"k2", (Object)"v2");
        Assert.assertEquals((int)0, (int)dt.getEnlistedResources().size());
        Assert.assertEquals((int)1, (int)dt.getEnlistedSynchronization().size());
        return dt;
    }
}

