/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.distribution.ch.impl.DefaultConsistentHash;
import org.infinispan.distribution.ch.impl.ReplicatedConsistentHash;
import org.infinispan.distribution.ch.impl.ScatteredConsistentHash;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.remoting.transport.Address;
import org.testng.AssertJUnit;

public abstract class BaseControlledConsistentHashFactory<CH extends ConsistentHash>
implements ConsistentHashFactory<CH> {
    protected Trait<CH> trait;
    @ProtoField(number=1, defaultValue="0")
    public int numSegments;

    protected BaseControlledConsistentHashFactory() {
    }

    protected BaseControlledConsistentHashFactory(Trait<CH> trait, int numSegments) {
        this.trait = trait;
        this.numSegments = numSegments;
    }

    public CH create(int numOwners, int numSegments, List<Address> members, Map<Address, Float> capacityFactors) {
        this.assertNumberOfSegments(numSegments);
        List<Address>[] segmentOwners = this.assignSegments(numSegments, numOwners, members);
        return this.create(numOwners, numSegments, members, capacityFactors, segmentOwners, false);
    }

    private List<Address>[] assignSegments(int numSegments, int numOwners, List<Address> members) {
        int[][] ownerIndexes = this.assignOwners(numSegments, members);
        return (List[])Arrays.stream(ownerIndexes).map(indexes -> Arrays.stream(indexes).mapToObj(members::get).collect(Collectors.toList())).map(indexes -> indexes.subList(0, Math.min(indexes.size(), numOwners))).toArray(List[]::new);
    }

    protected CH create(int numOwners, int numSegments, List<Address> members, Map<Address, Float> capacityFactors, List<Address>[] segmentOwners, boolean rebalanced) {
        return this.trait.create(numOwners, numSegments, members, capacityFactors, segmentOwners, rebalanced);
    }

    public CH updateMembers(CH baseCH, List<Address> newMembers, Map<Address, Float> capacityFactors) {
        this.assertNumberOfSegments(baseCH.getNumSegments());
        List[] segmentOwners = new List[this.numSegments];
        List<Address>[] balancedOwners = null;
        int numOwners = this.trait.getNumOwners(baseCH);
        for (int i = 0; i < this.numSegments; ++i) {
            ArrayList owners = new ArrayList(baseCH.locateOwnersForSegment(i));
            owners.retainAll(newMembers);
            if (owners.isEmpty() && this.trait.requiresPrimaryOwner()) {
                if (balancedOwners == null) {
                    balancedOwners = this.assignSegments(this.numSegments, numOwners, newMembers);
                }
                owners = balancedOwners[i];
            }
            segmentOwners[i] = owners;
        }
        CH updated = this.create(numOwners, this.numSegments, newMembers, capacityFactors, segmentOwners, false);
        return baseCH.equals(updated) ? baseCH : updated;
    }

    public CH rebalance(CH baseCH) {
        int numOwners = this.trait.getNumOwners(baseCH);
        List<Address>[] owners = this.assignSegments(baseCH.getNumSegments(), numOwners, baseCH.getMembers());
        CH rebalanced = this.create(numOwners, baseCH.getNumSegments(), baseCH.getMembers(), baseCH.getCapacityFactors(), owners, true);
        return baseCH.equals(rebalanced) ? baseCH : rebalanced;
    }

    public CH union(CH ch1, CH ch2) {
        this.assertNumberOfSegments(ch1.getNumSegments());
        this.assertNumberOfSegments(ch2.getNumSegments());
        return this.trait.union(ch1, ch2);
    }

    protected abstract int[][] assignOwners(int var1, List<Address> var2);

    private void assertNumberOfSegments(int numSegments) {
        AssertJUnit.assertEquals((String)"Wrong number of segments.", (int)this.numSegments, (int)numSegments);
    }

    public static abstract class Default
    extends BaseControlledConsistentHashFactory<DefaultConsistentHash> {
        protected Default(int numSegments) {
            super(new DefaultTrait(), numSegments);
        }
    }

    public static class ReplicatedTrait
    implements Trait<ReplicatedConsistentHash> {
        @Override
        public ReplicatedConsistentHash create(int numOwners, int numSegments, List<Address> members, Map<Address, Float> capacityFactors, List<Address>[] segmentOwners, boolean rebalanced) {
            int[] segmentOwners1 = Stream.of(segmentOwners).mapToInt(list -> members.indexOf(list.get(0))).toArray();
            return new ReplicatedConsistentHash(members, capacityFactors, Collections.emptyList(), segmentOwners1);
        }

        @Override
        public ReplicatedConsistentHash union(ReplicatedConsistentHash ch1, ReplicatedConsistentHash ch2) {
            return ch1.union(ch2);
        }

        @Override
        public boolean requiresPrimaryOwner() {
            return true;
        }

        @Override
        public int getNumOwners(ReplicatedConsistentHash ReplicatedConsistentHash2) {
            return 1;
        }
    }

    public static class ScatteredTrait
    implements Trait<ScatteredConsistentHash> {
        @Override
        public ScatteredConsistentHash create(int numOwners, int numSegments, List<Address> members, Map<Address, Float> capacityFactors, List<Address>[] segmentOwners, boolean rebalanced) {
            Address[] segmentOwners1 = (Address[])Stream.of(segmentOwners).map(list -> list.isEmpty() ? null : (Address)list.get(0)).toArray(Address[]::new);
            return new ScatteredConsistentHash(numSegments, members, capacityFactors, segmentOwners1, rebalanced);
        }

        @Override
        public ScatteredConsistentHash union(ScatteredConsistentHash ch1, ScatteredConsistentHash ch2) {
            return ch1.union(ch2);
        }

        @Override
        public boolean requiresPrimaryOwner() {
            return false;
        }

        @Override
        public int getNumOwners(ScatteredConsistentHash scatteredConsistentHash) {
            return 1;
        }
    }

    public static class DefaultTrait
    implements Trait<DefaultConsistentHash> {
        @Override
        public DefaultConsistentHash create(int numOwners, int numSegments, List<Address> members, Map<Address, Float> capacityFactors, List<Address>[] segmentOwners, boolean rebalanced) {
            return new DefaultConsistentHash(numOwners, numSegments, members, capacityFactors, (List[])segmentOwners);
        }

        @Override
        public DefaultConsistentHash union(DefaultConsistentHash ch1, DefaultConsistentHash ch2) {
            return ch1.union(ch2);
        }

        @Override
        public boolean requiresPrimaryOwner() {
            return true;
        }

        @Override
        public int getNumOwners(DefaultConsistentHash defaultConsistentHash) {
            return defaultConsistentHash.getNumOwners();
        }
    }

    protected static interface Trait<CH extends ConsistentHash> {
        public CH create(int var1, int var2, List<Address> var3, Map<Address, Float> var4, List<Address>[] var5, boolean var6);

        public CH union(CH var1, CH var2);

        public boolean requiresPrimaryOwner();

        public int getNumOwners(CH var1);
    }
}

