/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util;

import io.reactivex.rxjava3.exceptions.UndeliverableException;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.logging.log4j.spi.AbstractLogger;
import org.infinispan.commons.IllegalLifecycleStateException;
import org.infinispan.commons.internal.CommonsBlockHoundIntegration;
import org.infinispan.commons.test.PolarionJUnitXMLWriter;
import org.infinispan.commons.test.TestResourceTracker;
import org.infinispan.commons.test.TestSuiteProgress;
import org.infinispan.distribution.BlockingInterceptor;
import org.infinispan.eviction.impl.EvictionWithConcurrentOperationsTest;
import org.infinispan.functional.FunctionalTestUtils;
import org.infinispan.notifications.cachelistener.CacheListenerVisibilityTest;
import org.infinispan.persistence.support.WaitNonBlockingStore;
import org.infinispan.test.ReplListener;
import org.infinispan.test.TestBlocking;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.concurrent.InboundRpcSequencerAction;
import org.infinispan.test.concurrent.StateSequencer;
import org.infinispan.test.fwk.CheckPoint;
import org.infinispan.util.AbstractControlledLocalTopologyManager;
import org.infinispan.util.BlockingLocalTopologyManager;
import org.infinispan.util.ControlledRpcManager;
import org.infinispan.util.NotifierLatch;
import org.infinispan.util.concurrent.ReclosableLatch;
import org.infinispan.util.logging.LogFactory;
import reactor.blockhound.BlockHound;
import reactor.blockhound.integration.BlockHoundIntegration;

public class CoreTestBlockHoundIntegration
implements BlockHoundIntegration {
    public void applyTo(BlockHound.Builder builder) {
        try {
            CoreTestBlockHoundIntegration.allowTestsToBlock(builder);
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
        builder.allowBlockingCallsInside(CoreTestBlockHoundIntegration.class.getName(), "writeJUnitReport");
        builder.allowBlockingCallsInside(AbstractLogger.class.getName(), "logMessage");
        builder.blockingMethodCallback(bm -> {
            String testName = TestResourceTracker.getCurrentTestName();
            AssertionError assertionError = new AssertionError((Object)String.format("Blocking call! %s on thread %s", bm, Thread.currentThread()));
            TestSuiteProgress.fakeTestFailure((String)(testName + ".BlockingChecker"), (Throwable)((Object)assertionError));
            CoreTestBlockHoundIntegration.writeJUnitReport(testName, (Throwable)((Object)assertionError), "Blocking");
            throw assertionError;
        });
        Thread.setDefaultUncaughtExceptionHandler((thread, t) -> {
            LogFactory.getLogger((String)"Infinispan-TEST").fatal((Object)("Throwable was not caught in thread " + thread + " - exception is: " + t));
            if (!(t instanceof UndeliverableException)) {
                CoreTestBlockHoundIntegration.writeJUnitReport(TestResourceTracker.getCurrentTestName(), t, "Uncaught");
            }
        });
        RxJavaPlugins.setErrorHandler(t -> {
            Throwable throwable;
            Throwable throwable2 = throwable = t instanceof UndeliverableException ? t.getCause() : t;
            if (throwable instanceof IllegalLifecycleStateException) {
                return;
            }
            CoreTestBlockHoundIntegration.writeJUnitReport(TestResourceTracker.getCurrentTestName(), throwable, "Undelivered");
        });
    }

    private static void allowTestsToBlock(BlockHound.Builder builder) throws ClassNotFoundException {
        builder.allowBlockingCallsInside(EvictionWithConcurrentOperationsTest.class.getName() + "$Latch", "blockIfNeeded");
        CommonsBlockHoundIntegration.allowPublicMethodsToBlock((BlockHound.Builder)builder, CheckPoint.class);
        builder.allowBlockingCallsInside(BlockingInterceptor.class.getName(), "blockIfNeeded");
        builder.allowBlockingCallsInside(TestingUtil.class.getName(), "sleepRandom");
        builder.allowBlockingCallsInside(TestingUtil.class.getName(), "sleepThread");
        CommonsBlockHoundIntegration.allowPublicMethodsToBlock((BlockHound.Builder)builder, ReclosableLatch.class);
        builder.allowBlockingCallsInside(BlockingLocalTopologyManager.class.getName() + "$Event", "awaitUnblock");
        builder.allowBlockingCallsInside(BlockingLocalTopologyManager.class.getName() + "$Event", "unblock");
        builder.allowBlockingCallsInside(ControlledRpcManager.class.getName(), "performRequest");
        builder.allowBlockingCallsInside(ControlledRpcManager.class.getName(), "expectCommandAsync");
        CommonsBlockHoundIntegration.allowPublicMethodsToBlock((BlockHound.Builder)builder, StateSequencer.class);
        CommonsBlockHoundIntegration.allowPublicMethodsToBlock((BlockHound.Builder)builder, NotifierLatch.class);
        CommonsBlockHoundIntegration.allowPublicMethodsToBlock((BlockHound.Builder)builder, TestBlocking.class);
        builder.allowBlockingCallsInside(FunctionalTestUtils.class.getName(), "await");
        builder.allowBlockingCallsInside(TestingUtil.class.getName(), "sleepThread");
        CommonsBlockHoundIntegration.allowMethodsToBlock((BlockHound.Builder)builder, Class.forName(ReplListener.class.getName() + "$ReplListenerInterceptor"), (boolean)false);
        CommonsBlockHoundIntegration.allowMethodsToBlock((BlockHound.Builder)builder, Class.forName(InboundRpcSequencerAction.class.getName() + "$SequencerPerCacheInboundInvocationHandler"), (boolean)false);
        builder.allowBlockingCallsInside(CacheListenerVisibilityTest.EntryModifiedWithAssertListener.class.getName(), "entryCreated");
        builder.allowBlockingCallsInside(CacheListenerVisibilityTest.EntryCreatedWithAssertListener.class.getName(), "entryCreated");
        CommonsBlockHoundIntegration.allowPublicMethodsToBlock((BlockHound.Builder)builder, BlockingLocalTopologyManager.class);
        CommonsBlockHoundIntegration.allowPublicMethodsToBlock((BlockHound.Builder)builder, AbstractControlledLocalTopologyManager.class);
        builder.allowBlockingCallsInside(WaitNonBlockingStore.class.getName(), "join");
    }

    private static void writeJUnitReport(String testName, Throwable throwable, String type) {
        try {
            File reportsDir = new File("target/surefire-reports");
            if (!reportsDir.exists() && !reportsDir.mkdirs()) {
                throw new IOException("Cannot create report directory " + reportsDir.getAbsolutePath());
            }
            PolarionJUnitXMLWriter writer = new PolarionJUnitXMLWriter(new File(reportsDir, "TEST-" + testName + "-" + type + ".xml"));
            String property = System.getProperty("infinispan.modulesuffix");
            String moduleName = property != null ? property.substring(1) : "";
            writer.start(moduleName, 1L, 0L, 1L, 0L, false);
            StringWriter exceptionWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(exceptionWriter));
            writer.writeTestCase(type, testName, 0L, PolarionJUnitXMLWriter.Status.FAILURE, exceptionWriter.toString(), throwable.getClass().getName(), throwable.getMessage());
            writer.close();
        }
        catch (Exception e) {
            throw new RuntimeException("Error reporting " + type, e);
        }
    }
}

