/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.impl.Request;
import org.infinispan.remoting.transport.impl.RequestRepository;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.infinispan.test.TestingUtil;

public class CountingRequestRepository
extends RequestRepository {
    private final AtomicLong generation = new AtomicLong();
    private Map<Long, Map<Long, Request<?>>> requests = new ConcurrentHashMap();

    public static CountingRequestRepository replaceDispatcher(EmbeddedCacheManager cacheManager) {
        GlobalComponentRegistry gcr = cacheManager.getGlobalComponentRegistry();
        JGroupsTransport transport = (JGroupsTransport)gcr.getComponent(Transport.class);
        RequestRepository requestRepository = (RequestRepository)TestingUtil.extractField(JGroupsTransport.class, transport, "requests");
        CountingRequestRepository instance = new CountingRequestRepository(requestRepository);
        TestingUtil.replaceField((Object)instance, "requests", transport, JGroupsTransport.class);
        return instance;
    }

    private CountingRequestRepository(RequestRepository requestRepository) {
        requestRepository.forEach(this::addRequest);
    }

    public void addRequest(Request<?> request) {
        this.requests.compute(this.generation.get(), (generation, map) -> {
            if (map == null) {
                map = new ConcurrentHashMap<Long, Request>();
            }
            map.put(request.getRequestId(), request);
            return map;
        });
        super.addRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void advanceGenerationAndAwait(long timeout, TimeUnit timeUnit) throws Exception {
        long lastGen = this.generation.getAndIncrement();
        Map lastGenRequests = this.requests.getOrDefault(lastGen, Collections.emptyMap());
        long now = System.nanoTime();
        long deadline = now + timeUnit.toNanos(timeout);
        CountingRequestRepository countingRequestRepository = this;
        synchronized (countingRequestRepository) {
            for (Map.Entry entry : lastGenRequests.entrySet()) {
                Request request = (Request)entry.getValue();
                request.toCompletableFuture().get(deadline - now, TimeUnit.NANOSECONDS);
                now = System.currentTimeMillis();
            }
        }
    }
}

