/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util;

import java.util.HashSet;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.configuration.ClassAllowList;
import org.infinispan.commons.io.ByteBufferFactory;
import org.infinispan.commons.io.ByteBufferFactoryImpl;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.test.BlockHoundHelper;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.time.TimeService;
import org.infinispan.configuration.ConfigurationManager;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.distribution.ch.impl.SingleSegmentKeyPartitioner;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.impl.BasicComponentRegistry;
import org.infinispan.factories.impl.TestComponentAccessors;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.manager.TestModuleRepository;
import org.infinispan.marshall.persistence.PersistenceMarshaller;
import org.infinispan.marshall.persistence.impl.MarshalledEntryFactoryImpl;
import org.infinispan.persistence.InitializationContextImpl;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.MarshallableEntryFactory;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.concurrent.BlockingManager;
import org.infinispan.util.concurrent.BlockingManagerImpl;
import org.infinispan.util.concurrent.NonBlockingManager;
import org.infinispan.util.concurrent.NonBlockingManagerImpl;
import org.infinispan.util.concurrent.WithinThreadExecutor;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class PersistenceMockUtil {
    public static InitializationContext createContext(Class<?> testClass, Configuration configuration, PersistenceMarshaller marshaller) {
        return PersistenceMockUtil.createContext(testClass, configuration, marshaller, AbstractInfinispanTest.TIME_SERVICE);
    }

    public static InitializationContext createContext(Class<?> testClass, Configuration configuration, PersistenceMarshaller marshaller, TimeService timeService) {
        return PersistenceMockUtil.createContext(testClass, configuration, marshaller, timeService, null);
    }

    public static InitializationContext createContext(Class<?> testClass, Configuration configuration, PersistenceMarshaller marshaller, TimeService timeService, ClassAllowList allowList) {
        return new InvocationContextBuilder(testClass, configuration, marshaller).setTimeService(timeService).setClassAllowList(allowList).build();
    }

    private static Cache mockCache(String nodeName, Configuration configuration, TimeService timeService, ClassAllowList allowList, ScheduledExecutorService timeoutScheduledExecutor) {
        String cacheName = "mock-cache";
        AdvancedCache cache = (AdvancedCache)Mockito.mock(AdvancedCache.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        GlobalConfiguration gc = new GlobalConfigurationBuilder().transport().nodeName(nodeName).build();
        HashSet cachesSet = new HashSet();
        EmbeddedCacheManager cm = (EmbeddedCacheManager)Mockito.mock(EmbeddedCacheManager.class);
        Mockito.when((Object)cm.getCacheManagerConfiguration()).thenReturn((Object)gc);
        Mockito.when((Object)cm.getClassAllowList()).thenReturn((Object)new ClassAllowList());
        GlobalComponentRegistry gcr = new GlobalComponentRegistry(gc, cm, cachesSet, TestModuleRepository.defaultModuleRepository(), (ConfigurationManager)Mockito.mock(ConfigurationManager.class));
        BasicComponentRegistry gbcr = (BasicComponentRegistry)gcr.getComponent(BasicComponentRegistry.class);
        gbcr.replaceComponent(TimeService.class.getName(), (Object)timeService, true);
        gbcr.replaceComponent("org.infinispan.executors.timeout", (Object)timeoutScheduledExecutor, false);
        ComponentRegistry registry = new ComponentRegistry(cacheName, configuration, cache, gcr, configuration.getClass().getClassLoader());
        Mockito.when((Object)cache.getCacheManager().getGlobalComponentRegistry()).thenReturn((Object)gcr);
        Mockito.when((Object)cache.getClassLoader()).thenReturn((Object)PersistenceMockUtil.class.getClassLoader());
        Mockito.when((Object)cache.getCacheManager().getCacheManagerConfiguration()).thenReturn((Object)gc);
        Mockito.when((Object)cache.getCacheManager().getClassAllowList()).thenReturn((Object)allowList);
        Mockito.when((Object)cache.getName()).thenReturn((Object)cacheName);
        Mockito.when((Object)cache.getAdvancedCache()).thenReturn((Object)cache);
        Mockito.when((Object)cache.getComponentRegistry()).thenReturn((Object)registry);
        Mockito.when((Object)cache.getStatus()).thenReturn((Object)ComponentStatus.RUNNING);
        Mockito.when((Object)cache.getCacheConfiguration()).thenReturn((Object)configuration);
        return cache;
    }

    public static class InvocationContextBuilder {
        private final Class<?> testClass;
        private final Configuration configuration;
        private final PersistenceMarshaller persistenceMarshaller;
        private ClassAllowList classAllowList;
        private TimeService timeService = AbstractInfinispanTest.TIME_SERVICE;
        private KeyPartitioner keyPartitioner = SingleSegmentKeyPartitioner.getInstance();
        private NonBlockingManager nonBlockingManager;
        private BlockingManager blockingManager;
        private ScheduledExecutorService timeoutScheduledExecutor;

        public InvocationContextBuilder(Class<?> testClass, Configuration configuration, PersistenceMarshaller persistenceMarshaller) {
            this.testClass = testClass;
            this.configuration = configuration;
            this.persistenceMarshaller = persistenceMarshaller;
            this.blockingManager = new BlockingManagerImpl();
            TestingUtil.inject(this.blockingManager, new TestComponentAccessors.NamedComponent("org.infinispan.executors.blocking", BlockHoundHelper.allowBlockingExecutor()), new TestComponentAccessors.NamedComponent("org.infinispan.executors.non-blocking", BlockHoundHelper.ensureNonBlockingExecutor()));
            TestingUtil.startComponent(this.blockingManager);
            this.nonBlockingManager = new NonBlockingManagerImpl();
            TestingUtil.inject(this.nonBlockingManager, new TestComponentAccessors.NamedComponent("org.infinispan.executors.non-blocking", BlockHoundHelper.ensureNonBlockingExecutor()));
            TestingUtil.startComponent(this.nonBlockingManager);
            this.timeoutScheduledExecutor = (ScheduledExecutorService)Mockito.mock(ScheduledExecutorService.class);
        }

        public InvocationContextBuilder setTimeService(TimeService timeService) {
            this.timeService = timeService;
            return this;
        }

        public InvocationContextBuilder setClassAllowList(ClassAllowList classAllowList) {
            this.classAllowList = classAllowList;
            return this;
        }

        public InvocationContextBuilder setKeyPartitioner(KeyPartitioner keyPartitioner) {
            this.keyPartitioner = keyPartitioner;
            return this;
        }

        public InvocationContextBuilder setBlockingManager(BlockingManager blockingManager) {
            this.blockingManager = blockingManager;
            return this;
        }

        public InvocationContextBuilder setNonBlockingManager(NonBlockingManager nonBlockingManager) {
            this.nonBlockingManager = nonBlockingManager;
            return this;
        }

        public InvocationContextBuilder setScheduledExecutor(ScheduledExecutorService timeoutScheduledExecutor) {
            this.timeoutScheduledExecutor = timeoutScheduledExecutor;
            return this;
        }

        public InitializationContext build() {
            Cache mockCache = PersistenceMockUtil.mockCache(this.testClass.getSimpleName(), this.configuration, this.timeService, this.classAllowList, this.timeoutScheduledExecutor);
            MarshalledEntryFactoryImpl mef = new MarshalledEntryFactoryImpl((Marshaller)this.persistenceMarshaller);
            GlobalConfigurationBuilder global = new GlobalConfigurationBuilder();
            global.globalState().persistentLocation(CommonsTestingUtil.tmpDirectory(this.testClass));
            return new InitializationContextImpl((StoreConfiguration)this.configuration.persistence().stores().get(0), mockCache, this.keyPartitioner, this.persistenceMarshaller, this.timeService, (ByteBufferFactory)new ByteBufferFactoryImpl(), (MarshallableEntryFactory)mef, (Executor)new WithinThreadExecutor(), global.build(), this.blockingManager, this.nonBlockingManager);
        }
    }
}

