/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.marshall.SerializeWith;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.distribution.ch.impl.ReplicatedConsistentHash;
import org.infinispan.remoting.transport.Address;

@SerializeWith(value=Externalizer.class)
public class ReplicatedControlledConsistentHashFactory
implements ConsistentHashFactory<ReplicatedConsistentHash>,
Serializable {
    private volatile List<Address> membersToUse;
    private int[] primaryOwnerIndices;

    private ReplicatedControlledConsistentHashFactory(List<Address> membersToUse, int[] primaryOwnerIndices) {
        this.membersToUse = membersToUse;
        this.primaryOwnerIndices = primaryOwnerIndices;
    }

    public ReplicatedControlledConsistentHashFactory(int primaryOwner1, int ... otherPrimaryOwners) {
        this.setOwnerIndexes(primaryOwner1, otherPrimaryOwners);
    }

    public void setOwnerIndexes(int primaryOwner1, int ... otherPrimaryOwners) {
        this.primaryOwnerIndices = this.concatOwners(primaryOwner1, otherPrimaryOwners);
    }

    public ReplicatedConsistentHash create(int numOwners, int numSegments, List<Address> members, Map<Address, Float> capacityFactors) {
        int[] thePrimaryOwners = new int[this.primaryOwnerIndices.length];
        for (int i = 0; i < this.primaryOwnerIndices.length; ++i) {
            int membersToUseIndex;
            int membersIndex;
            thePrimaryOwners[i] = this.membersToUse != null ? ((membersIndex = members.indexOf(this.membersToUse.get(membersToUseIndex = Math.min(this.primaryOwnerIndices[i], this.membersToUse.size() - 1)))) > 0 ? membersIndex : members.size() - 1) : Math.min(this.primaryOwnerIndices[i], members.size() - 1);
        }
        return new ReplicatedConsistentHash(members, thePrimaryOwners);
    }

    public ReplicatedConsistentHash updateMembers(ReplicatedConsistentHash baseCH, List<Address> newMembers, Map<Address, Float> capacityFactors) {
        return this.create(baseCH.getNumOwners(), baseCH.getNumSegments(), newMembers, null);
    }

    public ReplicatedConsistentHash rebalance(ReplicatedConsistentHash baseCH) {
        return this.create(baseCH.getNumOwners(), baseCH.getNumSegments(), (List<Address>)baseCH.getMembers(), null);
    }

    public ReplicatedConsistentHash union(ReplicatedConsistentHash ch1, ReplicatedConsistentHash ch2) {
        return ch1.union(ch2);
    }

    private int[] concatOwners(int head, int[] tail) {
        int[] firstSegmentOwners;
        if (tail == null || tail.length == 0) {
            firstSegmentOwners = new int[]{head};
        } else {
            firstSegmentOwners = new int[tail.length + 1];
            firstSegmentOwners[0] = head;
            for (int i = 0; i < tail.length; ++i) {
                firstSegmentOwners[i + 1] = tail[i];
            }
        }
        return firstSegmentOwners;
    }

    public void setMembersToUse(List<Address> membersToUse) {
        this.membersToUse = membersToUse;
    }

    public static class Externalizer
    implements org.infinispan.commons.marshall.Externalizer<ReplicatedControlledConsistentHashFactory> {
        public void writeObject(ObjectOutput output, ReplicatedControlledConsistentHashFactory object) throws IOException {
            MarshallUtil.marshallCollection((Collection)object.membersToUse, (ObjectOutput)output);
            MarshallUtil.marshallSize((ObjectOutput)output, (int)object.primaryOwnerIndices.length);
            for (int i : object.primaryOwnerIndices) {
                output.writeInt(i);
            }
        }

        public ReplicatedControlledConsistentHashFactory readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            List addresses = (List)MarshallUtil.unmarshallCollection((ObjectInput)input, ArrayList::new);
            int size = MarshallUtil.unmarshallSize((ObjectInput)input);
            int[] indices = new int[size];
            for (int i = 0; i < size; ++i) {
                indices[i] = input.readInt();
            }
            return new ReplicatedControlledConsistentHashFactory(addresses, indices);
        }
    }
}

