/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util;

import java.io.File;
import java.lang.ref.Reference;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.infinispan.Cache;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.test.TestResourceTracker;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.SingleFileStoreConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractInfinispanTest;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="util.ThreadLocalLeakTest")
public class ThreadLocalLeakTest
extends AbstractInfinispanTest {
    private static final Pattern THREAD_LOCAL_FILTER = Pattern.compile("org\\.infinispan\\..*");
    private static final Set<String> ACCEPTED_THREAD_LOCALS = new HashSet<String>(Arrays.asList(new String[0]));
    private final ThreadLocal<ThreadLocalLeakTest> DUMMY_THREAD_LOCAL = ThreadLocal.withInitial(() -> this);
    private String tmpDirectory;

    @BeforeClass
    protected void setUpTempDir() {
        this.tmpDirectory = CommonsTestingUtil.tmpDirectory(this.getClass());
    }

    @AfterClass(alwaysRun=true)
    protected void clearTempDir() {
        Util.recursiveFileRemove((String)this.tmpDirectory);
        new File(this.tmpDirectory).mkdirs();
    }

    public void testCheckThreadLocalLeaks() throws Exception {
        this.fork(this::doCheckThreadLocalLeaks).get(30L, TimeUnit.SECONDS);
    }

    private void doCheckThreadLocalLeaks() throws Exception {
        Future<Void> putFuture;
        TestResourceTracker.testThreadStarted((String)this.getTestName());
        ConfigurationBuilder builder = new ConfigurationBuilder();
        ((SingleFileStoreConfigurationBuilder)builder.memory().maxCount(4096L).locking().concurrencyLevel(2048).invocationBatching().enable().persistence().passivation(false).addSingleFileStore().shared(false)).preload(true);
        this.amendConfiguration(builder);
        GlobalConfigurationBuilder globalBuilder = new GlobalConfigurationBuilder().nonClusteredDefault();
        globalBuilder.globalState().enable().persistentLocation(this.tmpDirectory);
        CyclicBarrier barrier = new CyclicBarrier(2);
        AtomicReference putThread = new AtomicReference();
        try (DefaultCacheManager cm = new DefaultCacheManager(globalBuilder.build());){
            cm.defineConfiguration("leak", builder.build());
            Cache c = cm.getCache("leak");
            c.put((Object)"key1", (Object)"value1");
            putFuture = this.fork(() -> this.lambda$doCheckThreadLocalLeaks$1(putThread, (EmbeddedCacheManager)cm, barrier));
            c.put((Object)"key3", (Object)"value3");
            barrier.await(10L, TimeUnit.SECONDS);
        }
        Map<Class<?>, Object> mainThreadLeaks = this.findThreadLocalLeaks(Thread.currentThread());
        AssertJUnit.assertEquals(Collections.emptySet(), mainThreadLeaks.keySet());
        Map<Class<?>, Object> forkThreadLeaks = this.findThreadLocalLeaks((Thread)putThread.get());
        AssertJUnit.assertEquals(Collections.singleton(this.DUMMY_THREAD_LOCAL.getClass()), forkThreadLeaks.keySet());
        barrier.await(10L, TimeUnit.SECONDS);
        putFuture.get(10L, TimeUnit.SECONDS);
    }

    protected void amendConfiguration(ConfigurationBuilder builder) {
    }

    private Map<Class<?>, Object> findThreadLocalLeaks(Thread thread) throws Exception {
        Object table;
        Field threadLocalsField = Thread.class.getDeclaredField("threadLocals");
        threadLocalsField.setAccessible(true);
        Object threadLocalTable = threadLocalsField.get(thread);
        Class<?> threadLocalMapClass = Class.forName("java.lang.ThreadLocal$ThreadLocalMap");
        Field tableField = threadLocalMapClass.getDeclaredField("table");
        tableField.setAccessible(true);
        try {
            table = tableField.get(threadLocalTable);
        }
        catch (NullPointerException e) {
            return null;
        }
        Class<?> entryClass = Class.forName("java.lang.ThreadLocal$ThreadLocalMap$Entry");
        Field valueField = entryClass.getDeclaredField("value");
        valueField.setAccessible(true);
        HashMap threadLocals = new HashMap();
        for (int i = 0; i < Array.getLength(table); ++i) {
            Reference entry = (Reference)Array.get(table, i);
            if (entry == null) continue;
            ThreadLocal threadLocal = (ThreadLocal)entry.get();
            Object value = valueField.get(entry);
            if (threadLocal != null) {
                if (!this.filterThreadLocals(threadLocal, value) || ACCEPTED_THREAD_LOCALS.contains(threadLocal.getClass().getCanonicalName())) continue;
                log.error((Object)("Thread local leak: " + threadLocal));
                threadLocals.put(threadLocal.getClass(), value);
                continue;
            }
            log.warn((Object)("Thread local is not accessible, but it wasn't removed either: " + value));
        }
        return threadLocals;
    }

    private boolean filterThreadLocals(ThreadLocal<?> tl, Object value) {
        String tlClassName = tl.getClass().getName();
        String valueClassName = value != null ? value.getClass().getName() : "";
        log.tracef("Checking thread-local %s = %s", (Object)tlClassName, (Object)valueClassName);
        if (!THREAD_LOCAL_FILTER.matcher(tlClassName).find() && !THREAD_LOCAL_FILTER.matcher(valueClassName).find()) {
            return false;
        }
        return !ACCEPTED_THREAD_LOCALS.contains(tlClassName) && !ACCEPTED_THREAD_LOCALS.contains(valueClassName);
    }

    private /* synthetic */ void lambda$doCheckThreadLocalLeaks$1(AtomicReference putThread, EmbeddedCacheManager cm, CyclicBarrier barrier) throws Exception {
        AssertJUnit.assertSame((Object)this, (Object)this.DUMMY_THREAD_LOCAL.get());
        putThread.set(Thread.currentThread());
        Cache c1 = cm.getCache("leak");
        c1.put((Object)"key2", (Object)"value2");
        c1 = null;
        barrier.await(10L, TimeUnit.SECONDS);
        barrier.await(10L, TimeUnit.SECONDS);
    }
}

