/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.interceptors.BaseCustomAsyncInterceptor;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TransactionTrackInterceptor
extends BaseCustomAsyncInterceptor {
    private static final Log log = LogFactory.getLog(TransactionTrackInterceptor.class);
    private static final GlobalTransaction CLEAR_TRANSACTION = new ClearGlobalTransaction();
    private final Set<GlobalTransaction> localTransactionsSeen = new HashSet<GlobalTransaction>();
    private final Set<GlobalTransaction> remoteTransactionsSeen = new HashSet<GlobalTransaction>();
    private final ArrayList<GlobalTransaction> localTransactionsOperation = new ArrayList(8);

    private TransactionTrackInterceptor() {
    }

    public static TransactionTrackInterceptor injectInCache(Cache<?, ?> cache) {
        AsyncInterceptorChain chain = cache.getAdvancedCache().getAsyncInterceptorChain();
        if (chain.containsInterceptorType(TransactionTrackInterceptor.class)) {
            return (TransactionTrackInterceptor)chain.findInterceptorWithClass(TransactionTrackInterceptor.class);
        }
        TransactionTrackInterceptor interceptor = new TransactionTrackInterceptor();
        cache.getAdvancedCache().getComponentRegistry().wireDependencies((Object)interceptor);
        TestingUtil.startComponent((Object)interceptor);
        chain.addInterceptor((AsyncInterceptor)interceptor, 0);
        return interceptor;
    }

    public final synchronized GlobalTransaction getLastExecutedTransaction() {
        int size = this.localTransactionsOperation.size();
        if (size == 0) {
            return null;
        }
        return this.localTransactionsOperation.get(size - 1);
    }

    public final synchronized List<GlobalTransaction> getExecutedTransactions() {
        return Collections.unmodifiableList(this.localTransactionsOperation);
    }

    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        return this.invokeNextAndFinally(ctx, (VisitableCommand)command, (rCtx, rCommand, rv, t) -> {
            if (rCtx.isOriginLocal()) {
                this.addLocalTransaction(CLEAR_TRANSACTION);
                this.seen(CLEAR_TRANSACTION, false);
            }
            this.seen(CLEAR_TRANSACTION, rCtx.isOriginLocal());
        });
    }

    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        return this.invokeNextAndFinally((InvocationContext)ctx, (VisitableCommand)command, (rCtx, rCommand, rv, t) -> this.seen(command.getGlobalTransaction(), rCtx.isOriginLocal()));
    }

    public Object visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) throws Throwable {
        return this.invokeNextAndFinally((InvocationContext)ctx, (VisitableCommand)command, (rCtx, rCommand, rv, t) -> this.seen(command.getGlobalTransaction(), rCtx.isOriginLocal()));
    }

    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        return this.invokeNextAndFinally((InvocationContext)ctx, (VisitableCommand)command, (rCtx, rCommand, rv, t) -> this.seen(command.getGlobalTransaction(), rCtx.isOriginLocal()));
    }

    public boolean awaitForLocalCompletion(GlobalTransaction globalTransaction, long timeout, TimeUnit unit) throws InterruptedException {
        long endTimeout = unit.toMillis(timeout) + System.currentTimeMillis();
        while (System.currentTimeMillis() < endTimeout && !this.completedLocalTransactions(globalTransaction)) {
            this.sleep();
        }
        boolean completed = this.completedLocalTransactions(globalTransaction);
        if (log.isDebugEnabled()) {
            log.debugf("[local] is %d completed? %s", (Object)globalTransaction.getId(), (Object)completed);
        }
        return completed;
    }

    public boolean awaitForRemoteCompletion(GlobalTransaction globalTransaction, long timeout, TimeUnit unit) throws InterruptedException {
        long endTimeout = unit.toMillis(timeout) + System.currentTimeMillis();
        while (System.currentTimeMillis() < endTimeout && !this.completedRemoteTransactions(globalTransaction)) {
            this.sleep();
        }
        boolean completed = this.completedRemoteTransactions(globalTransaction);
        if (log.isDebugEnabled()) {
            log.debugf("[remote] is %d completed? %s", (Object)globalTransaction.getId(), (Object)completed);
        }
        return completed;
    }

    public boolean awaitForLocalCompletion(int expectedTransactions, long timeout, TimeUnit unit) throws InterruptedException {
        long endTimeout = unit.toMillis(timeout) + System.currentTimeMillis();
        while (System.currentTimeMillis() < endTimeout && this.completedLocalTransactions() < expectedTransactions) {
            this.sleep();
        }
        if (log.isDebugEnabled()) {
            log.debugf("[local] check for completion. seen=%s, expected=%s", this.localTransactionsSeen.size(), expectedTransactions);
        }
        return this.completedLocalTransactions() >= expectedTransactions;
    }

    public boolean awaitForRemoteCompletion(int expectedTransactions, long timeout, TimeUnit unit) throws InterruptedException {
        long endTimeout = unit.toMillis(timeout) + System.currentTimeMillis();
        while (System.currentTimeMillis() < endTimeout && this.completedRemoteTransactions() < expectedTransactions) {
            this.sleep();
        }
        if (log.isDebugEnabled()) {
            log.debugf("[remote] check for completion. seen=%s, expected=%s", this.remoteTransactionsSeen.size(), expectedTransactions);
        }
        return this.completedRemoteTransactions() >= expectedTransactions;
    }

    public synchronized void reset() {
        this.localTransactionsSeen.clear();
        this.remoteTransactionsSeen.clear();
        this.localTransactionsOperation.clear();
    }

    protected Object handleDefault(InvocationContext ctx, VisitableCommand command) throws Throwable {
        return this.invokeNextAndFinally(ctx, command, (rCtx, rCommand, rv, t) -> {
            if (rCtx.isOriginLocal() && rCtx.isInTxScope()) {
                GlobalTransaction globalTransaction = ((TxInvocationContext)rCtx).getGlobalTransaction();
                this.addLocalTransaction(globalTransaction);
            }
        });
    }

    private synchronized void addLocalTransaction(GlobalTransaction globalTransaction) {
        if (!this.localTransactionsOperation.contains(globalTransaction)) {
            this.localTransactionsOperation.add(globalTransaction);
        }
    }

    private synchronized void seen(GlobalTransaction globalTransaction, boolean local) {
        log.tracef("Seen transaction %s. Local? %s", (Object)globalTransaction, (Object)local);
        if (local) {
            this.localTransactionsSeen.add(globalTransaction);
        } else {
            this.remoteTransactionsSeen.add(globalTransaction);
        }
    }

    private void sleep() throws InterruptedException {
        Thread.sleep(100L);
    }

    private synchronized int completedLocalTransactions() {
        int count = 0;
        TransactionTable transactionTable = this.getTransactionTable();
        for (GlobalTransaction tx : this.localTransactionsSeen) {
            if (transactionTable.containsLocalTx(tx)) continue;
            ++count;
        }
        return count;
    }

    private synchronized int completedRemoteTransactions() {
        int count = 0;
        TransactionTable transactionTable = this.getTransactionTable();
        for (GlobalTransaction tx : this.remoteTransactionsSeen) {
            if (transactionTable.containRemoteTx(tx)) continue;
            ++count;
        }
        return count;
    }

    private synchronized boolean completedLocalTransactions(GlobalTransaction globalTransaction) {
        return this.localTransactionsSeen.contains(globalTransaction) && !this.getTransactionTable().containsLocalTx(globalTransaction);
    }

    private synchronized boolean completedRemoteTransactions(GlobalTransaction globalTransaction) {
        return this.remoteTransactionsSeen.contains(globalTransaction) && !this.getTransactionTable().containRemoteTx(globalTransaction);
    }

    private TransactionTable getTransactionTable() {
        return (TransactionTable)this.cache.getAdvancedCache().getComponentRegistry().getComponent(TransactionTable.class);
    }

    private static class ClearGlobalTransaction
    extends GlobalTransaction {
        ClearGlobalTransaction() {
            super(null, false);
        }
    }
}

