/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.mocks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.infinispan.Cache;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.functional.Mutation;
import org.infinispan.commands.functional.ReadOnlyKeyCommand;
import org.infinispan.commands.functional.ReadOnlyManyCommand;
import org.infinispan.commands.functional.ReadWriteKeyCommand;
import org.infinispan.commands.functional.ReadWriteKeyValueCommand;
import org.infinispan.commands.functional.ReadWriteManyCommand;
import org.infinispan.commands.functional.ReadWriteManyEntriesCommand;
import org.infinispan.commands.functional.TxReadOnlyKeyCommand;
import org.infinispan.commands.functional.TxReadOnlyManyCommand;
import org.infinispan.commands.functional.WriteOnlyKeyCommand;
import org.infinispan.commands.functional.WriteOnlyKeyValueCommand;
import org.infinispan.commands.functional.WriteOnlyManyCommand;
import org.infinispan.commands.functional.WriteOnlyManyEntriesCommand;
import org.infinispan.commands.irac.IracCleanupKeyCommand;
import org.infinispan.commands.irac.IracCleanupTombstoneCommand;
import org.infinispan.commands.irac.IracClearKeysCommand;
import org.infinispan.commands.irac.IracMetadataRequestCommand;
import org.infinispan.commands.irac.IracPutKeyCommand;
import org.infinispan.commands.irac.IracRemoveKeyCommand;
import org.infinispan.commands.irac.IracRequestStateCommand;
import org.infinispan.commands.irac.IracStateResponseCommand;
import org.infinispan.commands.irac.IracTouchKeyCommand;
import org.infinispan.commands.irac.IracUpdateVersionCommand;
import org.infinispan.commands.read.EntrySetCommand;
import org.infinispan.commands.read.GetAllCommand;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.read.KeySetCommand;
import org.infinispan.commands.read.SizeCommand;
import org.infinispan.commands.remote.CheckTransactionRpcCommand;
import org.infinispan.commands.remote.ClusteredGetAllCommand;
import org.infinispan.commands.remote.ClusteredGetCommand;
import org.infinispan.commands.remote.GetKeysInGroupCommand;
import org.infinispan.commands.remote.RenewBiasCommand;
import org.infinispan.commands.remote.RevokeBiasCommand;
import org.infinispan.commands.remote.SingleRpcCommand;
import org.infinispan.commands.remote.recovery.CompleteTransactionCommand;
import org.infinispan.commands.remote.recovery.GetInDoubtTransactionsCommand;
import org.infinispan.commands.remote.recovery.GetInDoubtTxInfoCommand;
import org.infinispan.commands.remote.recovery.TxCompletionNotificationCommand;
import org.infinispan.commands.statetransfer.ConflictResolutionStartCommand;
import org.infinispan.commands.statetransfer.ScatteredStateConfirmRevokedCommand;
import org.infinispan.commands.statetransfer.ScatteredStateGetKeysCommand;
import org.infinispan.commands.statetransfer.StateResponseCommand;
import org.infinispan.commands.statetransfer.StateTransferCancelCommand;
import org.infinispan.commands.statetransfer.StateTransferGetListenersCommand;
import org.infinispan.commands.statetransfer.StateTransferGetTransactionsCommand;
import org.infinispan.commands.statetransfer.StateTransferStartCommand;
import org.infinispan.commands.triangle.BackupNoopCommand;
import org.infinispan.commands.triangle.MultiEntriesFunctionalBackupWriteCommand;
import org.infinispan.commands.triangle.MultiKeyFunctionalBackupWriteCommand;
import org.infinispan.commands.triangle.PutMapBackupWriteCommand;
import org.infinispan.commands.triangle.SingleKeyBackupWriteCommand;
import org.infinispan.commands.triangle.SingleKeyFunctionalBackupWriteCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.tx.VersionedCommitCommand;
import org.infinispan.commands.tx.VersionedPrepareCommand;
import org.infinispan.commands.write.BackupAckCommand;
import org.infinispan.commands.write.BackupMultiKeyAckCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.ComputeCommand;
import org.infinispan.commands.write.ComputeIfAbsentCommand;
import org.infinispan.commands.write.EvictCommand;
import org.infinispan.commands.write.ExceptionAckCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.InvalidateVersionsCommand;
import org.infinispan.commands.write.IracPutKeyValueCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.RemoveExpiredCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.tx.XidImpl;
import org.infinispan.commons.util.IntSet;
import org.infinispan.configuration.cache.XSiteStateTransferMode;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.versioning.irac.IracEntryVersion;
import org.infinispan.encoding.DataConversion;
import org.infinispan.expiration.impl.TouchCommand;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.impl.Params;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.IracMetadata;
import org.infinispan.metadata.impl.PrivateMetadata;
import org.infinispan.notifications.cachelistener.cluster.ClusterEvent;
import org.infinispan.notifications.cachelistener.cluster.MultiClusterEventCommand;
import org.infinispan.reactive.publisher.impl.DeliveryGuarantee;
import org.infinispan.reactive.publisher.impl.commands.batch.CancelPublisherCommand;
import org.infinispan.reactive.publisher.impl.commands.batch.InitialPublisherCommand;
import org.infinispan.reactive.publisher.impl.commands.batch.NextPublisherCommand;
import org.infinispan.reactive.publisher.impl.commands.reduction.ReductionPublisherRequestCommand;
import org.infinispan.remoting.transport.Address;
import org.infinispan.statetransfer.StateChunk;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.concurrent.ReclosableLatch;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.SingleXSiteRpcCommand;
import org.infinispan.xsite.commands.XSiteAmendOfflineStatusCommand;
import org.infinispan.xsite.commands.XSiteAutoTransferStatusCommand;
import org.infinispan.xsite.commands.XSiteBringOnlineCommand;
import org.infinispan.xsite.commands.XSiteOfflineStatusCommand;
import org.infinispan.xsite.commands.XSiteSetStateTransferModeCommand;
import org.infinispan.xsite.commands.XSiteStateTransferCancelSendCommand;
import org.infinispan.xsite.commands.XSiteStateTransferClearStatusCommand;
import org.infinispan.xsite.commands.XSiteStateTransferFinishReceiveCommand;
import org.infinispan.xsite.commands.XSiteStateTransferFinishSendCommand;
import org.infinispan.xsite.commands.XSiteStateTransferRestartSendingCommand;
import org.infinispan.xsite.commands.XSiteStateTransferStartReceiveCommand;
import org.infinispan.xsite.commands.XSiteStateTransferStartSendCommand;
import org.infinispan.xsite.commands.XSiteStateTransferStatusRequestCommand;
import org.infinispan.xsite.commands.XSiteStatusCommand;
import org.infinispan.xsite.commands.XSiteTakeOfflineCommand;
import org.infinispan.xsite.statetransfer.XSiteState;
import org.infinispan.xsite.statetransfer.XSiteStatePushCommand;
import org.reactivestreams.Publisher;

public class ControlledCommandFactory
implements CommandsFactory {
    private static final Log log = LogFactory.getLog(ControlledCommandFactory.class);
    public final CommandsFactory actual;
    public final ReclosableLatch gate = new ReclosableLatch(true);
    public final AtomicInteger remoteCommandsReceived = new AtomicInteger(0);
    public final AtomicInteger blockTypeCommandsReceived = new AtomicInteger(0);
    public final List<ReplicableCommand> receivedCommands = new ArrayList<ReplicableCommand>();
    public final Class<? extends ReplicableCommand> toBlock;

    public ControlledCommandFactory(CommandsFactory actual, Class<? extends ReplicableCommand> toBlock) {
        this.actual = actual;
        this.toBlock = toBlock;
    }

    public int received(Class<? extends ReplicableCommand> command) {
        int result = 0;
        for (ReplicableCommand r : this.receivedCommands) {
            if (r.getClass() != command) continue;
            ++result;
        }
        return result;
    }

    public void initializeReplicableCommand(ReplicableCommand command, boolean isRemote) {
        log.tracef("Received command %s", (Object)command);
        this.receivedCommands.add(command);
        if (isRemote) {
            this.remoteCommandsReceived.incrementAndGet();
            if (this.toBlock != null && command.getClass().isAssignableFrom(this.toBlock)) {
                this.blockTypeCommandsReceived.incrementAndGet();
                try {
                    this.gate.await(30L, TimeUnit.SECONDS);
                    log.tracef("gate is opened, processing the lock cleanup:  %s", (Object)command);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        this.actual.initializeReplicableCommand(command, isRemote);
    }

    public static ControlledCommandFactory registerControlledCommandFactory(Cache cache, Class<? extends ReplicableCommand> toBlock) {
        ComponentRegistry componentRegistry = cache.getAdvancedCache().getComponentRegistry();
        ControlledCommandFactory ccf = new ControlledCommandFactory(componentRegistry.getCommandsFactory(), toBlock);
        TestingUtil.replaceComponent(cache, CommandsFactory.class, ccf, true);
        componentRegistry.getGlobalComponentRegistry().registerNamedComponentRegistry(componentRegistry, TestingUtil.getDefaultCacheName(cache.getCacheManager()));
        return ccf;
    }

    public PutKeyValueCommand buildPutKeyValueCommand(Object key, Object value, int segment, Metadata metadata, long flagsBitSet) {
        return this.actual.buildPutKeyValueCommand(key, value, segment, metadata, flagsBitSet);
    }

    public RemoveCommand buildRemoveCommand(Object key, Object value, int segment, long flagsBitSet) {
        return this.actual.buildRemoveCommand(key, value, segment, flagsBitSet);
    }

    public InvalidateCommand buildInvalidateCommand(long flagsBitSet, Object ... keys) {
        return this.actual.buildInvalidateCommand(flagsBitSet, keys);
    }

    public InvalidateCommand buildInvalidateFromL1Command(long flagsBitSet, Collection<Object> keys) {
        return this.actual.buildInvalidateFromL1Command(flagsBitSet, keys);
    }

    public InvalidateCommand buildInvalidateFromL1Command(Address origin, long flagsBitSet, Collection<Object> keys) {
        return this.actual.buildInvalidateFromL1Command(origin, flagsBitSet, keys);
    }

    public RemoveExpiredCommand buildRemoveExpiredCommand(Object key, Object value, int segment, Long lifespan, long flagsBitSet) {
        return this.actual.buildRemoveExpiredCommand(key, value, segment, lifespan, flagsBitSet);
    }

    public RemoveExpiredCommand buildRemoveExpiredCommand(Object key, Object value, int segment, long flagsBitSet) {
        return this.actual.buildRemoveExpiredCommand(key, value, segment, flagsBitSet);
    }

    public ReplaceCommand buildReplaceCommand(Object key, Object oldValue, Object newValue, int segment, Metadata metadata, long flagsBitSet) {
        return this.actual.buildReplaceCommand(key, oldValue, newValue, segment, metadata, flagsBitSet);
    }

    public ComputeCommand buildComputeCommand(Object key, BiFunction mappingFunction, boolean computeIfPresent, int segment, Metadata metadata, long flagsBitSet) {
        return this.actual.buildComputeCommand(key, mappingFunction, computeIfPresent, segment, metadata, flagsBitSet);
    }

    public ComputeIfAbsentCommand buildComputeIfAbsentCommand(Object key, Function mappingFunction, int segment, Metadata metadata, long flagsBitSet) {
        return this.actual.buildComputeIfAbsentCommand(key, mappingFunction, segment, metadata, flagsBitSet);
    }

    public SizeCommand buildSizeCommand(long flagsBitSet) {
        return this.actual.buildSizeCommand(flagsBitSet);
    }

    public GetKeyValueCommand buildGetKeyValueCommand(Object key, int segment, long flagsBitSet) {
        return this.actual.buildGetKeyValueCommand(key, segment, flagsBitSet);
    }

    public GetAllCommand buildGetAllCommand(Collection<?> keys, long flagsBitSet, boolean returnEntries) {
        return this.actual.buildGetAllCommand(keys, flagsBitSet, returnEntries);
    }

    public KeySetCommand buildKeySetCommand(long flagsBitSet) {
        return this.actual.buildKeySetCommand(flagsBitSet);
    }

    public EntrySetCommand buildEntrySetCommand(long flagsBitSet) {
        return this.actual.buildEntrySetCommand(flagsBitSet);
    }

    public PutMapCommand buildPutMapCommand(Map<?, ?> map, Metadata metadata, long flagsBitSet) {
        return this.actual.buildPutMapCommand(map, metadata, flagsBitSet);
    }

    public ClearCommand buildClearCommand(long flagsBitSet) {
        return this.actual.buildClearCommand(flagsBitSet);
    }

    public EvictCommand buildEvictCommand(Object key, int segment, long flagsBitSet) {
        return this.actual.buildEvictCommand(key, segment, flagsBitSet);
    }

    public PrepareCommand buildPrepareCommand(GlobalTransaction gtx, List<WriteCommand> modifications, boolean onePhaseCommit) {
        return this.actual.buildPrepareCommand(gtx, modifications, onePhaseCommit);
    }

    public VersionedPrepareCommand buildVersionedPrepareCommand(GlobalTransaction gtx, List<WriteCommand> modifications, boolean onePhase) {
        return this.actual.buildVersionedPrepareCommand(gtx, modifications, onePhase);
    }

    public CommitCommand buildCommitCommand(GlobalTransaction gtx) {
        return this.actual.buildCommitCommand(gtx);
    }

    public VersionedCommitCommand buildVersionedCommitCommand(GlobalTransaction gtx) {
        return this.actual.buildVersionedCommitCommand(gtx);
    }

    public RollbackCommand buildRollbackCommand(GlobalTransaction gtx) {
        return this.actual.buildRollbackCommand(gtx);
    }

    public SingleRpcCommand buildSingleRpcCommand(VisitableCommand call) {
        return this.actual.buildSingleRpcCommand(call);
    }

    public ClusteredGetCommand buildClusteredGetCommand(Object key, Integer segment, long flagsBitSet) {
        return this.actual.buildClusteredGetCommand(key, segment, flagsBitSet);
    }

    public ClusteredGetAllCommand buildClusteredGetAllCommand(List<?> keys, long flagsBitSet, GlobalTransaction gtx) {
        return this.actual.buildClusteredGetAllCommand(keys, flagsBitSet, gtx);
    }

    public LockControlCommand buildLockControlCommand(Collection<?> keys, long flagsBitSet, GlobalTransaction gtx) {
        return this.actual.buildLockControlCommand(keys, flagsBitSet, gtx);
    }

    public LockControlCommand buildLockControlCommand(Object key, long flagsBitSet, GlobalTransaction gtx) {
        return this.actual.buildLockControlCommand(key, flagsBitSet, gtx);
    }

    public LockControlCommand buildLockControlCommand(Collection<?> keys, long flagsBitSet) {
        return this.actual.buildLockControlCommand(keys, flagsBitSet);
    }

    public ConflictResolutionStartCommand buildConflictResolutionStartCommand(int topologyId, IntSet segments) {
        return this.actual.buildConflictResolutionStartCommand(topologyId, segments);
    }

    public StateTransferCancelCommand buildStateTransferCancelCommand(int topologyId, IntSet segments) {
        return this.actual.buildStateTransferCancelCommand(topologyId, segments);
    }

    public StateTransferGetListenersCommand buildStateTransferGetListenersCommand(int topologyId) {
        return this.actual.buildStateTransferGetListenersCommand(topologyId);
    }

    public StateTransferGetTransactionsCommand buildStateTransferGetTransactionsCommand(int topologyId, IntSet segments) {
        return this.actual.buildStateTransferGetTransactionsCommand(topologyId, segments);
    }

    public StateTransferStartCommand buildStateTransferStartCommand(int topologyId, IntSet segments) {
        return this.actual.buildStateTransferStartCommand(topologyId, segments);
    }

    public ScatteredStateGetKeysCommand buildScatteredStateGetKeysCommand(int topologyId, IntSet segments) {
        return this.actual.buildScatteredStateGetKeysCommand(topologyId, segments);
    }

    public ScatteredStateConfirmRevokedCommand buildScatteredStateConfirmRevokeCommand(int topologyId, IntSet segments) {
        return this.actual.buildScatteredStateConfirmRevokeCommand(topologyId, segments);
    }

    public StateResponseCommand buildStateResponseCommand(int viewId, Collection<StateChunk> stateChunks, boolean applyState, boolean pushTransfer) {
        return this.actual.buildStateResponseCommand(viewId, stateChunks, applyState, pushTransfer);
    }

    public String getCacheName() {
        return this.actual.getCacheName();
    }

    public GetInDoubtTransactionsCommand buildGetInDoubtTransactionsCommand() {
        return this.actual.buildGetInDoubtTransactionsCommand();
    }

    public TxCompletionNotificationCommand buildTxCompletionNotificationCommand(XidImpl xid, GlobalTransaction globalTransaction) {
        return this.actual.buildTxCompletionNotificationCommand(xid, globalTransaction);
    }

    public GetInDoubtTxInfoCommand buildGetInDoubtTxInfoCommand() {
        return this.actual.buildGetInDoubtTxInfoCommand();
    }

    public CompleteTransactionCommand buildCompleteTransactionCommand(XidImpl xid, boolean commit) {
        return this.actual.buildCompleteTransactionCommand(xid, commit);
    }

    public TxCompletionNotificationCommand buildTxCompletionNotificationCommand(long internalId) {
        return this.actual.buildTxCompletionNotificationCommand(internalId);
    }

    public XSiteStateTransferCancelSendCommand buildXSiteStateTransferCancelSendCommand(String siteName) {
        return this.actual.buildXSiteStateTransferCancelSendCommand(siteName);
    }

    public XSiteStateTransferClearStatusCommand buildXSiteStateTransferClearStatusCommand() {
        return this.actual.buildXSiteStateTransferClearStatusCommand();
    }

    public XSiteStateTransferFinishReceiveCommand buildXSiteStateTransferFinishReceiveCommand(String siteName) {
        return this.actual.buildXSiteStateTransferFinishReceiveCommand(siteName);
    }

    public XSiteStateTransferFinishSendCommand buildXSiteStateTransferFinishSendCommand(String siteName, boolean statusOk) {
        return this.actual.buildXSiteStateTransferFinishSendCommand(siteName, statusOk);
    }

    public XSiteStateTransferRestartSendingCommand buildXSiteStateTransferRestartSendingCommand(String siteName, int topologyId) {
        return this.actual.buildXSiteStateTransferRestartSendingCommand(siteName, topologyId);
    }

    public XSiteStateTransferStartReceiveCommand buildXSiteStateTransferStartReceiveCommand() {
        return this.actual.buildXSiteStateTransferStartReceiveCommand();
    }

    public XSiteStateTransferStartSendCommand buildXSiteStateTransferStartSendCommand(String siteName, int topologyId) {
        return this.actual.buildXSiteStateTransferStartSendCommand(siteName, topologyId);
    }

    public XSiteStateTransferStatusRequestCommand buildXSiteStateTransferStatusRequestCommand() {
        return this.actual.buildXSiteStateTransferStatusRequestCommand();
    }

    public XSiteAmendOfflineStatusCommand buildXSiteAmendOfflineStatusCommand(String siteName, Integer afterFailures, Long minTimeToWait) {
        return this.actual.buildXSiteAmendOfflineStatusCommand(siteName, afterFailures, minTimeToWait);
    }

    public XSiteBringOnlineCommand buildXSiteBringOnlineCommand(String siteName) {
        return this.actual.buildXSiteBringOnlineCommand(siteName);
    }

    public XSiteOfflineStatusCommand buildXSiteOfflineStatusCommand(String siteName) {
        return this.actual.buildXSiteOfflineStatusCommand(siteName);
    }

    public XSiteStatusCommand buildXSiteStatusCommand() {
        return this.actual.buildXSiteStatusCommand();
    }

    public XSiteTakeOfflineCommand buildXSiteTakeOfflineCommand(String siteName) {
        return this.actual.buildXSiteTakeOfflineCommand(siteName);
    }

    public XSiteStatePushCommand buildXSiteStatePushCommand(XSiteState[] chunk, long timeoutMillis) {
        return this.actual.buildXSiteStatePushCommand(chunk, timeoutMillis);
    }

    public SingleXSiteRpcCommand buildSingleXSiteRpcCommand(VisitableCommand command) {
        return this.actual.buildSingleXSiteRpcCommand(command);
    }

    public GetKeysInGroupCommand buildGetKeysInGroupCommand(long flagsBitSet, Object groupName) {
        return this.actual.buildGetKeysInGroupCommand(flagsBitSet, groupName);
    }

    public GetCacheEntryCommand buildGetCacheEntryCommand(Object key, int segment, long flagsBitSet) {
        return this.actual.buildGetCacheEntryCommand(key, segment, flagsBitSet);
    }

    public <K, V, R> ReadOnlyKeyCommand<K, V, R> buildReadOnlyKeyCommand(Object key, Function<EntryView.ReadEntryView<K, V>, R> f, int segment, Params params, DataConversion keyDataConversion, DataConversion valueDataConversion) {
        return this.actual.buildReadOnlyKeyCommand(key, f, segment, params, keyDataConversion, valueDataConversion);
    }

    public <K, V, R> ReadOnlyManyCommand<K, V, R> buildReadOnlyManyCommand(Collection<?> keys, Function<EntryView.ReadEntryView<K, V>, R> f, Params params, DataConversion keyDataConversion, DataConversion valueDataConversion) {
        return this.actual.buildReadOnlyManyCommand(keys, f, params, keyDataConversion, valueDataConversion);
    }

    public <K, V, T, R> ReadWriteKeyValueCommand<K, V, T, R> buildReadWriteKeyValueCommand(Object key, Object argument, BiFunction<T, EntryView.ReadWriteEntryView<K, V>, R> f, int segment, Params params, DataConversion keyDataConversion, DataConversion valueDataConversion) {
        return this.actual.buildReadWriteKeyValueCommand(key, argument, f, segment, params, keyDataConversion, valueDataConversion);
    }

    public <K, V, R> ReadWriteKeyCommand<K, V, R> buildReadWriteKeyCommand(Object key, Function<EntryView.ReadWriteEntryView<K, V>, R> f, int segment, Params params, DataConversion keyDataConversion, DataConversion valueDataConversion) {
        return this.actual.buildReadWriteKeyCommand(key, f, segment, params, keyDataConversion, valueDataConversion);
    }

    public <K, V, R> ReadWriteManyCommand<K, V, R> buildReadWriteManyCommand(Collection<?> keys, Function<EntryView.ReadWriteEntryView<K, V>, R> f, Params params, DataConversion keyDataConversion, DataConversion valueDataConversion) {
        return this.actual.buildReadWriteManyCommand(keys, f, params, keyDataConversion, valueDataConversion);
    }

    public <K, V, T, R> ReadWriteManyEntriesCommand<K, V, T, R> buildReadWriteManyEntriesCommand(Map<?, ?> entries, BiFunction<T, EntryView.ReadWriteEntryView<K, V>, R> f, Params params, DataConversion keyDataConversion, DataConversion valueDataConversion) {
        return this.actual.buildReadWriteManyEntriesCommand(entries, f, params, keyDataConversion, valueDataConversion);
    }

    public <K, V> WriteOnlyKeyCommand<K, V> buildWriteOnlyKeyCommand(Object key, Consumer<EntryView.WriteEntryView<K, V>> f, int segment, Params params, DataConversion keyDataConversion, DataConversion valueDataConversion) {
        return this.actual.buildWriteOnlyKeyCommand(key, f, segment, params, keyDataConversion, valueDataConversion);
    }

    public <K, V, T> WriteOnlyKeyValueCommand<K, V, T> buildWriteOnlyKeyValueCommand(Object key, Object argument, BiConsumer<T, EntryView.WriteEntryView<K, V>> f, int segment, Params params, DataConversion keyDataConversion, DataConversion valueDataConversion) {
        return this.actual.buildWriteOnlyKeyValueCommand(key, argument, f, segment, params, keyDataConversion, valueDataConversion);
    }

    public <K, V> WriteOnlyManyCommand<K, V> buildWriteOnlyManyCommand(Collection<?> keys, Consumer<EntryView.WriteEntryView<K, V>> f, Params params, DataConversion keyDataConversion, DataConversion valueDataConversion) {
        return this.actual.buildWriteOnlyManyCommand(keys, f, params, keyDataConversion, valueDataConversion);
    }

    public <K, V, T> WriteOnlyManyEntriesCommand<K, V, T> buildWriteOnlyManyEntriesCommand(Map<?, ?> arguments, BiConsumer<T, EntryView.WriteEntryView<K, V>> f, Params params, DataConversion keyDataConversion, DataConversion valueDataConversion) {
        return this.actual.buildWriteOnlyManyEntriesCommand(arguments, f, params, keyDataConversion, valueDataConversion);
    }

    public <K, V, R> TxReadOnlyKeyCommand<K, V, R> buildTxReadOnlyKeyCommand(Object key, Function<EntryView.ReadEntryView<K, V>, R> f, List<Mutation<K, V, ?>> mutations, int segment, Params params, DataConversion keyDataConversion, DataConversion valueDataConversion) {
        return this.actual.buildTxReadOnlyKeyCommand(key, f, mutations, segment, params, keyDataConversion, valueDataConversion);
    }

    public <K, V, R> TxReadOnlyManyCommand<K, V, R> buildTxReadOnlyManyCommand(Collection<?> keys, List<List<Mutation<K, V, ?>>> mutations, Params params, DataConversion keyDataConversion, DataConversion valueDataConversion) {
        return this.actual.buildTxReadOnlyManyCommand(keys, mutations, params, keyDataConversion, valueDataConversion);
    }

    public BackupAckCommand buildBackupAckCommand(long id, int topologyId) {
        return this.actual.buildBackupAckCommand(id, topologyId);
    }

    public BackupMultiKeyAckCommand buildBackupMultiKeyAckCommand(long id, int segment, int topologyId) {
        return this.actual.buildBackupMultiKeyAckCommand(id, segment, topologyId);
    }

    public ExceptionAckCommand buildExceptionAckCommand(long id, Throwable throwable, int topologyId) {
        return this.actual.buildExceptionAckCommand(id, throwable, topologyId);
    }

    public InvalidateVersionsCommand buildInvalidateVersionsCommand(int topologyId, Object[] keys, int[] topologyIds, long[] versions, boolean removed) {
        return this.actual.buildInvalidateVersionsCommand(topologyId, keys, topologyIds, versions, removed);
    }

    public RevokeBiasCommand buildRevokeBiasCommand(Address ackTarget, long id, int topologyId, Collection<Object> keys) {
        return this.actual.buildRevokeBiasCommand(ackTarget, id, topologyId, keys);
    }

    public RenewBiasCommand buildRenewBiasCommand(Object[] keys) {
        return this.actual.buildRenewBiasCommand(keys);
    }

    public SingleKeyBackupWriteCommand buildSingleKeyBackupWriteCommand() {
        return this.actual.buildSingleKeyBackupWriteCommand();
    }

    public SingleKeyFunctionalBackupWriteCommand buildSingleKeyFunctionalBackupWriteCommand() {
        return this.actual.buildSingleKeyFunctionalBackupWriteCommand();
    }

    public PutMapBackupWriteCommand buildPutMapBackupWriteCommand() {
        return this.actual.buildPutMapBackupWriteCommand();
    }

    public MultiEntriesFunctionalBackupWriteCommand buildMultiEntriesFunctionalBackupWriteCommand() {
        return this.actual.buildMultiEntriesFunctionalBackupWriteCommand();
    }

    public MultiKeyFunctionalBackupWriteCommand buildMultiKeyFunctionalBackupWriteCommand() {
        return this.actual.buildMultiKeyFunctionalBackupWriteCommand();
    }

    public BackupNoopCommand buildBackupNoopCommand() {
        return this.actual.buildBackupNoopCommand();
    }

    public <K, R> ReductionPublisherRequestCommand<K> buildKeyReductionPublisherCommand(boolean parallelStream, DeliveryGuarantee deliveryGuarantee, IntSet segments, Set<K> keys, Set<K> excludedKeys, boolean includeLoader, Function<? super Publisher<K>, ? extends CompletionStage<R>> transformer, Function<? super Publisher<R>, ? extends CompletionStage<R>> finalizer) {
        return this.actual.buildKeyReductionPublisherCommand(parallelStream, deliveryGuarantee, segments, keys, excludedKeys, includeLoader, transformer, finalizer);
    }

    public <K, V, R> ReductionPublisherRequestCommand<K> buildEntryReductionPublisherCommand(boolean parallelStream, DeliveryGuarantee deliveryGuarantee, IntSet segments, Set<K> keys, Set<K> excludedKeys, boolean includeLoader, Function<? super Publisher<CacheEntry<K, V>>, ? extends CompletionStage<R>> transformer, Function<? super Publisher<R>, ? extends CompletionStage<R>> finalizer) {
        return this.actual.buildEntryReductionPublisherCommand(parallelStream, deliveryGuarantee, segments, keys, excludedKeys, includeLoader, transformer, finalizer);
    }

    public <K, I, R> InitialPublisherCommand<K, I, R> buildInitialPublisherCommand(String requestId, DeliveryGuarantee deliveryGuarantee, int batchSize, IntSet segments, Set<K> keys, Set<K> excludedKeys, boolean includeLoader, boolean entryStream, boolean trackKeys, Function<? super Publisher<I>, ? extends Publisher<R>> transformer) {
        return this.actual.buildInitialPublisherCommand(requestId, deliveryGuarantee, batchSize, segments, keys, excludedKeys, includeLoader, entryStream, trackKeys, transformer);
    }

    public NextPublisherCommand buildNextPublisherCommand(String requestId) {
        return this.actual.buildNextPublisherCommand(requestId);
    }

    public CancelPublisherCommand buildCancelPublisherCommand(String requestId) {
        return this.actual.buildCancelPublisherCommand(requestId);
    }

    public <K, V> MultiClusterEventCommand<K, V> buildMultiClusterEventCommand(Map<UUID, Collection<ClusterEvent<K, V>>> events) {
        return this.actual.buildMultiClusterEventCommand(events);
    }

    public CheckTransactionRpcCommand buildCheckTransactionRpcCommand(Collection<GlobalTransaction> globalTransactions) {
        return this.actual.buildCheckTransactionRpcCommand(globalTransactions);
    }

    public TouchCommand buildTouchCommand(Object key, int segment, boolean touchEvenIfExpired, long flagBitSet) {
        return this.actual.buildTouchCommand(key, segment, touchEvenIfExpired, flagBitSet);
    }

    public <K, V> IracPutKeyCommand buildIracPutKeyCommand(InternalCacheEntry<K, V> entry) {
        return this.actual.buildIracPutKeyCommand(entry);
    }

    public IracRemoveKeyCommand buildIracRemoveKeyCommand(Object key, IracMetadata iracMetadata, boolean expiration) {
        return this.actual.buildIracRemoveKeyCommand(key, iracMetadata, expiration);
    }

    public IracClearKeysCommand buildIracClearKeysCommand() {
        return this.actual.buildIracClearKeysCommand();
    }

    public IracCleanupKeyCommand buildIracCleanupKeyCommand(int segment, Object key, Object lockOwner) {
        return this.actual.buildIracCleanupKeyCommand(segment, key, lockOwner);
    }

    public IracCleanupTombstoneCommand buildIracCleanupTombstoneCommand(Object key, IracMetadata tombstone) {
        return this.actual.buildIracCleanupTombstoneCommand(key, tombstone);
    }

    public IracMetadataRequestCommand buildIracMetadataRequestCommand(int segment, IracEntryVersion versionSeen) {
        return this.actual.buildIracMetadataRequestCommand(segment, versionSeen);
    }

    public IracRequestStateCommand buildIracRequestStateCommand(IntSet segments) {
        return this.actual.buildIracRequestStateCommand(segments);
    }

    public IracStateResponseCommand buildIracStateResponseCommand(int segment, Object key, Object lockOwner, IracMetadata tombstone) {
        return this.actual.buildIracStateResponseCommand(segment, key, lockOwner, tombstone);
    }

    public IracPutKeyValueCommand buildIracPutKeyValueCommand(Object key, int segment, Object value, Metadata metadata, PrivateMetadata privateMetadata) {
        return this.actual.buildIracPutKeyValueCommand(key, segment, value, metadata, privateMetadata);
    }

    public IracTouchKeyCommand buildIracTouchCommand(Object key) {
        return this.actual.buildIracTouchCommand(key);
    }

    public IracUpdateVersionCommand buildIracUpdateVersionCommand(Map<Integer, IracEntryVersion> segmentsVersion) {
        return this.actual.buildIracUpdateVersionCommand(segmentsVersion);
    }

    public XSiteAutoTransferStatusCommand buildXSiteAutoTransferStatusCommand(String site) {
        return this.actual.buildXSiteAutoTransferStatusCommand(site);
    }

    public XSiteSetStateTransferModeCommand buildXSiteSetStateTransferModeCommand(String site, XSiteStateTransferMode mode) {
        return this.actual.buildXSiteSetStateTransferModeCommand(site, mode);
    }
}

