/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.tx.lookup;

import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.apache.geronimo.transaction.GeronimoUserTransaction;
import org.apache.geronimo.transaction.log.HOWLLog;
import org.apache.geronimo.transaction.manager.GeronimoTransactionManager;
import org.apache.geronimo.transaction.manager.TransactionLog;
import org.apache.geronimo.transaction.manager.XidFactory;
import org.apache.geronimo.transaction.manager.XidFactoryImpl;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.GLOBAL)
public class GeronimoTransactionManagerLookup
implements TransactionManagerLookup {
    private static final int DEFAULT_TRANSACTION_TIMEOUT = 600;
    private static final Log log = LogFactory.getLog(GeronimoTransactionManagerLookup.class);
    private TransactionManager manager;
    private UserTransaction userTransaction;
    private TransactionLog transactionLog;

    @Inject
    public void init(GlobalConfiguration globalCfg) {
        String bufferClassName = "org.objectweb.howl.log.BlockLogBuffer";
        boolean bufferSizeKBytes = true;
        boolean checksumEnabled = true;
        boolean adler32Checksum = true;
        int flushSleepTimeMilliseconds = 50;
        String logFileExt = "log";
        String logFileName = "transaction";
        int maxBlocksPerFile = -1;
        int maxLogFiles = 2;
        int minBuffers = 4;
        boolean maxBuffers = false;
        int threadsWaitingForceThreshold = -1;
        String logFileDir = System.getProperty("java.io.tmpdir");
        try {
            this.transactionLog = new HOWLLog("org.objectweb.howl.log.BlockLogBuffer", 1, true, true, 50, logFileDir, "log", "transaction", -1, 0, 2, 4, -1, (XidFactory)new XidFactoryImpl(), null);
            ((HOWLLog)this.transactionLog).doStart();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized TransactionManager getTransactionManager() throws Exception {
        if (this.manager == null) {
            try {
                this.manager = new GeronimoTransactionManager(600, this.transactionLog);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (log.isInfoEnabled()) {
            log.retrievingTm(this.manager);
        }
        return this.manager;
    }

    public UserTransaction getUserTransaction() throws Exception {
        if (this.userTransaction == null) {
            this.userTransaction = new GeronimoUserTransaction(this.getTransactionManager());
        }
        return this.userTransaction;
    }

    public String toString() {
        return "GeronimoTransactionManagerLookup";
    }
}

