/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite;

import java.util.Collections;
import java.util.LinkedList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.functional.WriteOnlyManyEntriesCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.IracPutKeyValueCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.container.versioning.irac.DefaultIracTombstoneManager;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.DistributionInfo;
import org.infinispan.distribution.DistributionTestHelper;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.metadata.impl.IracMetadata;
import org.infinispan.metadata.impl.PrivateMetadata;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.concurrent.IsolationLevel;
import org.infinispan.xsite.AbstractTwoSitesTest;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;

@Test(groups={"xsite"}, testName="xsite.AsyncBackupTest")
public class AsyncBackupTest
extends AbstractTwoSitesTest {
    private BlockingInterceptor blockingInterceptor;
    private ConfigMode lonConfigMode;
    private ConfigMode nycConfigMode;

    private static ConfigurationBuilder getConfig(ConfigMode configMode) {
        if (configMode == ConfigMode.NON_TX) {
            return AsyncBackupTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, false);
        }
        ConfigurationBuilder builder = AsyncBackupTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true);
        switch (configMode) {
            case OPTIMISTIC_TX_RC: {
                builder.transaction().lockingMode(LockingMode.OPTIMISTIC);
                builder.locking().isolationLevel(IsolationLevel.READ_COMMITTED);
                break;
            }
            case OPTIMISTIC_TX_RR: {
                builder.transaction().lockingMode(LockingMode.OPTIMISTIC);
                builder.locking().isolationLevel(IsolationLevel.REPEATABLE_READ);
                break;
            }
            case PESSIMISTIC_TX: {
                builder.transaction().lockingMode(LockingMode.PESSIMISTIC);
            }
        }
        return builder;
    }

    @Factory
    public Object[] factory() {
        LinkedList<AsyncBackupTest> tests = new LinkedList<AsyncBackupTest>();
        for (ConfigMode lon : ConfigMode.values()) {
            for (ConfigMode nyc : ConfigMode.values()) {
                tests.add(new AsyncBackupTest().setLonConfigMode(lon).setNycConfigMode(nyc));
            }
        }
        return tests.toArray();
    }

    @Override
    protected String[] parameterNames() {
        return new String[]{"LON", "NYC"};
    }

    @Override
    protected Object[] parameterValues() {
        return new Object[]{this.lonConfigMode, this.nycConfigMode};
    }

    @Override
    protected ConfigurationBuilder getNycActiveConfig() {
        return AsyncBackupTest.getConfig(this.nycConfigMode);
    }

    public AsyncBackupTest() {
        this.lonBackupStrategy = BackupConfiguration.BackupStrategy.ASYNC;
        this.nycBackupStrategy = BackupConfiguration.BackupStrategy.ASYNC;
        this.implicitBackupCache = true;
    }

    @Override
    protected void createSites() {
        super.createSites();
        this.blockingInterceptor = new BlockingInterceptor();
        TestingUtil.extractInterceptorChain(this.backup("LON-1")).addInterceptor((AsyncInterceptor)this.blockingInterceptor, 1);
    }

    @Override
    protected ConfigurationBuilder getLonActiveConfig() {
        return AsyncBackupTest.getConfig(this.lonConfigMode);
    }

    private AsyncBackupTest setLonConfigMode(ConfigMode configMode) {
        this.lonConfigMode = configMode;
        return this;
    }

    private AsyncBackupTest setNycConfigMode(ConfigMode configMode) {
        this.nycConfigMode = configMode;
        return this;
    }

    @BeforeMethod
    void resetBlockingInterceptor() {
        this.blockingInterceptor.reset();
    }

    public void testPut() throws Exception {
        this.cache("LON-1", 0).put((Object)"k", (Object)"v");
        this.assertReachedRemoteSite();
        AssertJUnit.assertEquals((Object)"v", (Object)this.cache("LON-1", 0).get((Object)"k"));
        AssertJUnit.assertEquals((Object)"v", (Object)this.cache("LON-1", 1).get((Object)"k"));
        AssertJUnit.assertNull((Object)this.backup("LON-1").get((Object)"k"));
        this.resumeRemoteSite();
        this.eventuallyEquals("v", () -> this.backup("LON-1").get((Object)"k"));
        this.assertDataContainerState("v");
        this.assertNoDataLeak();
    }

    public void testRemove() throws Exception {
        this.doPutWithDisabledBlockingInterceptor();
        this.cache("LON-1", 1).remove((Object)"k");
        this.assertReachedRemoteSite();
        AssertJUnit.assertNull((Object)this.cache("LON-1", 0).get((Object)"k"));
        AssertJUnit.assertNull((Object)this.cache("LON-1", 1).get((Object)"k"));
        AssertJUnit.assertEquals((Object)"v", (Object)this.backup("LON-1").get((Object)"k"));
        this.resumeRemoteSite();
        this.eventuallyEquals(null, () -> this.backup("LON-1").get((Object)"k"));
        this.assertNoDataLeak();
    }

    public void testClear() throws Exception {
        this.doPutWithDisabledBlockingInterceptor();
        this.cache("LON-1", 1).clear();
        this.assertReachedRemoteSite();
        AssertJUnit.assertNull((Object)this.cache("LON-1", 0).get((Object)"k"));
        AssertJUnit.assertNull((Object)this.cache("LON-1", 1).get((Object)"k"));
        AssertJUnit.assertEquals((Object)"v", (Object)this.backup("LON-1").get((Object)"k"));
        this.resumeRemoteSite();
        this.eventuallyEquals(null, () -> this.backup("LON-1").get((Object)"k"));
        this.assertNoDataLeak();
    }

    public void testReplace() throws Exception {
        this.doPutWithDisabledBlockingInterceptor();
        this.cache("LON-1", 1).replace((Object)"k", (Object)"v2");
        this.assertReachedRemoteSite();
        AssertJUnit.assertEquals((Object)"v2", (Object)this.cache("LON-1", 0).get((Object)"k"));
        AssertJUnit.assertEquals((Object)"v2", (Object)this.cache("LON-1", 1).get((Object)"k"));
        AssertJUnit.assertEquals((Object)"v", (Object)this.backup("LON-1").get((Object)"k"));
        this.resumeRemoteSite();
        this.eventuallyEquals("v2", () -> this.backup("LON-1").get((Object)"k"));
        this.assertDataContainerState("v2");
        this.assertNoDataLeak();
    }

    public void testPutAll() throws Exception {
        this.cache("LON-1", 0).putAll(Collections.singletonMap("k", "v"));
        this.assertReachedRemoteSite();
        AssertJUnit.assertEquals((Object)"v", (Object)this.cache("LON-1", 0).get((Object)"k"));
        AssertJUnit.assertEquals((Object)"v", (Object)this.cache("LON-1", 1).get((Object)"k"));
        AssertJUnit.assertNull((Object)this.backup("LON-1").get((Object)"k"));
        this.resumeRemoteSite();
        this.eventuallyEquals("v", () -> this.backup("LON-1").get((Object)"k"));
        this.assertDataContainerState("v");
        this.assertNoDataLeak();
    }

    public void testPutForExternalRead() throws InterruptedException {
        this.cache("LON-1", 0).putForExternalRead((Object)"k", (Object)"v");
        this.assertReachedRemoteSite();
        this.eventuallyEquals("v", () -> this.cache("LON-1", 0).get((Object)"k"));
        this.eventuallyEquals("v", () -> this.cache("LON-1", 1).get((Object)"k"));
        AssertJUnit.assertNull((Object)this.backup("LON-1").get((Object)"k"));
        this.resumeRemoteSite();
        this.eventuallyEquals("v", () -> this.backup("LON-1").get((Object)"k"));
        this.assertDataContainerState("v");
        this.assertNoDataLeak();
    }

    private void doPutWithDisabledBlockingInterceptor() {
        this.blockingInterceptor.isActive = false;
        this.cache("LON-1", 0).put((Object)"k", (Object)"v");
        this.eventuallyEquals("v", () -> this.backup("LON-1").get((Object)"k"));
        this.blockingInterceptor.isActive = true;
    }

    private void assertReachedRemoteSite() throws InterruptedException {
        try {
            AssertJUnit.assertTrue((boolean)this.blockingInterceptor.invocationReceivedLatch.await(20000L, TimeUnit.MILLISECONDS));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw e;
        }
    }

    private void resumeRemoteSite() {
        this.blockingInterceptor.waitingLatch.countDown();
    }

    private DistributionInfo getDistributionForKey(Cache<String, String> cache) {
        return TestingUtil.extractComponent(cache, ClusteringDependentLogic.class).getCacheTopology().getDistribution((Object)"k");
    }

    private boolean isNotWriteOwner(Cache<String, String> cache) {
        return !this.getDistributionForKey(cache).isWriteOwner();
    }

    private Cache<String, String> findPrimaryOwner() {
        for (Cache c : this.caches("LON-1")) {
            if (!this.getDistributionForKey(c).isPrimary()) continue;
            return c;
        }
        throw new IllegalStateException(String.format("Unable to find primary owner for key %s", "k"));
    }

    private InternalDataContainer<String, String> getInternalDataContainer(Cache<String, String> cache) {
        return TestingUtil.extractComponent(cache, InternalDataContainer.class);
    }

    private IracMetadata extractMetadataFromPrimaryOwner() {
        Cache<String, String> cache = this.findPrimaryOwner();
        InternalDataContainer<String, String> dataContainer = this.getInternalDataContainer(cache);
        InternalCacheEntry entry = dataContainer.peek((Object)"k");
        AssertJUnit.assertNotNull((Object)entry);
        PrivateMetadata internalMetadata = entry.getInternalMetadata();
        AssertJUnit.assertNotNull((Object)internalMetadata);
        IracMetadata metadata = internalMetadata.iracMetadata();
        AssertJUnit.assertNotNull((Object)metadata);
        return metadata;
    }

    private void assertInDataContainer(String site, String value, IracMetadata metadata) {
        for (Cache cache : this.caches(site)) {
            if (this.isNotWriteOwner(cache)) continue;
            InternalDataContainer<String, String> dc = this.getInternalDataContainer(cache);
            InternalCacheEntry ice = dc.peek((Object)"k");
            log.debugf("Checking DataContainer in %s. entry=%s", (Object)DistributionTestHelper.addressOf(cache), (Object)ice);
            AssertJUnit.assertNotNull((String)String.format("Internal entry is null for key %s", "k"), (Object)ice);
            AssertJUnit.assertEquals((String)"Internal entry wrong key", (String)"k", (String)((String)ice.getKey()));
            AssertJUnit.assertEquals((String)"Internal entry wrong value", (String)value, (String)((String)ice.getValue()));
            AssertJUnit.assertEquals((String)"Internal entry wrong metadata", (Object)metadata, (Object)ice.getInternalMetadata().iracMetadata());
        }
    }

    private void assertDataContainerState(String value) {
        IracMetadata metadata = this.extractMetadataFromPrimaryOwner();
        this.assertInDataContainer("LON-1", value, metadata);
        this.assertInDataContainer("NYC-2", value, metadata);
    }

    private void assertNoDataLeak() {
        Cache nycCache;
        Cache lonCache;
        int i;
        for (i = 0; i < this.initialClusterSize; ++i) {
            lonCache = this.cache("LON-1", null, i);
            nycCache = this.cache("NYC-2", null, i);
            this.eventually("Updated keys map is not empty in LON!", () -> this.isIracManagerEmpty(lonCache));
            this.eventually("Updated keys map is not empty in NYC!", () -> this.isIracManagerEmpty(nycCache));
            this.iracTombstoneManager(lonCache).startCleanupTombstone();
            this.iracTombstoneManager(nycCache).startCleanupTombstone();
        }
        for (i = 0; i < this.initialClusterSize; ++i) {
            lonCache = this.cache("LON-1", null, i);
            nycCache = this.cache("NYC-2", null, i);
            this.eventually("Tombstone map is not empty in LON", () -> ((DefaultIracTombstoneManager)this.iracTombstoneManager(lonCache)).isEmpty());
            this.eventually("Tombstone map is not empty in NYC", () -> ((DefaultIracTombstoneManager)this.iracTombstoneManager(nycCache)).isEmpty());
        }
    }

    private static enum ConfigMode {
        NON_TX,
        PESSIMISTIC_TX,
        OPTIMISTIC_TX_RC,
        OPTIMISTIC_TX_RR;

    }

    public static class BlockingInterceptor
    extends DDAsyncInterceptor {
        public volatile CountDownLatch invocationReceivedLatch = new CountDownLatch(1);
        public volatile CountDownLatch waitingLatch = new CountDownLatch(1);
        public volatile boolean isActive = true;

        void reset() {
            this.invocationReceivedLatch = new CountDownLatch(1);
            this.waitingLatch = new CountDownLatch(1);
        }

        public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
            return this.handle((InvocationContext)ctx, (VisitableCommand)command);
        }

        public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
            return this.handle((InvocationContext)ctx, (VisitableCommand)command);
        }

        public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
            return this.handle(ctx, (VisitableCommand)command);
        }

        public Object visitIracPutKeyValueCommand(InvocationContext ctx, IracPutKeyValueCommand command) throws Throwable {
            return this.handle(ctx, (VisitableCommand)command);
        }

        public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
            return this.handle(ctx, (VisitableCommand)command);
        }

        public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
            return this.handle(ctx, (VisitableCommand)command);
        }

        public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
            return this.handle(ctx, (VisitableCommand)command);
        }

        public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
            return this.handle(ctx, (VisitableCommand)command);
        }

        public Object visitWriteOnlyManyEntriesCommand(InvocationContext ctx, WriteOnlyManyEntriesCommand command) throws Throwable {
            return this.handle(ctx, (VisitableCommand)command);
        }

        protected Object handle(InvocationContext ctx, VisitableCommand command) throws Throwable {
            if (this.isActive) {
                this.invocationReceivedLatch.countDown();
                AssertJUnit.assertTrue((boolean)this.waitingLatch.await(30L, TimeUnit.SECONDS));
            }
            return super.handleDefault(ctx, command);
        }
    }
}

