/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite;

import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.CacheContainer;
import org.infinispan.remoting.inboundhandler.GlobalInboundInvocationHandler;
import org.infinispan.remoting.inboundhandler.InboundInvocationHandler;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.ByteString;
import org.infinispan.xsite.AbstractTwoSitesTest;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"xsite"}, testName="xsite.BackupCacheStoppedTest")
public class BackupCacheStoppedTest
extends AbstractTwoSitesTest {
    public void testCacheStopped() {
        String site = "LON-1";
        String key = this.key("LON-1");
        String val = this.val("LON-1");
        this.cache("LON-1", 0).put((Object)key, (Object)val);
        Cache<Object, Object> backup = this.backup("LON-1");
        AssertJUnit.assertEquals((Object)backup.get((Object)key), (Object)val);
        AssertJUnit.assertTrue((boolean)backup.getStatus().allowInvocations());
        GlobalInboundInvocationHandler handler = (GlobalInboundInvocationHandler)TestingUtil.extractGlobalComponent((CacheContainer)backup.getCacheManager(), InboundInvocationHandler.class);
        backup.stop();
        this.eventually(() -> handler.getLocalCacheForRemoteSite("LON-1", ByteString.fromString((String)this.getDefaultCacheName())) == null);
        AssertJUnit.assertFalse((boolean)backup.getStatus().allowInvocations());
        backup.start();
        log.trace((Object)"About to put the 2nd value");
        this.cache("LON-1", 0).put((Object)key, (Object)"v2");
        AssertJUnit.assertEquals((Object)this.backup("LON-1").get((Object)key), (Object)"v2");
        AssertJUnit.assertTrue((boolean)backup.getStatus().allowInvocations());
    }

    @Override
    protected ConfigurationBuilder getNycActiveConfig() {
        return BackupCacheStoppedTest.getDefaultClusteredCacheConfig(CacheMode.REPL_SYNC, false);
    }

    @Override
    protected ConfigurationBuilder getLonActiveConfig() {
        return BackupCacheStoppedTest.getDefaultClusteredCacheConfig(CacheMode.REPL_SYNC, false);
    }
}

