/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite;

import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.BackupFailurePolicy;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.xsite.AbstractXSiteTest;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"xsite"}, testName="xsite.BackupForNotSpecifiedTest")
public class BackupForNotSpecifiedTest
extends AbstractXSiteTest {
    protected static final String LON = "LON-1";
    protected static final String NYC = "NYC-2";

    @Override
    protected void createSites() {
        GlobalConfigurationBuilder lonGc = GlobalConfigurationBuilder.defaultClusteredBuilder();
        ConfigurationBuilder lonDefault = BackupForNotSpecifiedTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true);
        lonDefault.sites().addBackup().site(NYC).backupFailurePolicy(BackupFailurePolicy.FAIL).strategy(BackupConfiguration.BackupStrategy.SYNC).sites().addInUseBackupSite(NYC);
        ConfigurationBuilder someCache = BackupForNotSpecifiedTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true);
        GlobalConfigurationBuilder nycGc = GlobalConfigurationBuilder.defaultClusteredBuilder();
        ConfigurationBuilder nycDefault = BackupForNotSpecifiedTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true);
        nycDefault.sites().addBackup().site(LON).strategy(BackupConfiguration.BackupStrategy.SYNC).sites().addInUseBackupSite(LON);
        ConfigurationBuilder someCacheBackup = BackupForNotSpecifiedTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true);
        someCacheBackup.sites().backupFor().remoteCache("someCache").remoteSite(LON);
        someCacheBackup.sites().disableBackups(true);
        this.createSite(LON, 2, lonGc, lonDefault);
        this.createSite(NYC, 2, nycGc, nycDefault);
        this.startCache(LON, "backup", BackupForNotSpecifiedTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true));
        this.startCache(NYC, "backup", BackupForNotSpecifiedTest.getDefaultClusteredCacheConfig(CacheMode.REPL_SYNC, true));
        this.startCache(LON, "someCache", someCache);
        this.startCache(NYC, "someCacheBackup", someCacheBackup);
    }

    public void testDataGetsReplicated() {
        this.cache(LON, 0).put((Object)"k_default_lon", (Object)"v_default_lon");
        AssertJUnit.assertEquals((Object)"v_default_lon", (Object)this.cache(LON, 1).get((Object)"k_default_lon"));
        AssertJUnit.assertEquals((Object)"v_default_lon", (Object)this.cache(NYC, 0).get((Object)"k_default_lon"));
        AssertJUnit.assertEquals((Object)"v_default_lon", (Object)this.cache(NYC, 1).get((Object)"k_default_lon"));
        this.cache(NYC, 0).put((Object)"k_default_nyc", (Object)"v_default_nyc");
        AssertJUnit.assertEquals((Object)"v_default_nyc", (Object)this.cache(NYC, 1).get((Object)"k_default_nyc"));
        AssertJUnit.assertEquals((Object)"v_default_nyc", (Object)this.cache(LON, 0).get((Object)"k_default_nyc"));
        AssertJUnit.assertEquals((Object)"v_default_nyc", (Object)this.cache(LON, 1).get((Object)"k_default_nyc"));
        this.cache(LON, "backup", 0).put((Object)"k_backup_lon", (Object)"v_backup_lon");
        AssertJUnit.assertEquals((Object)"v_backup_lon", (Object)this.cache(LON, "backup", 1).get((Object)"k_backup_lon"));
        AssertJUnit.assertEquals((Object)"v_backup_lon", (Object)this.cache(NYC, "backup", 0).get((Object)"k_backup_lon"));
        AssertJUnit.assertEquals((Object)"v_backup_lon", (Object)this.cache(NYC, "backup", 1).get((Object)"k_backup_lon"));
        this.cache(NYC, "backup", 0).put((Object)"k_backup_nyc", (Object)"v_backup_nyc");
        AssertJUnit.assertEquals((Object)"v_backup_nyc", (Object)this.cache(NYC, "backup", 1).get((Object)"k_backup_nyc"));
        AssertJUnit.assertEquals((Object)"v_backup_nyc", (Object)this.cache(LON, "backup", 0).get((Object)"k_backup_nyc"));
        AssertJUnit.assertEquals((Object)"v_backup_nyc", (Object)this.cache(LON, "backup", 1).get((Object)"k_backup_nyc"));
        this.cache(LON, "someCache", 0).put((Object)"k_someCache_lon", (Object)"v_someCache_lon");
        AssertJUnit.assertEquals((Object)"v_someCache_lon", (Object)this.cache(LON, "someCache", 1).get((Object)"k_someCache_lon"));
        AssertJUnit.assertEquals((Object)"v_someCache_lon", (Object)this.cache(NYC, "someCacheBackup", 0).get((Object)"k_someCache_lon"));
        AssertJUnit.assertEquals((Object)"v_someCache_lon", (Object)this.cache(NYC, "someCacheBackup", 1).get((Object)"k_someCache_lon"));
        this.cache(NYC, "someCacheBackup", 0).put((Object)"k_lon_sb", (Object)"v_lon_sb");
        AssertJUnit.assertEquals((Object)"v_lon_sb", (Object)this.cache(NYC, "someCacheBackup", 1).get((Object)"k_lon_sb"));
    }
}

