/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite;

import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import org.infinispan.configuration.cache.AuthorizationConfigurationBuilder;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalAuthorizationConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.PrincipalRoleMapper;
import org.infinispan.security.Security;
import org.infinispan.security.mappers.IdentityRoleMapper;
import org.infinispan.test.TestingUtil;
import org.infinispan.xsite.AbstractMultipleSitesTest;
import org.infinispan.xsite.AbstractXSiteTest;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"xsite"}, testName="xsite.BackupWithSecurityTest")
public class BackupWithSecurityTest
extends AbstractMultipleSitesTest {
    static final Subject ADMIN;
    static final Map<AuthorizationPermission, Subject> SUBJECTS;
    public static final String XSITECACHE = "XSITECACHE";

    @Override
    protected ConfigurationBuilder defaultConfigurationForSite(int siteIndex) {
        ConfigurationBuilder builder = super.defaultConfigurationForSite(siteIndex);
        AuthorizationConfigurationBuilder authConfig = builder.security().authorization().enable();
        for (AuthorizationPermission perm : AuthorizationPermission.values()) {
            authConfig.role(perm.toString());
        }
        return builder;
    }

    @Override
    protected GlobalConfigurationBuilder defaultGlobalConfigurationForSite(int siteIndex) {
        GlobalConfigurationBuilder builder = super.defaultGlobalConfigurationForSite(siteIndex);
        GlobalAuthorizationConfigurationBuilder globalRoles = builder.security().authorization().enable().principalRoleMapper((PrincipalRoleMapper)new IdentityRoleMapper());
        for (AuthorizationPermission perm : AuthorizationPermission.values()) {
            globalRoles.role(perm.toString()).permission(perm);
        }
        return builder;
    }

    @Override
    protected AbstractXSiteTest.TestSite createSite(String siteName, int numNodes, GlobalConfigurationBuilder gcb, String cacheName, ConfigurationBuilder cb) {
        return (AbstractXSiteTest.TestSite)Security.doAs((Subject)ADMIN, () -> BackupWithSecurityTest.super.createSite(siteName, numNodes, gcb, cacheName, cb));
    }

    @Override
    protected void killSite(AbstractXSiteTest.TestSite ts) {
        Security.doAs((Subject)ADMIN, () -> {
            BackupWithSecurityTest.super.killSite(ts);
            return null;
        });
    }

    @Override
    protected void clearSite(AbstractXSiteTest.TestSite ts) {
        Security.doAs((Subject)ADMIN, () -> {
            BackupWithSecurityTest.super.clearSite(ts);
            return null;
        });
    }

    @Override
    protected void afterSitesCreated() {
        super.afterSitesCreated();
        Security.doAs((Subject)ADMIN, () -> {
            ConfigurationBuilder builder = this.defaultConfigurationForSite(0);
            builder.sites().addBackup().site(this.siteName(1)).strategy(BackupConfiguration.BackupStrategy.SYNC);
            BackupWithSecurityTest.defineInSite(this.site(0), XSITECACHE, builder.build());
            this.site(0).waitForClusterToForm(XSITECACHE);
            builder = this.defaultConfigurationForSite(1);
            BackupWithSecurityTest.defineInSite(this.site(1), XSITECACHE, builder.build());
            this.site(1).waitForClusterToForm(XSITECACHE);
            return null;
        });
    }

    public void testBackupCacheAccess() {
        Security.doAs((Subject)SUBJECTS.get(AuthorizationPermission.WRITE), () -> {
            this.site(0).cache(XSITECACHE, 0).put((Object)"k1", (Object)"v1");
            return null;
        });
        String v = (String)Security.doAs((Subject)SUBJECTS.get(AuthorizationPermission.READ), () -> (String)this.site(1).cache(XSITECACHE, 0).get((Object)"k1"));
        AssertJUnit.assertEquals((String)"v1", (String)v);
    }

    static {
        SUBJECTS = new HashMap<AuthorizationPermission, Subject>(AuthorizationPermission.values().length);
        for (AuthorizationPermission perm : AuthorizationPermission.values()) {
            SUBJECTS.put(perm, TestingUtil.makeSubject(perm.toString() + "_user", perm.toString()));
        }
        ADMIN = SUBJECTS.get(AuthorizationPermission.ALL);
    }
}

