/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.transaction.TransactionManager;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distribution.MagicKey;
import org.infinispan.functional.FunctionalMap;
import org.infinispan.functional.MetaParam;
import org.infinispan.functional.impl.FunctionalMapImpl;
import org.infinispan.functional.impl.ReadWriteMapImpl;
import org.infinispan.functional.impl.WriteOnlyMapImpl;
import org.infinispan.marshall.core.MarshallableFunctions;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.function.SerializableFunction;
import org.infinispan.xsite.AbstractTwoSitesTest;
import org.testng.AssertJUnit;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;

@Test(groups={"xsite"}, testName="xsite.CacheOperationsTest")
public class CacheOperationsTest
extends AbstractTwoSitesTest {
    @Factory
    public Object[] factory() {
        return new Object[]{new CacheOperationsTest().cacheMode(CacheMode.DIST_SYNC).transactional(false), new CacheOperationsTest().cacheMode(CacheMode.REPL_SYNC).transactional(false), new CacheOperationsTest().cacheMode(CacheMode.DIST_SYNC).transactional(true).lockingMode(LockingMode.OPTIMISTIC).use2Pc(false), new CacheOperationsTest().cacheMode(CacheMode.DIST_SYNC).transactional(true).lockingMode(LockingMode.OPTIMISTIC).use2Pc(true), new CacheOperationsTest().cacheMode(CacheMode.DIST_SYNC).transactional(true).lockingMode(LockingMode.PESSIMISTIC), new CacheOperationsTest().cacheMode(CacheMode.REPL_SYNC).transactional(true).lockingMode(LockingMode.OPTIMISTIC).use2Pc(false), new CacheOperationsTest().cacheMode(CacheMode.REPL_SYNC).transactional(true).lockingMode(LockingMode.OPTIMISTIC).use2Pc(true), new CacheOperationsTest().cacheMode(CacheMode.REPL_SYNC).transactional(true).lockingMode(LockingMode.PESSIMISTIC)};
    }

    public CacheOperationsTest() {
        this.initialClusterSize = 3;
    }

    @Override
    protected ConfigurationBuilder getNycActiveConfig() {
        ConfigurationBuilder cb = CacheOperationsTest.getDefaultClusteredCacheConfig(this.cacheMode, this.transactional);
        if (this.lockingMode != null) {
            cb.transaction().lockingMode(this.lockingMode);
        }
        return cb;
    }

    @Override
    protected ConfigurationBuilder getLonActiveConfig() {
        return this.getNycActiveConfig();
    }

    public void testRemove() {
        this.testRemove("LON-1");
        this.testRemove("NYC-2");
    }

    public void testPutAndClear() {
        this.testPutAndClear("LON-1");
        this.testPutAndClear("NYC-2");
    }

    public void testReplace() {
        this.testReplace("LON-1");
        this.testReplace("NYC-2");
    }

    public void testPutAll() {
        this.testPutAll("LON-1");
        this.testPutAll("NYC-2");
    }

    private void testRemove(String site) {
        String key = this.key(site);
        String val = this.val(site);
        this.cache(site, 0).put((Object)key, (Object)val);
        AssertJUnit.assertEquals((Object)this.backup(site).get((Object)key), (Object)val);
        this.cache(site, 0).remove((Object)key);
        AssertJUnit.assertNull((Object)this.backup(site).get((Object)key));
        this.cache(site, 0).put((Object)key, (Object)val);
        AssertJUnit.assertEquals((Object)this.backup(site).get((Object)key), (Object)val);
        this.cache(site, 0).remove((Object)key, (Object)val);
        AssertJUnit.assertNull((Object)this.backup(site).get((Object)key));
    }

    private void testReplace(String site) {
        String key = this.key(site);
        String val = this.val(site);
        this.cache(site, 0).put((Object)key, (Object)val);
        Cache<Object, Object> backup = this.backup(site);
        AssertJUnit.assertEquals((Object)backup.get((Object)key), (Object)val);
        String val2 = val + 1;
        this.cache(site, 0).replace((Object)key, (Object)val2);
        AssertJUnit.assertEquals((Object)backup.get((Object)key), (Object)val2);
        String val3 = val + 2;
        this.cache(site, 0).replace((Object)key, (Object)"v_non", (Object)val3);
        AssertJUnit.assertEquals((Object)backup.get((Object)key), (Object)val2);
        this.cache(site, 0).replace((Object)key, (Object)val2, (Object)val3);
        AssertJUnit.assertEquals((Object)backup.get((Object)key), (Object)val3);
    }

    private void testPutAndClear(String site) {
        String key = this.key(site);
        String val = this.val(site);
        this.cache(site, 0).put((Object)key, (Object)val);
        AssertJUnit.assertEquals((Object)this.backup(site).get((Object)key), (Object)val);
        this.cache(site, 0).clear();
        AssertJUnit.assertNull((Object)this.backup(site).get((Object)(key + 1)));
        AssertJUnit.assertNull((Object)this.backup(site).get((Object)key));
    }

    private void testPutAll(String site) {
        int i;
        HashMap<String, String> all = new HashMap<String, String>();
        String key = this.key(site);
        String val = this.val(site);
        for (i = 0; i < 10; ++i) {
            all.put(key + i, val + i);
        }
        this.cache(site, 0).putAll(all);
        for (i = 0; i < 10; ++i) {
            AssertJUnit.assertEquals((Object)this.backup(site).get((Object)(key + i)), (Object)(val + i));
        }
    }

    public void testDataGetsReplicated() {
        this.cache("LON-1", 0).put((Object)"k_lon", (Object)"v_lon");
        AssertJUnit.assertNull((Object)this.cache("NYC-2", 0).get((Object)"k_lon"));
        AssertJUnit.assertEquals((Object)this.cache("LON-1", 1).get((Object)"k_lon"), (Object)"v_lon");
        AssertJUnit.assertEquals((Object)this.cache("NYC-2", "lonBackup", 0).get((Object)"k_lon"), (Object)"v_lon");
        AssertJUnit.assertEquals((Object)this.cache("NYC-2", "lonBackup", 1).get((Object)"k_lon"), (Object)"v_lon");
        this.cache("NYC-2", 1).put((Object)"k_nyc", (Object)"v_nyc");
        AssertJUnit.assertEquals((Object)this.cache("LON-1", 1).get((Object)"k_lon"), (Object)"v_lon");
        AssertJUnit.assertEquals((Object)this.cache("LON-1", "nycBackup", 0).get((Object)"k_nyc"), (Object)"v_nyc");
        AssertJUnit.assertEquals((Object)this.cache("LON-1", "nycBackup", 1).get((Object)"k_nyc"), (Object)"v_nyc");
        AssertJUnit.assertNull((Object)this.cache("LON-1", 0).get((Object)"k_nyc"));
        this.cache("LON-1", 1).remove((Object)"k_lon");
        AssertJUnit.assertNull((Object)this.cache("LON-1", 1).get((Object)"k_lon"));
        AssertJUnit.assertNull((Object)this.cache("NYC-2", "lonBackup", 0).get((Object)"k_lon"));
        AssertJUnit.assertNull((Object)this.cache("NYC-2", "lonBackup", 1).get((Object)"k_lon"));
    }

    public void testPutWithLocality() {
        MagicKey remoteOwnedKey = new MagicKey(this.cache("LON-1", 1));
        this.cache("LON-1", 0).put((Object)remoteOwnedKey, (Object)"v_LON");
        AssertJUnit.assertEquals((Object)this.cache("NYC-2", "lonBackup", 0).get((Object)remoteOwnedKey), (Object)"v_LON");
        AssertJUnit.assertEquals((Object)this.cache("NYC-2", "lonBackup", 1).get((Object)remoteOwnedKey), (Object)"v_LON");
        MagicKey localOwnedKey = new MagicKey(this.cache("LON-1", 0));
        this.cache("LON-1", 0).put((Object)localOwnedKey, (Object)"v_LON");
        AssertJUnit.assertEquals((Object)this.cache("NYC-2", "lonBackup", 0).get((Object)remoteOwnedKey), (Object)"v_LON");
        AssertJUnit.assertEquals((Object)this.cache("NYC-2", "lonBackup", 1).get((Object)remoteOwnedKey), (Object)"v_LON");
    }

    public void testFunctional() throws Exception {
        this.testFunctional("LON-1");
        this.testFunctional("NYC-2");
    }

    private void testFunctional(String site) throws Exception {
        Object[] keys;
        FunctionalMapImpl fmap = FunctionalMapImpl.create((AdvancedCache)this.cache(site, 0).getAdvancedCache());
        FunctionalMap.WriteOnlyMap wo = WriteOnlyMapImpl.create((FunctionalMapImpl)fmap);
        FunctionalMap.ReadWriteMap rw = ReadWriteMapImpl.create((FunctionalMapImpl)fmap);
        Cache<Object, Object> backup = this.backup(site);
        for (Object key : keys = new Object[]{new MagicKey("k0", this.cache(site, 0), this.cache(site, 1)), new MagicKey("k1", this.cache(site, 1), this.cache(site, 0)), new MagicKey("k2", this.cache(site, 1), this.cache(site, 2))}) {
            wo.eval(key, (Object)"v0", MarshallableFunctions.setValueConsumer()).join();
            AssertJUnit.assertEquals((Object)"v0", (Object)backup.get(key));
        }
        for (Object key : keys) {
            wo.eval(key, MarshallableFunctions.removeConsumer()).join();
            AssertJUnit.assertEquals(null, (Object)backup.get(key));
        }
        wo.evalMany(CacheOperationsTest.map(keys, "v1"), MarshallableFunctions.setValueConsumer()).join();
        for (Object key : keys) {
            AssertJUnit.assertEquals((Object)"v1", (Object)backup.get(key));
        }
        for (Object key : keys) {
            rw.eval(key, (SerializableFunction & Serializable)view -> view.set((Object)(view.get() + "+2"), new MetaParam.Writable[0])).join();
            AssertJUnit.assertEquals((Object)"v1+2", (Object)backup.get(key));
        }
        rw.evalMany(Util.asSet((Object[])keys), (SerializableFunction & Serializable)view -> view.set((Object)(view.get() + "+3"), new MetaParam.Writable[0])).forEach(ret -> AssertJUnit.assertEquals(null, (Object)ret));
        for (Object key : keys) {
            AssertJUnit.assertEquals((Object)"v1+2+3", (Object)backup.get(key));
        }
        wo.evalMany(Util.asSet((Object[])keys), MarshallableFunctions.removeConsumer()).join();
        for (Object key : keys) {
            AssertJUnit.assertEquals(null, (Object)backup.get(key));
        }
        rw.evalMany(Util.asSet((Object[])keys), (SerializableFunction & Serializable)view -> view.find().orElse("none")).forEach(ret -> AssertJUnit.assertEquals((Object)"none", (Object)ret));
        for (Object key : keys) {
            AssertJUnit.assertEquals(null, (Object)backup.get(key));
        }
        if (this.transactional) {
            TransactionManager tm = this.cache(site, 0).getAdvancedCache().getTransactionManager();
            tm.begin();
            rw.eval(keys[0], (Object)"v4", MarshallableFunctions.setValueReturnPrevOrNull()).join();
            rw.evalMany(Util.asSet((Object[])new Object[]{keys[1], keys[2]}), (SerializableFunction & Serializable)view -> view.find().orElse("none")).forEach(ret -> AssertJUnit.assertEquals((Object)"none", (Object)ret));
            tm.commit();
            AssertJUnit.assertEquals((Object)"v4", (Object)backup.get(keys[0]));
            AssertJUnit.assertEquals(null, (Object)backup.get(keys[1]));
            AssertJUnit.assertEquals(null, (Object)backup.get(keys[2]));
        }
    }

    private static Map<Object, Object> map(Object[] keys, String value) {
        return Stream.of(keys).collect(Collectors.toMap(Function.identity(), ignored -> value));
    }
}

