/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite;

import java.lang.reflect.Method;
import org.infinispan.Cache;
import org.infinispan.commons.api.Lifecycle;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distribution.DistributionTestHelper;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.test.TestingUtil;
import org.infinispan.xsite.AbstractTwoSitesTest;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"xsite"}, testName="xsite.PreloadWithXSiteTest")
public class PreloadWithXSiteTest
extends AbstractTwoSitesTest {
    private static final String NYC_CACHE_STORE_NAME = "nyc-dummy-cache-store";
    private static final String LON_CACHE_STORE_NAME = "lon-dummy-cache-store";
    private static final int NR_KEYS = 5;

    public PreloadWithXSiteTest() {
        this.implicitBackupCache = true;
        this.initialClusterSize = 2;
    }

    public void testPreload(Method method) {
        for (int i = 0; i < 5; ++i) {
            this.cache("NYC-2", 0).put((Object)TestingUtil.k(method, i), (Object)TestingUtil.v(method, i));
        }
        this.assertData(method);
        this.stopNYC();
        this.reCreateNYC();
        this.assertData(method);
    }

    @Override
    protected ConfigurationBuilder getNycActiveConfig() {
        ConfigurationBuilder builder = PreloadWithXSiteTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, false);
        ((DummyInMemoryStoreConfigurationBuilder)((DummyInMemoryStoreConfigurationBuilder)builder.persistence().addStore(DummyInMemoryStoreConfigurationBuilder.class)).preload(true)).storeName(NYC_CACHE_STORE_NAME);
        return builder;
    }

    @Override
    protected ConfigurationBuilder getLonActiveConfig() {
        ConfigurationBuilder builder = PreloadWithXSiteTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, false);
        ((DummyInMemoryStoreConfigurationBuilder)((DummyInMemoryStoreConfigurationBuilder)builder.persistence().addStore(DummyInMemoryStoreConfigurationBuilder.class)).preload(true)).storeName(LON_CACHE_STORE_NAME);
        return builder;
    }

    private void stopNYC() {
        this.site((String)"NYC-2").cacheManagers.forEach(Lifecycle::stop);
    }

    private void reCreateNYC() {
        ConfigurationBuilder nyc = this.getNycActiveConfig();
        nyc.sites().addBackup().site("LON-1").strategy(BackupConfiguration.BackupStrategy.SYNC).sites().addInUseBackupSite("LON-1");
        this.createSite("NYC-2", this.initialClusterSize, this.globalConfigurationBuilderForSite("NYC-2"), nyc);
    }

    private void assertData(Method method) {
        this.assertDataForSite(method, "NYC-2");
        this.assertDataForSite(method, "LON-1");
    }

    private void assertDataForSite(Method method, String site) {
        for (Cache cache : this.caches(site)) {
            for (int i = 0; i < 5; ++i) {
                AssertJUnit.assertEquals((String)("Cache=" + DistributionTestHelper.addressOf(cache)), (String)TestingUtil.v(method, i), (String)((String)cache.get((Object)TestingUtil.k(method, i))));
            }
        }
    }
}

