/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite;

import java.util.concurrent.CompletionStage;
import javax.transaction.TransactionManager;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.test.TestingUtil;
import org.infinispan.xsite.AbstractTwoSitesTest;
import org.infinispan.xsite.BackupReceiver;
import org.infinispan.xsite.BackupReceiverDelegator;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"xsite"}, testName="xsite.RollbackNoPrepareOptimisticTest")
public class RollbackNoPrepareOptimisticTest
extends AbstractTwoSitesTest {
    public RollbackNoPrepareOptimisticTest() {
        this.use2Pc = true;
    }

    public void testRollbackNoCommit() throws Throwable {
        String key = this.key("LON-1");
        String val = this.val("LON-1");
        LogBackupReceiver receiver = TestingUtil.wrapComponent(this.backup("LON-1"), BackupReceiver.class, LogBackupReceiver::new);
        AssertJUnit.assertNull((Object)receiver.received);
        this.cache("LON-1", 0).put((Object)key, (Object)val);
        AssertJUnit.assertNotNull((Object)receiver.received);
        AssertJUnit.assertEquals((Object)this.backup("LON-1").get((Object)key), (Object)val);
        receiver.received = null;
        TransactionManager tmLon0 = this.cache("LON-1", 0).getAdvancedCache().getTransactionManager();
        AssertJUnit.assertNull((Object)receiver.received);
        tmLon0.begin();
        this.cache("LON-1", 0).put((Object)key, (Object)val);
        log.trace((Object)"Before rollback!");
        tmLon0.rollback();
        AssertJUnit.assertNull((Object)receiver.received);
    }

    @Override
    protected ConfigurationBuilder getNycActiveConfig() {
        return RollbackNoPrepareOptimisticTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true);
    }

    @Override
    protected ConfigurationBuilder getLonActiveConfig() {
        return RollbackNoPrepareOptimisticTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true);
    }

    public static class LogBackupReceiver
    extends BackupReceiverDelegator {
        volatile VisitableCommand received;

        protected LogBackupReceiver(BackupReceiver delegate) {
            super(delegate);
        }

        @Override
        public <O> CompletionStage<O> handleRemoteCommand(VisitableCommand command, boolean preserveOrder) {
            this.received = command;
            return super.handleRemoteCommand(command, preserveOrder);
        }
    }
}

