/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite;

import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.BackupConfigurationBuilder;
import org.infinispan.configuration.cache.BackupFailurePolicy;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.TransportFlags;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="xsite.XSiteFileParsing2Test")
public class XSiteFileParsing2Test
extends SingleCacheManagerTest {
    public static final String FILE_NAME = "configs/xsite/xsite-test2.xml";

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        return TestCacheManagerFactory.fromXml(FILE_NAME, false, true, TransportFlags.minimalXsiteFlags());
    }

    public void testDefaultCache() {
        Configuration dcc = this.cacheManager.getDefaultCacheConfiguration();
        AssertJUnit.assertEquals((int)dcc.sites().allBackups().size(), (int)3);
        AssertJUnit.assertEquals((int)dcc.sites().enabledBackups().size(), (int)2);
        this.testDefault(dcc);
    }

    public void testInheritor() {
        Configuration dcc = this.cacheManager.getCacheConfiguration("inheritor");
        this.testDefault(dcc);
    }

    public void testNoBackupFor() {
        Configuration dcc = this.cacheManager.getCacheConfiguration("noBackupFor");
        AssertJUnit.assertEquals((int)1, (int)dcc.sites().allBackups().size());
        BackupConfiguration nyc = new BackupConfigurationBuilder(null).site("NYC").strategy(BackupConfiguration.BackupStrategy.SYNC).backupFailurePolicy(BackupFailurePolicy.WARN).failurePolicyClass(null).replicationTimeout(12003L).useTwoPhaseCommit(false).enabled(true).create();
        AssertJUnit.assertTrue((boolean)dcc.sites().allBackups().contains(nyc));
        AssertJUnit.assertNull((Object)dcc.sites().backupFor().remoteSite());
        AssertJUnit.assertNull((Object)dcc.sites().backupFor().remoteCache());
    }

    public void testNoBackupFor2() {
        Configuration dcc = this.cacheManager.getCacheConfiguration("noBackupFor2");
        AssertJUnit.assertEquals((int)0, (int)dcc.sites().allBackups().size());
    }

    private void testDefault(Configuration dcc) {
        BackupConfiguration nyc = new BackupConfigurationBuilder(null).site("NYC").strategy(BackupConfiguration.BackupStrategy.SYNC).backupFailurePolicy(BackupFailurePolicy.IGNORE).failurePolicyClass(null).replicationTimeout(12003L).useTwoPhaseCommit(false).enabled(true).create();
        BackupConfiguration sfo = new BackupConfigurationBuilder(null).site("SFO").strategy(BackupConfiguration.BackupStrategy.ASYNC).backupFailurePolicy(BackupFailurePolicy.WARN).failurePolicyClass(null).replicationTimeout(15000L).useTwoPhaseCommit(false).enabled(true).create();
        BackupConfiguration lon = new BackupConfigurationBuilder(null).site("LON").strategy(BackupConfiguration.BackupStrategy.SYNC).backupFailurePolicy(BackupFailurePolicy.WARN).failurePolicyClass(null).replicationTimeout(15000L).useTwoPhaseCommit(false).enabled(false).create();
        AssertJUnit.assertTrue((boolean)dcc.sites().allBackups().contains(nyc));
        AssertJUnit.assertTrue((boolean)dcc.sites().allBackups().contains(sfo));
        AssertJUnit.assertTrue((boolean)dcc.sites().allBackups().contains(lon));
        AssertJUnit.assertTrue((boolean)dcc.sites().enabledBackups().contains(nyc));
        AssertJUnit.assertTrue((boolean)dcc.sites().enabledBackups().contains(sfo));
        AssertJUnit.assertFalse((boolean)dcc.sites().enabledBackups().contains(lon));
        AssertJUnit.assertEquals((String)"someCache", (String)dcc.sites().backupFor().remoteCache());
        AssertJUnit.assertEquals((String)"SFO", (String)dcc.sites().backupFor().remoteSite());
    }
}

