/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite;

import org.infinispan.Cache;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.BackupConfigurationBuilder;
import org.infinispan.configuration.cache.BackupFailurePolicy;
import org.infinispan.configuration.cache.BackupForConfiguration;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.XSiteStateTransferMode;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.TransportFlags;
import org.infinispan.xsite.CountingCustomFailurePolicy;
import org.infinispan.xsite.CustomXSiteEntryMergePolicy;
import org.infinispan.xsite.spi.AlwaysRemoveXSiteEntryMergePolicy;
import org.infinispan.xsite.spi.DefaultXSiteEntryMergePolicy;
import org.infinispan.xsite.spi.PreferNonNullXSiteEntryMergePolicy;
import org.infinispan.xsite.spi.PreferNullXSiteEntryMergePolicy;
import org.infinispan.xsite.spi.XSiteEntryMergePolicy;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="xsite.XSiteFileParsingTest")
public class XSiteFileParsingTest
extends SingleCacheManagerTest {
    public static final String FILE_NAME = "configs/xsite/xsite-test.xml";

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        return TestCacheManagerFactory.fromXml(FILE_NAME, false, true, TransportFlags.minimalXsiteFlags());
    }

    public void testLocalSiteName() {
        this.cacheManager.getTransport().checkCrossSiteAvailable();
        AssertJUnit.assertEquals((String)"LON-1", (String)this.cacheManager.getTransport().localSiteName());
    }

    public void testDefaultCache() {
        Configuration dcc = this.cacheManager.getDefaultCacheConfiguration();
        this.testDefault(dcc);
    }

    public void testBackupNyc() {
        Configuration dcc = this.cacheManager.getCacheConfiguration("backupNyc");
        AssertJUnit.assertEquals((int)dcc.sites().allBackups().size(), (int)0);
        BackupForConfiguration backupForConfiguration = dcc.sites().backupFor();
        AssertJUnit.assertEquals((String)"someCache", (String)backupForConfiguration.remoteCache());
        AssertJUnit.assertEquals((String)"NYC", (String)backupForConfiguration.remoteSite());
    }

    public void testInheritor() {
        Configuration dcc = this.cacheManager.getCacheConfiguration("inheritor");
        this.testDefault(dcc);
    }

    public void testNoBackups() {
        Configuration dcc = this.cacheManager.getCacheConfiguration("noBackups");
        AssertJUnit.assertEquals((int)dcc.sites().allBackups().size(), (int)0);
        AssertJUnit.assertNull((Object)dcc.sites().backupFor().remoteCache());
        AssertJUnit.assertNull((Object)dcc.sites().backupFor().remoteSite());
    }

    public void testCustomBackupPolicy() {
        Configuration dcc = this.cacheManager.getCacheConfiguration("customBackupPolicy");
        AssertJUnit.assertEquals((int)dcc.sites().allBackups().size(), (int)1);
        BackupConfigurationBuilder nyc2 = new BackupConfigurationBuilder(null).site("NYC2").strategy(BackupConfiguration.BackupStrategy.SYNC).backupFailurePolicy(BackupFailurePolicy.CUSTOM).failurePolicyClass(CountingCustomFailurePolicy.class.getName()).replicationTimeout(160000L).useTwoPhaseCommit(false).enabled(true);
        AssertJUnit.assertTrue((boolean)dcc.sites().allBackups().contains(nyc2.create()));
        AssertJUnit.assertNull((Object)dcc.sites().backupFor().remoteCache());
    }

    public void testXSiteMergePolicy() {
        Configuration dcc = this.cacheManager.getCacheConfiguration("conflictResolver");
        AssertJUnit.assertEquals((int)dcc.sites().allBackups().size(), (int)1);
        AssertJUnit.assertEquals((Object)PreferNonNullXSiteEntryMergePolicy.getInstance(), (Object)dcc.sites().mergePolicy());
    }

    public void testXSiteMergePolicy2() {
        Configuration dcc = this.cacheManager.getCacheConfiguration("conflictResolver2");
        AssertJUnit.assertEquals((int)dcc.sites().allBackups().size(), (int)1);
        AssertJUnit.assertEquals((Object)PreferNullXSiteEntryMergePolicy.getInstance(), (Object)dcc.sites().mergePolicy());
    }

    public void testXSiteMergePolicy3() {
        Configuration dcc = this.cacheManager.getCacheConfiguration("conflictResolver3");
        AssertJUnit.assertEquals((int)dcc.sites().allBackups().size(), (int)1);
        AssertJUnit.assertEquals((Object)AlwaysRemoveXSiteEntryMergePolicy.getInstance(), (Object)dcc.sites().mergePolicy());
    }

    public void testCustomXSiteMergePolicy() {
        Configuration dcc = this.cacheManager.getCacheConfiguration("customConflictResolver");
        AssertJUnit.assertEquals((int)dcc.sites().allBackups().size(), (int)1);
        AssertJUnit.assertEquals(CustomXSiteEntryMergePolicy.class, dcc.sites().mergePolicy().getClass());
        Cache cache = this.cacheManager.getCache("customConflictResolver");
        XSiteEntryMergePolicy resolver = (XSiteEntryMergePolicy)cache.getAdvancedCache().getComponentRegistry().getComponent(XSiteEntryMergePolicy.class);
        AssertJUnit.assertEquals(CustomXSiteEntryMergePolicy.class, resolver.getClass());
    }

    public void testAutoStateTransfer() {
        Configuration dcc = this.cacheManager.getCacheConfiguration("autoStateTransfer");
        AssertJUnit.assertEquals((int)dcc.sites().allBackups().size(), (int)1);
        AssertJUnit.assertEquals((Object)((BackupConfiguration)dcc.sites().allBackups().get(0)).stateTransfer().mode(), (Object)XSiteStateTransferMode.AUTO);
    }

    private void testDefault(Configuration dcc) {
        AssertJUnit.assertEquals((int)dcc.sites().allBackups().size(), (int)2);
        AssertJUnit.assertEquals((Object)DefaultXSiteEntryMergePolicy.getInstance(), (Object)dcc.sites().mergePolicy());
        BackupConfigurationBuilder nyc = new BackupConfigurationBuilder(null).site("NYC").strategy(BackupConfiguration.BackupStrategy.SYNC).backupFailurePolicy(BackupFailurePolicy.IGNORE).failurePolicyClass(null).replicationTimeout(12003L).useTwoPhaseCommit(false).enabled(true);
        AssertJUnit.assertTrue((boolean)dcc.sites().allBackups().contains(nyc.create()));
        BackupConfigurationBuilder sfo = new BackupConfigurationBuilder(null).site("SFO").strategy(BackupConfiguration.BackupStrategy.ASYNC).backupFailurePolicy(BackupFailurePolicy.WARN).failurePolicyClass(null).replicationTimeout(15000L).useTwoPhaseCommit(false).enabled(true);
        AssertJUnit.assertTrue((boolean)dcc.sites().allBackups().contains(sfo.create()));
    }
}

