/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite;

import java.io.ByteArrayInputStream;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.BackupConfigurationBuilder;
import org.infinispan.configuration.cache.BackupFailurePolicy;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.XSiteStateTransferConfiguration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.TransportFlags;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="xsite.XSiteStateTransferFileParsingTest")
public class XSiteStateTransferFileParsingTest
extends SingleCacheManagerTest {
    private static final String FILE_NAME = "configs/xsite/xsite-state-transfer-test.xml";
    private static final String XML_FORMAT = "<infinispan>\n<cache-container default-cache=\"default\">\n  <transport cluster=\"infinispan-cluster\" lock-timeout=\"50000\" stack=\"udp\" node-name=\"Jalapeno\" machine=\"m1\"\n                   rack=\"r1\" site=\"LON\"/>\n  <replicated-cache name=\"default\">\n     <backups>\n        <backup site=\"NYC\" strategy=\"SYNC\" failure-policy=\"WARN\" timeout=\"12003\">\n           <state-transfer chunk-size=\"10\" timeout=\"%s\" max-retries=\"30\" wait-time=\"%s\" mode=\"%s\"/>\n        </backup>\n     </backups>\n     <backup-for remote-cache=\"someCache\" remote-site=\"SFO\"/>\n  </replicated-cache>\n</cache-container>\n</infinispan>";

    public void testDefaultCache() {
        Configuration dcc = this.cacheManager.getDefaultCacheConfiguration();
        AssertJUnit.assertEquals((int)1, (int)dcc.sites().allBackups().size());
        this.testDefault(dcc);
    }

    public void testInheritor() {
        Configuration dcc = this.cacheManager.getCacheConfiguration("inheritor");
        AssertJUnit.assertEquals((int)1, (int)dcc.sites().allBackups().size());
        this.testDefault(dcc);
    }

    public void testNoStateTransfer() {
        Configuration dcc = this.cacheManager.getCacheConfiguration("noStateTransfer");
        AssertJUnit.assertEquals((int)1, (int)dcc.sites().allBackups().size());
        AssertJUnit.assertTrue((boolean)dcc.sites().allBackups().contains(XSiteStateTransferFileParsingTest.createDefault()));
        AssertJUnit.assertNull((Object)dcc.sites().backupFor().remoteSite());
        AssertJUnit.assertNull((Object)dcc.sites().backupFor().remoteCache());
    }

    public void testStateTransferDifferentConfig() {
        Configuration dcc = this.cacheManager.getCacheConfiguration("stateTransferDifferentConfiguration");
        AssertJUnit.assertEquals((int)1, (int)dcc.sites().allBackups().size());
        AssertJUnit.assertTrue((boolean)dcc.sites().allBackups().contains(XSiteStateTransferFileParsingTest.create(98, 7654L, 321, 101L)));
        AssertJUnit.assertEquals((String)"someCache", (String)dcc.sites().backupFor().remoteCache());
        AssertJUnit.assertEquals((String)"SFO", (String)dcc.sites().backupFor().remoteSite());
    }

    @Test(expectedExceptions={CacheConfigurationException.class}, expectedExceptionsMessageRegExp="ISPN000449:.*")
    public void testNegativeTimeout() {
        this.testInvalidConfiguration(String.format(XML_FORMAT, -1, XSiteStateTransferConfiguration.DEFAULT_WAIT_TIME, "MANUAL"));
    }

    @Test(expectedExceptions={CacheConfigurationException.class}, expectedExceptionsMessageRegExp="ISPN000449:.*")
    public void testZeroTimeout() {
        this.testInvalidConfiguration(String.format(XML_FORMAT, 0, XSiteStateTransferConfiguration.DEFAULT_WAIT_TIME, "MANUAL"));
    }

    @Test(expectedExceptions={CacheConfigurationException.class}, expectedExceptionsMessageRegExp="ISPN000450:.*")
    public void testNegativeWaitTime() {
        this.testInvalidConfiguration(String.format(XML_FORMAT, XSiteStateTransferConfiguration.DEFAULT_TIMEOUT, -1, "MANUAL"));
    }

    @Test(expectedExceptions={CacheConfigurationException.class}, expectedExceptionsMessageRegExp="ISPN000450:.*")
    public void testZeroWaitTime() {
        this.testInvalidConfiguration(String.format(XML_FORMAT, XSiteStateTransferConfiguration.DEFAULT_TIMEOUT, 0, "MANUAL"));
    }

    @Test(expectedExceptions={CacheConfigurationException.class}, expectedExceptionsMessageRegExp="ISPN000634:.*")
    public void testAutoStateTransferModeWithSync() {
        this.testInvalidConfiguration(String.format(XML_FORMAT, XSiteStateTransferConfiguration.DEFAULT_TIMEOUT, XSiteStateTransferConfiguration.DEFAULT_WAIT_TIME, "AUTO"));
    }

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        return TestCacheManagerFactory.fromXml(FILE_NAME, false, true, TransportFlags.minimalXsiteFlags());
    }

    private void testInvalidConfiguration(String xmlConfiguration) {
        EmbeddedCacheManager invalidCacheManager = null;
        try {
            log.infof("Creating cache manager with %s", (Object)xmlConfiguration);
            invalidCacheManager = TestCacheManagerFactory.fromStream(new ByteArrayInputStream(xmlConfiguration.getBytes()));
        }
        finally {
            if (invalidCacheManager != null) {
                invalidCacheManager.stop();
            }
        }
    }

    private void testDefault(Configuration dcc) {
        AssertJUnit.assertTrue((boolean)dcc.sites().allBackups().contains(XSiteStateTransferFileParsingTest.create(123, 4567L, 890, 1011L)));
        AssertJUnit.assertEquals((String)"someCache", (String)dcc.sites().backupFor().remoteCache());
        AssertJUnit.assertEquals((String)"SFO", (String)dcc.sites().backupFor().remoteSite());
    }

    private static BackupConfiguration create(int chunkSize, long timeout, int maxRetries, long waitingTimeBetweenRetries) {
        BackupConfigurationBuilder builder = new BackupConfigurationBuilder(null).site("NYC").strategy(BackupConfiguration.BackupStrategy.SYNC).backupFailurePolicy(BackupFailurePolicy.WARN).failurePolicyClass(null).replicationTimeout(12003L).useTwoPhaseCommit(false).enabled(true);
        builder.stateTransfer().chunkSize(chunkSize).timeout(timeout).maxRetries(maxRetries).waitTime(waitingTimeBetweenRetries);
        return builder.create();
    }

    private static BackupConfiguration createDefault() {
        BackupConfigurationBuilder builder = new BackupConfigurationBuilder(null).site("NYC").strategy(BackupConfiguration.BackupStrategy.SYNC).backupFailurePolicy(BackupFailurePolicy.WARN).failurePolicyClass(null).replicationTimeout(12003L).useTwoPhaseCommit(false).enabled(true);
        return builder.create();
    }
}

