/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.backupfailure;

import java.util.HashMap;
import org.infinispan.commons.CacheException;
import org.infinispan.configuration.cache.BackupFailurePolicy;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.xsite.backupfailure.BaseBackupFailureTest;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"xsite"}, testName="xsite.backupfailure.NonTxBackupFailureTest")
public class NonTxBackupFailureTest
extends BaseBackupFailureTest {
    @Override
    protected ConfigurationBuilder getLonActiveConfig() {
        return NonTxBackupFailureTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, false);
    }

    @Override
    protected ConfigurationBuilder getNycActiveConfig() {
        return NonTxBackupFailureTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, false);
    }

    public void testPutFailure() {
        this.failureInterceptor.enable();
        try {
            this.cache("LON-1", 0).put((Object)"k", (Object)"v");
            this.checkFailOnBackupFailure();
        }
        catch (CacheException e) {
            this.checkNonFailOnBackupFailure();
        }
        finally {
            this.failureInterceptor.disable();
        }
        this.eventuallyEquals("v", () -> this.cache("LON-1", 1).get((Object)"k"));
        AssertJUnit.assertTrue((boolean)this.failureInterceptor.putFailed);
        AssertJUnit.assertNull((Object)this.backup("LON-1").get((Object)"k"));
    }

    public void testRemoveFailure() {
        this.cache("LON-1", 0).put((Object)"k", (Object)"v");
        AssertJUnit.assertEquals((Object)"v", (Object)this.cache("LON-1", 1).get((Object)"k"));
        AssertJUnit.assertEquals((Object)"v", (Object)this.backup("LON-1").get((Object)"k"));
        this.failureInterceptor.enable();
        try {
            this.cache("LON-1", 0).remove((Object)"k");
            this.checkFailOnBackupFailure();
        }
        catch (CacheException e) {
            this.checkNonFailOnBackupFailure();
        }
        finally {
            this.failureInterceptor.disable();
        }
        this.eventuallyEquals(null, () -> this.cache("LON-1", 0).get((Object)"k"));
        this.eventuallyEquals(null, () -> this.cache("LON-1", 1).get((Object)"k"));
        AssertJUnit.assertTrue((boolean)this.failureInterceptor.removeFailed);
        AssertJUnit.assertEquals((Object)"v", (Object)this.backup("LON-1").get((Object)"k"));
    }

    public void testReplaceFailure() {
        this.failureInterceptor.disable();
        this.cache("LON-1", 0).put((Object)"k", (Object)"v");
        AssertJUnit.assertEquals((Object)"v", (Object)this.cache("LON-1", 1).get((Object)"k"));
        AssertJUnit.assertEquals((Object)"v", (Object)this.backup("LON-1").get((Object)"k"));
        this.failureInterceptor.enable();
        try {
            this.cache("LON-1", 0).replace((Object)"k", (Object)"v2");
            this.checkFailOnBackupFailure();
        }
        catch (CacheException e) {
            this.checkNonFailOnBackupFailure();
        }
        finally {
            this.failureInterceptor.disable();
        }
        this.eventuallyEquals("v2", () -> this.cache("LON-1", 0).get((Object)"k"));
        this.eventuallyEquals("v2", () -> this.cache("LON-1", 1).get((Object)"k"));
        AssertJUnit.assertTrue((boolean)this.failureInterceptor.putFailed);
        AssertJUnit.assertEquals((Object)"v", (Object)this.backup("LON-1").get((Object)"k"));
    }

    public void testClearFailure() {
        this.cache("LON-1", 0).put((Object)"k1", (Object)"v1");
        this.cache("LON-1", 0).put((Object)"k2", (Object)"v2");
        this.cache("LON-1", 0).put((Object)"k3", (Object)"v3");
        this.failureInterceptor.enable();
        try {
            this.cache("LON-1", 1).clear();
            this.checkFailOnBackupFailure();
        }
        catch (CacheException e) {
            this.checkNonFailOnBackupFailure();
        }
        finally {
            this.failureInterceptor.disable();
        }
        this.eventuallyEquals(null, () -> this.cache("LON-1", 0).get((Object)"k1"));
        this.eventuallyEquals(null, () -> this.cache("LON-1", 0).get((Object)"k2"));
        this.eventuallyEquals(null, () -> this.cache("LON-1", 0).get((Object)"k3"));
        this.eventuallyEquals(null, () -> this.cache("LON-1", 1).get((Object)"k1"));
        this.eventuallyEquals(null, () -> this.cache("LON-1", 1).get((Object)"k2"));
        this.eventuallyEquals(null, () -> this.cache("LON-1", 1).get((Object)"k3"));
        AssertJUnit.assertTrue((boolean)this.failureInterceptor.clearFailed);
        AssertJUnit.assertEquals((Object)"v1", (Object)this.backup("LON-1").get((Object)"k1"));
        AssertJUnit.assertEquals((Object)"v2", (Object)this.backup("LON-1").get((Object)"k2"));
        AssertJUnit.assertEquals((Object)"v3", (Object)this.backup("LON-1").get((Object)"k3"));
    }

    public void testPutMapFailure() {
        HashMap<String, String> toAdd = new HashMap<String, String>();
        for (int i = 0; i < 100; ++i) {
            toAdd.put("k" + i, "v" + i);
        }
        this.failureInterceptor.enable();
        try {
            this.cache("LON-1", 0).putAll(toAdd);
            this.checkFailOnBackupFailure();
        }
        catch (CacheException e) {
            this.checkNonFailOnBackupFailure();
        }
        finally {
            this.failureInterceptor.disable();
        }
        AssertJUnit.assertTrue((boolean)this.failureInterceptor.writeOnlyManyEntriesFailed);
        for (int i = 0; i < 100; ++i) {
            int keyIndex = i;
            if (this.lonBackupFailurePolicy != BackupFailurePolicy.FAIL) {
                this.eventuallyEquals("v" + keyIndex, () -> this.cache("LON-1", keyIndex % 2).get((Object)("k" + keyIndex)));
            }
            AssertJUnit.assertNull((Object)this.backup("LON-1").get((Object)("k" + i)));
        }
    }

    private void checkNonFailOnBackupFailure() {
        if (!this.failOnBackupFailure("LON-1", 0)) {
            throw new AssertionError((Object)"Should fail silently!");
        }
    }

    private void checkFailOnBackupFailure() {
        if (this.failOnBackupFailure("LON-1", 0)) {
            throw new AssertionError((Object)"Exception expected!");
        }
    }
}

