/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.backupfailure.tx;

import org.infinispan.commons.CacheException;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.configuration.cache.BackupFailurePolicy;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.xsite.AbstractTwoSitesTest;
import org.infinispan.xsite.backupfailure.BaseBackupFailureTest;
import org.testng.annotations.Test;

@Test(groups={"xsite"}, testName="xsite.backupfailure.tx.SinglePhaseCommitFailureTest")
public class SinglePhaseCommitFailureTest
extends AbstractTwoSitesTest {
    private BaseBackupFailureTest.FailureInterceptor failureInterceptor;

    public SinglePhaseCommitFailureTest() {
        this.use2Pc = false;
        this.lonBackupFailurePolicy = BackupFailurePolicy.FAIL;
    }

    @Override
    protected void createSites() {
        super.createSites();
        this.failureInterceptor = new BaseBackupFailureTest.FailureInterceptor();
        this.backup("LON-1").getAdvancedCache().getAsyncInterceptorChain().addInterceptor((AsyncInterceptor)this.failureInterceptor, 1);
    }

    public void testPrepareFailure() {
        this.failureInterceptor.enable();
        try {
            Exceptions.expectException(CacheException.class, () -> this.cache("LON-1", 0).put((Object)"k", (Object)"v"));
        }
        finally {
            this.failureInterceptor.disable();
        }
    }

    @Override
    protected ConfigurationBuilder getNycActiveConfig() {
        return SinglePhaseCommitFailureTest.getDefaultClusteredCacheConfig(CacheMode.REPL_SYNC, true);
    }

    @Override
    protected ConfigurationBuilder getLonActiveConfig() {
        ConfigurationBuilder dcc = SinglePhaseCommitFailureTest.getDefaultClusteredCacheConfig(CacheMode.REPL_SYNC, true);
        dcc.transaction().useSynchronization(false);
        return dcc;
    }
}

