/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.irac;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.manager.EmbeddedCacheManagerAdmin;
import org.infinispan.remoting.transport.AbstractDelegatingTransport;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.XSiteResponse;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.ExponentialBackOff;
import org.infinispan.xsite.XSiteBackup;
import org.infinispan.xsite.XSiteReplicateCommand;
import org.infinispan.xsite.irac.DefaultIracManager;
import org.infinispan.xsite.irac.IracManager;
import org.jgroups.UnreachableException;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="xsite.iract.IracExponentialBackOffTest")
public class IracExponentialBackOffTest
extends SingleCacheManagerTest {
    private static final String LON = "LON";
    private static final String NYC = "NYC";
    private static final String CACHE_NAME = "irac-exponential-backoff";
    private static final Supplier<Throwable> NO_EXCEPTION = () -> null;
    private final ControlledExponentialBackOff backOff = new ControlledExponentialBackOff();
    private volatile ControlledTransport transport;
    private volatile DefaultIracManager iracManager;

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createClusteredCacheManager();
        this.transport = TestingUtil.wrapGlobalComponent((CacheContainer)cacheManager, Transport.class, ControlledTransport::new, true);
        this.cache = ((EmbeddedCacheManagerAdmin)cacheManager.administration().withFlags(new CacheContainerAdmin.AdminFlag[]{CacheContainerAdmin.AdminFlag.VOLATILE})).getOrCreateCache(CACHE_NAME, IracExponentialBackOffTest.createCacheConfiguration().build());
        this.iracManager = (DefaultIracManager)TestingUtil.extractComponent(this.cache, IracManager.class);
        this.iracManager.setBackOff((ExponentialBackOff)this.backOff);
        return cacheManager;
    }

    private static ConfigurationBuilder createCacheConfiguration() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.clustering().cacheMode(CacheMode.DIST_SYNC);
        builder.sites().addBackup().site(NYC).strategy(BackupConfiguration.BackupStrategy.ASYNC);
        return builder;
    }

    public void testSimulatedTimeout(Method method) throws InterruptedException {
        this.doTest(method, () -> log.requestTimedOut(1L, NYC));
    }

    public void testSimulatedUnreachableException(Method method) throws InterruptedException {
        this.doTest(method, () -> new UnreachableException(null));
    }

    public void testSimulatedSiteUnreachableEvent(Method method) throws InterruptedException {
        this.doTest(method, () -> log.remoteNodeSuspected(null));
    }

    public void testNoBackoffOnOtherException(Method method) throws InterruptedException {
        this.backOff.drainPermits();
        this.backOff.cleanupEvents();
        this.backOff.assertNoEvents();
        this.transport.throwableSupplier = CacheException::new;
        String key = TestingUtil.k(method);
        String value = TestingUtil.v(method);
        this.cache.put((Object)key, (Object)value);
        this.backOff.eventually("Reset event with CacheException.", Event.RESET);
        this.transport.throwableSupplier = IracExponentialBackOffTest.NO_EXCEPTION;
        this.eventually(() -> ((DefaultIracManager)this.iracManager).isEmpty());
        this.backOff.cleanupEvents();
        this.backOff.assertNoEvents();
    }

    private void doTest(Method method, Supplier<Throwable> throwableSupplier) throws InterruptedException {
        this.backOff.drainPermits();
        this.backOff.cleanupEvents();
        this.backOff.assertNoEvents();
        this.transport.throwableSupplier = throwableSupplier;
        String key = TestingUtil.k(method);
        String value = TestingUtil.v(method);
        this.cache.put((Object)key, (Object)value);
        this.backOff.eventually("Backoff event on first try.", Event.BACK_OFF);
        this.backOff.release();
        this.backOff.eventually("Backoff event on second try.", Event.BACK_OFF);
        this.transport.throwableSupplier = IracExponentialBackOffTest.NO_EXCEPTION;
        this.backOff.release();
        this.eventually(() -> ((DefaultIracManager)this.iracManager).isEmpty());
        this.backOff.eventually("Reset event after successful try", Event.RESET);
        this.backOff.assertNoEvents();
    }

    static /* synthetic */ Supplier access$200() {
        return NO_EXCEPTION;
    }

    private static enum Event {
        BACK_OFF,
        RESET;

    }

    private static class ControlledXSiteResponse<T>
    extends CompletableFuture<T>
    implements XSiteResponse<T> {
        private final XSiteBackup backup;
        private final Throwable result;

        private ControlledXSiteResponse(XSiteBackup backup, Throwable result) {
            this.backup = backup;
            this.result = result;
        }

        public void whenCompleted(XSiteResponse.XSiteResponseCompleted listener) {
            listener.onCompleted(this.backup, System.currentTimeMillis(), 0L, this.result);
        }

        void complete() {
            if (this.result == null) {
                this.complete(null);
            } else {
                this.completeExceptionally(this.result);
            }
        }
    }

    static class ControlledTransport
    extends AbstractDelegatingTransport {
        private volatile Supplier<Throwable> throwableSupplier = IracExponentialBackOffTest.access$200();

        ControlledTransport(Transport actual) {
            super(actual);
        }

        public void start() {
        }

        public <O> XSiteResponse<O> backupRemotely(XSiteBackup backup, XSiteReplicateCommand<O> rpcCommand) {
            ControlledXSiteResponse response = new ControlledXSiteResponse(backup, this.throwableSupplier.get());
            response.complete();
            return response;
        }

        public void checkCrossSiteAvailable() throws CacheConfigurationException {
        }

        public String localSiteName() {
            return IracExponentialBackOffTest.LON;
        }

        public Set<String> getSitesView() {
            return Collections.singleton(IracExponentialBackOffTest.LON);
        }
    }

    private static class ControlledExponentialBackOff
    implements ExponentialBackOff {
        private final BlockingDeque<Event> backOffEvents;
        private final Semaphore semaphore;
        private volatile CompletableFuture<Void> backOff = new CompletableFuture();

        private ControlledExponentialBackOff() {
            this.backOffEvents = new LinkedBlockingDeque<Event>();
            this.semaphore = new Semaphore(0);
        }

        public void reset() {
            this.backOffEvents.add(Event.RESET);
        }

        public CompletionStage<Void> asyncBackOff() {
            this.backOffEvents.add(Event.BACK_OFF);
            return this.backOff;
        }

        void release() {
            this.semaphore.release(1);
            this.backOff.complete(null);
            this.backOff = new CompletableFuture();
        }

        void drainPermits() {
            this.semaphore.drainPermits();
            this.backOff.complete(null);
            this.backOff = new CompletableFuture();
        }

        void cleanupEvents() {
            this.backOffEvents.clear();
        }

        void eventually(String message, Event expected) throws InterruptedException {
            Event current = this.backOffEvents.poll(30L, TimeUnit.SECONDS);
            AssertJUnit.assertEquals((String)message, (Object)((Object)expected), (Object)((Object)current));
        }

        void assertNoEvents() {
            AssertJUnit.assertTrue((String)"Expected no events.", (boolean)this.backOffEvents.isEmpty());
        }
    }
}

