/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.irac;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.infinispan.Cache;
import org.infinispan.commons.time.ControlledTimeService;
import org.infinispan.commons.time.TimeService;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.manager.CacheContainer;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.xsite.AbstractMultipleSitesTest;
import org.infinispan.xsite.irac.ManualIracManager;
import org.testng.AssertJUnit;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="xsite.irac.IracMaxIdleTest")
public class IracMaxIdleTest
extends AbstractMultipleSitesTest {
    private static final long MAX_IDLE = 1000L;
    private final ControlledTimeService timeService = new ControlledTimeService();

    @Override
    protected int defaultNumberOfSites() {
        return 2;
    }

    @Override
    protected int defaultNumberOfNodes() {
        return 1;
    }

    @Override
    protected ConfigurationBuilder defaultConfigurationForSite(int siteIndex) {
        ConfigurationBuilder builder = super.defaultConfigurationForSite(siteIndex);
        builder.expiration().reaperEnabled(false);
        builder.sites().addBackup().site(siteIndex == 0 ? this.siteName(1) : this.siteName(0)).strategy(BackupConfiguration.BackupStrategy.ASYNC);
        return builder;
    }

    @DataProvider(name="data")
    public Object[][] data() {
        return new Object[][]{{TestData.NON_TX}, {TestData.PESSIMISTIC}, {TestData.OPTIMISTIC}};
    }

    @Test(dataProvider="data")
    public void testMaxIdle(TestData testData) {
        String cacheName = this.createCaches(testData);
        List<ManualIracManager> iracManagers = this.caches(0, cacheName).stream().map(ManualIracManager::wrapCache).peek(m -> m.disable(ManualIracManager.DisableMode.DROP)).collect(Collectors.toList());
        String key = IracMaxIdleTest.createKeyOrValue(testData, "key");
        String value = IracMaxIdleTest.createKeyOrValue(testData, "value");
        this.cache(0, 0, cacheName).put((Object)key, (Object)value, -1L, TimeUnit.MILLISECONDS, 1000L, TimeUnit.MILLISECONDS);
        this.eventuallyAssertInAllSitesAndCaches(cacheName, c -> Objects.equals(value, c.get((Object)key)));
        iracManagers.forEach(ManualIracManager::enable);
        this.timeService.advance(1001L);
        AssertJUnit.assertNull((Object)this.cache(0, 0, cacheName).get((Object)key));
        AssertJUnit.assertTrue((boolean)iracManagers.stream().anyMatch(ManualIracManager::hasPendingKeys));
        iracManagers.forEach(ManualIracManager::sendKeys);
        this.eventually(() -> iracManagers.stream().noneMatch(ManualIracManager::hasPendingKeys));
        this.eventually(() -> iracManagers.stream().allMatch(ManualIracManager::isEmpty));
        this.assertNoKeyInDataContainer(1, cacheName, key);
        this.assertNoKeyInDataContainer(0, cacheName, key);
        this.assertNoDataLeak(cacheName);
    }

    private static String createKeyOrValue(TestData testData, String prefix) {
        switch (testData) {
            case NON_TX: {
                return prefix + "_ntx_";
            }
            case PESSIMISTIC: {
                return prefix + "_pes_";
            }
            case OPTIMISTIC: {
                return prefix + "_opt_";
            }
        }
        throw new IllegalStateException(String.valueOf((Object)testData));
    }

    private String createCaches(TestData testData) {
        LockingMode lockingMode;
        String cacheName;
        switch (testData) {
            case NON_TX: {
                return null;
            }
            case PESSIMISTIC: {
                cacheName = "pes_cache";
                lockingMode = LockingMode.PESSIMISTIC;
                break;
            }
            case OPTIMISTIC: {
                cacheName = "opt_cache";
                lockingMode = LockingMode.OPTIMISTIC;
                break;
            }
            default: {
                throw new IllegalStateException(String.valueOf((Object)testData));
            }
        }
        for (int i = 0; i < this.defaultNumberOfSites(); ++i) {
            IracMaxIdleTest.defineInSite(this.site(i), cacheName, this.defaultConfigurationForSite(i).transaction().transactionMode(TransactionMode.TRANSACTIONAL).lockingMode(lockingMode).build());
            this.site(i).waitForClusterToForm(cacheName);
        }
        return cacheName;
    }

    private void assertNoKeyInDataContainer(int siteIndex, String cacheName, String key) {
        for (Cache c : this.caches(siteIndex, cacheName)) {
            AssertJUnit.assertNull((Object)this.internalDataContainer(c).peek((Object)key));
        }
    }

    private InternalDataContainer<String, String> internalDataContainer(Cache<String, String> c) {
        return TestingUtil.extractComponent(c, InternalDataContainer.class);
    }

    @Override
    protected void afterSitesCreated() {
        super.afterSitesCreated();
        for (int i = 0; i < this.defaultNumberOfSites(); ++i) {
            this.site(i).cacheManagers().forEach(cm -> TestingUtil.replaceComponent((CacheContainer)cm, TimeService.class, this.timeService, true));
        }
    }

    private static enum TestData {
        NON_TX,
        PESSIMISTIC,
        OPTIMISTIC;

    }
}

