/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.irac;

import java.util.Objects;
import javax.transaction.RollbackException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.container.versioning.IncrementableEntryVersion;
import org.infinispan.container.versioning.irac.IracEntryVersion;
import org.infinispan.distribution.DistributionInfo;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.concurrent.IsolationLevel;
import org.infinispan.xsite.AbstractMultipleSitesTest;
import org.testng.AssertJUnit;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="xsite.irac.IracWriteSkewTest")
public class IracWriteSkewTest
extends AbstractMultipleSitesTest {
    private static final int N_SITES = 2;
    private static final int CLUSTER_SIZE = 2;
    private static final String CACHE_NAME = "ws-cache";

    private static InternalDataContainer<String, String> dataContainer(Cache<String, String> cache) {
        return TestingUtil.extractComponent(cache, InternalDataContainer.class);
    }

    private static DistributionInfo distributionInfo(Cache<String, String> cache, String key) {
        return TestingUtil.extractCacheTopology(cache).getDistribution((Object)key);
    }

    /*
     * Exception decompiling
     */
    @DataProvider(name="default")
    public Object[][] dataProvider() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Test(dataProvider="default")
    public void testWriteSkewCheck(TestMode testMode) throws Exception {
        Cache lonCache = this.cache(this.siteName(0), CACHE_NAME, 0);
        Cache nycCache = this.cache(this.siteName(1), CACHE_NAME, 0);
        TransactionManager tm = nycCache.getAdvancedCache().getTransactionManager();
        String key = testMode.toString();
        if (!testMode.startEmpty) {
            lonCache.put((Object)key, (Object)"before");
            this.eventuallyAssertInAllSitesAndCaches(CACHE_NAME, C2 -> Objects.equals("before", C2.get((Object)key)));
            this.checkKey(key, "before");
        }
        tm.begin();
        String oldValue = (String)nycCache.get((Object)key);
        if (testMode.startEmpty) {
            AssertJUnit.assertNull((Object)oldValue);
        } else {
            AssertJUnit.assertEquals((String)"before", (String)oldValue);
        }
        Transaction tx = tm.suspend();
        if (testMode.isRemove) {
            lonCache.remove((Object)key);
            this.eventually(() -> this.iracManager(this.siteName(0), CACHE_NAME, 0).isEmpty());
            this.eventuallyAssertInAllSitesAndCaches(CACHE_NAME, c -> Objects.isNull(c.get((Object)key)));
        } else {
            lonCache.put((Object)key, (Object)"write-skew-value");
            this.eventuallyAssertInAllSitesAndCaches(CACHE_NAME, c -> Objects.equals("write-skew-value", c.get((Object)key)));
            this.checkKey(key, "write-skew-value");
        }
        tm.resume(tx);
        nycCache.put((Object)key, (Object)"after");
        if (testMode.startEmpty && testMode.isRemove) {
            tm.commit();
            this.eventuallyAssertInAllSitesAndCaches(CACHE_NAME, c -> Objects.equals("after", c.get((Object)key)));
            this.checkKey(key, "after");
        } else {
            Exceptions.expectException(RollbackException.class, () -> ((TransactionManager)tm).commit());
            if (testMode.isRemove) {
                this.eventuallyAssertInAllSitesAndCaches(CACHE_NAME, c -> Objects.isNull(c.get((Object)key)));
            } else {
                this.eventuallyAssertInAllSitesAndCaches(CACHE_NAME, c -> Objects.equals("write-skew-value", c.get((Object)key)));
                this.checkKey(key, "write-skew-value");
            }
        }
        this.assertNoDataLeak(CACHE_NAME);
    }

    @Override
    protected int defaultNumberOfSites() {
        return 2;
    }

    @Override
    protected int defaultNumberOfNodes() {
        return 2;
    }

    @Override
    protected void afterSitesCreated() {
        ConfigurationBuilder builder = IracWriteSkewTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC);
        builder.sites().addBackup().site(this.siteName(1)).strategy(BackupConfiguration.BackupStrategy.ASYNC);
        this.startCache(this.siteName(0), CACHE_NAME, builder);
        builder = IracWriteSkewTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true);
        builder.transaction().lockingMode(LockingMode.OPTIMISTIC);
        builder.locking().isolationLevel(IsolationLevel.REPEATABLE_READ);
        builder.sites().addBackup().site(this.siteName(0)).strategy(BackupConfiguration.BackupStrategy.ASYNC);
        this.startCache(this.siteName(1), CACHE_NAME, builder);
    }

    private void checkKey(String key, String value) {
        IracEntryVersion iracVersion = this.extractIracEntryVersion(key);
        AssertJUnit.assertNotNull((Object)iracVersion);
        this.assertIracEntryVersion(key, value, iracVersion);
        IncrementableEntryVersion entryVersion = this.extractEntryVersion(key);
        AssertJUnit.assertNotNull((Object)entryVersion);
        this.assertIracEntryVersion(key, value, iracVersion, entryVersion);
    }

    private IracEntryVersion extractIracEntryVersion(String key) {
        return this.primaryOwner(0, key).getInternalMetadata().iracMetadata().getVersion();
    }

    private IncrementableEntryVersion extractEntryVersion(String key) {
        return this.primaryOwner(1, key).getInternalMetadata().entryVersion();
    }

    private InternalCacheEntry<String, String> primaryOwner(int siteIndex, String key) {
        for (Cache c : this.caches(this.siteName(siteIndex), CACHE_NAME)) {
            DistributionInfo distributionInfo = IracWriteSkewTest.distributionInfo(c, key);
            if (!distributionInfo.isPrimary()) continue;
            return IracWriteSkewTest.dataContainer(c).peek(distributionInfo.segmentId(), (Object)key);
        }
        AssertJUnit.fail((String)("Unable to find primary owner for key: " + key));
        throw new IllegalStateException();
    }

    private void assertIracEntryVersion(String key, String value, IracEntryVersion version) {
        for (Cache c : this.caches(this.siteName(0), CACHE_NAME)) {
            InternalDataContainer<String, String> dc = IracWriteSkewTest.dataContainer(c);
            InternalCacheEntry entry = dc.peek((Object)key);
            AssertJUnit.assertEquals((String)value, (String)((String)entry.getValue()));
            AssertJUnit.assertEquals((Object)version, (Object)entry.getInternalMetadata().iracMetadata().getVersion());
        }
    }

    private void assertIracEntryVersion(String key, String value, IracEntryVersion iracVersion, IncrementableEntryVersion entryVersion) {
        for (Cache c : this.caches(this.siteName(1), CACHE_NAME)) {
            InternalDataContainer<String, String> dc = IracWriteSkewTest.dataContainer(c);
            InternalCacheEntry entry = dc.peek((Object)key);
            AssertJUnit.assertEquals((String)value, (String)((String)entry.getValue()));
            AssertJUnit.assertEquals((Object)iracVersion, (Object)entry.getInternalMetadata().iracMetadata().getVersion());
            AssertJUnit.assertEquals((Object)entryVersion, (Object)entry.getInternalMetadata().entryVersion());
        }
    }

    private static /* synthetic */ Object[][] lambda$dataProvider$1(int x$0) {
        return new Object[x$0][];
    }

    private static enum TestMode {
        EMPTY_AND_REMOVE(true, true),
        EMPTY_AND_PUT(true, false),
        NON_EMPTY_AND_REMOVE(false, true),
        NON_EMPTY_AND_PUT(false, false);

        private final boolean startEmpty;
        private final boolean isRemove;

        private TestMode(boolean startEmpty, boolean isRemove) {
            this.startEmpty = startEmpty;
            this.isRemove = isRemove;
        }
    }
}

