/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.irac;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import net.jcip.annotations.GuardedBy;
import org.infinispan.Cache;
import org.infinispan.commons.util.IntSet;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.TestingUtil;
import org.infinispan.xsite.irac.ControlledIracManager;
import org.infinispan.xsite.irac.DefaultIracManager;
import org.infinispan.xsite.irac.IracManager;
import org.infinispan.xsite.statetransfer.XSiteState;

public class ManualIracManager
extends ControlledIracManager {
    @GuardedBy(value="this")
    private final Map<Object, PendingKeyRequest> pendingKeys = new HashMap<Object, PendingKeyRequest>();
    @GuardedBy(value="this")
    private boolean enabled;
    private final List<StateTransferRequest> pendingStateTransfer = new ArrayList<StateTransferRequest>(2);

    private ManualIracManager(IracManager actual) {
        super(actual);
    }

    public static ManualIracManager wrapCache(Cache<?, ?> cache) {
        IracManager iracManager = TestingUtil.extractComponent(cache, IracManager.class);
        if (iracManager instanceof ManualIracManager) {
            return (ManualIracManager)iracManager;
        }
        return TestingUtil.wrapComponent(cache, IracManager.class, ManualIracManager::new);
    }

    @Override
    public synchronized void trackUpdatedKey(int segment, Object key, Object lockOwner) {
        if (this.enabled) {
            this.pendingKeys.put(key, new PendingKeyRequest(key, lockOwner, segment, false));
        } else {
            super.trackUpdatedKey(segment, key, lockOwner);
        }
    }

    @Override
    public void trackExpiredKey(int segment, Object key, Object lockOwner) {
        if (this.enabled) {
            this.pendingKeys.put(key, new PendingKeyRequest(key, lockOwner, segment, true));
        } else {
            super.trackExpiredKey(segment, key, lockOwner);
        }
    }

    @Override
    public synchronized CompletionStage<Void> trackForStateTransfer(Collection<XSiteState> stateList) {
        if (this.enabled) {
            StateTransferRequest request = new StateTransferRequest(stateList);
            this.pendingStateTransfer.add(request);
            return request;
        }
        return super.trackForStateTransfer(stateList);
    }

    @Override
    public synchronized void requestState(Address origin, IntSet segments) {
        this.asDefaultIracManager().ifPresent(im -> this.pendingKeys.values().forEach(req -> im.sendStateIfNeeded(origin, segments, req.getSegment(), req.getKey(), req.getLockOwner())));
        super.requestState(origin, segments);
    }

    public synchronized void sendKeys() {
        this.pendingKeys.values().forEach(this::send);
        this.pendingKeys.clear();
        this.pendingStateTransfer.forEach(this::send);
        this.pendingStateTransfer.clear();
    }

    public synchronized void enable() {
        this.enabled = true;
    }

    public synchronized void disable(DisableMode disableMode) {
        this.enabled = false;
        switch (disableMode) {
            case DROP: {
                this.pendingKeys.clear();
                this.pendingStateTransfer.clear();
                break;
            }
            case SEND: {
                this.sendKeys();
            }
        }
    }

    public boolean isEmpty() {
        return this.asDefaultIracManager().map(DefaultIracManager::isEmpty).orElse(true);
    }

    public boolean hasPendingKeys() {
        return !this.pendingKeys.isEmpty();
    }

    private void send(PendingKeyRequest request) {
        if (request.isExpiration()) {
            super.trackExpiredKey(request.getSegment(), request.getKey(), request.getLockOwner());
            return;
        }
        super.trackUpdatedKey(request.getSegment(), request.getKey(), request.getLockOwner());
    }

    private void send(StateTransferRequest request) {
        CompletionStage<Void> rsp = super.trackForStateTransfer(request.getState());
        rsp.whenComplete(request);
    }

    private static class PendingKeyRequest {
        private final Object key;
        private final Object lockOwner;
        private final int segment;
        private final boolean expiration;

        private PendingKeyRequest(Object key, Object lockOwner, int segment, boolean expiration) {
            this.key = key;
            this.lockOwner = lockOwner;
            this.segment = segment;
            this.expiration = expiration;
        }

        Object getKey() {
            return this.key;
        }

        Object getLockOwner() {
            return this.lockOwner;
        }

        int getSegment() {
            return this.segment;
        }

        boolean isExpiration() {
            return this.expiration;
        }
    }

    private static class StateTransferRequest
    extends CompletableFuture<Void>
    implements BiConsumer<Void, Throwable> {
        private final Collection<XSiteState> state;

        private StateTransferRequest(Collection<XSiteState> state) {
            this.state = new ArrayList<XSiteState>(state);
        }

        Collection<XSiteState> getState() {
            return this.state;
        }

        @Override
        public void accept(Void unused, Throwable throwable) {
            if (throwable != null) {
                this.completeExceptionally(throwable);
            } else {
                this.complete(null);
            }
        }
    }

    public static enum DisableMode {
        SEND,
        DROP;

    }
}

