/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.offline;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.infinispan.Cache;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.BackupFailurePolicy;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.manager.EmbeddedCacheManagerAdmin;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.inboundhandler.InboundInvocationHandler;
import org.infinispan.remoting.inboundhandler.Reply;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.ExponentialBackOff;
import org.infinispan.xsite.AbstractXSiteTest;
import org.infinispan.xsite.OfflineStatus;
import org.infinispan.xsite.XSiteReplicateCommand;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="xsite.offline.AsyncOfflineTest")
public class AsyncOfflineTest
extends AbstractXSiteTest {
    private static final int NUM_NODES = 3;
    private static final int NUM_FAILURES = 6;
    private static final String LON = "LON-1";
    private static final String NYC = "NYC-2";
    private static final String SFO = "SFO-3";

    public void testSFOOffline(Method method) {
        String cacheName = method.getName();
        this.defineCache(LON, cacheName, this.getLONConfiguration());
        this.defineCache(NYC, cacheName, this.getNYCOrSFOConfiguration());
        for (int i = 0; i < 3; ++i) {
            this.iracManager(LON, cacheName, i).setBackOff(ExponentialBackOff.NO_OP);
        }
        String key = method.getName() + "-key";
        int primaryOwner = this.primaryOwnerIndex(cacheName, key);
        for (int i = 0; i < 3; ++i) {
            this.doTestInNode(cacheName, i, primaryOwner, key);
        }
    }

    public void testSlowSFO(Method method) {
        this.createTestSite(SFO);
        String cacheName = method.getName();
        this.defineCache(LON, cacheName, this.getLONConfiguration());
        this.defineCache(NYC, cacheName, this.getNYCOrSFOConfiguration());
        this.defineCache(SFO, cacheName, this.getNYCOrSFOConfiguration());
        for (int i = 0; i < 3; ++i) {
            this.iracManager(LON, cacheName, i).setBackOff(ExponentialBackOff.NO_OP);
        }
        String key = method.getName() + "-key";
        int primaryOwner = this.primaryOwnerIndex(cacheName, key);
        this.cache(LON, cacheName, 0).put((Object)"key", (Object)"value");
        this.eventuallyEquals("value", () -> this.cache(SFO, cacheName, 0).get((Object)"key"));
        AssertJUnit.assertEquals((int)0, (int)this.takeOfflineManager(LON, cacheName, primaryOwner).getOfflineStatus(SFO).getFailureCount());
        List<DiscardInboundHandler> handlers = this.replaceSFOInboundHandler();
        handlers.forEach(h -> ((DiscardInboundHandler)h).discard = true);
        for (int i = 0; i < 3; ++i) {
            this.doTestInNode(cacheName, i, primaryOwner, key);
        }
    }

    public void testReset(Method method) {
        this.createTestSite(SFO);
        String cacheName = method.getName();
        this.defineCache(LON, cacheName, this.getLONConfiguration());
        this.defineCache(NYC, cacheName, this.getNYCOrSFOConfiguration());
        this.defineCache(SFO, cacheName, this.getNYCOrSFOConfiguration());
        for (int i = 0; i < 3; ++i) {
            this.iracManager(LON, cacheName, i).setBackOff(ExponentialBackOff.NO_OP);
        }
        String key = method.getName() + "-key";
        int primaryOwner = this.primaryOwnerIndex(cacheName, key);
        Cache lonCache = this.cache(LON, cacheName, 0);
        Cache sfoCache = this.cache(SFO, cacheName, 0);
        OfflineStatus lonStatus = this.takeOfflineManager(LON, cacheName, primaryOwner).getOfflineStatus(SFO);
        lonCache.put((Object)key, (Object)"value");
        this.eventuallyEquals("value", () -> (String)sfoCache.get((Object)key));
        AssertJUnit.assertEquals((int)0, (int)lonStatus.getFailureCount());
        List<DiscardInboundHandler> handlers = this.replaceSFOInboundHandler();
        handlers.forEach(h -> ((DiscardInboundHandler)h).discard = true);
        lonCache.put((Object)key, (Object)"value2");
        this.eventuallyEquals(1, () -> ((OfflineStatus)lonStatus).getFailureCount());
        AssertJUnit.assertEquals((String)"value", (String)((String)sfoCache.get((Object)key)));
        handlers.forEach(h -> ((DiscardInboundHandler)h).discard = false);
        this.eventually(() -> {
            for (int i = 0; i < 3; ++i) {
                if (this.iracManager(LON, cacheName, i).isEmpty()) continue;
                return false;
            }
            return true;
        });
        lonCache.put((Object)key, (Object)"value3");
        this.eventuallyEquals("value3", () -> (String)sfoCache.get((Object)key));
        this.eventuallyEquals(0, () -> ((OfflineStatus)lonStatus).getFailureCount());
    }

    @AfterMethod(alwaysRun=true)
    public void killSFO() {
        this.killSite(SFO);
    }

    @Override
    protected void createSites() {
        this.createTestSite(LON);
        this.createTestSite(NYC);
        this.waitForSites(LON, NYC);
    }

    private void doTestInNode(String cacheName, int index, int primaryOwnerIndex, String key) {
        Cache cache = this.cache(LON, cacheName, index);
        this.assertOnline(cacheName, index, NYC);
        this.assertOnline(cacheName, index, SFO);
        if (index != primaryOwnerIndex) {
            this.assertOnline(cacheName, primaryOwnerIndex, NYC);
            this.assertOnline(cacheName, primaryOwnerIndex, SFO);
        }
        for (int i = 0; i < 6; ++i) {
            cache.put((Object)key, (Object)"value");
        }
        if (index == primaryOwnerIndex) {
            this.assertOnline(cacheName, index, NYC);
            this.assertEventuallyOffline(cacheName, index);
        } else {
            this.assertOnline(cacheName, index, NYC);
            this.assertOnline(cacheName, index, SFO);
            this.assertOnline(cacheName, primaryOwnerIndex, NYC);
            this.assertEventuallyOffline(cacheName, primaryOwnerIndex);
        }
        this.assertBringSiteOnline(cacheName, primaryOwnerIndex);
    }

    private void assertOnline(String cacheName, int index, String targetSiteName) {
        OfflineStatus status = this.takeOfflineManager(LON, cacheName, index).getOfflineStatus(targetSiteName);
        AssertJUnit.assertTrue((boolean)status.isEnabled());
        AssertJUnit.assertFalse((String)("Site " + targetSiteName + " is offline. status=" + status), (boolean)status.isOffline());
    }

    private void assertEventuallyOffline(String cacheName, int index) {
        OfflineStatus status = this.takeOfflineManager(LON, cacheName, index).getOfflineStatus(SFO);
        AssertJUnit.assertTrue((boolean)status.isEnabled());
        AsyncOfflineTest.eventually(() -> "Site SFO-3 is online. status=" + status, () -> ((OfflineStatus)status).isOffline());
    }

    private void assertBringSiteOnline(String cacheName, int index) {
        OfflineStatus status = this.takeOfflineManager(LON, cacheName, index).getOfflineStatus(SFO);
        AssertJUnit.assertTrue((String)("Unable to bring SFO-3 online. status=" + status), (boolean)status.bringOnline());
    }

    private int primaryOwnerIndex(String cacheName, String key) {
        for (int i = 0; i < 3; ++i) {
            boolean isPrimary = TestingUtil.extractCacheTopology(this.cache(LON, cacheName, i)).getDistribution((Object)key).isPrimary();
            if (!isPrimary) continue;
            return i;
        }
        throw new IllegalStateException();
    }

    private Configuration getLONConfiguration() {
        ConfigurationBuilder builder = AsyncOfflineTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC);
        builder.clustering().hash().numSegments(4);
        builder.sites().addBackup().site(NYC).backupFailurePolicy(BackupFailurePolicy.FAIL).replicationTimeout(1000L).takeOffline().afterFailures(6).backup().strategy(BackupConfiguration.BackupStrategy.SYNC);
        builder.sites().addInUseBackupSite(NYC);
        builder.sites().addBackup().site(SFO).backupFailurePolicy(BackupFailurePolicy.FAIL).replicationTimeout(1000L).takeOffline().afterFailures(6).backup().strategy(BackupConfiguration.BackupStrategy.ASYNC);
        builder.sites().addInUseBackupSite(SFO);
        return builder.build();
    }

    private Configuration getNYCOrSFOConfiguration() {
        return AsyncOfflineTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC).build();
    }

    private void defineCache(String siteName, String cacheName, Configuration configuration) {
        AbstractXSiteTest.TestSite site = this.site(siteName);
        ((EmbeddedCacheManagerAdmin)site.cacheManagers().get(0).administration().withFlags(new CacheContainerAdmin.AdminFlag[]{CacheContainerAdmin.AdminFlag.VOLATILE})).createCache(cacheName, configuration);
        site.waitForClusterToForm(cacheName);
    }

    private void createTestSite(String siteName) {
        GlobalConfigurationBuilder gcb = GlobalConfigurationBuilder.defaultClusteredBuilder();
        this.createSite(siteName, 3, gcb, new ConfigurationBuilder());
    }

    private List<DiscardInboundHandler> replaceSFOInboundHandler() {
        ArrayList<DiscardInboundHandler> handlers = new ArrayList<DiscardInboundHandler>(3);
        for (EmbeddedCacheManager manager : this.site(SFO).cacheManagers()) {
            handlers.add(TestingUtil.wrapGlobalComponent((CacheContainer)manager, InboundInvocationHandler.class, x$0 -> new DiscardInboundHandler((InboundInvocationHandler)x$0), true));
        }
        return handlers;
    }

    private static class DiscardInboundHandler
    implements InboundInvocationHandler {
        private final InboundInvocationHandler handler;
        private volatile boolean discard;

        private DiscardInboundHandler(InboundInvocationHandler handler) {
            this.handler = handler;
            this.discard = false;
        }

        public void handleFromCluster(Address origin, ReplicableCommand command, Reply reply, DeliverOrder order) {
            this.handler.handleFromCluster(origin, command, reply, order);
        }

        public void handleFromRemoteSite(String origin, XSiteReplicateCommand<?> command, Reply reply, DeliverOrder order) {
            if (this.discard) {
                return;
            }
            this.handler.handleFromRemoteSite(origin, command, reply, order);
        }
    }
}

