/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.offline;

import java.lang.reflect.Method;
import org.infinispan.Cache;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.BackupFailurePolicy;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManagerAdmin;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.ExponentialBackOff;
import org.infinispan.xsite.AbstractXSiteTest;
import org.infinispan.xsite.OfflineStatus;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="xsite.offline.AsyncTimeBasedOfflineTest")
public class AsyncTimeBasedOfflineTest
extends AbstractXSiteTest {
    private static final int NUM_NODES = 3;
    private static final long MIN_WAIT_TIME_MILLIS = 1000L;
    private static final String LON = "LON-1";
    private static final String NYC = "NYC-2";
    private static final String SFO = "SFO-3";

    public void testSFOOffline(Method method) {
        String cacheName = method.getName();
        this.defineCache(LON, cacheName, this.getLONConfiguration());
        this.defineCache(NYC, cacheName, this.getNYCOrSFOConfiguration());
        for (int i = 0; i < 3; ++i) {
            this.iracManager(LON, cacheName, i).setBackOff(ExponentialBackOff.NO_OP);
        }
        String key = method.getName() + "-key";
        int primaryOwner = this.primaryOwnerIndex(cacheName, key);
        for (int i = 0; i < 3; ++i) {
            this.doTestInNode(cacheName, i, primaryOwner, key);
        }
    }

    @AfterMethod(alwaysRun=true)
    public void killSFO() {
        this.killSite(SFO);
    }

    @Override
    protected void createSites() {
        this.createTestSite(LON);
        this.createTestSite(NYC);
        this.waitForSites(LON, NYC);
    }

    private void doTestInNode(String cacheName, int index, int primaryOwnerIndex, String key) {
        Cache cache = this.cache(LON, cacheName, index);
        this.assertOnline(cacheName, index, NYC);
        this.assertOnline(cacheName, index, SFO);
        if (index != primaryOwnerIndex) {
            this.assertOnline(cacheName, primaryOwnerIndex, NYC);
            this.assertOnline(cacheName, primaryOwnerIndex, SFO);
        }
        cache.put((Object)key, (Object)"value");
        if (index == primaryOwnerIndex) {
            this.assertOnline(cacheName, index, NYC);
            this.assertEventuallyOffline(cacheName, index);
        } else {
            this.assertOnline(cacheName, index, NYC);
            this.assertOnline(cacheName, index, SFO);
            this.assertOnline(cacheName, primaryOwnerIndex, NYC);
            this.assertEventuallyOffline(cacheName, primaryOwnerIndex);
        }
        this.assertBringSiteOnline(cacheName, primaryOwnerIndex);
    }

    private void assertOnline(String cacheName, int index, String targetSiteName) {
        OfflineStatus status = this.takeOfflineManager(LON, cacheName, index).getOfflineStatus(targetSiteName);
        AssertJUnit.assertTrue((boolean)status.isEnabled());
        AssertJUnit.assertFalse((String)("Site " + targetSiteName + " is offline. status=" + status), (boolean)status.isOffline());
    }

    private void assertEventuallyOffline(String cacheName, int index) {
        OfflineStatus status = this.takeOfflineManager(LON, cacheName, index).getOfflineStatus(SFO);
        AssertJUnit.assertTrue((boolean)status.isEnabled());
        this.eventually(() -> ((OfflineStatus)status).minTimeHasElapsed());
        this.cache(LON, cacheName, index).put((Object)"_key_", (Object)"_value_");
        AsyncTimeBasedOfflineTest.eventually(() -> "Site SFO-3 is online. status=" + status, () -> ((OfflineStatus)status).isOffline());
    }

    private void assertBringSiteOnline(String cacheName, int index) {
        OfflineStatus status = this.takeOfflineManager(LON, cacheName, index).getOfflineStatus(SFO);
        AssertJUnit.assertTrue((String)("Unable to bring SFO-3 online. status=" + status), (boolean)status.bringOnline());
    }

    private int primaryOwnerIndex(String cacheName, String key) {
        for (int i = 0; i < 3; ++i) {
            boolean isPrimary = TestingUtil.extractCacheTopology(this.cache(LON, cacheName, i)).getDistribution((Object)key).isPrimary();
            if (!isPrimary) continue;
            return i;
        }
        throw new IllegalStateException();
    }

    private Configuration getLONConfiguration() {
        ConfigurationBuilder builder = AsyncTimeBasedOfflineTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC);
        builder.clustering().hash().numSegments(4);
        builder.sites().addBackup().site(NYC).backupFailurePolicy(BackupFailurePolicy.FAIL).replicationTimeout(1000L).takeOffline().afterFailures(-1).minTimeToWait(1000L).backup().strategy(BackupConfiguration.BackupStrategy.SYNC);
        builder.sites().addInUseBackupSite(NYC);
        builder.sites().addBackup().site(SFO).backupFailurePolicy(BackupFailurePolicy.FAIL).replicationTimeout(1000L).takeOffline().afterFailures(-1).minTimeToWait(1000L).backup().strategy(BackupConfiguration.BackupStrategy.ASYNC);
        builder.sites().addInUseBackupSite(SFO);
        return builder.build();
    }

    private Configuration getNYCOrSFOConfiguration() {
        return AsyncTimeBasedOfflineTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC).build();
    }

    private void defineCache(String siteName, String cacheName, Configuration configuration) {
        AbstractXSiteTest.TestSite site = this.site(siteName);
        ((EmbeddedCacheManagerAdmin)site.cacheManagers().get(0).administration().withFlags(new CacheContainerAdmin.AdminFlag[]{CacheContainerAdmin.AdminFlag.VOLATILE})).createCache(cacheName, configuration);
        site.waitForClusterToForm(cacheName);
    }

    private void createTestSite(String siteName) {
        GlobalConfigurationBuilder gcb = GlobalConfigurationBuilder.defaultClusteredBuilder();
        this.createSite(siteName, 3, gcb, new ConfigurationBuilder());
    }
}

