/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.offline;

import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.BackupConfigurationBuilder;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.test.TestingUtil;
import org.infinispan.xsite.AbstractMultipleSitesTest;
import org.infinispan.xsite.AbstractXSiteTest;
import org.infinispan.xsite.OfflineStatus;
import org.infinispan.xsite.status.DefaultTakeOfflineManager;
import org.infinispan.xsite.status.TakeOfflineManager;
import org.testng.AssertJUnit;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"xsite"}, testName="xsite.offline.InvalidConfigurationOfflineTest")
public class InvalidConfigurationOfflineTest
extends AbstractMultipleSitesTest {
    @Override
    protected int defaultNumberOfSites() {
        return 2;
    }

    @Override
    protected int defaultNumberOfNodes() {
        return 1;
    }

    @Override
    protected void afterSitesCreated() {
        this.waitForSites((String[])this.sites.stream().map(AbstractXSiteTest.TestSite::getSiteName).toArray(String[]::new));
    }

    @DataProvider(name="data")
    public Object[][] collectionItemProvider() {
        return new Object[][]{{"not-defined-true", true, RemoteSiteMode.NOT_DEFINED}, {"not-started-true", true, RemoteSiteMode.NOT_STARTED}, {"not-clustered-true", true, RemoteSiteMode.LOCAL_CACHE}, {"not-defined-false", false, RemoteSiteMode.NOT_DEFINED}, {"not-started-false", false, RemoteSiteMode.NOT_STARTED}, {"not-clustered-false", false, RemoteSiteMode.LOCAL_CACHE}};
    }

    @Test(dataProvider="data")
    public void testTakeOffline(String cacheName, boolean takeOfflineEnabled, RemoteSiteMode remoteSiteMode) {
        this.configureSite1(cacheName, takeOfflineEnabled);
        this.configureSite2(cacheName, remoteSiteMode);
        OfflineStatus offlineStatus = this.takeOfflineManager(cacheName).getOfflineStatus(this.siteName(1));
        AssertJUnit.assertEquals((boolean)takeOfflineEnabled, (boolean)offlineStatus.isEnabled());
        AssertJUnit.assertFalse((boolean)offlineStatus.isOffline());
        this.cache(0, cacheName, 0).put((Object)"key", (Object)"value");
        InvalidConfigurationOfflineTest.eventually(() -> "Invalid configuration should take site offline.", () -> ((OfflineStatus)offlineStatus).isOffline());
    }

    private DefaultTakeOfflineManager takeOfflineManager(String cacheName) {
        return (DefaultTakeOfflineManager)TestingUtil.extractComponent(this.cache(0, cacheName, 0), TakeOfflineManager.class);
    }

    private void configureSite2(String cacheName, RemoteSiteMode remoteSiteMode) {
        switch (remoteSiteMode) {
            case LOCAL_CACHE: {
                ConfigurationBuilder builder = new ConfigurationBuilder();
                builder.clustering().cacheMode(CacheMode.LOCAL);
                InvalidConfigurationOfflineTest.defineInSite(this.site(1), cacheName, builder.build());
                this.site(1).waitForClusterToForm(cacheName);
                AssertJUnit.assertTrue((boolean)this.site(1).cacheManagers().get(0).isRunning(cacheName));
                return;
            }
            case NOT_DEFINED: {
                AssertJUnit.assertFalse((boolean)this.site(1).cacheManagers().get(0).cacheExists(cacheName));
                return;
            }
            case NOT_STARTED: {
                InvalidConfigurationOfflineTest.defineInSite(this.site(1), cacheName, InvalidConfigurationOfflineTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC).build());
                AssertJUnit.assertFalse((boolean)this.site(1).cacheManagers().get(0).isRunning(cacheName));
                return;
            }
        }
        AssertJUnit.fail((String)("Unexpected: " + (Object)((Object)remoteSiteMode)));
    }

    private void configureSite1(String cacheName, boolean takeOfflineEnabled) {
        ConfigurationBuilder builder = InvalidConfigurationOfflineTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC);
        BackupConfigurationBuilder backupBuilder = builder.sites().addBackup();
        backupBuilder.site(this.siteName(1)).strategy(BackupConfiguration.BackupStrategy.ASYNC);
        if (takeOfflineEnabled) {
            backupBuilder.takeOffline().afterFailures(Integer.MAX_VALUE);
        }
        InvalidConfigurationOfflineTest.defineInSite(this.site(0), cacheName, builder.build());
        this.site(0).waitForClusterToForm(cacheName);
    }

    private static enum RemoteSiteMode {
        NOT_DEFINED,
        NOT_STARTED,
        LOCAL_CACHE;

    }
}

