/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.offline;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.infinispan.commons.time.TimeService;
import org.infinispan.configuration.cache.TakeOfflineConfiguration;
import org.infinispan.configuration.cache.TakeOfflineConfigurationBuilder;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.util.ControlledTimeService;
import org.infinispan.xsite.OfflineStatus;
import org.infinispan.xsite.notification.SiteStatusListener;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"xsite"}, testName="xsite.offline.OfflineStatusTest")
public class OfflineStatusTest
extends AbstractInfinispanTest {
    public void timeBasedTakeOffline() {
        int i;
        long minTimeWait = 3000L;
        int minFailures = 10;
        TestContext context = OfflineStatusTest.createNew(3000L, 10);
        for (i = 0; i < 11; ++i) {
            OfflineStatusTest.assertOffline(context, false);
            OfflineStatusTest.addCommunicationFailure(context);
        }
        OfflineStatusTest.assertMinFailureCount(context, 11);
        OfflineStatusTest.assertMinTimeElapsed(context, false);
        OfflineStatusTest.assertOffline(context, false);
        context.timeService.advance(3001L);
        OfflineStatusTest.assertMinTimeElapsed(context, true);
        OfflineStatusTest.assertMinFailureCount(context, 11);
        OfflineStatusTest.addCommunicationFailure(context);
        OfflineStatusTest.assertOffline(context, true);
        context.offlineStatus.reset();
        for (i = 0; i < 9; ++i) {
            OfflineStatusTest.assertOffline(context, false);
            OfflineStatusTest.addCommunicationFailure(context);
        }
        OfflineStatusTest.assertMinFailureCount(context, 9);
        OfflineStatusTest.assertMinTimeElapsed(context, false);
        OfflineStatusTest.assertOffline(context, false);
        context.timeService.advance(3001L);
        OfflineStatusTest.assertMinFailureCount(context, 9);
        OfflineStatusTest.assertMinTimeElapsed(context, true);
        OfflineStatusTest.assertOffline(context, false);
        OfflineStatusTest.addCommunicationFailure(context);
        OfflineStatusTest.assertMinTimeElapsed(context, true);
        OfflineStatusTest.assertMinFailureCount(context, 10);
        OfflineStatusTest.assertOffline(context, true);
        context.listener.check(SiteStatus.OFFLINE, new SiteStatus[]{SiteStatus.ONLINE, SiteStatus.OFFLINE});
    }

    public void testFailureBasedOnly() {
        int minFailures = 10;
        TestContext context = OfflineStatusTest.createNew(0L, 10);
        for (int i = 0; i < 9; ++i) {
            OfflineStatusTest.assertOffline(context, false);
            OfflineStatusTest.addCommunicationFailure(context);
        }
        OfflineStatusTest.assertMinFailureCount(context, 9);
        OfflineStatusTest.assertOffline(context, false);
        context.timeService.advance(1L);
        OfflineStatusTest.assertMinFailureCount(context, 9);
        OfflineStatusTest.assertOffline(context, false);
        OfflineStatusTest.addCommunicationFailure(context);
        OfflineStatusTest.assertMinFailureCount(context, 10);
        OfflineStatusTest.assertOffline(context, true);
        context.listener.check(SiteStatus.OFFLINE);
    }

    public void testTimeBasedOnly() {
        long minWaitTime = 3000L;
        int minFailures = 10;
        TestContext context = OfflineStatusTest.createNew(3000L, -1);
        for (int i = 0; i < 10; ++i) {
            OfflineStatusTest.assertOffline(context, false);
            OfflineStatusTest.addCommunicationFailure(context);
        }
        OfflineStatusTest.assertMinFailureCount(context, 10);
        OfflineStatusTest.assertMinTimeElapsed(context, false);
        OfflineStatusTest.assertOffline(context, false);
        context.timeService.advance(3001L);
        OfflineStatusTest.assertMinFailureCount(context, 10);
        OfflineStatusTest.assertMinTimeElapsed(context, true);
        OfflineStatusTest.addCommunicationFailure(context);
        OfflineStatusTest.assertOffline(context, true);
        context.listener.check(SiteStatus.OFFLINE);
    }

    public void testForceOffline() {
        TestContext context = OfflineStatusTest.createNew(-1L, -1);
        OfflineStatusTest.addCommunicationFailure(context);
        context.timeService.advance(1L);
        OfflineStatusTest.assertMinFailureCount(context, 1);
        OfflineStatusTest.assertOffline(context, false);
        context.offlineStatus.forceOffline();
        OfflineStatusTest.assertMinFailureCount(context, 1);
        OfflineStatusTest.assertOffline(context, true);
        context.offlineStatus.bringOnline();
        OfflineStatusTest.assertMinFailureCount(context, 0);
        OfflineStatusTest.assertOffline(context, false);
        OfflineStatusTest.addCommunicationFailure(context);
        context.timeService.advance(1L);
        OfflineStatusTest.assertMinFailureCount(context, 1);
        OfflineStatusTest.assertOffline(context, false);
        context.offlineStatus.forceOffline();
        OfflineStatusTest.assertMinFailureCount(context, 1);
        OfflineStatusTest.assertOffline(context, true);
        context.offlineStatus.reset();
        OfflineStatusTest.assertMinFailureCount(context, 0);
        OfflineStatusTest.assertOffline(context, false);
        context.listener.check(SiteStatus.OFFLINE, new SiteStatus[]{SiteStatus.ONLINE, SiteStatus.OFFLINE, SiteStatus.ONLINE});
    }

    private static void assertOffline(TestContext context, boolean expected) {
        AssertJUnit.assertEquals((String)"Checking offline.", (boolean)expected, (boolean)context.offlineStatus.isOffline());
    }

    private static void assertMinFailureCount(TestContext context, int expected) {
        AssertJUnit.assertEquals((String)"Check failure count.", (int)expected, (int)context.offlineStatus.getFailureCount());
    }

    private static void assertMinTimeElapsed(TestContext context, boolean expected) {
        AssertJUnit.assertEquals((String)String.format("Check min time has elapsed. Current time=%d. Time elapsed=%d", context.timeService.time(), context.offlineStatus.millisSinceFirstFailure()), (boolean)expected, (boolean)context.offlineStatus.minTimeHasElapsed());
    }

    private static void addCommunicationFailure(TestContext context) {
        context.offlineStatus.updateOnCommunicationFailure(context.timeService.wallClockTime());
    }

    private static TestContext createNew(long minWait, int afterFailures) {
        ControlledTimeService t = new ControlledTimeService();
        ListenerImpl l = new ListenerImpl();
        TakeOfflineConfiguration c = new TakeOfflineConfigurationBuilder(null, null).afterFailures(afterFailures).minTimeToWait(minWait).create();
        return new TestContext(new OfflineStatus(c, (TimeService)t, (SiteStatusListener)l), t, l);
    }

    private static enum SiteStatus {
        ONLINE,
        OFFLINE;

    }

    private static class ListenerImpl
    implements SiteStatusListener {
        private final Queue<SiteStatus> notifications = new ConcurrentLinkedDeque<SiteStatus>();

        private ListenerImpl() {
        }

        public void siteOnline() {
            this.notifications.add(SiteStatus.ONLINE);
        }

        public void siteOffline() {
            this.notifications.add(SiteStatus.OFFLINE);
        }

        private void check(SiteStatus first) {
            AssertJUnit.assertEquals((String)"Check first site status.", (Object)((Object)first), (Object)((Object)this.notifications.poll()));
            AssertJUnit.assertTrue((String)"Check notifications is empty.", (boolean)this.notifications.isEmpty());
        }

        private void check(SiteStatus first, SiteStatus ... remaining) {
            AssertJUnit.assertEquals((String)"Check first site status.", (Object)((Object)first), (Object)((Object)this.notifications.poll()));
            int i = 2;
            for (SiteStatus status : remaining) {
                AssertJUnit.assertEquals((String)String.format("Check %d(\"th\") site status", i), (Object)((Object)status), (Object)((Object)this.notifications.poll()));
                ++i;
            }
            AssertJUnit.assertTrue((String)"Check notifications is empty.", (boolean)this.notifications.isEmpty());
        }
    }

    private static class TestContext {
        private final OfflineStatus offlineStatus;
        private final ControlledTimeService timeService;
        private final ListenerImpl listener;

        private TestContext(OfflineStatus offlineStatus, ControlledTimeService timeService, ListenerImpl listener) {
            this.offlineStatus = offlineStatus;
            this.timeService = timeService;
            this.listener = listener;
        }
    }
}

