/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.statetransfer;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.XSiteStateTransferMode;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.TestingUtil;
import org.infinispan.topology.CacheTopology;
import org.infinispan.xsite.statetransfer.StateTransferStatus;
import org.infinispan.xsite.statetransfer.XSiteStateConsumer;
import org.infinispan.xsite.statetransfer.XSiteStateProvider;
import org.infinispan.xsite.statetransfer.XSiteStateTransferManager;

@Scope(value=Scopes.NAMED_CACHE)
public class AbstractDelegatingXSiteStateTransferManager
implements XSiteStateTransferManager {
    private final XSiteStateTransferManager delegate;

    public AbstractDelegatingXSiteStateTransferManager(XSiteStateTransferManager delegate) {
        this.delegate = delegate;
    }

    public static <T extends AbstractDelegatingXSiteStateTransferManager> T wrapCache(Cache<?, ?> cache, Function<XSiteStateTransferManager, T> ctor, Class<T> tClass) {
        XSiteStateTransferManager actual = TestingUtil.extractComponent(cache, XSiteStateTransferManager.class);
        if (actual.getClass().isAssignableFrom(tClass)) {
            return (T)((AbstractDelegatingXSiteStateTransferManager)tClass.cast(actual));
        }
        return (T)((AbstractDelegatingXSiteStateTransferManager)TestingUtil.wrapComponent(cache, XSiteStateTransferManager.class, ctor));
    }

    public static void revertXsiteStateTransferManager(Cache<?, ?> cache) {
        XSiteStateTransferManager manager = TestingUtil.extractComponent(cache, XSiteStateTransferManager.class);
        if (manager instanceof AbstractDelegatingXSiteStateTransferManager) {
            TestingUtil.replaceComponent(cache, XSiteStateTransferManager.class, ((AbstractDelegatingXSiteStateTransferManager)manager).delegate, true);
        }
    }

    public void notifyStatePushFinished(String siteName, Address node, boolean statusOk) {
        this.delegate.notifyStatePushFinished(siteName, node, statusOk);
    }

    public void startPushState(String siteName) throws Throwable {
        this.delegate.startPushState(siteName);
    }

    public void cancelPushState(String siteName) throws Throwable {
        this.delegate.cancelPushState(siteName);
    }

    public List<String> getRunningStateTransfers() {
        return this.delegate.getRunningStateTransfers();
    }

    public Map<String, StateTransferStatus> getStatus() {
        return this.delegate.getStatus();
    }

    public void clearStatus() {
        this.delegate.clearStatus();
    }

    public Map<String, StateTransferStatus> getClusterStatus() {
        return this.delegate.getClusterStatus();
    }

    public void clearClusterStatus() {
        this.delegate.clearClusterStatus();
    }

    public String getSendingSiteName() {
        return this.delegate.getSendingSiteName();
    }

    public void cancelReceive(String siteName) throws Exception {
        this.delegate.cancelReceive(siteName);
    }

    public void becomeCoordinator(String siteName) {
        this.delegate.becomeCoordinator(siteName);
    }

    public void onTopologyUpdated(CacheTopology cacheTopology, boolean stateTransferInProgress) {
        this.delegate.onTopologyUpdated(cacheTopology, stateTransferInProgress);
    }

    public XSiteStateProvider getStateProvider() {
        return this.delegate.getStateProvider();
    }

    public XSiteStateConsumer getStateConsumer() {
        return this.delegate.getStateConsumer();
    }

    public void startAutomaticStateTransfer(Collection<String> sites) {
        this.delegate.startAutomaticStateTransfer(sites);
    }

    public XSiteStateTransferMode stateTransferMode(String site) {
        return this.delegate.stateTransferMode(site);
    }

    public boolean setAutomaticStateTransfer(String site, XSiteStateTransferMode mode) {
        return this.delegate.setAutomaticStateTransfer(site, mode);
    }
}

