/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.statetransfer;

import java.util.Collection;
import org.infinispan.Cache;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.statetransfer.AbstractDelegatingXSiteStateTransferManager;
import org.infinispan.xsite.statetransfer.SiteUpEvent;
import org.infinispan.xsite.statetransfer.XSiteStateTransferManager;

class ControlledXSiteStateTransferManager
extends AbstractDelegatingXSiteStateTransferManager {
    private static final Log log = LogFactory.getLog(ControlledXSiteStateTransferManager.class);
    private SiteUpEvent event;

    private ControlledXSiteStateTransferManager(XSiteStateTransferManager delegate) {
        super(delegate);
    }

    public static ControlledXSiteStateTransferManager extract(Cache<?, ?> cache) {
        return AbstractDelegatingXSiteStateTransferManager.wrapCache(cache, ControlledXSiteStateTransferManager::new, ControlledXSiteStateTransferManager.class);
    }

    @Override
    public void startAutomaticStateTransfer(Collection<String> sites) {
        SiteUpEvent event = this.getEvent();
        if (event != null) {
            log.tracef("Blocking automatic state transfer with sites %s", sites);
            event.receive(sites, () -> {
                log.tracef("Resuming automatic state transfer with sites %s", (Object)sites);
                super.startAutomaticStateTransfer(sites);
            });
        } else {
            super.startAutomaticStateTransfer(sites);
        }
    }

    public synchronized SiteUpEvent blockSiteUpEvent() {
        assert (this.event == null);
        this.event = new SiteUpEvent();
        return this.event;
    }

    private synchronized SiteUpEvent getEvent() {
        SiteUpEvent event = this.event;
        this.event = null;
        return event;
    }
}

