/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.statetransfer;

import java.util.Collection;
import org.testng.AssertJUnit;

public class SiteUpEvent {
    private static final long TIMEOUT_MILLIS = 30000L;
    private Collection<String> sites;
    private Runnable runnable;

    public synchronized void receive(Collection<String> sites, Runnable runnable) {
        assert (this.runnable == null);
        assert (this.sites == null);
        this.sites = sites;
        this.runnable = runnable;
        this.notifyAll();
    }

    public synchronized Collection<String> waitForEvent() throws InterruptedException {
        long waitMillis;
        long endMillis = System.currentTimeMillis() + 30000L;
        while (this.sites == null && (waitMillis = this.timeLeft(endMillis)) > 0L) {
            this.wait(waitMillis);
        }
        Collection<String> sites = this.sites;
        this.sites = null;
        AssertJUnit.assertNotNull(sites);
        return sites;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void continueRunnable() {
        Runnable runnable;
        SiteUpEvent siteUpEvent = this;
        synchronized (siteUpEvent) {
            runnable = this.runnable;
            this.runnable = null;
        }
        if (runnable != null) {
            runnable.run();
        }
    }

    private long timeLeft(long endMillis) {
        return endMillis - System.currentTimeMillis();
    }
}

