/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.statetransfer.failures;

import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.BackupConfigurationBuilder;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distribution.DistributionTestHelper;
import org.infinispan.statetransfer.StateConsumer;
import org.infinispan.statetransfer.StateProvider;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.xsite.statetransfer.AbstractStateTransferTest;
import org.infinispan.xsite.statetransfer.XSiteStateProvider;
import org.testng.AssertJUnit;

public abstract class AbstractTopologyChangeTest
extends AbstractStateTransferTest {
    private static final int NR_KEYS = 20;

    AbstractTopologyChangeTest() {
        this.implicitBackupCache = true;
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
        this.initialClusterSize = 3;
    }

    private static ConfigurationBuilder createConfiguration() {
        ConfigurationBuilder builder = AbstractTopologyChangeTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, false);
        builder.clustering().hash().numOwners(2);
        return builder;
    }

    void awaitLocalStateTransfer(String site) {
        log.debugf("Await until rebalance in site '%s' is finished!", (Object)site);
        this.assertEventuallyInSite(site, cache -> !TestingUtil.extractComponent(cache, StateConsumer.class).isStateTransferInProgress() && !TestingUtil.extractComponent(cache, StateProvider.class).isStateTransferInProgress(), 30L, TimeUnit.SECONDS);
    }

    void awaitXSiteStateSent(String site) {
        log.debugf("Await until all nodes in '%s' has sent the state!", (Object)site);
        this.assertEventuallyInSite(site, cache -> TestingUtil.extractComponent(cache, XSiteStateProvider.class).getCurrentStateSending().isEmpty(), 30L, TimeUnit.SECONDS);
    }

    Future<Void> triggerTopologyChange(String siteName, int removeIndex) {
        if (removeIndex >= 0) {
            return this.fork(() -> {
                log.debugf("Shutting down cache %s", (Object)DistributionTestHelper.addressOf(this.cache(siteName, removeIndex)));
                this.site(siteName).kill(removeIndex);
                log.debugf("Wait for cluster to form on caches %s", this.site(siteName).getCaches(null));
                this.site(siteName).waitForClusterToForm(null, 60L, TimeUnit.SECONDS);
                return null;
            });
        }
        log.debug((Object)"Adding new cache");
        this.site(siteName).addCache(this.globalConfigurationBuilderForSite(siteName), this.lonConfigurationBuilder());
        return this.fork(() -> {
            log.debugf("Wait for cluster to form on caches %s", this.site(siteName).getCaches(null));
            this.site(siteName).waitForClusterToForm(null, 60L, TimeUnit.SECONDS);
            return null;
        });
    }

    void initBeforeTest() {
        this.takeSiteOffline();
        this.assertOffline();
        this.putData();
        this.assertDataInSite("LON-1");
        this.assertInSite("NYC-2", cache -> AssertJUnit.assertTrue((boolean)cache.isEmpty()));
    }

    void assertData() {
        this.assertDataInSite("LON-1");
        this.assertDataInSite("NYC-2");
    }

    void assertDataInSite(String siteName) {
        this.assertInSite(siteName, cache -> {
            for (int i = 0; i < 20; ++i) {
                AssertJUnit.assertEquals((Object)this.val(Integer.toString(i)), (Object)cache.get((Object)this.key(Integer.toString(i))));
            }
        });
    }

    void assertXSiteErrorStatus() {
        AssertJUnit.assertEquals((String)"ERROR", (String)this.getXSitePushStatus());
    }

    String getXSitePushStatus() {
        return (String)this.adminOperations().getPushStateStatus().get("NYC-2");
    }

    <K, V> TestCaches<K, V> createTestCache(TopologyEvent topologyEvent, String siteName) {
        switch (topologyEvent) {
            case JOIN: {
                return new TestCaches(this.cache("LON-1", 0), this.cache(siteName, 0), -1);
            }
            case COORDINATOR_LEAVE: {
                return new TestCaches(this.cache("LON-1", 1), this.cache(siteName, 0), 1);
            }
            case LEAVE: {
                return new TestCaches(this.cache("LON-1", 0), this.cache(siteName, 0), 1);
            }
            case SITE_MASTER_LEAVE: {
                return new TestCaches(this.cache("LON-1", 1), this.cache(siteName, 1), 0);
            }
        }
        throw new IllegalStateException();
    }

    void printTestCaches(TestCaches<?, ?> testCaches) {
        log.debugf("Controlled cache=%s, Coordinator cache=%s, Cache to remove=%s", (Object)DistributionTestHelper.addressOf(testCaches.controllerCache), (Object)DistributionTestHelper.addressOf(testCaches.coordinator), (Object)(testCaches.removeIndex < 0 ? "NONE" : DistributionTestHelper.addressOf(this.cache("LON-1", testCaches.removeIndex))));
    }

    @Override
    protected void adaptLONConfiguration(BackupConfigurationBuilder builder) {
        builder.stateTransfer().chunkSize(2).timeout(2000L);
    }

    @Override
    protected ConfigurationBuilder getNycActiveConfig() {
        return AbstractTopologyChangeTest.createConfiguration();
    }

    @Override
    protected ConfigurationBuilder getLonActiveConfig() {
        return AbstractTopologyChangeTest.createConfiguration();
    }

    private void putData() {
        for (int i = 0; i < 20; ++i) {
            this.cache("LON-1", 0).put((Object)this.key(Integer.toString(i)), (Object)this.val(Integer.toString(i)));
        }
    }

    protected static class TestCaches<K, V> {
        public final Cache<K, V> coordinator;
        final Cache<K, V> controllerCache;
        final int removeIndex;

        TestCaches(Cache<K, V> coordinator, Cache<K, V> controllerCache, int removeIndex) {
            this.coordinator = coordinator;
            this.controllerCache = controllerCache;
            this.removeIndex = removeIndex;
        }
    }

    protected static enum TopologyEvent {
        JOIN,
        LEAVE,
        SITE_MASTER_LEAVE,
        COORDINATOR_LEAVE;

    }
}

