/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.statetransfer.failures;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.infinispan.configuration.cache.BackupConfigurationBuilder;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.Flag;
import org.infinispan.manager.CacheContainer;
import org.infinispan.remoting.transport.AbstractDelegatingTransport;
import org.infinispan.remoting.transport.BackupResponse;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.XSiteResponse;
import org.infinispan.remoting.transport.impl.XSiteResponseImpl;
import org.infinispan.statetransfer.CommitManager;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.concurrent.TimeoutException;
import org.infinispan.xsite.XSiteAdminOperations;
import org.infinispan.xsite.XSiteBackup;
import org.infinispan.xsite.XSiteReplicateCommand;
import org.infinispan.xsite.statetransfer.XSiteStatePushCommand;
import org.infinispan.xsite.statetransfer.XSiteStateTransferManager;
import org.infinispan.xsite.statetransfer.failures.AbstractTopologyChangeTest;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"xsite"}, testName="xsite.statetransfer.failures.StateTransferLinkFailuresTest")
public class StateTransferLinkFailuresTest
extends AbstractTopologyChangeTest {
    public StateTransferLinkFailuresTest() {
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
        this.implicitBackupCache = true;
    }

    private static ConfigurationBuilder createConfiguration() {
        ConfigurationBuilder builder = StateTransferLinkFailuresTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, false);
        builder.clustering().hash().numOwners(2);
        return builder;
    }

    public void testStartStateTransferWithoutLink() {
        this.initBeforeTest();
        List<ControllerTransport> transports = this.replaceTransportInSite();
        for (ControllerTransport transport : transports) {
            transport.fail = true;
        }
        Assert.assertNotEquals((Object)TestingUtil.extractComponent(this.cache("LON-1", 0), XSiteAdminOperations.class).pushState("NYC-2"), (Object)"ok");
        this.assertDataInSite("LON-1");
        this.assertInSite("NYC-2", cache -> AssertJUnit.assertTrue((boolean)cache.isEmpty()));
    }

    public void testLinkBrokenDuringStateTransfer() {
        this.initBeforeTest();
        List<ControllerTransport> transports = this.replaceTransportInSite();
        for (ControllerTransport transport : transports) {
            transport.failAfterFirstChunk = true;
        }
        this.startStateTransfer();
        this.assertOnline("LON-1", "NYC-2");
        this.assertEventuallyInSite("LON-1", cache -> TestingUtil.extractComponent(cache, XSiteStateTransferManager.class).getRunningStateTransfers().isEmpty(), 1L, TimeUnit.MINUTES);
        AssertJUnit.assertEquals((int)1, (int)this.getStatus().size());
        AssertJUnit.assertEquals((String)"ERROR", (String)this.getStatus().get("NYC-2"));
        this.assertInSite("NYC-2", cache -> {
            AssertJUnit.assertTrue((boolean)TestingUtil.extractComponent(cache, CommitManager.class).isTracking(Flag.PUT_FOR_X_SITE_STATE_TRANSFER));
            AssertJUnit.assertEquals((String)"LON-1", (String)TestingUtil.extractComponent(cache, XSiteAdminOperations.class).getSendingSiteName());
        });
        AssertJUnit.assertEquals((String)"ok", (String)TestingUtil.extractComponent(this.cache("NYC-2", 0), XSiteAdminOperations.class).cancelReceiveState("LON-1"));
        this.assertInSite("NYC-2", cache -> {
            AssertJUnit.assertFalse((boolean)TestingUtil.extractComponent(cache, CommitManager.class).isTracking(Flag.PUT_FOR_X_SITE_STATE_TRANSFER));
            AssertJUnit.assertNull((Object)TestingUtil.extractComponent(cache, XSiteAdminOperations.class).getSendingSiteName());
        });
        AssertJUnit.assertEquals((String)"ok", (String)TestingUtil.extractComponent(this.cache("LON-1", 0), XSiteAdminOperations.class).clearPushStateStatus());
    }

    @Override
    protected ConfigurationBuilder getNycActiveConfig() {
        return StateTransferLinkFailuresTest.createConfiguration();
    }

    @Override
    protected ConfigurationBuilder getLonActiveConfig() {
        return StateTransferLinkFailuresTest.createConfiguration();
    }

    @Override
    protected void adaptLONConfiguration(BackupConfigurationBuilder builder) {
        builder.stateTransfer().chunkSize(2).timeout(2000L).maxRetries(1);
    }

    private Map<String, String> getStatus() {
        return this.adminOperations().getPushStateStatus();
    }

    private List<ControllerTransport> replaceTransportInSite() {
        ArrayList<ControllerTransport> transports = new ArrayList<ControllerTransport>(this.site("LON-1").cacheManagers().size());
        for (CacheContainer cacheContainer : this.site("LON-1").cacheManagers()) {
            transports.add(TestingUtil.wrapGlobalComponent(cacheContainer, Transport.class, (wrapOn, current) -> new ControllerTransport((Transport)current), true));
        }
        return transports;
    }

    static class ControllerTransport
    extends AbstractDelegatingTransport {
        private volatile boolean fail;
        private volatile boolean failAfterFirstChunk;

        ControllerTransport(Transport actual) {
            super(actual);
        }

        public void start() {
        }

        public BackupResponse backupRemotely(Collection<XSiteBackup> backups, XSiteReplicateCommand rpcCommand) {
            throw new UnsupportedOperationException();
        }

        public <O> XSiteResponse<O> backupRemotely(XSiteBackup backup, XSiteReplicateCommand<O> rpcCommand) {
            if (this.fail) {
                this.getLog().debugf("Inducing timeout for %s", rpcCommand);
                XSiteResponseImpl rsp = new XSiteResponseImpl(AbstractInfinispanTest.TIME_SERVICE, backup);
                rsp.completeExceptionally((Throwable)new TimeoutException("induced timeout!"));
                return rsp;
            }
            if (this.failAfterFirstChunk && rpcCommand instanceof XSiteStatePushCommand) {
                this.fail = true;
            }
            return super.backupRemotely(backup, rpcCommand);
        }
    }
}

