/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.global.AbstractGlobalConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.JGroupsProtocolConfiguration;
import org.infinispan.configuration.global.JGroupsProtocolConfigurationBuilder;
import org.infinispan.configuration.global.StackBuilder;
import org.infinispan.configuration.global.StackConfiguration;
import org.infinispan.remoting.transport.jgroups.EmbeddedJGroupsChannelConfigurator;
import org.infinispan.remoting.transport.jgroups.JGroupsChannelConfigurator;
import org.jgroups.conf.ProtocolConfiguration;

public class StackConfigurationBuilder
extends AbstractGlobalConfigurationBuilder
implements StackBuilder<StackConfiguration> {
    private final AttributeSet attributes;
    private List<JGroupsProtocolConfigurationBuilder> protocols = new ArrayList<JGroupsProtocolConfigurationBuilder>();
    private EmbeddedJGroupsChannelConfigurator configurator;

    StackConfigurationBuilder(String name, GlobalConfigurationBuilder globalConfig) {
        super(globalConfig);
        this.attributes = StackConfiguration.attributeDefinitionSet();
        this.attributes.attribute(StackConfiguration.NAME).set((Object)name);
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public JGroupsProtocolConfigurationBuilder newProtocol() {
        JGroupsProtocolConfigurationBuilder protocolConfigurationBuilder = new JGroupsProtocolConfigurationBuilder(this.getGlobalConfig());
        this.protocols.add(protocolConfigurationBuilder);
        return protocolConfigurationBuilder;
    }

    public StackConfigurationBuilder channelConfigurator(EmbeddedJGroupsChannelConfigurator configurator) {
        this.configurator = configurator;
        this.attributes.attribute(StackConfiguration.NAME).set((Object)configurator.getName());
        configurator.getProtocolStack().forEach(protocolConfiguration -> {
            JGroupsProtocolConfigurationBuilder protocol = this.newProtocol();
            protocol.protocolConfig((ProtocolConfiguration)protocolConfiguration);
        });
        return this;
    }

    public StackConfiguration create() {
        List<JGroupsProtocolConfiguration> protocolConfigurations = this.protocols.stream().map(JGroupsProtocolConfigurationBuilder::create).collect(Collectors.toList());
        return new StackConfiguration(this.attributes.protect(), protocolConfigurations);
    }

    public StackConfigurationBuilder read(StackConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }

    @Override
    public JGroupsChannelConfigurator getConfigurator(String stackName) {
        return this.configurator;
    }
}

