package org.infinispan.persistence.sifs;

import java.util.Locale;
import java.io.Serializable;
import javax.annotation.processing.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.infinispan.commons.CacheConfigurationException;
import java.io.IOException;
import java.lang.String;
import org.jboss.logging.Logger;
import java.lang.InterruptedException;
import java.lang.Exception;
import org.jboss.logging.BasicLogger;
import org.infinispan.persistence.spi.PersistenceException;
import java.lang.Throwable;
import org.infinispan.persistence.sifs.EntryHeader;
import java.lang.Object;
import java.util.Arrays;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2023-10-11T10:16:30-0400")
public class Log_$logger extends DelegatingBasicLogger implements Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String maxNodeSizeLimitedToShort$str() {
        return "ISPN029001: Max size of index node (%d) is limited to 32767 bytes.";
    }
    @Override
    public final CacheConfigurationException maxNodeSizeLimitedToShort(final int maxNodeSize) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), maxNodeSizeLimitedToShort$str(), maxNodeSize));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String minNodeSizeMustBeLessOrEqualToMax$str() {
        return "ISPN029002: Min size of index node (%d) must be less or equal to max size (%d).";
    }
    @Override
    public final CacheConfigurationException minNodeSizeMustBeLessOrEqualToMax(final int minNodeSize, final int maxNodeSize) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), minNodeSizeMustBeLessOrEqualToMax$str(), minNodeSize, maxNodeSize));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String sizeCalculationInterrupted$str() {
        return "ISPN029003: Calculation of size has been interrupted.";
    }
    @Override
    public final PersistenceException sizeCalculationInterrupted(final InterruptedException e) {
        final PersistenceException result = new PersistenceException(String.format(getLoggingLocale(), sizeCalculationInterrupted$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void cannotTruncateIndex(final IOException e) {
        super.log.logf(FQCN, WARN, e, cannotTruncateIndex$str());
    }
    protected String cannotTruncateIndex$str() {
        return "ISPN029006: Cannot truncate index";
    }
    @Override
    public final void errorInIndexUpdater(final Throwable e) {
        super.log.logf(FQCN, ERROR, e, errorInIndexUpdater$str());
    }
    protected String errorInIndexUpdater$str() {
        return "ISPN029007: Unexpected error in index updater thread.";
    }
    @Override
    public final void failedToCloseIndex(final IOException e) {
        super.log.logf(FQCN, ERROR, e, failedToCloseIndex$str());
    }
    protected String failedToCloseIndex$str() {
        return "ISPN029008: Failed to close the index file.";
    }
    @Override
    public final void compactorFailed(final Throwable e) {
        super.log.logf(FQCN, ERROR, e, compactorFailed$str());
    }
    protected String compactorFailed$str() {
        return "ISPN029009: Unexpected error in data compactor.";
    }
    @Override
    public final void cannotCloseDeleteFile(final int fileId, final IOException e) {
        super.log.logf(FQCN, ERROR, e, cannotCloseDeleteFile$str(), fileId);
    }
    protected String cannotCloseDeleteFile$str() {
        return "ISPN290010: Cannot close/delete data file %d.";
    }
    @Override
    public final void cannotCloseFile(final IOException e) {
        super.log.logf(FQCN, ERROR, e, cannotCloseFile$str());
    }
    protected String cannotCloseFile$str() {
        return "ISPN029011: Cannot close data file.";
    }
    protected String invalidCompactionThreshold$str() {
        return "ISPN029012: Compaction threshold (%f) should be between 0 (exclusively) and 1 (inclusively).";
    }
    @Override
    public final CacheConfigurationException invalidCompactionThreshold(final double value) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), invalidCompactionThreshold$str(), value));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotOpenIndex$str() {
        return "ISPN029013: Cannot open index on %s";
    }
    @Override
    public final PersistenceException cannotOpenIndex(final String location, final IOException e) {
        final PersistenceException result = new PersistenceException(String.format(getLoggingLocale(), cannotOpenIndex$str(), location), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String interruptedWhileStopping$str() {
        return "ISPN029014: Interrupted while stopping the store";
    }
    @Override
    public final PersistenceException interruptedWhileStopping(final InterruptedException e) {
        final PersistenceException result = new PersistenceException(String.format(getLoggingLocale(), interruptedWhileStopping$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String interruptedWhileClearing$str() {
        return "ISPN029015: Interrupted while pausing the index for clear.";
    }
    @Override
    public final PersistenceException interruptedWhileClearing(final InterruptedException e) {
        final PersistenceException result = new PersistenceException(String.format(getLoggingLocale(), interruptedWhileClearing$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotClearIndex$str() {
        return "ISPN029016: Cannot clear/reopen index.";
    }
    @Override
    public final PersistenceException cannotClearIndex(final IOException e) {
        final PersistenceException result = new PersistenceException(String.format(getLoggingLocale(), cannotClearIndex$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotClearData$str() {
        return "ISPN029017: Cannot clear data directory.";
    }
    @Override
    public final PersistenceException cannotClearData(final IOException e) {
        final PersistenceException result = new PersistenceException(String.format(getLoggingLocale(), cannotClearData$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String keyIsTooLong$str() {
        return "ISPN029018: The serialized form of key %s is too long (%d); with maxNodeSize=%d bytes you can use only keys serialized to at most %d bytes.";
    }
    @Override
    public final PersistenceException keyIsTooLong(final Object key, final int keyLength, final int maxNodeSize, final int maxKeyLength) {
        final PersistenceException result = new PersistenceException(String.format(getLoggingLocale(), keyIsTooLong$str(), key, keyLength, maxNodeSize, maxKeyLength));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotLoadKeyFromIndex$str() {
        return "ISPN029019: Cannot load key %s from index.";
    }
    @Override
    public final PersistenceException cannotLoadKeyFromIndex(final Object key, final Exception e) {
        final PersistenceException result = new PersistenceException(String.format(getLoggingLocale(), cannotLoadKeyFromIndex$str(), key), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String indexLooksCorrupt$str() {
        return "ISPN029020: Index looks corrupt.";
    }
    @Override
    public final PersistenceException indexLooksCorrupt(final Exception e) {
        final PersistenceException result = new PersistenceException(String.format(getLoggingLocale(), indexLooksCorrupt$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void compactorEncounteredException(final Throwable t, final int fileId) {
        super.log.logf(FQCN, ERROR, t, compactorEncounteredException$str(), fileId);
    }
    protected String compactorEncounteredException$str() {
        return "ISPN029021: File id %s encountered an exception while compacting, file may be orphaned";
    }
    @Override
    public final void compactedFileNotLongEnough(final byte[] key, final int file, final long offset, final long fileSize, final org.infinispan.persistence.sifs.EntryHeader record) {
        super.log.logf(FQCN, WARN, null, compactedFileNotLongEnough$str(), Arrays.toString(key), file, offset, fileSize, record);
    }
    protected String compactedFileNotLongEnough$str() {
        return "ISPN029022: Compaction skipping a corrupted entry for key %s, at %s:%s|%s that doesn't have enough bytes for header %s";
    }
}
