/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.security.impl;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.security.auth.Subject;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.infinispan.AdvancedCache;
import org.infinispan.CacheCollection;
import org.infinispan.CacheSet;
import org.infinispan.LockedStream;
import org.infinispan.batch.BatchContainer;
import org.infinispan.commons.dataconversion.Encoder;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.Wrapper;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.encoding.DataConversion;
import org.infinispan.eviction.EvictionManager;
import org.infinispan.expiration.ExpirationManager;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.cachelistener.filter.CacheEventConverter;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.security.AuthorizationManager;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.SecureCache;
import org.infinispan.stats.Stats;
import org.infinispan.util.concurrent.locks.LockManager;

public final class SecureCacheImpl<K, V>
implements SecureCache<K, V> {
    private final AuthorizationManager authzManager;
    private final AdvancedCache<K, V> delegate;
    private final Subject subject;
    private final AuthorizationPermission writePermission;

    public SecureCacheImpl(AdvancedCache<K, V> delegate) {
        this(delegate, delegate.getAuthorizationManager(), null);
    }

    private SecureCacheImpl(AdvancedCache<K, V> delegate, AuthorizationManager authzManager, Subject subject) {
        this.authzManager = authzManager;
        this.delegate = delegate;
        this.subject = subject;
        this.writePermission = authzManager.getWritePermission();
    }

    public AdvancedCache<K, V> getDelegate() {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.ADMIN);
        return this.delegate;
    }

    @Override
    public AdvancedCache<K, V> withSubject(Subject subject) {
        if (this.subject == null) {
            return new SecureCacheImpl<K, V>(this.delegate, this.authzManager, subject);
        }
        throw new IllegalArgumentException("Cannot set a Subject on a SecureCache more than once");
    }

    public boolean startBatch() {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return this.delegate.startBatch();
    }

    @Override
    public <C> CompletionStage<Void> addListenerAsync(Object listener, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, C> converter) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.LISTEN);
        return this.delegate.addListenerAsync(listener, filter, converter);
    }

    @Override
    public CompletionStage<Void> addListenerAsync(Object listener) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.LISTEN);
        return this.delegate.addListenerAsync(listener);
    }

    @Override
    public <C> CompletionStage<Void> addFilteredListenerAsync(Object listener, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, C> converter, Set<Class<? extends Annotation>> filterAnnotations) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.LISTEN);
        return this.delegate.addFilteredListenerAsync(listener, filter, converter, filterAnnotations);
    }

    @Override
    public <C> CompletionStage<Void> addStorageFormatFilteredListenerAsync(Object listener, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, C> converter, Set<Class<? extends Annotation>> filterAnnotations) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.LISTEN);
        return this.delegate.addStorageFormatFilteredListenerAsync(listener, filter, converter, filterAnnotations);
    }

    @Override
    public void shutdown() {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.LIFECYCLE);
        this.delegate.shutdown();
    }

    public void start() {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.LIFECYCLE);
        this.delegate.start();
    }

    @Override
    public void stop() {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.LIFECYCLE);
        this.delegate.stop();
    }

    public CompletableFuture<V> putAsync(K key, V value) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return this.delegate.putAsync(key, value);
    }

    public void endBatch(boolean successful) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        this.delegate.endBatch(successful);
    }

    @Override
    public CompletionStage<Void> removeListenerAsync(Object listener) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.LISTEN);
        return this.delegate.removeListenerAsync(listener);
    }

    @Override
    @Deprecated
    public Set<Object> getListeners() {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.LISTEN);
        return this.delegate.getListeners();
    }

    public CompletableFuture<V> putAsync(K key, V value, long lifespan, TimeUnit unit) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return this.delegate.putAsync(key, value, lifespan, unit);
    }

    @Override
    public AdvancedCache<K, V> withFlags(Flag ... flags) {
        return new SecureCacheImpl<K, V>(this.delegate.withFlags(flags), this.authzManager, this.subject);
    }

    @Override
    public AdvancedCache<K, V> withFlags(Collection<Flag> flags) {
        return new SecureCacheImpl<K, V>(this.delegate.withFlags(flags), this.authzManager, this.subject);
    }

    @Override
    public AdvancedCache<K, V> noFlags() {
        return new SecureCacheImpl<K, V>(this.delegate.noFlags(), this.authzManager, this.subject);
    }

    @Override
    public AdvancedCache<K, V> transform(Function<AdvancedCache<K, V>, ? extends AdvancedCache<K, V>> transformation) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.ADMIN);
        AdvancedCache<K, V> newDelegate = this.delegate.transform(transformation);
        SecureCacheImpl<K, V> newInstance = newDelegate != this.delegate ? new SecureCacheImpl<K, V>(newDelegate, this.authzManager, this.subject) : this;
        return transformation.apply(newInstance);
    }

    public V putIfAbsent(K key, V value) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return (V)this.delegate.putIfAbsent(key, value);
    }

    public CompletableFuture<V> putAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return this.delegate.putAsync(key, value, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    public String getName() {
        return this.delegate.getName();
    }

    public String getVersion() {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.ADMIN);
        return this.delegate.getVersion();
    }

    public V put(K key, V value) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return (V)this.delegate.put(key, value);
    }

    public CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> data) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return this.delegate.putAllAsync(data);
    }

    public V put(K key, V value, long lifespan, TimeUnit unit) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return (V)this.delegate.put(key, value, lifespan, unit);
    }

    public boolean remove(Object key, Object value) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return this.delegate.remove(key, value);
    }

    public CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> data, long lifespan, TimeUnit unit) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return this.delegate.putAllAsync(data, lifespan, unit);
    }

    @Override
    @Deprecated
    public AsyncInterceptorChain getAsyncInterceptorChain() {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.ADMIN);
        return this.delegate.getAsyncInterceptorChain();
    }

    public V putIfAbsent(K key, V value, long lifespan, TimeUnit unit) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return (V)this.delegate.putIfAbsent(key, value, lifespan, unit);
    }

    public CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> data, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return this.delegate.putAllAsync(data, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    public void putAll(Map<? extends K, ? extends V> map, long lifespan, TimeUnit unit) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        this.delegate.putAll(map, lifespan, unit);
    }

    public boolean replace(K key, V oldValue, V newValue) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return this.delegate.replace(key, oldValue, newValue);
    }

    public CompletableFuture<Void> clearAsync() {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.BULK_WRITE);
        return this.delegate.clearAsync();
    }

    public V replace(K key, V value, long lifespan, TimeUnit unit) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return (V)this.delegate.replace(key, value, lifespan, unit);
    }

    public CompletableFuture<V> putIfAbsentAsync(K key, V value) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return this.delegate.putIfAbsentAsync(key, value);
    }

    public boolean replace(K key, V oldValue, V value, long lifespan, TimeUnit unit) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return this.delegate.replace(key, oldValue, value, lifespan, unit);
    }

    public CompletableFuture<V> putIfAbsentAsync(K key, V value, long lifespan, TimeUnit unit) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return this.delegate.putIfAbsentAsync(key, value, lifespan, unit);
    }

    public V replace(K key, V value) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return (V)this.delegate.replace(key, value);
    }

    @Override
    public EvictionManager getEvictionManager() {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.ADMIN);
        return this.delegate.getEvictionManager();
    }

    @Override
    public ExpirationManager<K, V> getExpirationManager() {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.ADMIN);
        return this.delegate.getExpirationManager();
    }

    public V put(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return (V)this.delegate.put(key, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    @Override
    public void putForExternalRead(K key, V value) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        this.delegate.putForExternalRead(key, value);
    }

    @Override
    public void putForExternalRead(K key, V value, Metadata metadata) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        this.delegate.putForExternalRead(key, value);
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return this.delegate.compute((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return this.delegate.merge(key, (V)value, (BiFunction<? extends V, ? extends V, ? extends V>)remappingFunction);
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return (V)this.delegate.merge(key, value, remappingFunction, lifespan, lifespanUnit);
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return (V)this.delegate.merge(key, value, remappingFunction, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, Metadata metadata) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return this.delegate.merge(key, (V)value, (BiFunction<? extends V, ? extends V, ? extends V>)remappingFunction, metadata);
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, Metadata metadata) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return this.delegate.compute((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction, metadata);
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return (V)this.delegate.compute(key, remappingFunction, lifespan, lifespanUnit);
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return (V)this.delegate.compute(key, remappingFunction, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return this.delegate.computeIfPresent((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, Metadata metadata) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return this.delegate.computeIfPresent((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction, metadata);
    }

    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return (V)this.delegate.computeIfPresent(key, remappingFunction, lifespan, lifespanUnit);
    }

    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return (V)this.delegate.computeIfPresent(key, remappingFunction, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return this.delegate.computeIfAbsent((K)key, mappingFunction);
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction, Metadata metadata) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return this.delegate.computeIfAbsent((K)key, mappingFunction, metadata);
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction, long lifespan, TimeUnit lifespanUnit) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return (V)this.delegate.computeIfAbsent(key, mappingFunction, lifespan, lifespanUnit);
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return (V)this.delegate.computeIfAbsent(key, mappingFunction, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    @Override
    public CompletableFuture<V> computeAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, Metadata metadata) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return this.delegate.computeAsync((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction, metadata);
    }

    @Override
    public CompletableFuture<V> computeIfPresentAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, Metadata metadata) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return this.delegate.computeIfPresentAsync((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction, metadata);
    }

    @Override
    public CompletableFuture<V> computeIfAbsentAsync(K key, Function<? super K, ? extends V> mappingFunction, Metadata metadata) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return this.delegate.computeIfAbsentAsync((K)key, mappingFunction, metadata);
    }

    @Override
    public CompletableFuture<V> mergeAsync(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return this.delegate.mergeAsync(key, value, remappingFunction, lifespan, lifespanUnit);
    }

    @Override
    public CompletableFuture<V> mergeAsync(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return this.delegate.mergeAsync(key, value, remappingFunction, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    @Override
    public CompletableFuture<V> mergeAsync(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, Metadata metadata) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return this.delegate.mergeAsync(key, (V)value, (BiFunction<? extends V, ? extends V, ? extends V>)remappingFunction, metadata);
    }

    @Override
    public CompletableFuture<V> computeAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return this.delegate.computeAsync(key, remappingFunction);
    }

    @Override
    public CompletableFuture<V> computeAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return this.delegate.computeAsync(key, remappingFunction, lifespan, lifespanUnit);
    }

    @Override
    public CompletableFuture<V> computeAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return this.delegate.computeAsync(key, remappingFunction, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    @Override
    public CompletableFuture<V> computeIfAbsentAsync(K key, Function<? super K, ? extends V> mappingFunction) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return this.delegate.computeIfAbsentAsync(key, mappingFunction);
    }

    @Override
    public CompletableFuture<V> computeIfAbsentAsync(K key, Function<? super K, ? extends V> mappingFunction, long lifespan, TimeUnit lifespanUnit) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return this.delegate.computeIfAbsentAsync(key, mappingFunction, lifespan, lifespanUnit);
    }

    @Override
    public CompletableFuture<V> computeIfAbsentAsync(K key, Function<? super K, ? extends V> mappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return this.delegate.computeIfAbsentAsync(key, mappingFunction, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    @Override
    public CompletableFuture<V> computeIfPresentAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return this.delegate.computeIfPresentAsync(key, remappingFunction);
    }

    public CompletableFuture<V> computeIfPresentAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return this.delegate.computeIfPresentAsync(key, remappingFunction, lifespan, lifespanUnit);
    }

    public CompletableFuture<V> computeIfPresentAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return this.delegate.computeIfPresentAsync(key, remappingFunction, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    @Override
    public CompletableFuture<V> mergeAsync(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return this.delegate.mergeAsync(key, value, remappingFunction);
    }

    @Override
    public void putForExternalRead(K key, V value, long lifespan, TimeUnit unit) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        this.delegate.putForExternalRead(key, value);
    }

    @Override
    public void putForExternalRead(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        this.delegate.putForExternalRead(key, value);
    }

    @Override
    public ComponentRegistry getComponentRegistry() {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.ADMIN);
        return this.delegate.getComponentRegistry();
    }

    @Override
    public DistributionManager getDistributionManager() {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.ADMIN);
        return this.delegate.getDistributionManager();
    }

    @Override
    public AuthorizationManager getAuthorizationManager() {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.ADMIN);
        return new AuthorizationManager(){

            @Override
            public void checkPermission(AuthorizationPermission permission) {
                SecureCacheImpl.this.authzManager.checkPermission(SecureCacheImpl.this.subject, permission);
            }

            @Override
            public void checkPermission(Subject subject, AuthorizationPermission permission) {
                SecureCacheImpl.this.authzManager.checkPermission(subject, permission);
            }

            @Override
            public void checkPermission(AuthorizationPermission permission, String role) {
                SecureCacheImpl.this.authzManager.checkPermission(SecureCacheImpl.this.subject, permission, role);
            }

            @Override
            public void checkPermission(Subject subject, AuthorizationPermission permission, String role) {
                SecureCacheImpl.this.authzManager.checkPermission(subject, permission, role);
            }

            @Override
            public EnumSet<AuthorizationPermission> getPermissions(Subject subject) {
                return SecureCacheImpl.this.authzManager.getPermissions(subject);
            }

            @Override
            public AuthorizationPermission getWritePermission() {
                return SecureCacheImpl.this.authzManager.getWritePermission();
            }

            @Override
            public void doIf(Subject subject, AuthorizationPermission permission, Runnable runnable) {
                SecureCacheImpl.this.authzManager.doIf(subject, permission, runnable);
            }

            @Override
            public boolean isPermissive() {
                return SecureCacheImpl.this.authzManager.isPermissive();
            }
        };
    }

    @Override
    public AdvancedCache<K, V> lockAs(Object lockOwner) {
        return new SecureCacheImpl<K, V>(this.delegate.lockAs(lockOwner));
    }

    public CompletableFuture<V> putIfAbsentAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return this.delegate.putIfAbsentAsync(key, value, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    public boolean isEmpty() {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.READ);
        return this.delegate.isEmpty();
    }

    @Override
    public boolean lock(K ... keys) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return this.delegate.lock(keys);
    }

    public boolean containsKey(Object key) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.READ);
        return this.delegate.containsKey(key);
    }

    public V putIfAbsent(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return (V)this.delegate.putIfAbsent(key, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    @Override
    public boolean lock(Collection<? extends K> keys) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return this.delegate.lock(keys);
    }

    public CompletableFuture<V> removeAsync(Object key) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return this.delegate.removeAsync(key);
    }

    @Override
    public CompletableFuture<CacheEntry<K, V>> removeAsyncEntry(Object key) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return this.delegate.removeAsyncEntry(key);
    }

    public boolean containsValue(Object value) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.READ);
        return this.delegate.containsValue(value);
    }

    public void putAll(Map<? extends K, ? extends V> map, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        this.delegate.putAll(map, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    public CompletableFuture<Boolean> removeAsync(Object key, Object value) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return this.delegate.removeAsync(key, value);
    }

    @Override
    public void evict(K key) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.ADMIN);
        this.delegate.evict(key);
    }

    public CompletableFuture<V> replaceAsync(K key, V value) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return this.delegate.replaceAsync(key, value);
    }

    @Override
    public RpcManager getRpcManager() {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.ADMIN);
        return this.delegate.getRpcManager();
    }

    public V replace(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return (V)this.delegate.replace(key, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    public V get(Object key) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.READ);
        return (V)this.delegate.get(key);
    }

    public CompletableFuture<V> replaceAsync(K key, V value, long lifespan, TimeUnit unit) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return this.delegate.replaceAsync(key, value, lifespan, unit);
    }

    @Override
    public BatchContainer getBatchContainer() {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return this.delegate.getBatchContainer();
    }

    @Override
    public Configuration getCacheConfiguration() {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.ADMIN);
        return this.delegate.getCacheConfiguration();
    }

    @Override
    public EmbeddedCacheManager getCacheManager() {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.ADMIN);
        return this.delegate.getCacheManager();
    }

    @Override
    public AdvancedCache<K, V> getAdvancedCache() {
        return this;
    }

    @Override
    public ComponentStatus getStatus() {
        return this.delegate.getStatus();
    }

    @Override
    public AvailabilityMode getAvailability() {
        return this.delegate.getAvailability();
    }

    @Override
    public void setAvailability(AvailabilityMode availabilityMode) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.ADMIN);
        this.delegate.setAvailability(availabilityMode);
    }

    @Override
    public CacheSet<CacheEntry<K, V>> cacheEntrySet() {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.BULK_READ);
        return this.delegate.cacheEntrySet();
    }

    @Override
    public LockedStream<K, V> lockedStream() {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.BULK_WRITE);
        return this.delegate.lockedStream();
    }

    @Override
    public CompletableFuture<Boolean> removeLifespanExpired(K key, V value, Long lifespan) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return this.delegate.removeLifespanExpired(key, value, lifespan);
    }

    @Override
    public CompletableFuture<Boolean> removeMaxIdleExpired(K key, V value) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return this.delegate.removeMaxIdleExpired(key, value);
    }

    @Override
    public AdvancedCache<?, ?> withEncoding(Class<? extends Encoder> encoderClass) {
        return new SecureCacheImpl(this.delegate.withEncoding(encoderClass), this.authzManager, this.subject);
    }

    @Override
    public AdvancedCache<?, ?> withKeyEncoding(Class<? extends Encoder> encoder) {
        return new SecureCacheImpl(this.delegate.withKeyEncoding(encoder), this.authzManager, this.subject);
    }

    @Override
    public AdvancedCache<K, V> withWrapping(Class<? extends Wrapper> wrapperClass) {
        return new SecureCacheImpl<K, V>(this.delegate.withWrapping(wrapperClass), this.authzManager, this.subject);
    }

    @Override
    public AdvancedCache<?, ?> withMediaType(String keyMediaType, String valueMediaType) {
        return new SecureCacheImpl(this.delegate.withMediaType(keyMediaType, valueMediaType), this.authzManager, this.subject);
    }

    @Override
    public <K1, V1> AdvancedCache<K1, V1> withMediaType(MediaType keyMediaType, MediaType valueMediaType) {
        return new SecureCacheImpl(this.delegate.withMediaType(keyMediaType, valueMediaType), this.authzManager, this.subject);
    }

    @Override
    public AdvancedCache<K, V> withStorageMediaType() {
        return new SecureCacheImpl<K, V>(this.delegate.withStorageMediaType(), this.authzManager, this.subject);
    }

    @Override
    public AdvancedCache<?, ?> withEncoding(Class<? extends Encoder> keyEncoderClass, Class<? extends Encoder> valueEncoderClass) {
        return new SecureCacheImpl(this.delegate.withEncoding(keyEncoderClass, valueEncoderClass), this.authzManager, this.subject);
    }

    @Override
    public AdvancedCache<K, V> withWrapping(Class<? extends Wrapper> keyWrapperClass, Class<? extends Wrapper> valueWrapperClass) {
        return new SecureCacheImpl<K, V>(this.delegate.withWrapping(keyWrapperClass, valueWrapperClass), this.authzManager, this.subject);
    }

    @Override
    public DataConversion getKeyDataConversion() {
        return this.delegate.getKeyDataConversion();
    }

    @Override
    public DataConversion getValueDataConversion() {
        return this.delegate.getValueDataConversion();
    }

    @Override
    public int size() {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.BULK_READ);
        return this.delegate.size();
    }

    public CompletableFuture<Long> sizeAsync() {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.BULK_READ);
        return this.delegate.sizeAsync();
    }

    public boolean replace(K key, V oldValue, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return this.delegate.replace(key, oldValue, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    @Override
    public DataContainer<K, V> getDataContainer() {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.ADMIN);
        return this.delegate.getDataContainer();
    }

    public CompletableFuture<V> replaceAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return this.delegate.replaceAsync(key, value, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    public TransactionManager getTransactionManager() {
        return this.delegate.getTransactionManager();
    }

    @Override
    public CacheSet<K> keySet() {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.BULK_READ);
        return this.delegate.keySet();
    }

    public V remove(Object key) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return (V)this.delegate.remove(key);
    }

    @Override
    public Map<K, V> getAll(Set<?> keys) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.BULK_READ);
        return this.delegate.getAll(keys);
    }

    public CompletableFuture<Map<K, V>> getAllAsync(Set<?> keys) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.BULK_READ);
        return this.delegate.getAllAsync(keys);
    }

    @Override
    public LockManager getLockManager() {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return this.delegate.getLockManager();
    }

    public CompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return this.delegate.replaceAsync(key, oldValue, newValue);
    }

    @Override
    public Stats getStats() {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.MONITOR);
        return this.delegate.getStats();
    }

    @Override
    public XAResource getXAResource() {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.ADMIN);
        return this.delegate.getXAResource();
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.delegate.getClassLoader();
    }

    public CompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, long lifespan, TimeUnit unit) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return this.delegate.replaceAsync(key, oldValue, newValue, lifespan, unit);
    }

    @Override
    public CacheCollection<V> values() {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.BULK_READ);
        return this.delegate.values();
    }

    @Override
    public AdvancedCache<K, V> with(ClassLoader classLoader) {
        return this;
    }

    public CompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return this.delegate.replaceAsync(key, oldValue, newValue, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    @Override
    public CacheSet<Map.Entry<K, V>> entrySet() {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.BULK_READ);
        return this.delegate.entrySet();
    }

    public CompletableFuture<V> getAsync(K key) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.READ);
        return this.delegate.getAsync(key);
    }

    @Override
    public V put(K key, V value, Metadata metadata) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return this.delegate.put(key, value, metadata);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m, Metadata metadata) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        this.delegate.putAll(m, metadata);
    }

    @Override
    public CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> map, Metadata metadata) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return this.delegate.putAllAsync(map, metadata);
    }

    public void putAll(Map<? extends K, ? extends V> m) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        this.delegate.putAll(m);
    }

    @Override
    public V replace(K key, V value, Metadata metadata) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return this.delegate.replace(key, value, metadata);
    }

    @Override
    public CompletableFuture<V> replaceAsync(K key, V value, Metadata metadata) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return this.delegate.replaceAsync(key, value, metadata);
    }

    @Override
    public CompletableFuture<CacheEntry<K, V>> replaceAsyncEntry(K key, V value, Metadata metadata) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return this.delegate.replaceAsyncEntry(key, value, metadata);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue, Metadata metadata) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return this.delegate.replace(key, oldValue, newValue, metadata);
    }

    @Override
    public CompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, Metadata metadata) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return this.delegate.replaceAsync(key, oldValue, newValue, metadata);
    }

    @Override
    public void clear() {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.BULK_WRITE);
        this.delegate.clear();
    }

    @Override
    public V putIfAbsent(K key, V value, Metadata metadata) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return this.delegate.putIfAbsent(key, value, metadata);
    }

    @Override
    public CompletableFuture<V> putIfAbsentAsync(K key, V value, Metadata metadata) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return this.delegate.putIfAbsentAsync(key, value, metadata);
    }

    @Override
    public CompletableFuture<CacheEntry<K, V>> putIfAbsentAsyncEntry(K key, V value, Metadata metadata) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return this.delegate.putIfAbsentAsyncEntry(key, value, metadata);
    }

    @Override
    public CompletableFuture<V> putAsync(K key, V value, Metadata metadata) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return this.delegate.putAsync(key, value, metadata);
    }

    @Override
    public CompletableFuture<CacheEntry<K, V>> putAsyncEntry(K key, V value, Metadata metadata) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return this.delegate.putAsyncEntry(key, value, metadata);
    }

    @Override
    public CacheEntry<K, V> getCacheEntry(Object key) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.READ);
        return this.delegate.getCacheEntry(key);
    }

    @Override
    public CompletableFuture<CacheEntry<K, V>> getCacheEntryAsync(Object key) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.READ);
        return this.delegate.getCacheEntryAsync(key);
    }

    @Override
    public Map<K, CacheEntry<K, V>> getAllCacheEntries(Set<?> keys) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.BULK_READ);
        return this.delegate.getAllCacheEntries(keys);
    }

    @Override
    public Map<K, V> getAndPutAll(Map<? extends K, ? extends V> map) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.BULK_WRITE);
        return this.delegate.getAndPutAll(map);
    }

    @Override
    public Map<K, V> getGroup(String groupName) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.BULK_READ);
        return this.delegate.getGroup(groupName);
    }

    @Override
    public void removeGroup(String groupName) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.BULK_WRITE);
        this.delegate.removeGroup(groupName);
    }

    public boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return "Secure " + this.delegate;
    }

    @Override
    public CompletionStage<Boolean> touch(Object key, int segment, boolean touchEvenIfExpired) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return this.delegate.touch(key, segment, touchEvenIfExpired);
    }

    @Override
    public CompletionStage<Boolean> touch(Object key, boolean touchEvenIfExpired) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return this.delegate.touch(key, touchEvenIfExpired);
    }

    @Override
    public CompletionStage<CacheEntry<K, V>> putAsyncReturnEntry(K key, V value, Metadata metadata) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return this.delegate.putAsyncReturnEntry(key, value, metadata);
    }

    @Override
    public CompletionStage<CacheEntry<K, V>> replaceAsyncReturnEntry(K key, V value, Metadata metadata) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return this.delegate.replaceAsyncReturnEntry(key, value, metadata);
    }

    @Override
    public CompletionStage<CacheEntry<K, V>> removeAsyncReturnEntry(K key) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return this.delegate.removeAsyncReturnEntry(key);
    }

    @Override
    public CompletionStage<CacheEntry<K, V>> putIfAbsentAsyncReturnEntry(K key, V value, Metadata metadata) {
        this.authzManager.checkPermission(this.subject, this.writePermission);
        return this.delegate.putIfAbsentAsyncReturnEntry(key, value, metadata);
    }
}

