/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.metrics.impl;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.TimeGauge;
import io.micrometer.core.instrument.Timer;
import io.micrometer.prometheus.PrometheusConfig;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.infinispan.commons.stat.CounterMetricInfo;
import org.infinispan.commons.stat.DistributionSummaryMetricInfo;
import org.infinispan.commons.stat.FunctionTimerMetricInfo;
import org.infinispan.commons.stat.GaugeMetricInfo;
import org.infinispan.commons.stat.MetricInfo;
import org.infinispan.commons.stat.TimeGaugeMetricInfo;
import org.infinispan.commons.stat.TimerMetricInfo;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.metrics.config.MicrometerMeterRegistryConfiguration;
import org.infinispan.metrics.impl.BaseAdditionalMetrics;
import org.infinispan.metrics.impl.CounterTrackerImpl;
import org.infinispan.metrics.impl.DistributionSummaryTrackerImpl;
import org.infinispan.metrics.impl.FunctionTimerTrackerImpl;
import org.infinispan.metrics.impl.MetricsRegistry;
import org.infinispan.metrics.impl.NameUtils;
import org.infinispan.metrics.impl.TimerTrackerImpl;
import org.infinispan.metrics.impl.VendorAdditionalMetrics;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.GLOBAL)
public class MetricsRegistryImpl
implements MetricsRegistry {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    @Inject
    GlobalConfiguration globalConfiguration;
    private ScrapeRegistry registry;

    @Start
    public void start() {
        boolean registerListeners;
        boolean bl = registerListeners = this.registry == null || !this.registry.isExternalManaged();
        if (this.registry != null && !this.registry.isExternalManaged()) {
            this.registry.registry().close();
        }
        this.registry = MetricsRegistryImpl.createMeterRegistry(this.globalConfiguration);
        if (registerListeners) {
            new BaseAdditionalMetrics().bindTo(this.registry.registry());
            new VendorAdditionalMetrics().bindTo(this.registry.registry());
            this.registry.registry().config().onMeterAdded(MetricsRegistryImpl::onMeterAdded);
            this.registry.registry().config().onMeterRemoved(MetricsRegistryImpl::onMeterRemoved);
            this.registry.registry().config().onMeterRegistrationFailed(MetricsRegistryImpl::onMeterRegistrationFailed);
        }
    }

    @Stop
    public void stop() {
        if (this.registry == null || this.registry.isExternalManaged()) {
            return;
        }
        this.registry.registry().close();
    }

    private static ScrapeRegistry createMeterRegistry(GlobalConfiguration globalConfiguration) {
        MicrometerMeterRegistryConfiguration configuration = globalConfiguration.module(MicrometerMeterRegistryConfiguration.class);
        MeterRegistry registry = configuration == null ? null : configuration.meterRegistry();
        boolean externalManaged = true;
        if (registry == null) {
            registry = new PrometheusMeterRegistry(PrometheusConfig.DEFAULT);
            externalManaged = false;
        }
        return registry instanceof PrometheusMeterRegistry ? new PrometheusRegistry((PrometheusMeterRegistry)registry, externalManaged) : new NoScrapeRegistry(registry, externalManaged);
    }

    @Override
    public Set<Object> registerMetrics(Object instance, Collection<MetricInfo> metricInfos, String prefix, Map<String, String> tags) {
        HashSet<Object> metricIds = new HashSet<Object>(metricInfos.size());
        for (MetricInfo info : metricInfos) {
            Meter.Id id;
            if (this.globalConfiguration.metrics().gauges() && (id = this.onGaugeEnabled(instance, prefix, info, tags)) != null) {
                metricIds.add(id);
                continue;
            }
            if (this.globalConfiguration.metrics().histograms() && (id = this.onHistogramEnabled(instance, prefix, info, tags)) != null) {
                metricIds.add(id);
                continue;
            }
            if (!log.isTraceEnabled()) continue;
            log.tracef("Metric %s not registered. Gauges enabled? %s, Histograms enabled? %s", info, this.globalConfiguration.metrics().gauges(), this.globalConfiguration.metrics().histograms());
        }
        if (log.isTraceEnabled()) {
            log.tracef("Registered %d metrics. Metric registry @%x contains %d metrics.", metricIds.size(), System.identityHashCode(this.registry), this.registry.registry().getMeters().size());
        }
        return metricIds;
    }

    @Override
    public void unregisterMetric(Object metricId) {
        if (!(metricId instanceof Meter.Id)) {
            if (log.isTraceEnabled()) {
                log.tracef("Metric %s is not a valid Meter.Id", metricId);
            }
            return;
        }
        Meter removed = this.registry.registry().remove((Meter.Id)metricId);
        if (log.isTraceEnabled()) {
            if (removed != null) {
                log.tracef("Unregistered metric \"%s\". Metric registry @%x contains %d metrics.", metricId, System.identityHashCode(this.registry), this.registry.registry().getMeters().size());
            } else {
                log.tracef("Could not remove unexisting metric \"%s\". Metric registry @%x contains %d metrics.", metricId, System.identityHashCode(this.registry), this.registry.registry().getMeters().size());
            }
        }
    }

    @Override
    public boolean namesAsTags() {
        return this.globalConfiguration.metrics().namesAsTags();
    }

    @Override
    public boolean supportScrape() {
        return this.registry.supportsScrape();
    }

    @Override
    public String scrape(String contentType) {
        return this.registry.scrape(contentType);
    }

    public MeterRegistry registry() {
        return this.registry.registry();
    }

    private static void onMeterAdded(Meter meter) {
        if (log.isDebugEnabled()) {
            log.debugf("Registered metric %s", meter.getId());
        }
    }

    private static void onMeterRemoved(Meter meter) {
        if (log.isDebugEnabled()) {
            log.debugf("Unregistered metric %s", meter.getId());
        }
    }

    private static void onMeterRegistrationFailed(Meter.Id id, String reason) {
        log.metricRegistrationFailed(String.valueOf(id), reason);
    }

    private Meter.Id onGaugeEnabled(Object targetInstance, String prefix, MetricInfo metricInfo, Map<String, String> commonTags) {
        if (metricInfo instanceof GaugeMetricInfo) {
            return this.createGauge(targetInstance, prefix, (GaugeMetricInfo<Object>)((GaugeMetricInfo)metricInfo), commonTags);
        }
        if (metricInfo instanceof CounterMetricInfo) {
            return this.createCounter(targetInstance, prefix, (CounterMetricInfo<Object>)((CounterMetricInfo)metricInfo), commonTags);
        }
        if (metricInfo instanceof FunctionTimerMetricInfo) {
            return this.createFunctionTimer(targetInstance, prefix, (FunctionTimerMetricInfo<Object>)((FunctionTimerMetricInfo)metricInfo), commonTags);
        }
        if (metricInfo instanceof TimeGaugeMetricInfo) {
            return this.createTimeGauge(targetInstance, prefix, (TimeGaugeMetricInfo<Object>)((TimeGaugeMetricInfo)metricInfo), commonTags);
        }
        return null;
    }

    private Meter.Id onHistogramEnabled(Object targetInstance, String prefix, MetricInfo metricInfo, Map<String, String> commonTags) {
        if (metricInfo instanceof TimerMetricInfo) {
            return this.createTimer(targetInstance, prefix, (TimerMetricInfo<Object>)((TimerMetricInfo)metricInfo), commonTags);
        }
        if (metricInfo instanceof DistributionSummaryMetricInfo) {
            return this.createSummary(targetInstance, prefix, (DistributionSummaryMetricInfo<Object>)((DistributionSummaryMetricInfo)metricInfo), commonTags);
        }
        return null;
    }

    private Collection<Tag> createTags(Map<String, String> attrTags, Map<String, String> tags) {
        TreeMap<String, String> allTags = new TreeMap<String, String>();
        if (this.namesAsTags()) {
            allTags.put("cache_manager", this.globalConfiguration.cacheManagerName());
        }
        if (tags != null) {
            allTags.putAll(tags);
        }
        if (attrTags != null) {
            allTags.putAll(attrTags);
        }
        return allTags.entrySet().stream().map(MetricsRegistryImpl::tagFromMapEntry).collect(Collectors.toList());
    }

    private static Tag tagFromMapEntry(Map.Entry<String, String> entry) {
        return Tag.of((String)entry.getKey(), (String)entry.getValue());
    }

    private static String metricName(String prefix, MetricInfo info) {
        return "vendor." + prefix + NameUtils.decamelize(info.getName());
    }

    private Meter.Id createTimeGauge(Object instance, String prefix, TimeGaugeMetricInfo<Object> info, Map<String, String> tags) {
        return TimeGauge.builder((String)MetricsRegistryImpl.metricName(prefix, info), (Supplier)info.getGauge(instance), (TimeUnit)info.getTimeUnit()).strongReference(true).tags(this.createTags(info.getTags(), tags)).description(info.getDescription()).register(this.registry.registry()).getId();
    }

    private Meter.Id createGauge(Object instance, String prefix, GaugeMetricInfo<Object> info, Map<String, String> tags) {
        return Gauge.builder((String)MetricsRegistryImpl.metricName(prefix, info), (Supplier)info.getGauge(instance)).strongReference(true).tags(this.createTags(info.getTags(), tags)).description(info.getDescription()).register(this.registry.registry()).getId();
    }

    private Meter.Id createCounter(Object instance, String prefix, CounterMetricInfo<Object> info, Map<String, String> tags) {
        Counter counter = Counter.builder((String)MetricsRegistryImpl.metricName(prefix, info)).description(info.getDescription()).tags(this.createTags(info.getTags(), tags)).register(this.registry.registry());
        info.accept(instance, (Object)new CounterTrackerImpl(counter));
        return counter.getId();
    }

    private Meter.Id createFunctionTimer(Object instance, String prefix, FunctionTimerMetricInfo<Object> info, Map<String, String> tags) {
        FunctionTimerTrackerImpl timerTracker = new FunctionTimerTrackerImpl(info.getTimeUnit());
        info.accept(instance, (Object)timerTracker);
        return timerTracker.create(MetricsRegistryImpl.metricName(prefix, info)).description(info.getDescription()).tags(this.createTags(info.getTags(), tags)).register(this.registry.registry()).getId();
    }

    private Meter.Id createTimer(Object instance, String prefix, TimerMetricInfo<Object> info, Map<String, String> tags) {
        Timer timer = Timer.builder((String)MetricsRegistryImpl.metricName(prefix, info)).description(info.getDescription()).publishPercentileHistogram(Boolean.valueOf(true)).tags(this.createTags(info.getTags(), tags)).register(this.registry.registry());
        info.accept(instance, (Object)new TimerTrackerImpl(timer));
        return timer.getId();
    }

    private Meter.Id createSummary(Object instance, String prefix, DistributionSummaryMetricInfo<Object> info, Map<String, String> tags) {
        DistributionSummary summary = DistributionSummary.builder((String)MetricsRegistryImpl.metricName(prefix, info)).description(info.getDescription()).publishPercentileHistogram(Boolean.valueOf(true)).tags(this.createTags(info.getTags(), tags)).register(this.registry.registry());
        info.accept(instance, (Object)new DistributionSummaryTrackerImpl(summary));
        return summary.getId();
    }

    private static interface ScrapeRegistry {
        public boolean supportsScrape();

        public String scrape(String var1);

        public MeterRegistry registry();

        public boolean isExternalManaged();
    }

    private static class PrometheusRegistry
    implements ScrapeRegistry {
        final PrometheusMeterRegistry registry;
        final boolean externalManaged;

        PrometheusRegistry(PrometheusMeterRegistry registry, boolean externalManaged) {
            this.registry = registry;
            this.externalManaged = externalManaged;
        }

        @Override
        public boolean supportsScrape() {
            return true;
        }

        @Override
        public String scrape(String contentType) {
            return this.registry.scrape(contentType);
        }

        @Override
        public MeterRegistry registry() {
            return this.registry;
        }

        @Override
        public boolean isExternalManaged() {
            return this.externalManaged;
        }
    }

    private static class NoScrapeRegistry
    implements ScrapeRegistry {
        final MeterRegistry registry;
        final boolean externalManaged;

        NoScrapeRegistry(MeterRegistry registry, boolean externalManaged) {
            this.registry = registry;
            this.externalManaged = externalManaged;
        }

        @Override
        public boolean supportsScrape() {
            return false;
        }

        @Override
        public String scrape(String contentType) {
            return null;
        }

        @Override
        public MeterRegistry registry() {
            return this.registry;
        }

        @Override
        public boolean isExternalManaged() {
            return this.externalManaged;
        }
    }
}

