/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.synchronization;

import java.util.Objects;
import java.util.concurrent.CompletionStage;
import javax.transaction.Synchronization;
import org.infinispan.commons.tx.AsyncSynchronization;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.transaction.impl.AbstractEnlistmentAdapter;
import org.infinispan.transaction.impl.LocalTransaction;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.util.concurrent.CompletionStages;

public class SynchronizationAdapter
extends AbstractEnlistmentAdapter
implements Synchronization,
AsyncSynchronization {
    private final LocalTransaction localTransaction;
    private final TransactionTable txTable;

    public SynchronizationAdapter(LocalTransaction localTransaction, TransactionTable txTable) {
        super(localTransaction);
        this.localTransaction = localTransaction;
        this.txTable = txTable;
    }

    public void beforeCompletion() {
        CompletionStages.join(this.txTable.beforeCompletion(this.localTransaction));
    }

    public void afterCompletion(int status) {
        CompletionStages.join(this.txTable.afterCompletion(this.localTransaction, status));
    }

    public String toString() {
        return "SynchronizationAdapter{localTransaction=" + String.valueOf(this.localTransaction) + "} " + super.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SynchronizationAdapter that = (SynchronizationAdapter)o;
        return Objects.equals(this.localTransaction, that.localTransaction);
    }

    public CompletionStage<Void> asyncBeforeCompletion() {
        return this.txTable.beforeCompletion(this.localTransaction).thenApply(CompletableFutures.toNullFunction());
    }

    public CompletionStage<Void> asyncAfterCompletion(int status) {
        return this.txTable.afterCompletion(this.localTransaction, status);
    }
}

