/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.Map;
import java.util.Properties;
import org.infinispan.commons.configuration.AbstractTypedPropertiesConfiguration;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.configuration.cache.AbstractCustomInterceptorsConfigurationChildBuilder;
import org.infinispan.configuration.cache.CustomInterceptorsConfigurationBuilder;
import org.infinispan.configuration.cache.InterceptorConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.BaseCustomAsyncInterceptor;
import org.infinispan.util.logging.Log;

@Deprecated
public class InterceptorConfigurationBuilder
extends AbstractCustomInterceptorsConfigurationChildBuilder
implements Builder<InterceptorConfiguration> {
    private final AttributeSet attributes = InterceptorConfiguration.attributeDefinitionSet();

    InterceptorConfigurationBuilder(CustomInterceptorsConfigurationBuilder builder) {
        super(builder);
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public InterceptorConfigurationBuilder after(Class<? extends AsyncInterceptor> after) {
        this.attributes.attribute(InterceptorConfiguration.AFTER).set(after);
        return this;
    }

    public InterceptorConfigurationBuilder before(Class<? extends AsyncInterceptor> before) {
        this.attributes.attribute(InterceptorConfiguration.BEFORE).set(before);
        return this;
    }

    public InterceptorConfigurationBuilder interceptorClass(Class<? extends AsyncInterceptor> interceptorClass) {
        this.attributes.attribute(InterceptorConfiguration.INTERCEPTOR_CLASS).set(interceptorClass);
        return this;
    }

    public InterceptorConfigurationBuilder interceptor(AsyncInterceptor interceptor) {
        this.attributes.attribute(InterceptorConfiguration.INTERCEPTOR).set((Object)interceptor);
        return this;
    }

    public InterceptorConfigurationBuilder index(int i) {
        if (i < 0) {
            throw new IllegalArgumentException("Index cannot be negative");
        }
        this.attributes.attribute(InterceptorConfiguration.INDEX).set((Object)i);
        return this;
    }

    public InterceptorConfigurationBuilder position(InterceptorConfiguration.Position p) {
        this.attributes.attribute(InterceptorConfiguration.POSITION).set((Object)p);
        return this;
    }

    public InterceptorConfigurationBuilder withProperties(Properties properties) {
        this.attributes.attribute(AbstractTypedPropertiesConfiguration.PROPERTIES).set((Object)TypedProperties.toTypedProperties((Map)properties));
        return this;
    }

    public InterceptorConfigurationBuilder clearProperties() {
        TypedProperties properties = (TypedProperties)this.attributes.attribute(AbstractTypedPropertiesConfiguration.PROPERTIES).get();
        properties.clear();
        this.attributes.attribute(AbstractTypedPropertiesConfiguration.PROPERTIES).set((Object)TypedProperties.toTypedProperties((Map)properties));
        return this;
    }

    public InterceptorConfigurationBuilder addProperty(String key, String value) {
        TypedProperties properties = (TypedProperties)this.attributes.attribute(AbstractTypedPropertiesConfiguration.PROPERTIES).get();
        properties.put((Object)key, (Object)value);
        this.attributes.attribute(AbstractTypedPropertiesConfiguration.PROPERTIES).set((Object)TypedProperties.toTypedProperties((Map)properties));
        return this;
    }

    public InterceptorConfigurationBuilder removeProperty(String key) {
        TypedProperties properties = (TypedProperties)this.attributes.attribute(AbstractTypedPropertiesConfiguration.PROPERTIES).get();
        properties.remove((Object)key);
        this.attributes.attribute(AbstractTypedPropertiesConfiguration.PROPERTIES).set((Object)TypedProperties.toTypedProperties((Map)properties));
        return this;
    }

    public void validate() {
        String className;
        Attribute interceptorClassAttribute = this.attributes.attribute(InterceptorConfiguration.INTERCEPTOR_CLASS);
        Attribute interceptorAttribute = this.attributes.attribute(InterceptorConfiguration.INTERCEPTOR);
        if (!interceptorClassAttribute.isNull() && !interceptorAttribute.isNull()) {
            throw Log.CONFIG.interceptorClassAndInstanceDefined(((Class)interceptorClassAttribute.get()).getName(), ((AsyncInterceptor)interceptorAttribute.get()).toString());
        }
        if (interceptorClassAttribute.isNull() && interceptorAttribute.isNull()) {
            throw Log.CONFIG.customInterceptorMissingClass();
        }
        Class<?> interceptorClass = (Class<?>)interceptorClassAttribute.get();
        if (interceptorClass == null) {
            interceptorClass = ((AsyncInterceptor)interceptorAttribute.get()).getClass();
        }
        if (!BaseCustomAsyncInterceptor.class.isAssignableFrom(interceptorClass) && !(className = interceptorClass.getName()).startsWith("org.infinispan.")) {
            Log.CONFIG.suggestCustomInterceptorInheritance(className);
        }
        int positions = 0;
        if (!this.attributes.attribute(InterceptorConfiguration.BEFORE).isNull()) {
            ++positions;
        }
        if (!this.attributes.attribute(InterceptorConfiguration.AFTER).isNull()) {
            ++positions;
        }
        if ((Integer)this.attributes.attribute(InterceptorConfiguration.INDEX).get() > -1) {
            ++positions;
        }
        if (this.attributes.attribute(InterceptorConfiguration.POSITION).isModified()) {
            ++positions;
        }
        switch (positions) {
            case 0: {
                throw Log.CONFIG.missingCustomInterceptorPosition(interceptorClass.getName());
            }
            case 1: {
                break;
            }
            default: {
                throw Log.CONFIG.multipleCustomInterceptorPositions(interceptorClass.getName());
            }
        }
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
    }

    public InterceptorConfiguration create() {
        return new InterceptorConfiguration(this.attributes.protect());
    }

    public InterceptorConfigurationBuilder read(InterceptorConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }

    public String toString() {
        return "InterceptorConfigurationBuilder [attributes=" + this.attributes + "]";
    }
}

