/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.HashSet;
import java.util.Set;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.cache.AbstractSecurityConfigurationChildBuilder;
import org.infinispan.configuration.cache.AuthorizationConfiguration;
import org.infinispan.configuration.cache.SecurityConfigurationBuilder;
import org.infinispan.configuration.global.GlobalAuthorizationConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.util.logging.Log;

public class AuthorizationConfigurationBuilder
extends AbstractSecurityConfigurationChildBuilder
implements Builder<AuthorizationConfiguration> {
    private final AttributeSet attributes = AuthorizationConfiguration.attributeDefinitionSet();

    public AuthorizationConfigurationBuilder(SecurityConfigurationBuilder securityBuilder) {
        super(securityBuilder);
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public AuthorizationConfigurationBuilder disable() {
        this.attributes.attribute(AuthorizationConfiguration.ENABLED).set((Object)false);
        return this;
    }

    public AuthorizationConfigurationBuilder enable() {
        this.attributes.attribute(AuthorizationConfiguration.ENABLED).set((Object)true);
        return this;
    }

    public AuthorizationConfigurationBuilder enabled(boolean enabled) {
        this.attributes.attribute(AuthorizationConfiguration.ENABLED).set((Object)enabled);
        return this;
    }

    public AuthorizationConfigurationBuilder role(String name) {
        Set roles = (Set)this.attributes.attribute(AuthorizationConfiguration.ROLES).get();
        roles.add(name);
        this.attributes.attribute(AuthorizationConfiguration.ROLES).set((Object)roles);
        return this;
    }

    public AuthorizationConfigurationBuilder roles(String ... names) {
        for (String name : names) {
            this.role(name);
        }
        return this;
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
        GlobalAuthorizationConfiguration authorization = globalConfig.security().authorization();
        if (((Boolean)this.attributes.attribute(AuthorizationConfiguration.ENABLED).get()).booleanValue() && !authorization.enabled()) {
            throw Log.CONFIG.globalSecurityAuthShouldBeEnabled();
        }
        Set cacheRoles = (Set)this.attributes.attribute(AuthorizationConfiguration.ROLES).get();
        HashSet<String> missingRoles = new HashSet<String>();
        for (String role : cacheRoles) {
            if (authorization.hasRole(role)) continue;
            missingRoles.add(role);
        }
        if (!missingRoles.isEmpty()) {
            throw Log.CONFIG.noSuchGlobalRoles(missingRoles);
        }
    }

    public AuthorizationConfiguration create() {
        return new AuthorizationConfiguration(this.attributes.protect());
    }

    public Builder<?> read(AuthorizationConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }

    public String toString() {
        return "AuthorizationConfigurationBuilder [attributes=" + String.valueOf(this.attributes) + "]";
    }
}

