/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.configuration.parsing.Element;

public enum CacheMode {
    LOCAL,
    REPL_SYNC,
    REPL_ASYNC,
    INVALIDATION_SYNC,
    INVALIDATION_ASYNC,
    DIST_SYNC,
    DIST_ASYNC,
    SCATTERED_SYNC;

    private static final CacheMode[] cachedValues;

    public static CacheMode valueOf(int order) {
        return cachedValues[order];
    }

    public boolean isInvalidation() {
        return this == INVALIDATION_SYNC || this == INVALIDATION_ASYNC;
    }

    public boolean isSynchronous() {
        return this == REPL_SYNC || this == DIST_SYNC || this == INVALIDATION_SYNC || this == SCATTERED_SYNC || this == LOCAL;
    }

    public boolean isClustered() {
        return this != LOCAL;
    }

    public boolean isDistributed() {
        return this == DIST_SYNC || this == DIST_ASYNC;
    }

    public boolean isReplicated() {
        return this == REPL_SYNC || this == REPL_ASYNC;
    }

    @Deprecated
    public boolean isScattered() {
        return this == SCATTERED_SYNC;
    }

    public boolean needsStateTransfer() {
        return this.isReplicated() || this.isDistributed() || this.isScattered();
    }

    public CacheMode toSync() {
        switch (this.ordinal()) {
            case 2: {
                return REPL_SYNC;
            }
            case 4: {
                return INVALIDATION_SYNC;
            }
            case 6: {
                return DIST_SYNC;
            }
        }
        return this;
    }

    public CacheMode toSync(boolean sync) {
        return sync ? this.toSync() : this.toAsync();
    }

    public CacheMode toAsync() {
        switch (this.ordinal()) {
            case 1: {
                return REPL_ASYNC;
            }
            case 3: {
                return INVALIDATION_ASYNC;
            }
            case 5: {
                return DIST_ASYNC;
            }
            case 7: {
                throw new IllegalArgumentException("Scattered mode does not have asynchronous mode.");
            }
        }
        return this;
    }

    public String friendlyCacheModeString() {
        switch (this.ordinal()) {
            case 1: 
            case 2: {
                return "REPLICATED";
            }
            case 3: 
            case 4: {
                return "INVALIDATED";
            }
            case 5: 
            case 6: {
                return "DISTRIBUTED";
            }
            case 7: {
                return "SCATTERED";
            }
            case 0: {
                return "LOCAL";
            }
        }
        throw new IllegalArgumentException("Unknown cache mode " + String.valueOf((Object)this));
    }

    public String toCacheType() {
        switch (this.ordinal()) {
            case 5: 
            case 6: {
                return Element.DISTRIBUTED_CACHE.getLocalName();
            }
            case 1: 
            case 2: {
                return Element.REPLICATED_CACHE.getLocalName();
            }
            case 3: 
            case 4: {
                return Element.INVALIDATION_CACHE.getLocalName();
            }
            case 7: {
                return Element.SCATTERED_CACHE.getLocalName();
            }
        }
        return Element.LOCAL_CACHE.getLocalName();
    }

    public Element toElement(boolean template) {
        switch (this.ordinal()) {
            case 5: 
            case 6: {
                return template ? Element.DISTRIBUTED_CACHE_CONFIGURATION : Element.DISTRIBUTED_CACHE;
            }
            case 1: 
            case 2: {
                return template ? Element.REPLICATED_CACHE_CONFIGURATION : Element.REPLICATED_CACHE;
            }
            case 3: 
            case 4: {
                return template ? Element.INVALIDATION_CACHE_CONFIGURATION : Element.INVALIDATION_CACHE;
            }
            case 7: {
                return template ? Element.SCATTERED_CACHE_CONFIGURATION : Element.SCATTERED_CACHE;
            }
        }
        return template ? Element.LOCAL_CACHE_CONFIGURATION : Element.LOCAL_CACHE;
    }

    public static CacheMode fromParts(String distribution, String synchronicity) {
        String sync = synchronicity.toLowerCase();
        if (!sync.equals("sync") && !sync.equals("async")) {
            throw new CacheConfigurationException("Invalid cache mode " + distribution + "," + synchronicity);
        }
        switch (distribution.toLowerCase()) {
            case "distributed": {
                return sync.equals("sync") ? DIST_SYNC : DIST_ASYNC;
            }
            case "replicated": {
                return sync.equals("sync") ? REPL_SYNC : REPL_ASYNC;
            }
            case "local": {
                return LOCAL;
            }
            case "scattered": {
                return SCATTERED_SYNC;
            }
            case "invalidation": {
                return sync.equals("sync") ? INVALIDATION_SYNC : INVALIDATION_ASYNC;
            }
        }
        throw new CacheConfigurationException("Invalid cache mode " + distribution + "," + synchronicity);
    }

    static {
        cachedValues = CacheMode.values();
    }
}

