/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.AbstractTypedPropertiesConfiguration;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.util.StringPropertyReplacer;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.AbstractConfigurationChildBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IndexReaderConfigurationBuilder;
import org.infinispan.configuration.cache.IndexShardingConfigurationBuilder;
import org.infinispan.configuration.cache.IndexStartupMode;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.configuration.cache.IndexWriterConfigurationBuilder;
import org.infinispan.configuration.cache.IndexingConfiguration;
import org.infinispan.configuration.cache.IndexingConfigurationChildBuilder;
import org.infinispan.configuration.cache.IndexingMode;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.util.logging.Log;

public class IndexingConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements IndexingConfigurationChildBuilder,
Builder<IndexingConfiguration> {
    private final AttributeSet attributes;
    private final Set<Class<?>> resolvedIndexedClasses = new HashSet();
    private final IndexReaderConfigurationBuilder readerConfigurationBuilder;
    private final IndexWriterConfigurationBuilder writerConfigurationBuilder;
    private final IndexShardingConfigurationBuilder shardingConfigurationBuilder;

    IndexingConfigurationBuilder(ConfigurationBuilder builder) {
        super(builder);
        this.attributes = IndexingConfiguration.attributeDefinitionSet();
        this.readerConfigurationBuilder = new IndexReaderConfigurationBuilder(this);
        this.writerConfigurationBuilder = new IndexWriterConfigurationBuilder(this);
        this.shardingConfigurationBuilder = new IndexShardingConfigurationBuilder(this);
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public IndexingConfigurationBuilder enabled(boolean enabled) {
        if (!enabled) {
            this.reset();
        }
        this.attributes.attribute(IndexingConfiguration.ENABLED).set((Object)enabled);
        return this;
    }

    @Override
    public IndexReaderConfigurationBuilder reader() {
        return this.readerConfigurationBuilder;
    }

    @Override
    public IndexWriterConfigurationBuilder writer() {
        return this.writerConfigurationBuilder;
    }

    @Override
    public IndexShardingConfigurationBuilder sharding() {
        return this.shardingConfigurationBuilder;
    }

    public void reset() {
        this.attributes.attribute(IndexingConfiguration.ENABLED).reset();
        this.attributes.attribute(IndexingConfiguration.INDEXED_ENTITIES).reset();
        this.attributes.attribute(AbstractTypedPropertiesConfiguration.PROPERTIES).reset();
        this.attributes.attribute(IndexingConfiguration.KEY_TRANSFORMERS).reset();
        this.attributes.attribute(IndexingConfiguration.STORAGE).reset();
        this.attributes.attribute(IndexingConfiguration.STARTUP_MODE).reset();
        this.attributes.attribute(IndexingConfiguration.INDEXING_MODE).reset();
        this.attributes.attribute(IndexingConfiguration.PATH).reset();
    }

    @Override
    public IndexingConfigurationBuilder enable() {
        return this.enabled(true);
    }

    @Override
    public IndexingConfigurationBuilder disable() {
        return this.enabled(false);
    }

    public boolean enabled() {
        return (Boolean)this.attributes.attribute(IndexingConfiguration.ENABLED).get();
    }

    @Override
    public IndexingConfigurationBuilder path(String path) {
        this.attributes.attribute(IndexingConfiguration.PATH).set((Object)path);
        return this;
    }

    @Override
    public IndexingConfigurationBuilder storage(IndexStorage storage) {
        this.attributes.attribute(IndexingConfiguration.STORAGE).set((Object)storage);
        return this;
    }

    @Override
    public IndexingConfigurationBuilder startupMode(IndexStartupMode startupMode) {
        this.attributes.attribute(IndexingConfiguration.STARTUP_MODE).set((Object)startupMode);
        return this;
    }

    @Override
    public IndexingConfigurationBuilder indexingMode(IndexingMode indexingMode) {
        this.attributes.attribute(IndexingConfiguration.INDEXING_MODE).set((Object)indexingMode);
        return this;
    }

    @Override
    public IndexingConfigurationBuilder addKeyTransformer(Class<?> keyClass, Class<?> keyTransformerClass) {
        Map<Class<?>, Class<?>> keyTransformers = this.keyTransformers();
        keyTransformers.put(keyClass, keyTransformerClass);
        this.attributes.attribute(IndexingConfiguration.KEY_TRANSFORMERS).set(keyTransformers);
        return this;
    }

    private Map<Class<?>, Class<?>> keyTransformers() {
        return (Map)this.attributes.attribute(IndexingConfiguration.KEY_TRANSFORMERS).get();
    }

    @Override
    public IndexingConfigurationBuilder addIndexedEntity(String indexedEntity) {
        if (indexedEntity == null || indexedEntity.length() == 0) {
            throw new CacheConfigurationException("Type name must not be null or empty");
        }
        Set<String> indexedEntitySet = this.indexedEntities();
        indexedEntitySet.add(indexedEntity);
        this.attributes.attribute(IndexingConfiguration.INDEXED_ENTITIES).set(indexedEntitySet);
        return this;
    }

    @Override
    public IndexingConfigurationBuilder addIndexedEntities(String ... indexedEntities) {
        Set<String> indexedEntitySet = this.indexedEntities();
        for (String typeName : indexedEntities) {
            if (typeName == null || typeName.length() == 0) {
                throw new CacheConfigurationException("Type name must not be null or empty");
            }
            indexedEntitySet.add(typeName);
        }
        this.attributes.attribute(IndexingConfiguration.INDEXED_ENTITIES).set(indexedEntitySet);
        return this;
    }

    @Override
    public IndexingConfigurationBuilder addIndexedEntity(Class<?> indexedEntity) {
        this.addIndexedEntity(indexedEntity.getName());
        this.resolvedIndexedClasses.add(indexedEntity);
        return this;
    }

    @Override
    public IndexingConfigurationBuilder addIndexedEntities(Class<?> ... indexedEntities) {
        this.addIndexedEntities((String[])Arrays.stream(indexedEntities).map(Class::getName).toArray(String[]::new));
        Collections.addAll(this.resolvedIndexedClasses, indexedEntities);
        return this;
    }

    private Set<String> indexedEntities() {
        return (Set)this.attributes.attribute(IndexingConfiguration.INDEXED_ENTITIES).get();
    }

    public void validate() {
        if (this.enabled()) {
            if (this.clustering().cacheMode().isInvalidation()) {
                throw Log.CONFIG.invalidConfigurationIndexingWithInvalidation();
            }
            if (this.indexedEntities().isEmpty() && !this.getBuilder().template()) {
                throw Log.CONFIG.noIndexableClassesDefined();
            }
        } else if (!this.indexedEntities().isEmpty()) {
            throw Log.CONFIG.indexableClassesDefined();
        }
        this.ensureSingleIndexingConfig();
    }

    private void ensureSingleIndexingConfig() {
        TypedProperties typedProperties = (TypedProperties)this.attributes.attribute(AbstractTypedPropertiesConfiguration.PROPERTIES).get();
        boolean hasMultiIndexConfig = typedProperties.keySet().stream().map(Object::toString).filter(k -> k.contains(".")).map(k -> k.substring(k.lastIndexOf(46))).anyMatch(s -> typedProperties.keySet().stream().filter(k -> k.toString().endsWith((String)s)).count() > 1L);
        if (hasMultiIndexConfig) {
            throw Log.CONFIG.foundDifferentIndexConfigPerType();
        }
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
        if (this.enabled()) {
            try {
                String clazz = "org.infinispan.query.Search";
                Util.loadClassStrict((String)clazz, (ClassLoader)globalConfig.classLoader());
            }
            catch (ClassNotFoundException e) {
                throw Log.CONFIG.invalidConfigurationIndexingWithoutModule();
            }
            if (this.attributes.attribute(IndexingConfiguration.STORAGE).get() == IndexStorage.FILESYSTEM) {
                boolean globalStateEnabled = globalConfig.globalState().enabled();
                String path = StringPropertyReplacer.replaceProperties((String)((String)this.attributes.attribute(IndexingConfiguration.PATH).get()));
                if (!globalStateEnabled) {
                    if (path == null) {
                        Log.CONFIG.indexLocationWorkingDir();
                    } else if (!Paths.get(path, new String[0]).isAbsolute()) {
                        Log.CONFIG.indexRelativeWorkingDir(path);
                    }
                }
            }
        }
    }

    public IndexingConfiguration create() {
        return new IndexingConfiguration(this.attributes.protect(), this.resolvedIndexedClasses, this.readerConfigurationBuilder.create(), this.writerConfigurationBuilder.create(), this.shardingConfigurationBuilder.create());
    }

    public IndexingConfigurationBuilder read(IndexingConfiguration template) {
        this.attributes.read(template.attributes());
        this.resolvedIndexedClasses.clear();
        this.resolvedIndexedClasses.addAll(template.indexedEntities());
        this.readerConfigurationBuilder.read(template.reader());
        this.writerConfigurationBuilder.read(template.writer());
        this.shardingConfigurationBuilder.read(template.sharding());
        return this;
    }

    public String toString() {
        return "IndexingConfigurationBuilder{attributes=" + String.valueOf(this.attributes) + ", readerConfigurationBuilder=" + String.valueOf(this.readerConfigurationBuilder) + ", writerConfigurationBuilder=" + String.valueOf(this.writerConfigurationBuilder) + ", shardingConfigurationBuilder=" + String.valueOf(this.shardingConfigurationBuilder) + "}";
    }
}

