/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.parsing;

import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.configuration.BuiltBy;
import org.infinispan.commons.configuration.ConfiguredBy;
import org.infinispan.commons.configuration.io.ConfigurationReader;
import org.infinispan.commons.configuration.io.ConfigurationReaderContext;
import org.infinispan.commons.configuration.io.NamingStrategy;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.commons.util.GlobUtils;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.AbstractStoreConfigurationBuilder;
import org.infinispan.configuration.cache.AsyncStoreConfigurationBuilder;
import org.infinispan.configuration.cache.AuthorizationConfigurationBuilder;
import org.infinispan.configuration.cache.BackupConfigurationBuilder;
import org.infinispan.configuration.cache.BiasAcquisition;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ClusterLoaderConfigurationBuilder;
import org.infinispan.configuration.cache.ClusteringConfigurationBuilder;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.ContentTypeConfigurationBuilder;
import org.infinispan.configuration.cache.CustomStoreConfigurationBuilder;
import org.infinispan.configuration.cache.EncodingConfigurationBuilder;
import org.infinispan.configuration.cache.GroupsConfigurationBuilder;
import org.infinispan.configuration.cache.IndexMergeConfigurationBuilder;
import org.infinispan.configuration.cache.IndexStartupMode;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.configuration.cache.IndexWriterConfigurationBuilder;
import org.infinispan.configuration.cache.IndexingMode;
import org.infinispan.configuration.cache.InterceptorConfiguration;
import org.infinispan.configuration.cache.InterceptorConfigurationBuilder;
import org.infinispan.configuration.cache.MemoryConfigurationBuilder;
import org.infinispan.configuration.cache.PartitionHandlingConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.cache.SecurityConfigurationBuilder;
import org.infinispan.configuration.cache.SingleFileStoreConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.configuration.cache.StoreConfigurationBuilder;
import org.infinispan.configuration.cache.TransactionConfiguration;
import org.infinispan.configuration.parsing.Attribute;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ConfigurationParser;
import org.infinispan.configuration.parsing.Element;
import org.infinispan.configuration.parsing.Namespace;
import org.infinispan.configuration.parsing.Namespaces;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.configuration.parsing.ParserScope;
import org.infinispan.configuration.parsing.SFSToSIFSConfigurationBuilder;
import org.infinispan.conflict.EntryMergePolicy;
import org.infinispan.conflict.MergePolicy;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.distribution.group.Grouper;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.eviction.EvictionType;
import org.infinispan.expiration.TouchMode;
import org.infinispan.partitionhandling.PartitionHandling;
import org.infinispan.persistence.cluster.ClusterLoader;
import org.infinispan.persistence.file.SingleFileStore;
import org.infinispan.persistence.sifs.configuration.SoftIndexFileStoreConfigurationBuilder;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.logging.Log;

@Namespaces(value={@Namespace(root="local-cache"), @Namespace(root="local-cache-configuration"), @Namespace(root="distributed-cache"), @Namespace(root="distributed-cache-configuration"), @Namespace(root="replicated-cache"), @Namespace(root="replicated-cache-configuration"), @Namespace(root="scattered-cache"), @Namespace(root="scattered-cache-configuration"), @Namespace(uri="urn:infinispan:config:*", root="local-cache"), @Namespace(uri="urn:infinispan:config:*", root="local-cache-configuration"), @Namespace(uri="urn:infinispan:config:*", root="distributed-cache"), @Namespace(uri="urn:infinispan:config:*", root="distributed-cache-configuration"), @Namespace(uri="urn:infinispan:config:*", root="replicated-cache"), @Namespace(uri="urn:infinispan:config:*", root="replicated-cache-configuration"), @Namespace(uri="urn:infinispan:config:*", root="scattered-cache"), @Namespace(uri="urn:infinispan:config:*", root="scattered-cache-configuration")})
public class CacheParser
implements ConfigurationParser {
    public static final String NAMESPACE = "urn:infinispan:config:";
    public static final String IGNORE_MISSING_TEMPLATES = "org.infinispan.parser.ignoreMissingTemplates";

    @Override
    public void readElement(ConfigurationReader reader, ConfigurationBuilderHolder holder) {
        Element element = Element.forName(reader.getLocalName());
        String name = reader.getAttributeValue(Attribute.NAME.getLocalName());
        switch (element) {
            case LOCAL_CACHE: {
                this.parseLocalCache(reader, holder, name, false);
                break;
            }
            case LOCAL_CACHE_CONFIGURATION: {
                this.parseLocalCache(reader, holder, name, true);
                break;
            }
            case INVALIDATION_CACHE: {
                this.parseInvalidationCache(reader, holder, name, false);
                break;
            }
            case INVALIDATION_CACHE_CONFIGURATION: {
                this.parseInvalidationCache(reader, holder, name, true);
                break;
            }
            case REPLICATED_CACHE: {
                this.parseReplicatedCache(reader, holder, name, false);
                break;
            }
            case REPLICATED_CACHE_CONFIGURATION: {
                this.parseReplicatedCache(reader, holder, name, true);
                break;
            }
            case DISTRIBUTED_CACHE: {
                this.parseDistributedCache(reader, holder, name, false);
                break;
            }
            case DISTRIBUTED_CACHE_CONFIGURATION: {
                this.parseDistributedCache(reader, holder, name, true);
                break;
            }
            case SCATTERED_CACHE: {
                if (reader.getSchema().since(9, 1)) {
                    this.parseScatteredCache(reader, holder, name, false);
                    break;
                }
                throw ParseUtils.unexpectedElement(reader);
            }
            case SCATTERED_CACHE_CONFIGURATION: {
                if (reader.getSchema().since(9, 1)) {
                    this.parseScatteredCache(reader, holder, name, true);
                    break;
                }
                throw ParseUtils.unexpectedElement(reader);
            }
        }
    }

    private void parseModules(ConfigurationReader reader, ConfigurationBuilderHolder holder) {
        while (reader.inTag()) {
            reader.handleAny((ConfigurationReaderContext)holder);
        }
    }

    protected void parseLocalCache(ConfigurationReader reader, ConfigurationBuilderHolder holder, String name, boolean template) {
        holder.pushScope(template ? ParserScope.CACHE_TEMPLATE : ParserScope.CACHE);
        if (!template && GlobUtils.isGlob((String)name)) {
            throw Log.CONFIG.wildcardsNotAllowedInCacheNames(name);
        }
        String configuration = reader.getAttributeValue(Attribute.CONFIGURATION.getLocalName());
        ConfigurationBuilder builder = this.getConfigurationBuilder(reader, holder, name, template, configuration);
        builder.clustering().cacheMode(CacheMode.LOCAL);
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            this.parseCacheAttribute(reader, i, attribute, value, builder);
        }
        while (reader.inTag()) {
            Element element = Element.forName(reader.getLocalName());
            this.parseCacheElement(reader, element, holder);
        }
        holder.popScope();
    }

    private void parseCacheAttribute(ConfigurationReader reader, int index, Attribute attribute, String value, ConfigurationBuilder builder) {
        switch (attribute) {
            case NAME: 
            case CONFIGURATION: {
                break;
            }
            case START: 
            case JNDI_NAME: 
            case MODULE: {
                ParseUtils.ignoreAttribute(reader, index);
                break;
            }
            case SIMPLE_CACHE: {
                builder.simpleCache(ParseUtils.parseBoolean(reader, index, value));
                break;
            }
            case STATISTICS: {
                builder.statistics().enabled(ParseUtils.parseBoolean(reader, index, value));
                break;
            }
            case STATISTICS_AVAILABLE: {
                builder.statistics().available(ParseUtils.parseBoolean(reader, index, value));
                break;
            }
            case SPIN_DURATION: {
                if (reader.getSchema().since(10, 0)) {
                    throw ParseUtils.attributeRemoved(reader, index);
                }
                ParseUtils.ignoreAttribute(reader, index);
                break;
            }
            case UNRELIABLE_RETURN_VALUES: {
                builder.unsafe().unreliableReturnValues(ParseUtils.parseBoolean(reader, index, value));
                break;
            }
            default: {
                if (!ParseUtils.isNoNamespaceAttribute(reader, index)) break;
                throw ParseUtils.unexpectedAttribute(reader, index);
            }
        }
    }

    private void parseSharedStateCacheElement(ConfigurationReader reader, Element element, ConfigurationBuilderHolder holder) {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        switch (element) {
            case STATE_TRANSFER: {
                this.parseStateTransfer(reader, builder);
                break;
            }
            default: {
                this.parseCacheElement(reader, element, holder);
            }
        }
    }

    private void parseBackups(ConfigurationReader reader, ConfigurationBuilderHolder holder) {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        builder.sites().backups().clear();
        ParseUtils.parseAttributes(reader, builder.sites());
        while (reader.inTag()) {
            Map.Entry item = reader.getMapItem((Enum)Attribute.SITE);
            Element element = Element.forName((String)item.getValue());
            if (element != Element.BACKUP) {
                throw ParseUtils.unexpectedElement(reader);
            }
            this.parseBackup(reader, builder, (String)item.getKey());
            reader.endMapItem();
        }
    }

    private void parsePartitionHandling(ConfigurationReader reader, ConfigurationBuilderHolder holder) {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        PartitionHandlingConfigurationBuilder ph = builder.clustering().partitionHandling();
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case ENABLED: {
                    if (reader.getSchema().since(11, 0)) {
                        throw ParseUtils.attributeRemoved(reader, i, Attribute.WHEN_SPLIT.getLocalName());
                    }
                    ParseUtils.ignoreAttribute(reader, i);
                    continue block5;
                }
                case WHEN_SPLIT: {
                    ph.whenSplit(ParseUtils.parseEnum(reader, i, PartitionHandling.class, value));
                    continue block5;
                }
                case MERGE_POLICY: {
                    MergePolicy mp = MergePolicy.fromString(value);
                    MergePolicy mergePolicy = mp == MergePolicy.CUSTOM ? (EntryMergePolicy)Util.getInstance((String)value, (ClassLoader)holder.getClassLoader()) : mp;
                    ph.mergePolicy(mergePolicy);
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseBackup(ConfigurationReader reader, ConfigurationBuilder builder, String site) {
        BackupConfigurationBuilder backup = builder.sites().addBackup().site(site);
        ParseUtils.parseAttributes(reader, backup);
        if (backup.site() == null) {
            throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.SITE));
        }
        block4: while (reader.inTag()) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case TAKE_OFFLINE: {
                    this.parseTakeOffline(reader, backup);
                    continue block4;
                }
                case STATE_TRANSFER: {
                    this.parseXSiteStateTransfer(reader, backup);
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseTakeOffline(ConfigurationReader reader, BackupConfigurationBuilder backup) {
        ParseUtils.parseAttributes(reader, backup.takeOffline());
        ParseUtils.requireNoContent(reader);
    }

    private void parseXSiteStateTransfer(ConfigurationReader reader, BackupConfigurationBuilder backup) {
        ParseUtils.parseAttributes(reader, backup.stateTransfer());
        ParseUtils.requireNoContent(reader);
    }

    private void parseBackupFor(ConfigurationReader reader, ConfigurationBuilder builder) {
        builder.sites().backupFor().reset();
        ParseUtils.parseAttributes(reader, builder.sites().backupFor());
        ParseUtils.requireNoContent(reader);
    }

    private void parseCacheSecurity(ConfigurationReader reader, ConfigurationBuilder builder) {
        SecurityConfigurationBuilder securityBuilder = builder.security();
        ParseUtils.requireNoAttributes(reader);
        block3: while (reader.inTag()) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case AUTHORIZATION: {
                    this.parseCacheAuthorization(reader, securityBuilder.authorization().enable());
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseCacheAuthorization(ConfigurationReader reader, AuthorizationConfigurationBuilder authzBuilder) {
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case ENABLED: {
                    authzBuilder.enabled(Boolean.parseBoolean(reader.getAttributeValue(i)));
                    continue block4;
                }
                case ROLES: {
                    for (String role : reader.getListAttributeValue(i)) {
                        authzBuilder.role(role);
                    }
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    protected final void parseCacheElement(ConfigurationReader reader, Element element, ConfigurationBuilderHolder holder) {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        switch (element) {
            case LOCKING: {
                this.parseLocking(reader, builder);
                break;
            }
            case TRANSACTION: {
                this.parseTransaction(reader, builder, holder);
                break;
            }
            case EVICTION: {
                if (reader.getSchema().since(10, 0)) {
                    throw ParseUtils.elementRemoved(reader, Element.MEMORY.getLocalName());
                }
                this.parseEviction(reader, builder);
                break;
            }
            case EXPIRATION: {
                this.parseExpiration(reader, builder);
                break;
            }
            case ENCODING: {
                this.parseDataType(reader, builder, holder);
                break;
            }
            case PERSISTENCE: {
                this.parsePersistence(reader, holder);
                break;
            }
            case QUERY: {
                this.parseQuery(reader, holder);
                break;
            }
            case INDEXING: {
                this.parseIndexing(reader, holder);
                break;
            }
            case CUSTOM_INTERCEPTORS: {
                Log.CONFIG.customInterceptorsDeprecated();
                this.parseCustomInterceptors(reader, holder);
                break;
            }
            case VERSIONING: {
                this.parseVersioning(reader, holder);
                break;
            }
            case COMPATIBILITY: {
                if (reader.getSchema().since(10, 0)) break;
                this.parseCompatibility(reader, holder);
                break;
            }
            case STORE_AS_BINARY: {
                this.parseStoreAsBinary(reader, holder);
                break;
            }
            case MODULES: {
                if (reader.getSchema().since(9, 0)) {
                    throw ParseUtils.elementRemoved(reader);
                }
                this.parseModules(reader, holder);
                break;
            }
            case DATA_CONTAINER: {
                if (reader.getSchema().since(10, 0)) {
                    throw ParseUtils.elementRemoved(reader);
                }
                this.parseDataContainer(reader);
                break;
            }
            case MEMORY: {
                this.parseMemory(reader, holder);
                break;
            }
            case BACKUPS: {
                this.parseBackups(reader, holder);
                break;
            }
            case BACKUP_FOR: {
                this.parseBackupFor(reader, builder);
                break;
            }
            case PARTITION_HANDLING: {
                this.parsePartitionHandling(reader, holder);
                break;
            }
            case SECURITY: {
                this.parseCacheSecurity(reader, builder);
                break;
            }
            default: {
                reader.handleAny((ConfigurationReaderContext)holder);
            }
        }
    }

    private void parseDataContainer(ConfigurationReader reader) {
        ParseUtils.ignoreElement(reader, Element.DATA_CONTAINER);
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case CLASS: 
                case KEY_EQUIVALENCE: 
                case VALUE_EQUIVALENCE: {
                    ParseUtils.ignoreAttribute(reader, i);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        Properties properties = new Properties();
        block7: while (reader.inTag()) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROPERTY: {
                    ParseUtils.ignoreElement(reader, element);
                    CacheParser.parseProperty(reader, properties);
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseMemory(ConfigurationReader reader, ConfigurationBuilderHolder holder) {
        MemoryConfigurationBuilder memoryBuilder = holder.getCurrentConfigurationBuilder().memory();
        if (reader.getSchema().since(11, 0)) {
            ParseUtils.parseAttributes(reader, memoryBuilder);
        }
        if (reader.getSchema().since(15, 0)) {
            ParseUtils.requireNoContent(reader);
        } else {
            block5: while (reader.inTag()) {
                Element element = Element.forName(reader.getLocalName());
                Log.CONFIG.warnUsingDeprecatedMemoryConfigs(element.getLocalName());
                switch (element) {
                    case OFF_HEAP: {
                        memoryBuilder.storageType(StorageType.OFF_HEAP);
                        this.parseOffHeapMemoryAttributes(reader, holder);
                        continue block5;
                    }
                    case OBJECT: {
                        memoryBuilder.storageType(StorageType.OBJECT);
                        this.parseObjectMemoryAttributes(reader, holder);
                        continue block5;
                    }
                    case BINARY: {
                        memoryBuilder.storageType(StorageType.BINARY);
                        this.parseBinaryMemoryAttributes(reader, holder);
                        continue block5;
                    }
                }
                throw ParseUtils.unexpectedElement(reader);
            }
        }
    }

    private void parseOffHeapMemoryAttributes(ConfigurationReader reader, ConfigurationBuilderHolder holder) {
        MemoryConfigurationBuilder memoryBuilder = holder.getCurrentConfigurationBuilder().memory();
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case SIZE: {
                    memoryBuilder.size(ParseUtils.parseLong(reader, i, value));
                    continue block6;
                }
                case EVICTION: {
                    memoryBuilder.evictionType(ParseUtils.parseEnum(reader, i, EvictionType.class, value));
                    continue block6;
                }
                case ADDRESS_COUNT: {
                    if (reader.getSchema().since(10, 0)) {
                        throw ParseUtils.attributeRemoved(reader, i);
                    }
                    ParseUtils.ignoreAttribute(reader, i);
                    continue block6;
                }
                case STRATEGY: {
                    memoryBuilder.evictionStrategy(ParseUtils.parseEnum(reader, i, EvictionStrategy.class, value));
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseObjectMemoryAttributes(ConfigurationReader reader, ConfigurationBuilderHolder holder) {
        MemoryConfigurationBuilder memoryBuilder = holder.getCurrentConfigurationBuilder().memory();
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case SIZE: {
                    memoryBuilder.size(ParseUtils.parseLong(reader, i, value));
                    continue block4;
                }
                case STRATEGY: {
                    memoryBuilder.evictionStrategy(ParseUtils.parseEnum(reader, i, EvictionStrategy.class, value));
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseBinaryMemoryAttributes(ConfigurationReader reader, ConfigurationBuilderHolder holder) {
        MemoryConfigurationBuilder memoryBuilder = holder.getCurrentConfigurationBuilder().memory();
        ParseUtils.parseAttributes(reader, memoryBuilder.legacyBuilder());
        ParseUtils.requireNoContent(reader);
    }

    private void parseStoreAsBinary(ConfigurationReader reader, ConfigurationBuilderHolder holder) {
        Log.CONFIG.configDeprecatedUseOther(Element.STORE_AS_BINARY, Element.MEMORY, reader.getLocation());
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        Boolean binaryKeys = null;
        Boolean binaryValues = null;
        builder.memory().storageType(StorageType.BINARY);
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case STORE_KEYS_AS_BINARY: {
                    binaryKeys = ParseUtils.parseBoolean(reader, i, value);
                    continue block4;
                }
                case STORE_VALUES_AS_BINARY: {
                    binaryValues = ParseUtils.parseBoolean(reader, i, value);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (binaryKeys != null && !binaryKeys.booleanValue() && binaryValues != null && !binaryValues.booleanValue()) {
            builder.memory().storageType(StorageType.OBJECT);
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseCompatibility(ConfigurationReader reader, ConfigurationBuilderHolder holder) {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        EncodingConfigurationBuilder encoding = builder.encoding();
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case ENABLED: {
                    if (!ParseUtils.parseBoolean(reader, i, value)) continue block4;
                    encoding.key().mediaType("application/x-java-object");
                    encoding.value().mediaType("application/x-java-object");
                    continue block4;
                }
                case MARSHALLER: {
                    Log.CONFIG.marshallersNotSupported();
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseVersioning(ConfigurationReader reader, ConfigurationBuilderHolder holder) {
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case VERSIONING_SCHEME: {
                    if (reader.getSchema().since(10, 0)) {
                        throw ParseUtils.attributeRemoved(reader, i);
                    }
                    Log.CONFIG.ignoredAttribute("versioning", "9.0", attribute.getLocalName(), reader.getLocation().getLineNumber());
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseCustomInterceptors(ConfigurationReader reader, ConfigurationBuilderHolder holder) {
        ParseUtils.requireNoAttributes(reader);
        while (reader.inTag()) {
            Map.Entry item = reader.getMapItem((Enum)Attribute.CLASS);
            Element element = Element.forName((String)item.getValue());
            switch (element) {
                case INTERCEPTOR: {
                    this.parseInterceptor(reader, holder, (String)item.getKey());
                    break;
                }
                default: {
                    throw ParseUtils.unexpectedElement(reader);
                }
            }
            reader.endMapItem();
        }
    }

    private void parseInterceptor(ConfigurationReader reader, ConfigurationBuilderHolder holder, String klass) {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        InterceptorConfigurationBuilder interceptorBuilder = builder.customInterceptors().addInterceptor();
        interceptorBuilder.interceptorClass(Util.loadClass((String)klass, (ClassLoader)holder.getClassLoader()));
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case AFTER: {
                    interceptorBuilder.after(Util.loadClass((String)value, (ClassLoader)holder.getClassLoader()));
                    continue block7;
                }
                case BEFORE: {
                    interceptorBuilder.before(Util.loadClass((String)value, (ClassLoader)holder.getClassLoader()));
                    continue block7;
                }
                case CLASS: {
                    continue block7;
                }
                case INDEX: {
                    interceptorBuilder.index(ParseUtils.parseInt(reader, i, value));
                    continue block7;
                }
                case POSITION: {
                    interceptorBuilder.position(InterceptorConfiguration.Position.valueOf(value.toUpperCase()));
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        interceptorBuilder.withProperties(CacheParser.parseProperties(reader, Element.INTERCEPTOR));
    }

    private void parseLocking(ConfigurationReader reader, ConfigurationBuilder builder) {
        ParseUtils.parseAttributes(reader, builder.locking());
        ParseUtils.requireNoContent(reader);
    }

    private void parseTransaction(ConfigurationReader reader, ConfigurationBuilder builder, ConfigurationBuilderHolder holder) {
        CacheMode cacheMode;
        if (!reader.getSchema().since(9, 0) && !(cacheMode = builder.clustering().cacheMode()).isSynchronous()) {
            Log.CONFIG.unsupportedAsyncCacheMode(cacheMode, cacheMode.toSync());
            builder.clustering().cacheMode(cacheMode.toSync());
        }
        block12: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case STOP_TIMEOUT: {
                    builder.transaction().cacheStopTimeout(ParseUtils.parseLong(reader, i, value));
                    continue block12;
                }
                case MODE: {
                    TransactionMode txMode = ParseUtils.parseEnum(reader, i, TransactionMode.class, value);
                    builder.transaction().transactionMode(txMode.getMode());
                    builder.transaction().useSynchronization(!txMode.isXAEnabled() && txMode.getMode().isTransactional());
                    builder.transaction().recovery().enabled(txMode.isRecoveryEnabled());
                    builder.invocationBatching().enable(txMode.isBatchingEnabled());
                    continue block12;
                }
                case LOCKING: {
                    builder.transaction().lockingMode(ParseUtils.parseEnum(reader, i, LockingMode.class, value));
                    continue block12;
                }
                case TRANSACTION_MANAGER_LOOKUP_CLASS: {
                    builder.transaction().transactionManagerLookup((TransactionManagerLookup)Util.getInstance((String)value, (ClassLoader)holder.getClassLoader()));
                    continue block12;
                }
                case REAPER_WAKE_UP_INTERVAL: {
                    builder.transaction().reaperWakeUpInterval(ParseUtils.parseLong(reader, i, value));
                    continue block12;
                }
                case COMPLETED_TX_TIMEOUT: {
                    builder.transaction().completedTxTimeout(ParseUtils.parseLong(reader, i, value));
                    continue block12;
                }
                case TRANSACTION_PROTOCOL: {
                    if (reader.getSchema().since(11, 0)) {
                        throw ParseUtils.attributeRemoved(reader, i);
                    }
                    Log.CONFIG.ignoredAttribute("transaction protocol", "11.0", attribute.getLocalName(), reader.getLocation().getLineNumber());
                    continue block12;
                }
                case AUTO_COMMIT: {
                    builder.transaction().autoCommit(ParseUtils.parseBoolean(reader, i, value));
                    continue block12;
                }
                case RECOVERY_INFO_CACHE_NAME: {
                    builder.transaction().recovery().recoveryInfoCacheName(value);
                    continue block12;
                }
                case NOTIFICATIONS: {
                    builder.transaction().notifications(ParseUtils.parseBoolean(reader, i, value));
                    continue block12;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private final void parseDataType(ConfigurationReader reader, ConfigurationBuilder builder, ConfigurationBuilderHolder holder) {
        EncodingConfigurationBuilder encodingBuilder = builder.encoding();
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            if (attribute != Attribute.MEDIA_TYPE || !reader.getSchema().since(11, 0)) {
                throw ParseUtils.unexpectedAttribute(reader, i);
            }
            encodingBuilder.mediaType(value);
        }
        block5: while (reader.inTag()) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case KEY_DATA_TYPE: {
                    ContentTypeConfigurationBuilder keyBuilder = encodingBuilder.key();
                    this.parseContentType(reader, holder, keyBuilder);
                    ParseUtils.requireNoContent(reader);
                    continue block5;
                }
                case VALUE_DATA_TYPE: {
                    ContentTypeConfigurationBuilder valueBuilder = encodingBuilder.value();
                    this.parseContentType(reader, holder, valueBuilder);
                    ParseUtils.requireNoContent(reader);
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseContentType(ConfigurationReader reader, ConfigurationBuilderHolder holder, ContentTypeConfigurationBuilder builder) {
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case MEDIA_TYPE: {
                    builder.mediaType(value);
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
    }

    private void parseEviction(ConfigurationReader reader, ConfigurationBuilder builder) {
        Log.CONFIG.configDeprecatedUseOther(Element.EVICTION, Element.MEMORY, reader.getLocation());
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case STRATEGY: 
                case THREAD_POLICY: 
                case TYPE: {
                    ParseUtils.ignoreAttribute(reader, i);
                    continue block4;
                }
                case SIZE: 
                case MAX_ENTRIES: {
                    long size = ParseUtils.parseLong(reader, i, value);
                    if (size < 0L) continue block4;
                    builder.memory().size(size);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseExpiration(ConfigurationReader reader, ConfigurationBuilder builder) {
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case MAX_IDLE: {
                    builder.expiration().maxIdle(ParseUtils.parseLong(reader, i, value));
                    continue block6;
                }
                case LIFESPAN: {
                    builder.expiration().lifespan(ParseUtils.parseLong(reader, i, value));
                    continue block6;
                }
                case INTERVAL: {
                    builder.expiration().wakeUpInterval(ParseUtils.parseLong(reader, i, value));
                    continue block6;
                }
                case TOUCH: {
                    if (reader.getSchema().since(12, 1)) {
                        builder.expiration().touch(ParseUtils.parseEnum(reader, i, TouchMode.class, value));
                        continue block6;
                    }
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    protected void parseInvalidationCache(ConfigurationReader reader, ConfigurationBuilderHolder holder, String name, boolean template) {
        holder.pushScope(template ? ParserScope.CACHE_TEMPLATE : ParserScope.CACHE);
        if (!template && GlobUtils.isGlob((String)name)) {
            throw Log.CONFIG.wildcardsNotAllowedInCacheNames(name);
        }
        String configuration = reader.getAttributeValue(Attribute.CONFIGURATION.getLocalName());
        ConfigurationBuilder builder = this.getConfigurationBuilder(reader, holder, name, template, configuration);
        CacheMode baseCacheMode = configuration == null ? CacheMode.INVALIDATION_SYNC : CacheMode.INVALIDATION_SYNC.toSync(builder.clustering().cacheMode().isSynchronous());
        builder.clustering().cacheMode(baseCacheMode);
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case KEY_PARTITIONER: {
                    builder.clustering().hash().keyPartitioner((KeyPartitioner)Util.getInstance((String)value, (ClassLoader)holder.getClassLoader()));
                    continue block5;
                }
                default: {
                    this.parseClusteredCacheAttribute(reader, i, attribute, value, builder, baseCacheMode);
                }
            }
        }
        while (reader.inTag()) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                default: 
            }
            this.parseCacheElement(reader, element, holder);
        }
        holder.popScope();
    }

    private void parseSegmentedCacheAttribute(ConfigurationReader reader, int index, Attribute attribute, String value, ConfigurationBuilder builder, ClassLoader classLoader, CacheMode baseCacheMode) {
        switch (attribute) {
            case SEGMENTS: {
                builder.clustering().hash().numSegments(ParseUtils.parseInt(reader, index, value));
                break;
            }
            case CONSISTENT_HASH_FACTORY: {
                if (reader.getSchema().since(11, 0)) {
                    Log.CONFIG.debug("Consistent hash customization has been deprecated and will be removed");
                }
                builder.clustering().hash().consistentHashFactory((ConsistentHashFactory)Util.getInstance((String)value, (ClassLoader)classLoader));
                break;
            }
            case KEY_PARTITIONER: {
                if (reader.getSchema().since(8, 2)) {
                    builder.clustering().hash().keyPartitioner((KeyPartitioner)Util.getInstance((String)value, (ClassLoader)classLoader));
                    break;
                }
                throw ParseUtils.unexpectedAttribute(reader, index);
            }
            default: {
                this.parseClusteredCacheAttribute(reader, index, attribute, value, builder, baseCacheMode);
            }
        }
    }

    private void parseClusteredCacheAttribute(ConfigurationReader reader, int index, Attribute attribute, String value, ConfigurationBuilder builder, CacheMode baseCacheMode) {
        switch (attribute) {
            case ASYNC_MARSHALLING: {
                if (reader.getSchema().since(9, 0)) {
                    throw ParseUtils.attributeRemoved(reader, index);
                }
                Log.CONFIG.ignoredReplicationQueueAttribute(attribute.getLocalName(), reader.getLocation().getLineNumber());
                break;
            }
            case MODE: {
                Mode mode = ParseUtils.parseEnum(reader, index, Mode.class, value);
                builder.clustering().cacheMode(mode.apply(baseCacheMode));
                break;
            }
            case QUEUE_SIZE: 
            case QUEUE_FLUSH_INTERVAL: {
                if (reader.getSchema().since(11, 0)) {
                    throw ParseUtils.attributeRemoved(reader, index);
                }
                Log.CONFIG.ignoredReplicationQueueAttribute(attribute.getLocalName(), reader.getLocation().getLineNumber());
                break;
            }
            case REMOTE_TIMEOUT: {
                builder.clustering().remoteTimeout(ParseUtils.parseLong(reader, index, value));
                break;
            }
            default: {
                this.parseCacheAttribute(reader, index, attribute, value, builder);
            }
        }
    }

    protected void parseReplicatedCache(ConfigurationReader reader, ConfigurationBuilderHolder holder, String name, boolean template) {
        holder.pushScope(template ? ParserScope.CACHE_TEMPLATE : ParserScope.CACHE);
        if (!template && GlobUtils.isGlob((String)name)) {
            throw Log.CONFIG.wildcardsNotAllowedInCacheNames(name);
        }
        String configuration = reader.getAttributeValue(Attribute.CONFIGURATION.getLocalName());
        ConfigurationBuilder builder = this.getConfigurationBuilder(reader, holder, name, template, configuration);
        CacheMode baseCacheMode = configuration == null ? CacheMode.REPL_SYNC : CacheMode.REPL_SYNC.toSync(builder.clustering().cacheMode().isSynchronous());
        builder.clustering().cacheMode(baseCacheMode);
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            this.parseSegmentedCacheAttribute(reader, i, attribute, value, builder, holder.getClassLoader(), baseCacheMode);
        }
        while (reader.inTag()) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                default: 
            }
            this.parseSharedStateCacheElement(reader, element, holder);
        }
        holder.popScope();
    }

    private void parseStateTransfer(ConfigurationReader reader, ConfigurationBuilder builder) {
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case AWAIT_INITIAL_TRANSFER: {
                    builder.clustering().stateTransfer().awaitInitialTransfer(ParseUtils.parseBoolean(reader, i, value));
                    continue block6;
                }
                case ENABLED: {
                    builder.clustering().stateTransfer().fetchInMemoryState(ParseUtils.parseBoolean(reader, i, value));
                    continue block6;
                }
                case TIMEOUT: {
                    builder.clustering().stateTransfer().timeout(ParseUtils.parseLong(reader, i, value));
                    continue block6;
                }
                case CHUNK_SIZE: {
                    builder.clustering().stateTransfer().chunkSize(ParseUtils.parseInt(reader, i, value));
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    protected void parseDistributedCache(ConfigurationReader reader, ConfigurationBuilderHolder holder, String name, boolean template) {
        holder.pushScope(template ? ParserScope.CACHE_TEMPLATE : ParserScope.CACHE);
        if (!template && GlobUtils.isGlob((String)name)) {
            throw Log.CONFIG.wildcardsNotAllowedInCacheNames(name);
        }
        String configuration = reader.getAttributeValue(Attribute.CONFIGURATION.getLocalName());
        ConfigurationBuilder builder = this.getConfigurationBuilder(reader, holder, name, template, configuration);
        CacheMode baseCacheMode = configuration == null ? CacheMode.DIST_SYNC : CacheMode.DIST_SYNC.toSync(builder.clustering().cacheMode().isSynchronous());
        builder.clustering().cacheMode(baseCacheMode);
        block10: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case OWNERS: {
                    builder.clustering().hash().numOwners(ParseUtils.parseInt(reader, i, value));
                    continue block10;
                }
                case L1_LIFESPAN: {
                    long lifespan = ParseUtils.parseLong(reader, i, value);
                    if (lifespan > 0L) {
                        builder.clustering().l1().enable().lifespan(lifespan);
                        continue block10;
                    }
                    builder.clustering().l1().disable();
                    continue block10;
                }
                case INVALIDATION_CLEANUP_TASK_FREQUENCY: {
                    builder.clustering().l1().cleanupTaskFrequency(ParseUtils.parseLong(reader, i, value));
                    continue block10;
                }
                case CAPACITY: {
                    if (reader.getSchema().since(13, 0)) {
                        throw Log.CONFIG.attributeRemoved(Attribute.CAPACITY.getLocalName(), reader.getLocation());
                    }
                    Log.CONFIG.configDeprecatedUseOther(Attribute.CAPACITY, Attribute.CAPACITY_FACTOR, reader.getLocation());
                }
                case CAPACITY_FACTOR: {
                    builder.clustering().hash().capacityFactor(Float.parseFloat(value));
                    continue block10;
                }
                default: {
                    this.parseSegmentedCacheAttribute(reader, i, attribute, value, builder, holder.getClassLoader(), baseCacheMode);
                }
            }
        }
        block11: while (reader.inTag()) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case GROUPS: {
                    this.parseGroups(reader, holder);
                    continue block11;
                }
            }
            this.parseSharedStateCacheElement(reader, element, holder);
        }
        holder.popScope();
    }

    private void parseGroups(ConfigurationReader reader, ConfigurationBuilderHolder holder) {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        GroupsConfigurationBuilder groups = builder.clustering().hash().groups();
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case ENABLED: {
                    if (ParseUtils.parseBoolean(reader, i, value)) {
                        groups.enabled();
                        continue block7;
                    }
                    groups.disabled();
                    continue block7;
                }
                case GROUPER: {
                    for (String grouper : reader.getListAttributeValue(i)) {
                        groups.addGrouper((Grouper)Util.getInstance((String)grouper, (ClassLoader)holder.getClassLoader()));
                    }
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        block9: while (reader.inTag()) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case GROUPER: {
                    if (reader.getAttributeCount() == 1) {
                        groups.addGrouper((Grouper)Util.getInstance((String)ParseUtils.readStringAttributeElement(reader, "class"), (ClassLoader)holder.getClassLoader()));
                        continue block9;
                    }
                    groups.addGrouper((Grouper)Util.getInstance((String)reader.getElementText(), (ClassLoader)holder.getClassLoader()));
                    reader.nextElement();
                    continue block9;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    protected void parseScatteredCache(ConfigurationReader reader, ConfigurationBuilderHolder holder, String name, boolean template) {
        if (!template && GlobUtils.isGlob((String)name)) {
            throw Log.CONFIG.wildcardsNotAllowedInCacheNames(name);
        }
        String configuration = reader.getAttributeValue(Attribute.CONFIGURATION.getLocalName());
        ConfigurationBuilder builder = this.getConfigurationBuilder(reader, holder, name, template, configuration);
        CacheMode baseCacheMode = configuration == null ? CacheMode.SCATTERED_SYNC : CacheMode.SCATTERED_SYNC.toSync(builder.clustering().cacheMode().isSynchronous());
        ClusteringConfigurationBuilder clusteringBuilder = builder.clustering();
        clusteringBuilder.cacheMode(baseCacheMode);
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case INVALIDATION_BATCH_SIZE: {
                    clusteringBuilder.invalidationBatchSize(ParseUtils.parseInt(reader, i, value));
                    continue block7;
                }
                case BIAS_ACQUISITION: {
                    clusteringBuilder.biasAcquisition(ParseUtils.parseEnum(reader, i, BiasAcquisition.class, value));
                    continue block7;
                }
                case BIAS_LIFESPAN: {
                    clusteringBuilder.biasLifespan(ParseUtils.parseLong(reader, i, value), TimeUnit.MILLISECONDS);
                    continue block7;
                }
                default: {
                    this.parseSegmentedCacheAttribute(reader, i, attribute, value, builder, holder.getClassLoader(), baseCacheMode);
                }
            }
        }
        while (reader.inTag()) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                default: 
            }
            this.parseSharedStateCacheElement(reader, element, holder);
        }
    }

    private ConfigurationBuilder getConfigurationBuilder(ConfigurationReader reader, ConfigurationBuilderHolder holder, String name, boolean template, String baseConfigurationName) {
        if (holder.getNamedConfigurationBuilders().containsKey(name)) {
            throw Log.CONFIG.duplicateCacheName(name);
        }
        boolean ignoreMissingTemplates = reader.getProperty(IGNORE_MISSING_TEMPLATES) != null;
        ConfigurationBuilder builder = holder.newConfigurationBuilder(name);
        if (baseConfigurationName != null) {
            Configuration baseConfiguration;
            ConfigurationBuilder baseConfigurationBuilder = holder.getNamedConfigurationBuilders().get(baseConfigurationName);
            if (baseConfigurationBuilder == null) {
                if (ignoreMissingTemplates) {
                    baseConfigurationBuilder = new ConfigurationBuilder().template(true);
                } else {
                    throw Log.CONFIG.undeclaredConfiguration(baseConfigurationName, name);
                }
            }
            if (!(baseConfiguration = baseConfigurationBuilder.build()).isTemplate()) {
                throw Log.CONFIG.noConfiguration(baseConfigurationName);
            }
            builder.read(baseConfiguration);
            if (ignoreMissingTemplates) {
                builder.configuration(baseConfigurationName);
            }
        }
        return builder.template(template);
    }

    private void parsePersistence(ConfigurationReader reader, ConfigurationBuilderHolder holder) {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        ParseUtils.parseAttributes(reader, builder.persistence());
        builder.persistence().clearStores();
        block7: while (reader.inTag()) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case CLUSTER_LOADER: {
                    Log.CONFIG.warnUsingDeprecatedClusterLoader();
                    this.parseClusterLoader(reader, holder);
                    continue block7;
                }
                case FILE_STORE: {
                    this.parseFileStore(reader, holder);
                    continue block7;
                }
                case STORE: {
                    this.parseCustomStore(reader, holder);
                    continue block7;
                }
                case LOADER: {
                    ParseUtils.ignoreElement(reader, element);
                    continue block7;
                }
                case SINGLE_FILE_STORE: {
                    Log.CONFIG.warnUsingDeprecatedClusterLoader();
                    this.parseSingleFileStore(reader, holder);
                    continue block7;
                }
            }
            reader.handleAny((ConfigurationReaderContext)holder);
        }
    }

    private void parseClusterLoader(ConfigurationReader reader, ConfigurationBuilderHolder holder) {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        ClusterLoaderConfigurationBuilder cclb = builder.persistence().addClusterLoader();
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            String attrName = reader.getAttributeName(i);
            Attribute attribute = Attribute.forName(attrName);
            switch (attribute) {
                case REMOTE_TIMEOUT: {
                    cclb.remoteCallTimeout(ParseUtils.parseLong(reader, i, value));
                    continue block3;
                }
                default: {
                    CacheParser.parseStoreAttribute(reader, i, cclb);
                }
            }
        }
        this.parseStoreElements(reader, cclb);
    }

    protected void parseFileStore(ConfigurationReader reader, ConfigurationBuilderHolder holder) {
        SoftIndexFileStoreConfigurationBuilder actualStoreConfig;
        SoftIndexFileStoreConfigurationBuilder fileStoreBuilder = null;
        PersistenceConfigurationBuilder persistence = holder.getCurrentConfigurationBuilder().persistence();
        int majorSchema = reader.getSchema().getMajor();
        boolean legacyFileStore = false;
        if (majorSchema < 13) {
            this.parseSingleFileStore(reader, holder);
            return;
        }
        if (majorSchema == 13) {
            actualStoreConfig = fileStoreBuilder = (SoftIndexFileStoreConfigurationBuilder)persistence.addStore(SFSToSIFSConfigurationBuilder.class);
            legacyFileStore = true;
        } else {
            actualStoreConfig = fileStoreBuilder = persistence.addSoftIndexFileStore();
        }
        block12: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case RELATIVE_TO: {
                    if (reader.getSchema().since(11, 0)) {
                        throw ParseUtils.attributeRemoved(reader, i);
                    }
                    ParseUtils.ignoreAttribute(reader, i);
                    continue block12;
                }
                case PATH: {
                    fileStoreBuilder.dataLocation(value);
                    fileStoreBuilder.indexLocation(value);
                    continue block12;
                }
                case MAX_ENTRIES: 
                case FRAGMENTATION_FACTOR: {
                    if (legacyFileStore) {
                        ParseUtils.ignoreAttribute(reader, i);
                        continue block12;
                    }
                    throw ParseUtils.attributeRemoved(reader, i);
                }
                case OPEN_FILES_LIMIT: {
                    if (fileStoreBuilder != null) {
                        fileStoreBuilder.openFilesLimit(ParseUtils.parseInt(reader, i, value));
                        continue block12;
                    }
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
                case COMPACTION_THRESHOLD: {
                    if (fileStoreBuilder != null) {
                        fileStoreBuilder.compactionThreshold(Double.parseDouble(value));
                        continue block12;
                    }
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
                case PURGE: {
                    actualStoreConfig.purgeOnStartup(ParseUtils.parseBoolean(reader, i, value));
                    continue block12;
                }
                default: {
                    CacheParser.parseStoreAttribute(reader, i, actualStoreConfig);
                }
            }
        }
        block13: while (reader.inTag()) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case DATA: {
                    if (fileStoreBuilder != null) {
                        this.parseData(reader, fileStoreBuilder);
                        continue block13;
                    }
                    throw ParseUtils.unexpectedElement(reader);
                }
                case INDEX: {
                    if (fileStoreBuilder != null) {
                        this.parseIndex(reader, fileStoreBuilder);
                        continue block13;
                    }
                    throw ParseUtils.unexpectedElement(reader);
                }
            }
            CacheParser.parseStoreElement(reader, actualStoreConfig);
        }
    }

    private void parseData(ConfigurationReader reader, SoftIndexFileStoreConfigurationBuilder builder) {
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case PATH: {
                    builder.dataLocation(value);
                    continue block6;
                }
                case RELATIVE_TO: {
                    if (reader.getSchema().since(13, 0)) {
                        throw ParseUtils.attributeRemoved(reader, i);
                    }
                    ParseUtils.ignoreAttribute(reader, i);
                    continue block6;
                }
                case MAX_FILE_SIZE: {
                    builder.maxFileSize(ParseUtils.parseInt(reader, i, value));
                    continue block6;
                }
                case SYNC_WRITES: {
                    builder.syncWrites(ParseUtils.parseBoolean(reader, i, value));
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseIndex(ConfigurationReader reader, SoftIndexFileStoreConfigurationBuilder builder) {
        block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case PATH: {
                    builder.indexLocation(value);
                    continue block8;
                }
                case RELATIVE_TO: {
                    if (reader.getSchema().since(13, 0)) {
                        throw ParseUtils.attributeRemoved(reader, i);
                    }
                    ParseUtils.ignoreAttribute(reader, i);
                    continue block8;
                }
                case SEGMENTS: {
                    builder.indexSegments(ParseUtils.parseInt(reader, i, value));
                    continue block8;
                }
                case INDEX_QUEUE_LENGTH: {
                    builder.indexQueueLength(ParseUtils.parseInt(reader, i, value));
                    continue block8;
                }
                case MIN_NODE_SIZE: {
                    builder.minNodeSize(ParseUtils.parseInt(reader, i, value));
                    continue block8;
                }
                case MAX_NODE_SIZE: {
                    builder.maxNodeSize(ParseUtils.parseInt(reader, i, value));
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    protected void parseSingleFileStore(ConfigurationReader reader, ConfigurationBuilderHolder holder) {
        SingleFileStoreConfigurationBuilder storeBuilder = holder.getCurrentConfigurationBuilder().persistence().addSingleFileStore();
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case RELATIVE_TO: {
                    if (reader.getSchema().since(11, 0)) {
                        throw ParseUtils.attributeRemoved(reader, i);
                    }
                    ParseUtils.ignoreAttribute(reader, i);
                    continue block6;
                }
                case PATH: {
                    storeBuilder.location(value);
                    continue block6;
                }
                case MAX_ENTRIES: {
                    storeBuilder.maxEntries(ParseUtils.parseInt(reader, i, value));
                    continue block6;
                }
                case FRAGMENTATION_FACTOR: {
                    storeBuilder.fragmentationFactor(Float.parseFloat(value));
                    continue block6;
                }
                default: {
                    CacheParser.parseStoreAttribute(reader, i, storeBuilder);
                }
            }
        }
        this.parseStoreElements(reader, storeBuilder);
    }

    public static void parseStoreAttribute(ConfigurationReader reader, int index, AbstractStoreConfigurationBuilder<?, ?> storeBuilder) {
        if (reader.getSchema().getMajor() < 10) {
            storeBuilder.segmented(false);
        }
        String value = reader.getAttributeValue(index);
        Attribute attribute = Attribute.forName(reader.getAttributeName(index));
        switch (attribute) {
            case SHARED: {
                storeBuilder.shared(ParseUtils.parseBoolean(reader, index, value));
                break;
            }
            case READ_ONLY: {
                storeBuilder.ignoreModifications(ParseUtils.parseBoolean(reader, index, value));
                break;
            }
            case PRELOAD: {
                storeBuilder.preload(ParseUtils.parseBoolean(reader, index, value));
                break;
            }
            case FETCH_STATE: {
                if (reader.getSchema().since(14, 0)) {
                    throw ParseUtils.attributeRemoved(reader, index);
                }
                ParseUtils.ignoreAttribute(reader, index);
                break;
            }
            case PURGE: {
                storeBuilder.purgeOnStartup(ParseUtils.parseBoolean(reader, index, value));
                break;
            }
            case SINGLETON: {
                if (reader.getSchema().since(10, 0)) {
                    throw ParseUtils.attributeRemoved(reader, index);
                }
                ParseUtils.ignoreAttribute(reader, index);
                break;
            }
            case TRANSACTIONAL: {
                storeBuilder.transactional(ParseUtils.parseBoolean(reader, index, value));
                break;
            }
            case MAX_BATCH_SIZE: {
                storeBuilder.maxBatchSize(ParseUtils.parseInt(reader, index, value));
                break;
            }
            case SEGMENTED: {
                storeBuilder.segmented(ParseUtils.parseBoolean(reader, index, value));
                break;
            }
            default: {
                throw ParseUtils.unexpectedAttribute(reader, index);
            }
        }
    }

    private void parseStoreElements(ConfigurationReader reader, StoreConfigurationBuilder<?, ?> storeBuilder) {
        while (reader.inTag()) {
            CacheParser.parseStoreElement(reader, storeBuilder);
        }
    }

    public static void parseStoreElement(ConfigurationReader reader, StoreConfigurationBuilder<?, ?> storeBuilder) {
        Element element = Element.forName(reader.getLocalName());
        switch (element) {
            case WRITE_BEHIND: {
                CacheParser.parseStoreWriteBehind(reader, storeBuilder.async().enable());
                break;
            }
            case PROPERTY: {
                CacheParser.parseStoreProperty(reader, storeBuilder);
                break;
            }
            case PROPERTIES: {
                CacheParser.parseStoreProperties(reader, storeBuilder);
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement(reader);
            }
        }
    }

    public static void parseStoreWriteBehind(ConfigurationReader reader, AsyncStoreConfigurationBuilder<?> storeBuilder) {
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case FLUSH_LOCK_TIMEOUT: 
                case SHUTDOWN_TIMEOUT: {
                    if (reader.getSchema().since(9, 0)) {
                        throw ParseUtils.attributeRemoved(reader, i);
                    }
                    ParseUtils.ignoreAttribute(reader, i);
                    continue block6;
                }
                case MODIFICATION_QUEUE_SIZE: {
                    storeBuilder.modificationQueueSize(ParseUtils.parseInt(reader, i, value));
                    continue block6;
                }
                case FAIL_SILENTLY: {
                    storeBuilder.failSilently(ParseUtils.parseBoolean(reader, i, value));
                    continue block6;
                }
                case THREAD_POOL_SIZE: {
                    if (reader.getSchema().since(11, 0)) {
                        throw ParseUtils.attributeRemoved(reader, i);
                    }
                    ParseUtils.ignoreAttribute(reader, i);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    public static void parseStoreProperty(ConfigurationReader reader, StoreConfigurationBuilder<?, ?> storeBuilder) {
        String property = ParseUtils.requireSingleAttribute(reader, Attribute.NAME.getLocalName());
        String value = reader.getElementText();
        storeBuilder.addProperty(property, value);
    }

    public static void parseStoreProperties(ConfigurationReader reader, StoreConfigurationBuilder<?, ?> storeBuilder) {
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            storeBuilder.addProperty(reader.getAttributeName(i, NamingStrategy.IDENTITY), reader.getAttributeValue(i));
        }
        while (reader.inTag()) {
            Element element = Element.forName(reader.getLocalName());
            if (element != Element.PROPERTY) {
                throw ParseUtils.unexpectedElement(reader, element);
            }
            CacheParser.parseStoreProperty(reader, storeBuilder);
        }
    }

    private void parseCustomStore(ConfigurationReader reader, ConfigurationBuilderHolder holder) {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        Boolean fetchPersistentState = null;
        Boolean ignoreModifications = null;
        Boolean purgeOnStartup = null;
        Boolean preload = null;
        Boolean shared = null;
        Boolean transactional = null;
        Boolean segmented = null;
        Object store = null;
        block11: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case CLASS: {
                    store = Util.getInstance((String)value, (ClassLoader)holder.getClassLoader());
                    continue block11;
                }
                case FETCH_STATE: {
                    fetchPersistentState = ParseUtils.parseBoolean(reader, i, value);
                    continue block11;
                }
                case READ_ONLY: {
                    ignoreModifications = ParseUtils.parseBoolean(reader, i, value);
                    continue block11;
                }
                case PURGE: {
                    purgeOnStartup = ParseUtils.parseBoolean(reader, i, value);
                    continue block11;
                }
                case PRELOAD: {
                    preload = ParseUtils.parseBoolean(reader, i, value);
                    continue block11;
                }
                case SHARED: {
                    shared = ParseUtils.parseBoolean(reader, i, value);
                    continue block11;
                }
                case SINGLETON: {
                    if (reader.getSchema().since(10, 0)) {
                        throw ParseUtils.attributeRemoved(reader, i);
                    }
                    ParseUtils.ignoreAttribute(reader, i);
                    continue block11;
                }
                case TRANSACTIONAL: {
                    transactional = ParseUtils.parseBoolean(reader, i, value);
                    continue block11;
                }
                case SEGMENTED: {
                    segmented = ParseUtils.parseBoolean(reader, i, value);
                    continue block11;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (store != null) {
            if (store instanceof SingleFileStore) {
                SingleFileStoreConfigurationBuilder sfs = builder.persistence().addSingleFileStore();
                if (fetchPersistentState != null) {
                    sfs.fetchPersistentState(fetchPersistentState);
                }
                if (ignoreModifications != null) {
                    sfs.ignoreModifications(ignoreModifications);
                }
                if (purgeOnStartup != null) {
                    sfs.purgeOnStartup(purgeOnStartup);
                }
                if (preload != null) {
                    sfs.preload(preload);
                }
                if (shared != null) {
                    sfs.shared(shared);
                }
                if (transactional != null) {
                    sfs.transactional(transactional);
                }
                if (segmented != null) {
                    sfs.segmented(segmented);
                }
                this.parseStoreElements(reader, sfs);
            } else if (store instanceof ClusterLoader) {
                ClusterLoaderConfigurationBuilder cscb = builder.persistence().addClusterLoader();
                this.parseStoreElements(reader, cscb);
            } else {
                Class configuredBy;
                ConfiguredBy annotation = store.getClass().getAnnotation(ConfiguredBy.class);
                Class<StoreConfigurationBuilder> builderClass = null;
                if (annotation != null && (configuredBy = annotation.value()) != null) {
                    BuiltBy builtBy = configuredBy.getAnnotation(BuiltBy.class);
                    builderClass = builtBy.value().asSubclass(StoreConfigurationBuilder.class);
                }
                Object configBuilder = builderClass == null ? builder.persistence().addStore(CustomStoreConfigurationBuilder.class).customStoreClass(store.getClass()) : builder.persistence().addStore(builderClass);
                if (fetchPersistentState != null) {
                    configBuilder.fetchPersistentState(fetchPersistentState.booleanValue());
                }
                if (ignoreModifications != null) {
                    configBuilder.ignoreModifications(ignoreModifications.booleanValue());
                }
                if (purgeOnStartup != null) {
                    configBuilder.purgeOnStartup(purgeOnStartup.booleanValue());
                }
                if (preload != null) {
                    configBuilder.preload(preload.booleanValue());
                }
                if (shared != null) {
                    configBuilder.shared(shared.booleanValue());
                }
                if (transactional != null) {
                    configBuilder.transactional(transactional.booleanValue());
                }
                if (segmented != null) {
                    configBuilder.segmented(segmented.booleanValue());
                }
                this.parseStoreElements(reader, (StoreConfigurationBuilder<?, ?>)configBuilder);
            }
        }
    }

    private void parseQuery(ConfigurationReader reader, ConfigurationBuilderHolder holder) {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case DEFAULT_MAX_RESULTS: {
                    builder.query().defaultMaxResults(ParseUtils.parseInt(reader, i, value));
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (reader.inTag()) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                default: 
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseIndexing(ConfigurationReader reader, ConfigurationBuilderHolder holder) {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        boolean selfEnable = reader.getSchema().since(11, 0);
        block16: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case ENABLED: {
                    if (reader.getSchema().since(11, 0)) {
                        builder.indexing().enabled(ParseUtils.parseBoolean(reader, i, value));
                        selfEnable = false;
                        continue block16;
                    }
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
                case STORAGE: {
                    builder.indexing().storage(IndexStorage.requireValid(value, Log.CONFIG));
                    continue block16;
                }
                case STARTUP_MODE: {
                    builder.indexing().startupMode(IndexStartupMode.requireValid(value, Log.CONFIG));
                    continue block16;
                }
                case PATH: {
                    builder.indexing().path(value);
                    continue block16;
                }
                case INDEXING_MODE: {
                    builder.indexing().indexingMode(IndexingMode.requireValid(value));
                    continue block16;
                }
                case INDEXED_ENTITIES: {
                    builder.indexing().addIndexedEntities(reader.getListAttributeValue(i));
                    continue block16;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (selfEnable) {
            builder.indexing().enable();
        }
        Properties indexingProperties = new Properties();
        block17: while (reader.inTag()) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case KEY_TRANSFORMERS: {
                    this.parseKeyTransformers(reader, holder, builder);
                    continue block17;
                }
                case INDEXED_ENTITIES: {
                    this.parseIndexedEntities(reader, holder, builder);
                    continue block17;
                }
                case PROPERTY: {
                    if (reader.getSchema().since(12, 0)) {
                        Log.CONFIG.deprecatedIndexProperties();
                    }
                    CacheParser.parseProperty(reader, indexingProperties);
                    continue block17;
                }
                case INDEX_READER: {
                    this.parseIndexReader(reader, builder);
                    continue block17;
                }
                case INDEX_WRITER: {
                    this.parseIndexWriter(reader, builder);
                    continue block17;
                }
                case INDEX_SHARDING: {
                    this.parseIndexSharding(reader, builder);
                    continue block17;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseKeyTransformers(ConfigurationReader reader, ConfigurationBuilderHolder holder, ConfigurationBuilder builder) {
        ParseUtils.requireNoAttributes(reader);
        block3: while (reader.inTag()) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case KEY_TRANSFORMER: {
                    this.parseKeyTransformer(reader, holder, builder);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseKeyTransformer(ConfigurationReader reader, ConfigurationBuilderHolder holder, ConfigurationBuilder builder) {
        String[] attrs = ParseUtils.requireAttributes(reader, Attribute.KEY.getLocalName(), Attribute.TRANSFORMER.getLocalName());
        Class keyClass = Util.loadClass((String)attrs[0], (ClassLoader)holder.getClassLoader());
        Class transformerClass = Util.loadClass((String)attrs[1], (ClassLoader)holder.getClassLoader());
        builder.indexing().addKeyTransformer(keyClass, transformerClass);
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case KEY: 
                case TRANSFORMER: {
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseIndexReader(ConfigurationReader reader, ConfigurationBuilder builder) {
        ParseUtils.parseAttributes(reader, builder.indexing().reader());
        ParseUtils.requireNoContent(reader);
    }

    private void parseIndexWriter(ConfigurationReader reader, ConfigurationBuilder builder) {
        IndexWriterConfigurationBuilder indexWriterBuilder = builder.indexing().writer();
        ParseUtils.parseAttributes(reader, indexWriterBuilder);
        while (reader.inTag()) {
            Element element = Element.forName(reader.getLocalName());
            if (element == Element.INDEX_MERGE) {
                this.parseIndexWriterMerge(reader, builder);
                continue;
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseIndexSharding(ConfigurationReader reader, ConfigurationBuilder builder) {
        ParseUtils.parseAttributes(reader, builder.indexing().sharding());
        ParseUtils.requireNoContent(reader);
    }

    private void parseIndexWriterMerge(ConfigurationReader reader, ConfigurationBuilder builder) {
        IndexMergeConfigurationBuilder mergeBuilder = builder.indexing().writer().merge();
        ParseUtils.parseAttributes(reader, mergeBuilder);
        ParseUtils.requireNoContent(reader);
    }

    private void parseIndexedEntities(ConfigurationReader reader, ConfigurationBuilderHolder holder, ConfigurationBuilder builder) {
        String[] entities;
        ParseUtils.requireNoAttributes(reader);
        boolean isProtobufStorage = builder.memory().encoding().value().isProtobufStorage();
        for (String entity : entities = reader.readArray((Enum)Element.INDEXED_ENTITIES, (Enum)Element.INDEXED_ENTITY)) {
            builder.indexing().addIndexedEntities(entity);
            if (isProtobufStorage) continue;
            try {
                Class indexedClass = Util.loadClass((String)entity, (ClassLoader)holder.getClassLoader());
                builder.indexing().addIndexedEntity(indexedClass);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void parseProperty(ConfigurationReader reader, Properties properties) {
        int attributes = reader.getAttributeCount();
        ParseUtils.requireAttributes(reader, Attribute.NAME.getLocalName());
        String key = null;
        String propertyValue = null;
        block4: for (int i = 0; i < attributes; ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case NAME: {
                    key = value;
                    continue block4;
                }
                case VALUE: {
                    propertyValue = value;
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (propertyValue == null) {
            propertyValue = reader.getElementText();
        }
        properties.setProperty(key, propertyValue);
    }

    public static Properties parseProperties(ConfigurationReader reader, Enum<?> outerElement) {
        return CacheParser.parseProperties(reader, outerElement.toString(), Element.PROPERTIES.toString(), Element.PROPERTY.toString());
    }

    public static Properties parseProperties(ConfigurationReader reader, Enum<?> outerElement, Enum<?> collectionElement, Enum<?> itemElement) {
        return CacheParser.parseProperties(reader, outerElement.toString(), collectionElement.toString(), itemElement.toString());
    }

    public static Properties parseProperties(ConfigurationReader reader, String outerElement, String collectionElement, String itemElement) {
        Properties properties = new Properties();
        while (reader.hasNext()) {
            ConfigurationReader.ElementType type = reader.nextElement();
            String element = reader.getLocalName();
            if (element.equals(collectionElement)) {
                for (int i = 0; i < reader.getAttributeCount(); ++i) {
                    properties.setProperty(reader.getAttributeName(i), reader.getAttributeValue(i));
                }
                continue;
            }
            if (element.equals(itemElement)) {
                if (type != ConfigurationReader.ElementType.START_ELEMENT) continue;
                CacheParser.parseProperty(reader, properties);
                continue;
            }
            if (type == ConfigurationReader.ElementType.END_ELEMENT && reader.getLocalName().equals(outerElement)) {
                return properties;
            }
            throw ParseUtils.unexpectedElement(reader);
        }
        return properties;
    }

    @Override
    public Namespace[] getNamespaces() {
        return ParseUtils.getNamespaceAnnotations(this.getClass());
    }

    public static enum TransactionMode {
        NONE(org.infinispan.transaction.TransactionMode.NON_TRANSACTIONAL, false, false, false),
        BATCH(org.infinispan.transaction.TransactionMode.TRANSACTIONAL, false, false, true),
        NON_XA(org.infinispan.transaction.TransactionMode.TRANSACTIONAL, false, false, false),
        NON_DURABLE_XA(org.infinispan.transaction.TransactionMode.TRANSACTIONAL, true, false, false),
        FULL_XA(org.infinispan.transaction.TransactionMode.TRANSACTIONAL, true, true, false);

        private final org.infinispan.transaction.TransactionMode mode;
        private final boolean xaEnabled;
        private final boolean recoveryEnabled;
        private final boolean batchingEnabled;

        private TransactionMode(org.infinispan.transaction.TransactionMode mode, boolean xaEnabled, boolean recoveryEnabled, boolean batchingEnabled) {
            this.mode = mode;
            this.xaEnabled = xaEnabled;
            this.recoveryEnabled = recoveryEnabled;
            this.batchingEnabled = batchingEnabled;
        }

        public static TransactionMode fromConfiguration(TransactionConfiguration transactionConfiguration, boolean batchingEnabled) {
            boolean xaEnabled;
            org.infinispan.transaction.TransactionMode mode = transactionConfiguration.transactionMode();
            boolean recoveryEnabled = transactionConfiguration.recovery().enabled();
            boolean bl = xaEnabled = !batchingEnabled && !transactionConfiguration.useSynchronization();
            if (mode == org.infinispan.transaction.TransactionMode.NON_TRANSACTIONAL) {
                return NONE;
            }
            for (TransactionMode txMode : TransactionMode.values()) {
                if (txMode.mode != mode || txMode.xaEnabled != xaEnabled || txMode.recoveryEnabled != recoveryEnabled || txMode.batchingEnabled != batchingEnabled) continue;
                return txMode;
            }
            throw Log.CONFIG.unknownTransactionConfiguration(mode, xaEnabled, recoveryEnabled, batchingEnabled);
        }

        public org.infinispan.transaction.TransactionMode getMode() {
            return this.mode;
        }

        public boolean isXAEnabled() {
            return this.xaEnabled;
        }

        public boolean isRecoveryEnabled() {
            return this.recoveryEnabled;
        }

        public boolean isBatchingEnabled() {
            return this.batchingEnabled;
        }
    }

    public static enum Mode {
        SYNC(true),
        ASYNC(false);

        private final boolean sync;

        private Mode(boolean sync) {
            this.sync = sync;
        }

        public static Mode forCacheMode(CacheMode mode) {
            return mode.isSynchronous() ? SYNC : ASYNC;
        }

        public CacheMode apply(CacheMode mode) {
            return this.sync ? mode.toSync() : mode.toAsync();
        }

        public boolean isSynchronous() {
            return this.sync;
        }
    }
}

