/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.serializing;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.infinispan.commons.configuration.ConfigurationFor;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.io.ConfigurationWriter;
import org.infinispan.commons.executors.BlockingThreadPoolExecutorFactory;
import org.infinispan.commons.executors.CachedThreadPoolExecutorFactory;
import org.infinispan.commons.executors.ScheduledThreadPoolExecutorFactory;
import org.infinispan.commons.util.Util;
import org.infinispan.commons.util.Version;
import org.infinispan.configuration.cache.AbstractStoreConfiguration;
import org.infinispan.configuration.cache.AuthorizationConfiguration;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.ClusterLoaderConfiguration;
import org.infinispan.configuration.cache.ClusteringConfiguration;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.CustomInterceptorsConfiguration;
import org.infinispan.configuration.cache.CustomStoreConfiguration;
import org.infinispan.configuration.cache.GroupsConfiguration;
import org.infinispan.configuration.cache.HashConfiguration;
import org.infinispan.configuration.cache.IndexMergeConfiguration;
import org.infinispan.configuration.cache.IndexWriterConfiguration;
import org.infinispan.configuration.cache.IndexingConfiguration;
import org.infinispan.configuration.cache.InterceptorConfiguration;
import org.infinispan.configuration.cache.MemoryConfiguration;
import org.infinispan.configuration.cache.PartitionHandlingConfiguration;
import org.infinispan.configuration.cache.PersistenceConfiguration;
import org.infinispan.configuration.cache.QueryConfiguration;
import org.infinispan.configuration.cache.RecoveryConfiguration;
import org.infinispan.configuration.cache.SingleFileStoreConfiguration;
import org.infinispan.configuration.cache.SitesConfiguration;
import org.infinispan.configuration.cache.StatisticsConfiguration;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.configuration.cache.TransactionConfiguration;
import org.infinispan.configuration.global.AllowListConfiguration;
import org.infinispan.configuration.global.GlobalAuthorizationConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalJmxConfiguration;
import org.infinispan.configuration.global.GlobalMetricsConfiguration;
import org.infinispan.configuration.global.GlobalStateConfiguration;
import org.infinispan.configuration.global.GlobalStatePathConfiguration;
import org.infinispan.configuration.global.SerializationConfiguration;
import org.infinispan.configuration.global.ShutdownHookBehavior;
import org.infinispan.configuration.global.StackConfiguration;
import org.infinispan.configuration.global.StackFileConfiguration;
import org.infinispan.configuration.global.TemporaryGlobalStatePathConfiguration;
import org.infinispan.configuration.global.ThreadPoolConfiguration;
import org.infinispan.configuration.global.TransportConfiguration;
import org.infinispan.configuration.parsing.Attribute;
import org.infinispan.configuration.parsing.CacheParser;
import org.infinispan.configuration.parsing.Element;
import org.infinispan.configuration.parsing.ParserScope;
import org.infinispan.configuration.serializing.AbstractStoreSerializer;
import org.infinispan.configuration.serializing.ConfigurationHolder;
import org.infinispan.configuration.serializing.ConfigurationSerializer;
import org.infinispan.configuration.serializing.SerializeUtils;
import org.infinispan.configuration.serializing.SerializedWith;
import org.infinispan.conflict.EntryMergePolicy;
import org.infinispan.conflict.MergePolicy;
import org.infinispan.factories.threads.DefaultThreadFactory;
import org.infinispan.factories.threads.EnhancedQueueExecutorFactory;
import org.infinispan.factories.threads.NonBlockingThreadPoolExecutorFactory;
import org.infinispan.persistence.sifs.configuration.DataConfiguration;
import org.infinispan.persistence.sifs.configuration.IndexConfiguration;
import org.infinispan.persistence.sifs.configuration.SoftIndexFileStoreConfiguration;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.remoting.transport.jgroups.EmbeddedJGroupsChannelConfigurator;
import org.infinispan.security.PrincipalRoleMapper;
import org.infinispan.security.Role;
import org.infinispan.security.mappers.ClusterRoleMapper;
import org.infinispan.security.mappers.CommonNameRoleMapper;
import org.infinispan.security.mappers.IdentityRoleMapper;
import org.infinispan.util.logging.Log;
import org.jgroups.conf.ProtocolConfiguration;

public class CoreConfigurationSerializer
extends AbstractStoreSerializer
implements ConfigurationSerializer<ConfigurationHolder> {
    private static final Map<String, Element> THREAD_POOL_FACTORIES = new ConcurrentHashMap<String, Element>();

    @Override
    public void serialize(ConfigurationWriter writer, ConfigurationHolder holder) {
        writer.writeStartElement("infinispan");
        writer.writeDefaultNamespace("urn:infinispan:config:" + Version.getMajorMinor());
        GlobalConfiguration globalConfiguration = holder.getGlobalConfiguration();
        if (globalConfiguration != null) {
            this.writeJGroups(writer, globalConfiguration);
            this.writeThreads(writer, globalConfiguration);
        }
        this.writeCacheContainer(writer, holder);
        if (globalConfiguration != null) {
            this.writeExtraConfiguration(writer, globalConfiguration.modules(), ParserScope.GLOBAL);
        }
        writer.writeEndElement();
    }

    private void writeJGroups(ConfigurationWriter writer, GlobalConfiguration globalConfiguration) {
        if (globalConfiguration.isClustered()) {
            writer.writeStartElement((Enum)Element.JGROUPS);
            writer.writeAttribute((Enum)Attribute.TRANSPORT, globalConfiguration.transport().transport().getClass().getName());
            List<StackFileConfiguration> stackFiles = globalConfiguration.transport().jgroups().stackFiles();
            List<StackConfiguration> stacks = globalConfiguration.transport().jgroups().stacks();
            if (stackFiles.stream().filter(s -> !s.builtIn()).count() + (long)stacks.size() > 0L) {
                writer.writeStartMap((Enum)Element.STACKS);
                for (StackFileConfiguration stackFileConfiguration : stackFiles) {
                    if (stackFileConfiguration.builtIn()) continue;
                    writer.writeMapItem((Enum)Element.STACK_FILE, (Enum)Attribute.NAME, stackFileConfiguration.name());
                    writer.writeAttribute((Enum)Attribute.PATH, stackFileConfiguration.path());
                    writer.writeEndMapItem();
                }
                for (StackConfiguration stackConfiguration : stacks) {
                    writer.writeMapItem((Enum)Element.STACK, (Enum)Attribute.NAME, stackConfiguration.name());
                    SerializeUtils.writeOptional(writer, Attribute.EXTENDS, stackConfiguration.extend());
                    for (ProtocolConfiguration protocol : stackConfiguration.configurator().getUncombinedProtocolStack()) {
                        if (protocol.getProperties().isEmpty()) {
                            writer.writeEmptyElement(protocol.getProtocolName());
                            continue;
                        }
                        writer.writeStartElement(protocol.getProtocolName());
                        for (Map.Entry entry : protocol.getProperties().entrySet()) {
                            writer.writeAttribute((String)entry.getKey(), (String)entry.getValue());
                        }
                        writer.writeEndElement();
                    }
                    EmbeddedJGroupsChannelConfigurator.RemoteSites remoteSites = stackConfiguration.configurator().getUncombinedRemoteSites();
                    if (remoteSites != null) {
                        writer.writeStartElement((Enum)Element.REMOTE_SITES);
                        writer.writeAttribute((Enum)Attribute.DEFAULT_STACK, remoteSites.getDefaultStack());
                        SerializeUtils.writeOptional(writer, Attribute.CLUSTER, remoteSites.getDefaultCluster());
                        Map<String, EmbeddedJGroupsChannelConfigurator.RemoteSite> sites = remoteSites.getRemoteSites();
                        for (Map.Entry<Object, Object> entry : sites.entrySet()) {
                            writer.writeStartElement((Enum)Element.REMOTE_SITE);
                            writer.writeAttribute((Enum)Attribute.NAME, (String)entry.getKey());
                            SerializeUtils.writeOptional(writer, Attribute.CLUSTER, ((EmbeddedJGroupsChannelConfigurator.RemoteSite)entry.getValue()).getCluster());
                            writer.writeAttribute((Enum)Attribute.STACK, ((EmbeddedJGroupsChannelConfigurator.RemoteSite)entry.getValue()).getStack());
                            writer.writeEndElement();
                        }
                        writer.writeEndElement();
                    }
                    writer.writeEndMapItem();
                }
                writer.writeEndMap();
            }
            writer.writeEndElement();
        }
    }

    private void writeThreads(ConfigurationWriter writer, GlobalConfiguration globalConfiguration) {
        ConcurrentHashMap<String, DefaultThreadFactory> threadFactories = new ConcurrentHashMap<String, DefaultThreadFactory>();
        for (ThreadPoolConfiguration threadPoolConfiguration : Arrays.asList(globalConfiguration.expirationThreadPool(), globalConfiguration.listenerThreadPool(), globalConfiguration.nonBlockingThreadPool(), globalConfiguration.blockingThreadPool(), globalConfiguration.transport().remoteCommandThreadPool(), globalConfiguration.transport().transportThreadPool())) {
            Object threadFactory = threadPoolConfiguration.threadFactory();
            if (!(threadFactory instanceof DefaultThreadFactory)) continue;
            DefaultThreadFactory tf = (DefaultThreadFactory)threadFactory;
            threadFactories.putIfAbsent(tf.getName(), tf);
        }
        if (threadFactories.size() > 0) {
            writer.writeStartElement((Enum)Element.THREADS);
            writer.writeStartMap((Enum)Element.THREAD_FACTORIES);
            for (DefaultThreadFactory threadFactory : threadFactories.values()) {
                this.writeThreadFactory(writer, threadFactory);
            }
            writer.writeEndMap();
            writer.writeStartMap((Enum)Element.THREAD_POOLS);
            this.writeThreadPool(writer, globalConfiguration.nonBlockingThreadPoolName(), globalConfiguration.nonBlockingThreadPool());
            this.writeThreadPool(writer, globalConfiguration.expirationThreadPoolName(), globalConfiguration.expirationThreadPool());
            this.writeThreadPool(writer, globalConfiguration.listenerThreadPoolName(), globalConfiguration.listenerThreadPool());
            this.writeThreadPool(writer, globalConfiguration.blockingThreadPoolName(), globalConfiguration.blockingThreadPool());
            this.writeThreadPool(writer, globalConfiguration.transport().remoteThreadPoolName(), globalConfiguration.transport().remoteCommandThreadPool());
            writer.writeEndMap();
            writer.writeEndElement();
        }
    }

    private void writeThreadFactory(ConfigurationWriter writer, DefaultThreadFactory threadFactory) {
        writer.writeMapItem((Enum)Element.THREAD_FACTORY, (Enum)Attribute.NAME, threadFactory.getName());
        SerializeUtils.writeOptional(writer, Attribute.GROUP_NAME, threadFactory.threadGroup().getName());
        SerializeUtils.writeOptional(writer, Attribute.THREAD_NAME_PATTERN, threadFactory.threadNamePattern());
        writer.writeAttribute((Enum)Attribute.PRIORITY, Integer.toString(threadFactory.initialPriority()));
        writer.writeEndMapItem();
    }

    private void writeThreadPool(ConfigurationWriter writer, String name, ThreadPoolConfiguration threadPoolConfiguration) {
        Object threadPoolFactory = threadPoolConfiguration.threadPoolFactory();
        if (threadPoolFactory != null) {
            Element element = THREAD_POOL_FACTORIES.get(threadPoolFactory.getClass().getName());
            if (element == Element.BLOCKING_BOUNDED_QUEUE_THREAD_POOL && threadPoolFactory.createsNonBlockingThreads()) {
                element = Element.NON_BLOCKING_BOUNDED_QUEUE_THREAD_POOL;
            }
            writer.writeMapItem((Enum)element, (Enum)Attribute.NAME, name);
            Object threadFactory = threadPoolConfiguration.threadFactory();
            if (threadFactory instanceof DefaultThreadFactory) {
                DefaultThreadFactory tf = (DefaultThreadFactory)threadFactory;
                writer.writeAttribute((Enum)Attribute.THREAD_FACTORY, tf.getName());
            }
            if (threadPoolFactory instanceof BlockingThreadPoolExecutorFactory) {
                BlockingThreadPoolExecutorFactory pool = (BlockingThreadPoolExecutorFactory)threadPoolFactory;
                writer.writeAttribute((Enum)Attribute.MAX_THREADS, Integer.toString(pool.maxThreads()));
                writer.writeAttribute((Enum)Attribute.CORE_THREADS, Integer.toString(pool.coreThreads()));
                writer.writeAttribute((Enum)Attribute.QUEUE_LENGTH, Integer.toString(pool.queueLength()));
                writer.writeAttribute((Enum)Attribute.KEEP_ALIVE_TIME, Long.toString(pool.keepAlive()));
            }
            writer.writeEndMapItem();
        }
    }

    private void writeCacheContainer(ConfigurationWriter writer, ConfigurationHolder holder) {
        writer.writeStartElement((Enum)Element.CACHE_CONTAINER);
        GlobalConfiguration globalConfiguration = holder.getGlobalConfiguration();
        if (globalConfiguration != null) {
            writer.writeAttribute((Enum)Attribute.NAME, globalConfiguration.cacheManagerName());
            if (globalConfiguration.shutdown().hookBehavior() != ShutdownHookBehavior.DEFAULT) {
                writer.writeAttribute((Enum)Attribute.SHUTDOWN_HOOK, globalConfiguration.shutdown().hookBehavior().name());
            }
            writer.writeAttribute((Enum)Attribute.STATISTICS, String.valueOf(globalConfiguration.statistics()));
            if (globalConfiguration.nonBlockingThreadPool().threadFactory() != null) {
                writer.writeAttribute((Enum)Attribute.NON_BLOCKING_EXECUTOR, globalConfiguration.nonBlockingThreadPoolName());
            }
            if (globalConfiguration.expirationThreadPool().threadFactory() != null) {
                writer.writeAttribute((Enum)Attribute.EXPIRATION_EXECUTOR, globalConfiguration.expirationThreadPoolName());
            }
            if (globalConfiguration.listenerThreadPool().threadFactory() != null) {
                writer.writeAttribute((Enum)Attribute.LISTENER_EXECUTOR, globalConfiguration.listenerThreadPoolName());
            }
            if (globalConfiguration.blockingThreadPool().threadFactory() != null) {
                writer.writeAttribute((Enum)Attribute.BLOCKING_EXECUTOR, globalConfiguration.blockingThreadPoolName());
            }
            this.writeTransport(writer, globalConfiguration);
            this.writeSecurity(writer, globalConfiguration);
            this.writeSerialization(writer, globalConfiguration);
            this.writeMetrics(writer, globalConfiguration);
            this.writeJMX(writer, globalConfiguration);
            this.writeGlobalState(writer, globalConfiguration);
            this.writeExtraConfiguration(writer, globalConfiguration.modules(), ParserScope.CACHE_CONTAINER);
        }
        writer.writeStartMap((Enum)Element.CACHES);
        for (Map.Entry<String, Configuration> configuration : holder.getConfigurations().entrySet()) {
            Configuration config = configuration.getValue();
            this.writeCache(writer, configuration.getKey(), config);
        }
        writer.writeEndMap();
        writer.writeEndElement();
    }

    public void writeCache(ConfigurationWriter writer, String name, Configuration config) {
        boolean unnamed = name == null || name.isBlank();
        switch (config.clustering().cacheMode()) {
            case LOCAL: {
                this.writeLocalCache(writer, name, config, unnamed);
                break;
            }
            case DIST_ASYNC: 
            case DIST_SYNC: {
                this.writeDistributedCache(writer, name, config, unnamed);
                break;
            }
            case INVALIDATION_ASYNC: 
            case INVALIDATION_SYNC: {
                this.writeInvalidationCache(writer, name, config, unnamed);
                break;
            }
            case REPL_ASYNC: 
            case REPL_SYNC: {
                this.writeReplicatedCache(writer, name, config, unnamed);
                break;
            }
            case SCATTERED_SYNC: {
                this.writeScatteredCache(writer, name, config, unnamed);
                break;
            }
        }
    }

    private void writeExtraConfiguration(ConfigurationWriter writer, Map<Class<?>, ?> modules) {
        this.writeExtraConfiguration(writer, modules, null);
    }

    private void writeExtraConfiguration(ConfigurationWriter writer, Map<Class<?>, ?> modules, ParserScope scope) {
        for (Map.Entry<Class<?>, ?> entry : modules.entrySet()) {
            SerializedWith serializedWith = entry.getKey().getAnnotation(SerializedWith.class);
            if (serializedWith == null || scope != null && scope != serializedWith.scope()) continue;
            try {
                ConfigurationSerializer serializer = (ConfigurationSerializer)Util.getInstanceStrict(serializedWith.value());
                serializer.serialize(writer, entry.getValue());
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw Log.CONFIG.unableToInstantiateSerializer(serializedWith.value());
            }
        }
    }

    private void writeGlobalState(ConfigurationWriter writer, GlobalConfiguration globalConfiguration) {
        GlobalStateConfiguration configuration = globalConfiguration.globalState();
        if (configuration.enabled()) {
            writer.writeStartElement((Enum)Element.GLOBAL_STATE);
            if (configuration.persistenceConfiguration().attributes().attribute(GlobalStatePathConfiguration.PATH).isModified()) {
                writer.writeStartElement((Enum)Element.PERSISTENT_LOCATION);
                writer.writeAttribute((Enum)Attribute.PATH, configuration.persistentLocation());
                writer.writeEndElement();
            }
            if (configuration.sharedPersistenceConfiguration().attributes().attribute(GlobalStatePathConfiguration.PATH).isModified()) {
                writer.writeStartElement((Enum)Element.SHARED_PERSISTENT_LOCATION);
                writer.writeAttribute((Enum)Attribute.PATH, configuration.sharedPersistentLocation());
                writer.writeEndElement();
            }
            if (configuration.temporaryLocationConfiguration().attributes().attribute(TemporaryGlobalStatePathConfiguration.PATH).isModified()) {
                writer.writeStartElement((Enum)Element.TEMPORARY_LOCATION);
                writer.writeAttribute((Enum)Attribute.PATH, configuration.temporaryLocation());
                writer.writeEndElement();
            }
            switch (configuration.configurationStorage()) {
                case IMMUTABLE: {
                    writer.writeEmptyElement((Enum)Element.IMMUTABLE_CONFIGURATION_STORAGE);
                    break;
                }
                case VOLATILE: {
                    writer.writeEmptyElement((Enum)Element.VOLATILE_CONFIGURATION_STORAGE);
                    break;
                }
                case OVERLAY: {
                    writer.writeEmptyElement((Enum)Element.OVERLAY_CONFIGURATION_STORAGE);
                    break;
                }
                case MANAGED: {
                    writer.writeEmptyElement((Enum)Element.MANAGED_CONFIGURATION_STORAGE);
                    break;
                }
                case CUSTOM: {
                    writer.writeStartElement((Enum)Element.CUSTOM_CONFIGURATION_STORAGE);
                    writer.writeAttribute((Enum)Attribute.CLASS, configuration.configurationStorageClass().get().getClass().getName());
                    writer.writeEndElement();
                }
            }
            writer.writeEndElement();
        }
    }

    private void writeSecurity(ConfigurationWriter writer, GlobalConfiguration configuration) {
        GlobalAuthorizationConfiguration authorization = configuration.security().authorization();
        AttributeSet attributes = authorization.attributes();
        if (attributes.isModified() && authorization.enabled()) {
            writer.writeStartElement((Enum)Element.SECURITY);
            writer.writeStartElement((Enum)Element.AUTHORIZATION);
            attributes.write(writer, GlobalAuthorizationConfiguration.AUDIT_LOGGER, (Enum)Attribute.AUDIT_LOGGER);
            PrincipalRoleMapper mapper = authorization.principalRoleMapper();
            if (mapper != null) {
                if (mapper instanceof IdentityRoleMapper) {
                    writer.writeEmptyElement((Enum)Element.IDENTITY_ROLE_MAPPER);
                } else if (mapper instanceof CommonNameRoleMapper) {
                    writer.writeEmptyElement((Enum)Element.COMMON_NAME_ROLE_MAPPER);
                } else if (mapper instanceof ClusterRoleMapper) {
                    writer.writeEmptyElement((Enum)Element.CLUSTER_ROLE_MAPPER);
                } else {
                    writer.writeStartElement((Enum)Element.CUSTOM_ROLE_MAPPER);
                    writer.writeAttribute((Enum)Attribute.CLASS, mapper.getClass().getName());
                    writer.writeEndElement();
                }
            }
            if (!authorization.isDefaultRoles()) {
                writer.writeStartMap((Enum)Element.ROLES);
                for (Role role : authorization.roles().values()) {
                    writer.writeMapItem((Enum)Element.ROLE, (Enum)Attribute.NAME, role.getName());
                    writer.writeAttribute((Enum)Attribute.PERMISSIONS, (Iterable)role.getPermissions().stream().map(Enum::name).collect(Collectors.toList()));
                    writer.writeEndMapItem();
                }
                writer.writeEndMap();
            }
            writer.writeEndElement();
            writer.writeEndElement();
        }
    }

    private void writeReplicatedCache(ConfigurationWriter writer, String name, Configuration configuration, boolean unnamed) {
        if (unnamed) {
            writer.writeStartElement((Enum)(configuration.isTemplate() ? Element.REPLICATED_CACHE_CONFIGURATION : Element.REPLICATED_CACHE));
        } else {
            writer.writeMapItem((Enum)(configuration.isTemplate() ? Element.REPLICATED_CACHE_CONFIGURATION : Element.REPLICATED_CACHE), (Enum)Attribute.NAME, name);
        }
        configuration.attributes().write(writer);
        AttributeSet hashAttributes = configuration.clustering().hash().attributes();
        hashAttributes.write(writer, HashConfiguration.NUM_SEGMENTS);
        hashAttributes.write(writer, HashConfiguration.CONSISTENT_HASH_FACTORY);
        hashAttributes.write(writer, HashConfiguration.KEY_PARTITIONER);
        this.writeCommonClusteredCacheAttributes(writer, configuration);
        this.writeCommonCacheAttributesElements(writer, name, configuration);
        this.writeExtraConfiguration(writer, configuration.modules());
        if (unnamed) {
            writer.writeEndElement();
        } else {
            writer.writeEndMapItem();
        }
    }

    private void writeDistributedCache(ConfigurationWriter writer, String name, Configuration configuration, boolean unnamed) {
        if (unnamed) {
            writer.writeStartElement((Enum)(configuration.isTemplate() ? Element.DISTRIBUTED_CACHE_CONFIGURATION : Element.DISTRIBUTED_CACHE));
        } else {
            writer.writeMapItem((Enum)(configuration.isTemplate() ? Element.DISTRIBUTED_CACHE_CONFIGURATION : Element.DISTRIBUTED_CACHE), (Enum)Attribute.NAME, name);
        }
        configuration.attributes().write(writer);
        configuration.clustering().hash().attributes().write(writer);
        configuration.clustering().l1().attributes().write(writer);
        this.writeCommonClusteredCacheAttributes(writer, configuration);
        this.writeCommonCacheAttributesElements(writer, name, configuration);
        GroupsConfiguration groups = configuration.clustering().hash().groups();
        if (groups.attributes().isModified()) {
            writer.writeStartElement((Enum)Element.GROUPS);
            groups.attributes().write(writer, GroupsConfiguration.ENABLED);
            writer.writeArrayElement((Enum)Element.GROUPER, (Enum)Element.GROUPER, (Enum)Attribute.CLASS, (Iterable)groups.groupers().stream().map(g -> g.getClass().getName()).collect(Collectors.toList()));
            writer.writeEndElement();
        }
        this.writeExtraConfiguration(writer, configuration.modules());
        if (unnamed) {
            writer.writeEndElement();
        } else {
            writer.writeEndMapItem();
        }
    }

    private void writeInvalidationCache(ConfigurationWriter writer, String name, Configuration configuration, boolean unnamed) {
        if (unnamed) {
            writer.writeStartElement((Enum)(configuration.isTemplate() ? Element.INVALIDATION_CACHE_CONFIGURATION : Element.INVALIDATION_CACHE));
        } else {
            writer.writeMapItem((Enum)(configuration.isTemplate() ? Element.INVALIDATION_CACHE_CONFIGURATION : Element.INVALIDATION_CACHE), (Enum)Attribute.NAME, name);
        }
        configuration.attributes().write(writer);
        this.writeCommonClusteredCacheAttributes(writer, configuration);
        this.writeCommonCacheAttributesElements(writer, name, configuration);
        this.writeExtraConfiguration(writer, configuration.modules());
        if (unnamed) {
            writer.writeEndElement();
        } else {
            writer.writeEndMapItem();
        }
    }

    private void writeScatteredCache(ConfigurationWriter writer, String name, Configuration configuration, boolean unnamed) {
        if (unnamed) {
            writer.writeStartElement((Enum)(configuration.isTemplate() ? Element.SCATTERED_CACHE_CONFIGURATION : Element.SCATTERED_CACHE));
        } else {
            writer.writeMapItem((Enum)(configuration.isTemplate() ? Element.SCATTERED_CACHE_CONFIGURATION : Element.SCATTERED_CACHE), (Enum)Attribute.NAME, name);
        }
        configuration.attributes().write(writer);
        writer.writeAttribute((Enum)Attribute.INVALIDATION_BATCH_SIZE, Integer.toString(configuration.clustering().invalidationBatchSize()));
        writer.writeAttribute((Enum)Attribute.BIAS_ACQUISITION, configuration.clustering().biasAcquisition().toString());
        writer.writeAttribute((Enum)Attribute.BIAS_LIFESPAN, Long.toString(configuration.clustering().biasLifespan()));
        this.writeCommonClusteredCacheAttributes(writer, configuration);
        this.writeCommonCacheAttributesElements(writer, name, configuration);
        this.writeExtraConfiguration(writer, configuration.modules());
        if (unnamed) {
            writer.writeEndElement();
        } else {
            writer.writeEndMapItem();
        }
    }

    private void writeLocalCache(ConfigurationWriter writer, String name, Configuration configuration, boolean unnamed) {
        if (unnamed) {
            writer.writeStartElement((Enum)(configuration.isTemplate() ? Element.LOCAL_CACHE_CONFIGURATION : Element.LOCAL_CACHE));
        } else {
            writer.writeMapItem((Enum)(configuration.isTemplate() ? Element.LOCAL_CACHE_CONFIGURATION : Element.LOCAL_CACHE), (Enum)Attribute.NAME, name);
        }
        configuration.attributes().write(writer);
        this.writeCommonCacheAttributesElements(writer, name, configuration);
        this.writeExtraConfiguration(writer, configuration.modules());
        if (unnamed) {
            writer.writeEndElement();
        } else {
            writer.writeEndMapItem();
        }
    }

    private void writeTransport(ConfigurationWriter writer, GlobalConfiguration globalConfiguration) {
        TransportConfiguration transport = globalConfiguration.transport();
        AttributeSet attributes = transport.attributes();
        if (attributes.isModified()) {
            writer.writeStartElement((Enum)Element.TRANSPORT);
            attributes.write(writer, TransportConfiguration.CLUSTER_NAME, (Enum)Attribute.CLUSTER);
            attributes.write(writer, TransportConfiguration.MACHINE_ID, (Enum)Attribute.MACHINE_ID);
            attributes.write(writer, TransportConfiguration.RACK_ID, (Enum)Attribute.RACK_ID);
            if (transport.siteId() != null) {
                attributes.write(writer, TransportConfiguration.SITE_ID, (Enum)Attribute.SITE);
            }
            attributes.write(writer, TransportConfiguration.NODE_NAME, (Enum)Attribute.NODE_NAME);
            attributes.write(writer, TransportConfiguration.STACK);
            if (transport.remoteCommandThreadPool().threadPoolFactory() != null) {
                writer.writeAttribute((Enum)Attribute.REMOTE_COMMAND_EXECUTOR, transport.remoteThreadPoolName());
            }
            attributes.write(writer, TransportConfiguration.DISTRIBUTED_SYNC_TIMEOUT, (Enum)Attribute.LOCK_TIMEOUT);
            attributes.write(writer, TransportConfiguration.INITIAL_CLUSTER_SIZE, (Enum)Attribute.INITIAL_CLUSTER_SIZE);
            attributes.write(writer, TransportConfiguration.INITIAL_CLUSTER_TIMEOUT, (Enum)Attribute.INITIAL_CLUSTER_TIMEOUT);
            if (!transport.raftMembers().isEmpty()) {
                attributes.write(writer, TransportConfiguration.RAFT_MEMBERS, (Enum)Attribute.RAFT_MEMBERS);
            }
            writer.writeEndElement();
        }
    }

    private void writeSerialization(ConfigurationWriter writer, GlobalConfiguration globalConfiguration) {
        SerializationConfiguration serialization = globalConfiguration.serialization();
        AttributeSet attributes = serialization.attributes();
        if (attributes.isModified()) {
            writer.writeStartElement((Enum)Element.SERIALIZATION);
            attributes.write(writer, SerializationConfiguration.MARSHALLER, (Enum)Attribute.MARSHALLER);
            SerializationConfiguration config = globalConfiguration.serialization();
            this.writeSerializationContextInitializers(writer, config);
            this.writeClassAllowList(writer, config.allowList());
            writer.writeEndElement();
        }
    }

    private void writeSerializationContextInitializers(ConfigurationWriter writer, SerializationConfiguration config) {
        List<SerializationContextInitializer> scis = config.contextInitializers();
        if (scis != null && !scis.isEmpty()) {
            List classes = scis.stream().map(s -> s.getClass().getName()).collect(Collectors.toList());
            writer.writeArrayElement((Enum)Element.SERIALIZATION_CONTEXT_INITIALIZERS, (Enum)Element.SERIALIZATION_CONTEXT_INITIALIZER, (Enum)Attribute.CLASS, classes);
        }
    }

    private void writeClassAllowList(ConfigurationWriter writer, AllowListConfiguration config) {
        if (!config.getClasses().isEmpty() || !config.getRegexps().isEmpty()) {
            writer.writeStartElement((Enum)Element.ALLOW_LIST);
            writer.writeArrayElement((Enum)Element.CLASS, (Enum)Element.CLASS, null, config.getClasses());
            writer.writeArrayElement((Enum)Element.REGEX, (Enum)Element.REGEX, null, config.getRegexps());
            writer.writeEndElement();
        }
    }

    private void writeMetrics(ConfigurationWriter writer, GlobalConfiguration globalConfiguration) {
        GlobalMetricsConfiguration metrics = globalConfiguration.metrics();
        AttributeSet attributes = metrics.attributes();
        if (attributes.isModified()) {
            writer.writeStartElement((Enum)Element.METRICS);
            attributes.write(writer, GlobalMetricsConfiguration.GAUGES, (Enum)Attribute.GAUGES);
            attributes.write(writer, GlobalMetricsConfiguration.HISTOGRAMS, (Enum)Attribute.HISTOGRAMS);
            attributes.write(writer, GlobalMetricsConfiguration.PREFIX, (Enum)Attribute.PREFIX);
            attributes.write(writer, GlobalMetricsConfiguration.NAMES_AS_TAGS, (Enum)Attribute.NAMES_AS_TAGS);
            writer.writeEndElement();
        }
    }

    private void writeJMX(ConfigurationWriter writer, GlobalConfiguration globalConfiguration) {
        GlobalJmxConfiguration jmx = globalConfiguration.jmx();
        AttributeSet attributes = jmx.attributes();
        if (attributes.isModified()) {
            writer.writeStartElement((Enum)Element.JMX);
            attributes.write(writer, GlobalJmxConfiguration.ENABLED, (Enum)Attribute.ENABLED);
            attributes.write(writer, GlobalJmxConfiguration.DOMAIN, (Enum)Attribute.DOMAIN);
            attributes.write(writer, GlobalJmxConfiguration.MBEAN_SERVER_LOOKUP, (Enum)Attribute.MBEAN_SERVER_LOOKUP);
            attributes.write(writer, GlobalJmxConfiguration.PROPERTIES);
            writer.writeEndElement();
        }
    }

    private void writeTransaction(ConfigurationWriter writer, Configuration configuration) {
        TransactionConfiguration transaction = configuration.transaction();
        AttributeSet attributes = transaction.attributes();
        if (attributes.isModified()) {
            writer.writeStartElement((Enum)Element.TRANSACTION);
            CacheParser.TransactionMode mode = CacheParser.TransactionMode.fromConfiguration(transaction, configuration.invocationBatching().enabled());
            writer.writeAttribute((Enum)Attribute.MODE, mode.toString());
            attributes.write(writer);
            if (mode != CacheParser.TransactionMode.NONE) {
                attributes.write(writer, TransactionConfiguration.TRANSACTION_MANAGER_LOOKUP);
            }
            if (transaction.recovery().enabled()) {
                transaction.recovery().attributes().write(writer, RecoveryConfiguration.RECOVERY_INFO_CACHE_NAME, (Enum)Attribute.RECOVERY_INFO_CACHE_NAME);
            }
            writer.writeEndElement();
        }
    }

    private void writeSecurity(ConfigurationWriter writer, Configuration configuration) {
        AuthorizationConfiguration authorization = configuration.security().authorization();
        AttributeSet attributes = authorization.attributes();
        if (attributes.isModified()) {
            writer.writeStartElement((Enum)Element.SECURITY);
            writer.writeStartElement((Enum)Element.AUTHORIZATION);
            attributes.write(writer, AuthorizationConfiguration.ENABLED, (Enum)Attribute.ENABLED);
            if (!authorization.roles().isEmpty()) {
                writer.writeAttribute((Enum)Attribute.ROLES, authorization.roles());
            }
            writer.writeEndElement();
            writer.writeEndElement();
        }
    }

    private void writeCommonClusteredCacheAttributes(ConfigurationWriter writer, Configuration configuration) {
        ClusteringConfiguration clustering = configuration.clustering();
        writer.writeAttribute((Enum)Attribute.MODE, clustering.cacheMode().isSynchronous() ? "SYNC" : "ASYNC");
        clustering.attributes().write(writer, ClusteringConfiguration.REMOTE_TIMEOUT, (Enum)Attribute.REMOTE_TIMEOUT);
    }

    private void writeCommonCacheAttributesElements(ConfigurationWriter writer, String name, Configuration configuration) {
        configuration.statistics().attributes().write(writer, StatisticsConfiguration.ENABLED, (Enum)Attribute.STATISTICS);
        configuration.unsafe().attributes().write(writer);
        this.writeBackup(writer, configuration);
        this.writeEncoding(writer, configuration);
        configuration.sites().backupFor().attributes().write(writer, Element.BACKUP_FOR.getLocalName());
        configuration.locking().attributes().write(writer, Element.LOCKING.getLocalName());
        this.writeTransaction(writer, configuration);
        configuration.expiration().attributes().write(writer, Element.EXPIRATION.getLocalName());
        this.writeMemory(writer, configuration);
        this.writePersistence(writer, configuration);
        this.writeQuery(writer, configuration);
        this.writeIndexing(writer, configuration);
        this.writeCustomInterceptors(writer, configuration);
        this.writeSecurity(writer, configuration);
        if (configuration.clustering().cacheMode().needsStateTransfer()) {
            configuration.clustering().stateTransfer().attributes().write(writer, Element.STATE_TRANSFER.getLocalName());
        }
        this.writePartitionHandling(writer, configuration);
    }

    private void writeEncoding(ConfigurationWriter writer, Configuration configuration) {
        configuration.encoding().write(writer);
    }

    private void writePartitionHandling(ConfigurationWriter writer, Configuration configuration) {
        PartitionHandlingConfiguration partitionHandling = configuration.clustering().partitionHandling();
        AttributeSet attributes = partitionHandling.attributes();
        if (attributes.isModified()) {
            writer.writeStartElement((Enum)Element.PARTITION_HANDLING);
            attributes.write(writer, PartitionHandlingConfiguration.WHEN_SPLIT, (Enum)Attribute.WHEN_SPLIT);
            EntryMergePolicy policyImpl = partitionHandling.mergePolicy();
            MergePolicy policy = MergePolicy.fromConfiguration(policyImpl);
            String output = policy == MergePolicy.CUSTOM ? policyImpl.getClass().getName() : policy.toString();
            writer.writeAttribute((Enum)Attribute.MERGE_POLICY, output);
            writer.writeEndElement();
        }
    }

    private void writeCustomInterceptors(ConfigurationWriter writer, Configuration configuration) {
        CustomInterceptorsConfiguration customInterceptors = configuration.customInterceptors();
        if (customInterceptors.interceptors().size() > 0) {
            writer.writeStartMap((Enum)Element.CUSTOM_INTERCEPTORS);
            for (InterceptorConfiguration interceptor : customInterceptors.interceptors()) {
                AttributeSet attributes = interceptor.attributes();
                if (attributes.attribute(InterceptorConfiguration.INTERCEPTOR_CLASS).isNull()) continue;
                writer.writeMapItem((Enum)Element.INTERCEPTOR, (Enum)Attribute.CLASS, ((Class)attributes.attribute(InterceptorConfiguration.INTERCEPTOR_CLASS).get()).getName());
                attributes.write(writer, InterceptorConfiguration.AFTER, (Enum)Attribute.AFTER);
                attributes.write(writer, InterceptorConfiguration.BEFORE, (Enum)Attribute.BEFORE);
                attributes.write(writer, InterceptorConfiguration.INDEX, (Enum)Attribute.INDEX);
                attributes.write(writer, InterceptorConfiguration.POSITION, (Enum)Attribute.POSITION);
                attributes.write(writer, InterceptorConfiguration.PROPERTIES);
                writer.writeEndMapItem();
            }
            writer.writeEndMap();
        }
    }

    private void writeMemory(ConfigurationWriter writer, Configuration configuration) {
        MemoryConfiguration memory = configuration.memory();
        AttributeSet attributes = memory.attributes();
        if (attributes.isModified()) {
            writer.writeStartElement((Enum)Element.MEMORY);
            attributes.write(writer, MemoryConfiguration.STORAGE, (Enum)Attribute.STORAGE);
            if ((Long)attributes.attribute(MemoryConfiguration.MAX_COUNT).get() > 0L) {
                attributes.write(writer, MemoryConfiguration.MAX_COUNT, (Enum)Attribute.MAX_COUNT);
            } else if (attributes.attribute(MemoryConfiguration.MAX_SIZE).get() != null) {
                attributes.write(writer, MemoryConfiguration.MAX_SIZE, (Enum)Attribute.MAX_SIZE);
            }
            attributes.write(writer, MemoryConfiguration.WHEN_FULL, (Enum)Attribute.WHEN_FULL);
            writer.writeEndElement();
        }
    }

    private void writeQuery(ConfigurationWriter writer, Configuration configuration) {
        QueryConfiguration query = configuration.query();
        AttributeSet attributes = query.attributes();
        if (attributes.isModified()) {
            writer.writeStartElement((Enum)Element.QUERY);
            attributes.write(writer, QueryConfiguration.DEFAULT_MAX_RESULTS, (Enum)Attribute.DEFAULT_MAX_RESULTS);
            writer.writeEndElement();
        }
    }

    private void writeIndexing(ConfigurationWriter writer, Configuration configuration) {
        IndexingConfiguration indexing = configuration.indexing();
        AttributeSet attributes = indexing.attributes();
        if (attributes.isModified()) {
            Integer shards;
            writer.writeStartElement((Enum)Element.INDEXING);
            attributes.write(writer, IndexingConfiguration.ENABLED, (Enum)Attribute.ENABLED);
            attributes.write(writer, IndexingConfiguration.STORAGE, (Enum)Attribute.STORAGE);
            attributes.write(writer, IndexingConfiguration.STARTUP_MODE, (Enum)Attribute.STARTUP_MODE);
            attributes.write(writer, IndexingConfiguration.PATH, (Enum)Attribute.PATH);
            attributes.write(writer, IndexingConfiguration.INDEXING_MODE, (Enum)Attribute.INDEXING_MODE);
            long refreshInterval = indexing.reader().getRefreshInterval();
            if (refreshInterval != 0L) {
                writer.writeStartElement((Enum)Element.INDEX_READER);
                writer.writeAttribute((Enum)Attribute.REFRESH_INTERVAL, Long.toString(refreshInterval));
                writer.writeEndElement();
            }
            if ((shards = indexing.sharding().getShards()) > 1) {
                writer.writeStartElement((Enum)Element.INDEX_SHARDING);
                writer.writeAttribute((Enum)Attribute.SHARDS, Integer.toString(shards));
                writer.writeEndElement();
            }
            IndexWriterConfiguration indexWriter = indexing.writer();
            IndexMergeConfiguration indexMerge = indexWriter.merge();
            AttributeSet writerAttributes = indexWriter.attributes();
            AttributeSet mergeAttributes = indexMerge.attributes();
            boolean indexWriterModified = writerAttributes.isModified();
            boolean indexMergeModified = mergeAttributes.isModified();
            if (indexWriterModified || indexMergeModified) {
                writer.writeStartElement((Enum)Element.INDEX_WRITER);
                writerAttributes.write(writer, IndexWriterConfiguration.INDEX_COMMIT_INTERVAL, (Enum)Attribute.COMMIT_INTERVAL);
                writerAttributes.write(writer, IndexWriterConfiguration.INDEX_LOW_LEVEL_TRACE, (Enum)Attribute.LOW_LEVEL_TRACE);
                writerAttributes.write(writer, IndexWriterConfiguration.INDEX_MAX_BUFFERED_ENTRIES, (Enum)Attribute.MAX_BUFFERED_ENTRIES);
                writerAttributes.write(writer, IndexWriterConfiguration.INDEX_QUEUE_COUNT, (Enum)Attribute.QUEUE_COUNT);
                writerAttributes.write(writer, IndexWriterConfiguration.INDEX_QUEUE_SIZE, (Enum)Attribute.QUEUE_SIZE);
                writerAttributes.write(writer, IndexWriterConfiguration.INDEX_THREAD_POOL_SIZE, (Enum)Attribute.THREAD_POOL_SIZE);
                writerAttributes.write(writer, IndexWriterConfiguration.INDEX_RAM_BUFFER_SIZE, (Enum)Attribute.RAM_BUFFER_SIZE);
                if (indexMergeModified) {
                    writer.writeStartElement((Enum)Element.INDEX_MERGE);
                    mergeAttributes.write(writer, IndexMergeConfiguration.CALIBRATE_BY_DELETES, (Enum)Attribute.CALIBRATE_BY_DELETES);
                    mergeAttributes.write(writer, IndexMergeConfiguration.FACTOR, (Enum)Attribute.FACTOR);
                    mergeAttributes.write(writer, IndexMergeConfiguration.MAX_ENTRIES, (Enum)Attribute.MAX_ENTRIES);
                    mergeAttributes.write(writer, IndexMergeConfiguration.MIN_SIZE, (Enum)Attribute.MIN_SIZE);
                    mergeAttributes.write(writer, IndexMergeConfiguration.MAX_SIZE, (Enum)Attribute.MAX_SIZE);
                    mergeAttributes.write(writer, IndexMergeConfiguration.MAX_FORCED_SIZE, (Enum)Attribute.MAX_FORCED_SIZE);
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            writer.writeArrayElement((Enum)Element.INDEXED_ENTITIES, (Enum)Element.INDEXED_ENTITY, null, indexing.indexedEntityTypes());
            if (!indexing.keyTransformers().isEmpty()) {
                writer.writeStartListElement((Enum)Element.KEY_TRANSFORMERS, true);
                for (Map.Entry<Class<?>, Class<?>> e : indexing.keyTransformers().entrySet()) {
                    writer.writeStartElement((Enum)Element.KEY_TRANSFORMER);
                    writer.writeAttribute((Enum)Attribute.KEY, e.getKey().getName());
                    writer.writeAttribute((Enum)Attribute.TRANSFORMER, e.getValue().getName());
                    writer.writeEndElement();
                }
                writer.writeEndListElement();
            }
            attributes.write(writer, GlobalJmxConfiguration.PROPERTIES);
            writer.writeEndElement();
        }
    }

    private void writePersistence(ConfigurationWriter writer, Configuration configuration) {
        PersistenceConfiguration persistence = configuration.persistence();
        AttributeSet attributes = persistence.attributes();
        if (attributes.isModified() || persistence.stores().size() > 0) {
            writer.writeStartElement((Enum)Element.PERSISTENCE);
            attributes.write(writer, PersistenceConfiguration.PASSIVATION, (Enum)Attribute.PASSIVATION);
            attributes.write(writer, PersistenceConfiguration.AVAILABILITY_INTERVAL, (Enum)Attribute.AVAILABILITY_INTERVAL);
            attributes.write(writer, PersistenceConfiguration.CONNECTION_ATTEMPTS, (Enum)Attribute.CONNECTION_ATTEMPTS);
            attributes.write(writer, PersistenceConfiguration.CONNECTION_INTERVAL, (Enum)Attribute.CONNECTION_INTERVAL);
            for (StoreConfiguration store : persistence.stores()) {
                this.writeStore(writer, store);
            }
            writer.writeEndElement();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeStore(ConfigurationWriter writer, StoreConfiguration configuration) {
        if (configuration instanceof SoftIndexFileStoreConfiguration) {
            this.writeFileStore(writer, (SoftIndexFileStoreConfiguration)configuration);
            return;
        }
        if (configuration instanceof SingleFileStoreConfiguration) {
            this.writeSingleFileStore(writer, (SingleFileStoreConfiguration)configuration);
            return;
        }
        if (configuration instanceof ClusterLoaderConfiguration) {
            this.writeClusterLoader(writer, (ClusterLoaderConfiguration)configuration);
            return;
        }
        if (configuration instanceof CustomStoreConfiguration) {
            this.writeCustomStore(writer, (CustomStoreConfiguration)configuration);
            return;
        }
        SerializedWith serializedWith = configuration.getClass().getAnnotation(SerializedWith.class);
        if (serializedWith == null) {
            ConfigurationFor configurationFor = configuration.getClass().getAnnotation(ConfigurationFor.class);
            if (!(configuration instanceof AbstractStoreConfiguration) || configurationFor == null) throw new UnsupportedOperationException("Cannot serialize store configuration " + configuration.getClass().getName());
            writer.writeComment("A serializer for the store configuration class " + configuration.getClass().getName() + " was not found. Using custom store mode");
            AbstractStoreConfiguration asc = (AbstractStoreConfiguration)configuration;
            this.writeGenericStore(writer, configurationFor.value().getName(), asc);
            return;
        }
        try {
            ConfigurationSerializer serializer = (ConfigurationSerializer)Util.getInstanceStrict(serializedWith.value());
            serializer.serialize(writer, configuration);
            return;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw Log.CONFIG.unableToInstantiateSerializer(serializedWith.value());
        }
    }

    private void writeBackup(ConfigurationWriter writer, Configuration configuration) {
        SitesConfiguration sites = configuration.sites();
        if (sites.allBackups().isEmpty()) {
            return;
        }
        writer.writeStartMap((Enum)Element.BACKUPS);
        sites.attributes().write(writer);
        for (BackupConfiguration backup : sites.allBackups()) {
            AttributeSet takeOffline;
            writer.writeMapItem((Enum)Element.BACKUP, (Enum)Attribute.SITE, backup.site());
            backup.attributes().write(writer);
            AttributeSet stateTransfer = backup.stateTransfer().attributes();
            if (stateTransfer.isModified()) {
                writer.writeStartElement((Enum)Element.STATE_TRANSFER);
                stateTransfer.write(writer);
                writer.writeEndElement();
            }
            if ((takeOffline = backup.takeOffline().attributes()).isModified()) {
                writer.writeStartElement((Enum)Element.TAKE_OFFLINE);
                takeOffline.write(writer);
                writer.writeEndElement();
            }
            writer.writeEndMapItem();
        }
        writer.writeEndMap();
    }

    private void writeFileStore(ConfigurationWriter writer, SoftIndexFileStoreConfiguration configuration) {
        writer.writeStartElement((Enum)Element.FILE_STORE);
        configuration.attributes().write(writer);
        this.writeCommonStoreSubAttributes(writer, configuration);
        this.writeDataElement(writer, configuration);
        this.writeIndexElement(writer, configuration);
        this.writeCommonStoreElements(writer, configuration);
        writer.writeEndElement();
    }

    private void writeDataElement(ConfigurationWriter writer, SoftIndexFileStoreConfiguration configuration) {
        configuration.data().attributes().write(writer, Element.DATA.getLocalName(), new AttributeDefinition[]{DataConfiguration.DATA_LOCATION, DataConfiguration.MAX_FILE_SIZE, DataConfiguration.SYNC_WRITES});
    }

    private void writeIndexElement(ConfigurationWriter writer, SoftIndexFileStoreConfiguration configuration) {
        configuration.index().attributes().write(writer, Element.INDEX.getLocalName(), new AttributeDefinition[]{IndexConfiguration.INDEX_LOCATION, IndexConfiguration.INDEX_QUEUE_LENGTH, IndexConfiguration.INDEX_SEGMENTS, IndexConfiguration.MIN_NODE_SIZE, IndexConfiguration.MAX_NODE_SIZE});
    }

    private void writeSingleFileStore(ConfigurationWriter writer, SingleFileStoreConfiguration configuration) {
        writer.writeStartElement((Enum)Element.SINGLE_FILE_STORE);
        configuration.attributes().write(writer);
        this.writeCommonStoreSubAttributes(writer, configuration);
        this.writeCommonStoreElements(writer, configuration);
        writer.writeEndElement();
    }

    private void writeClusterLoader(ConfigurationWriter writer, ClusterLoaderConfiguration configuration) {
        writer.writeStartElement((Enum)Element.CLUSTER_LOADER);
        configuration.attributes().write(writer);
        this.writeCommonStoreSubAttributes(writer, configuration);
        this.writeCommonStoreElements(writer, configuration);
        writer.writeEndElement();
    }

    private void writeCustomStore(ConfigurationWriter writer, CustomStoreConfiguration configuration) {
        writer.writeStartElement((Enum)Element.STORE);
        configuration.attributes().write(writer);
        this.writeCommonStoreSubAttributes(writer, configuration);
        this.writeCommonStoreElements(writer, configuration);
        writer.writeEndElement();
    }

    private void writeGenericStore(ConfigurationWriter writer, String storeClassName, AbstractStoreConfiguration configuration) {
        writer.writeStartElement((Enum)Element.STORE);
        writer.writeAttribute(Attribute.CLASS.getLocalName(), storeClassName);
        configuration.attributes().write(writer);
        this.writeCommonStoreSubAttributes(writer, configuration);
        this.writeCommonStoreElements(writer, configuration);
        writer.writeEndElement();
    }

    static {
        THREAD_POOL_FACTORIES.put(CachedThreadPoolExecutorFactory.class.getName(), Element.CACHED_THREAD_POOL);
        THREAD_POOL_FACTORIES.put(NonBlockingThreadPoolExecutorFactory.class.getName(), Element.BLOCKING_BOUNDED_QUEUE_THREAD_POOL);
        THREAD_POOL_FACTORIES.put(EnhancedQueueExecutorFactory.class.getName(), Element.BLOCKING_BOUNDED_QUEUE_THREAD_POOL);
        THREAD_POOL_FACTORIES.put(ScheduledThreadPoolExecutorFactory.class.getName(), Element.SCHEDULED_THREAD_POOL);
    }
}

