/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.executors;

import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.commons.executors.ExecutorFactory;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.factories.threads.BlockingThreadFactory;
import org.infinispan.factories.threads.NonBlockingThreadFactory;

public class DefaultExecutorFactory
implements ExecutorFactory {
    private final AtomicInteger counter = new AtomicInteger(0);

    public ExecutorService getExecutor(Properties p) {
        TypedProperties tp = TypedProperties.toTypedProperties((Map)p);
        int maxThreads = tp.getIntProperty("maxThreads", 1);
        int queueSize = tp.getIntProperty("queueSize", 100000);
        int coreThreads = queueSize == 0 ? 1 : tp.getIntProperty("coreThreads", maxThreads);
        long keepAliveTime = tp.getLongProperty("keepAliveTime", 60000L);
        final int threadPrio = tp.getIntProperty("threadPriority", 1);
        final String threadNamePrefix = tp.getProperty("threadNamePrefix", tp.getProperty("componentName", "Thread"));
        final String threadNameSuffix = tp.getProperty("threadNameSuffix", "");
        String blocking = tp.getProperty("blocking");
        final ThreadGroup threadGroup = blocking == null ? Thread.currentThread().getThreadGroup() : (Boolean.parseBoolean(blocking) ? new BlockingThreadFactory.ISPNBlockingThreadGroup(threadNamePrefix + "-group") : new NonBlockingThreadFactory.ISPNNonBlockingThreadGroup(threadNamePrefix + "-group"));
        SynchronousQueue<Runnable> queue = queueSize == 0 ? new SynchronousQueue() : new LinkedBlockingQueue(queueSize);
        ThreadFactory tf = new ThreadFactory(){

            private Thread createThread(Runnable r) {
                String threadName = threadNamePrefix + "-" + DefaultExecutorFactory.this.counter.getAndIncrement() + threadNameSuffix;
                Thread th = new Thread(threadGroup, r, threadName);
                th.setDaemon(true);
                th.setPriority(threadPrio);
                return th;
            }

            @Override
            public Thread newThread(Runnable r) {
                return this.createThread(r);
            }
        };
        return new ThreadPoolExecutor(coreThreads, maxThreads, keepAliveTime, TimeUnit.MILLISECONDS, queue, tf, new ThreadPoolExecutor.CallerRunsPolicy());
    }
}

