/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.Properties;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

final class SecurityActions {
    private static final Log log = LogFactory.getLog(SecurityActions.class);

    SecurityActions() {
    }

    private static Field findFieldRecursively(Class<?> c, String fieldName) {
        Field f;
        block2: {
            f = null;
            try {
                f = c.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                if (c.equals(Object.class)) break block2;
                f = SecurityActions.findFieldRecursively(c.getSuperclass(), fieldName);
            }
        }
        return f;
    }

    static void setValue(Object instance, String fieldName, Object value) {
        try {
            Field f = SecurityActions.findFieldRecursively(instance.getClass(), fieldName);
            if (f == null) {
                throw new NoSuchMethodException("Cannot find field " + fieldName + " on " + String.valueOf(instance.getClass()) + " or superclasses");
            }
            f.setAccessible(true);
            f.set(instance, value);
        }
        catch (Exception e) {
            log.unableToSetValue(e);
        }
    }

    static void applyProperties(Object o, Properties p) {
        for (Map.Entry<Object, Object> entry : p.entrySet()) {
            SecurityActions.setValue(o, (String)entry.getKey(), entry.getValue());
        }
    }
}

