/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.reactive.publisher.impl;

import java.util.Objects;
import org.infinispan.reactive.publisher.impl.SegmentAwarePublisherSupplier;

public class Notifications {
    private Notifications() {
    }

    public static <R> NotificationBuilder<R> reuseBuilder() {
        return new ReuseNotificationBuilder();
    }

    public static <R> NotificationBuilder<R> newBuilder() {
        return new NewBuilder();
    }

    public static <R> SegmentAwarePublisherSupplier.NotificationWithLost<R> value(R value, int segment) {
        return new ValueNotification<R>(value, segment);
    }

    public static <R> SegmentAwarePublisherSupplier.NotificationWithLost<R> segmentComplete(int segment) {
        return new ValueNotification(segment, true);
    }

    public static <R> SegmentAwarePublisherSupplier.NotificationWithLost<R> segmentLost(int segment) {
        return new ValueNotification(segment, false);
    }

    static class ReuseNotificationBuilder<R>
    implements SegmentAwarePublisherSupplier.NotificationWithLost<R>,
    NotificationBuilder<R> {
        R value;
        int segment;

        ReuseNotificationBuilder() {
        }

        @Override
        public SegmentAwarePublisherSupplier.NotificationWithLost<R> value(R value, int segment) {
            this.value = value;
            if (segment < 0) {
                throw new IllegalArgumentException("Segment must be 0 or greater");
            }
            this.segment = segment;
            return this;
        }

        @Override
        public SegmentAwarePublisherSupplier.NotificationWithLost<R> segmentComplete(int segment) {
            this.value = null;
            this.segment = segment;
            return this;
        }

        @Override
        public SegmentAwarePublisherSupplier.NotificationWithLost<R> segmentLost(int segment) {
            this.value = null;
            this.segment = -segment - 1;
            return null;
        }

        @Override
        public boolean isLostSegment() {
            return this.value == null && this.segment < 0;
        }

        @Override
        public int lostSegment() {
            if (!this.isLostSegment()) {
                return SegmentAwarePublisherSupplier.NotificationWithLost.super.lostSegment();
            }
            return -this.segment - 1;
        }

        @Override
        public boolean isValue() {
            return this.value != null;
        }

        @Override
        public boolean isSegmentComplete() {
            return this.value == null && this.segment >= 0;
        }

        @Override
        public R value() {
            if (!this.isValue()) {
                return SegmentAwarePublisherSupplier.NotificationWithLost.super.value();
            }
            return this.value;
        }

        @Override
        public int valueSegment() {
            if (!this.isValue()) {
                return SegmentAwarePublisherSupplier.NotificationWithLost.super.valueSegment();
            }
            return this.segment;
        }

        @Override
        public int completedSegment() {
            if (!this.isSegmentComplete()) {
                return SegmentAwarePublisherSupplier.NotificationWithLost.super.completedSegment();
            }
            return this.segment;
        }

        public String toString() {
            return "ReuseNotificationBuilder{" + (String)(this.value != null ? "value=" + String.valueOf(this.value) : "") + (this.value != null ? ", segment=" : (this.segment > 0 ? "completed segment=" : "lost segment")) + this.segment + "}";
        }
    }

    private static class NewBuilder<R>
    implements NotificationBuilder<R> {
        private NewBuilder() {
        }

        @Override
        public SegmentAwarePublisherSupplier.NotificationWithLost<R> value(R value, int segment) {
            return Notifications.value(value, segment);
        }

        @Override
        public SegmentAwarePublisherSupplier.NotificationWithLost<R> segmentComplete(int segment) {
            return Notifications.segmentComplete(segment);
        }

        @Override
        public SegmentAwarePublisherSupplier.NotificationWithLost<R> segmentLost(int segment) {
            return Notifications.segmentLost(segment);
        }
    }

    static class ValueNotification<R>
    implements SegmentAwarePublisherSupplier.NotificationWithLost<R> {
        protected final R value;
        protected final int segment;

        public ValueNotification(R value, int segment) {
            this.value = value;
            if (segment < 0) {
                throw new IllegalArgumentException("Segment must be 0 or greater");
            }
            this.segment = segment;
        }

        public ValueNotification(int segment, boolean segmentComplete) {
            this.value = null;
            this.segment = segmentComplete ? segment : -segment - 1;
        }

        @Override
        public boolean isLostSegment() {
            return this.segment < 0;
        }

        @Override
        public boolean isValue() {
            return this.value != null;
        }

        @Override
        public boolean isSegmentComplete() {
            return this.value == null && this.segment >= 0;
        }

        @Override
        public R value() {
            if (this.value != null) {
                return this.value;
            }
            return SegmentAwarePublisherSupplier.NotificationWithLost.super.value();
        }

        @Override
        public int valueSegment() {
            if (this.value != null) {
                return this.segment;
            }
            return SegmentAwarePublisherSupplier.NotificationWithLost.super.valueSegment();
        }

        @Override
        public int completedSegment() {
            if (this.value == null && this.segment >= 0) {
                return this.segment;
            }
            return SegmentAwarePublisherSupplier.NotificationWithLost.super.completedSegment();
        }

        @Override
        public int lostSegment() {
            if (this.segment < 0) {
                return -this.segment - 1;
            }
            return SegmentAwarePublisherSupplier.NotificationWithLost.super.lostSegment();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ValueNotification that = (ValueNotification)o;
            return this.segment == that.segment && Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            return this.segment * 31 + Objects.hashCode(this.value);
        }

        public String toString() {
            return "ValueNotification{" + (String)(this.value != null ? "value=" + String.valueOf(this.value) : "") + (this.value != null ? ", segment=" : (this.segment > 0 ? "completed segment=" : "lost segment")) + this.segment + "}";
        }
    }

    public static interface NotificationBuilder<R> {
        public SegmentAwarePublisherSupplier.NotificationWithLost<R> value(R var1, int var2);

        public SegmentAwarePublisherSupplier.NotificationWithLost<R> segmentComplete(int var1);

        public SegmentAwarePublisherSupplier.NotificationWithLost<R> segmentLost(int var1);
    }
}

