/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.security;

import java.security.Principal;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.security.auth.Subject;
import org.infinispan.commons.jdkspecific.CallerId;

public final class Security {
    private static final ThreadLocal<Boolean> PRIVILEGED = ThreadLocal.withInitial(() -> Boolean.FALSE);
    private static final ThreadLocal<Deque<Subject>> SUBJECT = new InheritableThreadLocal<Deque<Subject>>(){

        @Override
        protected Deque<Subject> childValue(Deque<Subject> parentValue) {
            return parentValue == null ? null : new ArrayDeque<Subject>(parentValue);
        }
    };

    private static boolean isTrustedClass(Class<?> klass) {
        String packageName = klass.getPackage().getName();
        return packageName.startsWith("org.infinispan") || packageName.startsWith("org.jboss.as.clustering.infinispan");
    }

    public static <T> T doPrivileged(Supplier<T> action) {
        if (!Security.isPrivileged() && Security.isTrustedClass(CallerId.getCallerClass((int)3))) {
            try {
                PRIVILEGED.set(true);
                T t = action.get();
                return t;
            }
            finally {
                PRIVILEGED.remove();
            }
        }
        return action.get();
    }

    public static void doPrivileged(Runnable action) {
        if (!Security.isPrivileged() && Security.isTrustedClass(CallerId.getCallerClass((int)3))) {
            try {
                PRIVILEGED.set(true);
                action.run();
            }
            finally {
                PRIVILEGED.remove();
            }
        } else {
            action.run();
        }
    }

    private static Deque<Subject> pre(Subject subject) {
        if (subject == null) {
            return null;
        }
        Deque<Subject> stack = SUBJECT.get();
        if (stack == null) {
            stack = new ArrayDeque<Subject>(3);
            SUBJECT.set(stack);
        }
        stack.push(subject);
        return stack;
    }

    private static void post(Subject subject, Deque<Subject> stack) {
        if (subject != null) {
            stack.pop();
            if (stack.isEmpty()) {
                SUBJECT.remove();
            }
        }
    }

    public static void doAs(Subject subject, Runnable action) {
        Deque<Subject> stack = Security.pre(subject);
        try {
            action.run();
        }
        finally {
            Security.post(subject, stack);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T doAs(Subject subject, Supplier<T> action) {
        Deque<Subject> stack = Security.pre(subject);
        try {
            T t = action.get();
            return t;
        }
        finally {
            Security.post(subject, stack);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, R> R doAs(Subject subject, Function<T, R> function, T t) {
        Deque<Subject> stack = Security.pre(subject);
        try {
            R r = function.apply(t);
            return r;
        }
        finally {
            Security.post(subject, stack);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, U, R> R doAs(Subject subject, BiFunction<T, U, R> function, T t, U u) {
        Deque<Subject> stack = Security.pre(subject);
        try {
            R r = function.apply(t, u);
            return r;
        }
        finally {
            Security.post(subject, stack);
        }
    }

    public static boolean isPrivileged() {
        return PRIVILEGED.get();
    }

    public static Subject getSubject() {
        Deque<Subject> subjects = SUBJECT.get();
        if (subjects != null && !subjects.isEmpty()) {
            return subjects.peek();
        }
        return null;
    }

    public static Principal getSubjectUserPrincipal(Subject s) {
        if (s != null && !s.getPrincipals().isEmpty()) {
            return s.getPrincipals().iterator().next();
        }
        return null;
    }

    public static String toString(Subject subject) {
        StringBuilder sb = new StringBuilder("Subject: [");
        boolean comma = false;
        for (Principal p : subject.getPrincipals()) {
            if (comma) {
                sb.append(" ,");
            }
            sb.append(p.toString());
            comma = true;
        }
        return sb.append(']').toString();
    }
}

